/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.cn;

import java.io.IOException;
import java.io.Reader;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.cn.ChineseFilter;
import org.apache.lucene.analysis.cn.ChineseTokenizer;

public class ChineseAnalyzer
extends Analyzer {
    public final TokenStream tokenStream(String fieldName, Reader reader) {
        TokenStream result = new ChineseTokenizer(reader);
        result = new ChineseFilter(result);
        return result;
    }

    public final TokenStream reusableTokenStream(String fieldName, Reader reader) throws IOException {
        SavedStreams streams = (SavedStreams)this.getPreviousTokenStream();
        if (streams == null) {
            streams = new SavedStreams();
            streams.source = new ChineseTokenizer(reader);
            streams.result = new ChineseFilter(streams.source);
            this.setPreviousTokenStream(streams);
        } else {
            streams.source.reset(reader);
        }
        return streams.result;
    }

    private class SavedStreams {
        Tokenizer source;
        TokenStream result;

        private SavedStreams() {
        }
    }
}

