/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.datastore.shared;

import com.google.appengine.repackaged.com.google.common.base.Function;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableList;
import com.google.appengine.repackaged.com.google.common.collect.Lists;
import com.google.appengine.repackaged.com.google.common.collect.Sets;
import com.google.appengine.repackaged.com.google.protobuf.ByteString;
import com.google.appengine.repackaged.com.google.protobuf.InvalidProtocolBufferException;
import com.google.appengine.repackaged.com.google.protobuf.MessageLite;
import com.google.appengine.repackaged.com.google.storage.onestore.v3.proto2api.OnestoreEntity;
import com.google.apphosting.api.DatastorePb;
import com.google.apphosting.datastore.DatastoreV4;
import com.google.apphosting.datastore.EntityV4;
import com.google.apphosting.datastore.shared.EntityProtoConverter;
import com.google.apphosting.datastore.shared.EquivalentMessageConverter;
import com.google.apphosting.datastore.shared.GqlParser;
import com.google.apphosting.datastore.shared.InvalidConversionException;
import com.google.apphosting.datastore.shared.ParseException;
import com.google.apphosting.datastore.shared.TokenMgrError;
import com.google.storage.onestore.v3.OnestoreEntity;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;

public abstract class DatastoreProtoConverter {
    public static final DatastoreProtoConverter TRIVIAL = new DatastoreProtoConverter(){

        @Override
        public ByteString toV4QueryCursor(DatastorePb.CompiledCursor compiledCursor) throws InvalidConversionException {
            return compiledCursor.toByteString();
        }

        @Override
        public DatastorePb.CompiledCursor toV3CompiledCursor(ByteString queryCursor) throws InvalidConversionException {
            try {
                return (DatastorePb.CompiledCursor)DatastorePb.CompiledCursor.PARSER.parseFrom(queryCursor);
            }
            catch (InvalidProtocolBufferException e) {
                throw new InvalidConversionException(e);
            }
        }
    };
    private static final Function<OnestoreEntity.CompositeIndex, OnestoreEntity.CompositeIndex> V3_TO_V4_COMPOSITE_INDEX_CONVERTER = EquivalentMessageConverter.create(OnestoreEntity.CompositeIndex.PARSER);
    private static final Function<OnestoreEntity.CompositeIndex, OnestoreEntity.CompositeIndex> V4_TO_V3_COMPOSITE_INDEX_CONVERTER = EquivalentMessageConverter.create(OnestoreEntity.CompositeIndex.PARSER);
    protected final EntityProtoConverter entityProtoConverter;

    protected static <V3 extends MessageLite, V4 extends MessageLite> List<V4> convertList(List<V3> list, Function<V3, V4> converter) {
        return ImmutableList.copyOf((Collection)Lists.transform(list, converter));
    }

    protected DatastoreProtoConverter() {
        this(EntityProtoConverter.DEFAULT);
    }

    protected DatastoreProtoConverter(EntityProtoConverter entityProtoConverter) {
        this.entityProtoConverter = entityProtoConverter;
    }

    public EntityProtoConverter getEntityProtoConverter() {
        return this.entityProtoConverter;
    }

    public abstract DatastorePb.CompiledCursor toV3CompiledCursor(ByteString var1) throws InvalidConversionException;

    public abstract ByteString toV4QueryCursor(DatastorePb.CompiledCursor var1) throws InvalidConversionException;

    public OnestoreEntity.CompositeIndex toV3CompositeIndex(OnestoreEntity.CompositeIndex compositeIndex) {
        return (OnestoreEntity.CompositeIndex)V4_TO_V3_COMPOSITE_INDEX_CONVERTER.apply((Object)compositeIndex);
    }

    public List<OnestoreEntity.CompositeIndex> toV3CompositeIndex(List<OnestoreEntity.CompositeIndex> compositeIndexes) {
        return DatastoreProtoConverter.convertList(compositeIndexes, V4_TO_V3_COMPOSITE_INDEX_CONVERTER);
    }

    public OnestoreEntity.CompositeIndex toV4CompositeIndex(OnestoreEntity.CompositeIndex compositeIndex) {
        return (OnestoreEntity.CompositeIndex)V3_TO_V4_COMPOSITE_INDEX_CONVERTER.apply((Object)compositeIndex);
    }

    public List<OnestoreEntity.CompositeIndex> toV4CompositeIndex(List<OnestoreEntity.CompositeIndex> compositeIndexes) {
        return DatastoreProtoConverter.convertList(compositeIndexes, V3_TO_V4_COMPOSITE_INDEX_CONVERTER);
    }

    public DatastoreV4.Query.Builder toV4Query(DatastoreV4.GqlQueryOrBuilder gqlQuery, EntityV4.PartitionId partitionId) throws InvalidConversionException {
        try {
            return new GqlParser(gqlQuery, partitionId).selector();
        }
        catch (ParseException exception) {
            throw new InvalidConversionException(exception.getMessage());
        }
        catch (TokenMgrError exception) {
            throw new InvalidConversionException(exception.getMessage());
        }
    }

    public DatastoreV4.Query.Builder toV4Query(DatastorePb.Query query) throws InvalidConversionException {
        DatastoreV4.Query.Builder builder = DatastoreV4.Query.newBuilder();
        if (query.hasLimit()) {
            builder.setLimit(query.getLimit());
        }
        if (query.getOffset() != 0) {
            builder.setOffset(query.getOffset());
        }
        if (query.hasCompiledCursor()) {
            builder.setStartCursor(this.toV4QueryCursor(query.getCompiledCursor()));
        }
        if (query.hasEndCompiledCursor()) {
            builder.setEndCursor(this.toV4QueryCursor(query.getEndCompiledCursor()));
        }
        if (query.hasKind()) {
            builder.addKindBuilder().setName(query.getKind());
        }
        HashSet groupByProperties = Sets.newHashSet((Iterable)query.groupByPropertyNames());
        for (String name : query.propertyNames()) {
            DatastoreV4.PropertyExpression.Builder projBuilder = builder.addProjectionBuilder();
            projBuilder.getPropertyBuilder().setName(name);
            if (groupByProperties.isEmpty() || groupByProperties.contains(name)) continue;
            projBuilder.setAggregationFunction(DatastoreV4.PropertyExpression.AggregationFunction.FIRST);
        }
        if (query.isKeysOnly()) {
            DatastoreV4.PropertyExpression.Builder projBuilder = builder.addProjectionBuilder();
            projBuilder.getPropertyBuilder().setName("__key__");
            if (!groupByProperties.isEmpty() && !groupByProperties.contains("__key__")) {
                projBuilder.setAggregationFunction(DatastoreV4.PropertyExpression.AggregationFunction.FIRST);
            }
        }
        for (String name : query.groupByPropertyNames()) {
            builder.addGroupByBuilder().setName(name);
        }
        DatastoreV4.CompositeFilter.Builder filter = DatastoreV4.CompositeFilter.newBuilder();
        filter.setOperator(DatastoreV4.CompositeFilter.Operator.AND);
        if (query.hasAncestor()) {
            DatastoreV4.PropertyFilter.Builder propFilter = filter.addFilterBuilder().getPropertyFilterBuilder();
            propFilter.setOperator(DatastoreV4.PropertyFilter.Operator.HAS_ANCESTOR);
            propFilter.getPropertyBuilder().setName("__key__");
            propFilter.setValue(EntityV4.Value.newBuilder().setKeyValue(this.entityProtoConverter.toV4Key(query.getAncestor())));
        }
        for (DatastorePb.Query.Filter filterV3 : query.filters()) {
            InvalidConversionException.checkConversion(filterV3.propertySize() == 1, "invalid filter", new Object[0]);
            InvalidConversionException.checkConversion(filterV3.getOp() <= 6, "unsupported filter: " + filterV3.getOpEnum(), new Object[0]);
            DatastorePb.Query.Filter.Operator operator = filterV3.getOpEnum();
            if (operator == DatastorePb.Query.Filter.Operator.IN) {
                operator = DatastorePb.Query.Filter.Operator.EQUAL;
            }
            DatastoreV4.PropertyFilter.Builder propFilter = filter.addFilterBuilder().getPropertyFilterBuilder();
            propFilter.setOperator(DatastoreV4.PropertyFilter.Operator.valueOf((int)operator.getValue()));
            propFilter.getPropertyBuilder().setName(filterV3.getProperty(0).getName());
            propFilter.setValue(this.entityProtoConverter.toV4Value(filterV3.getProperty(0), true));
        }
        if (filter.getFilterCount() == 1) {
            builder.setFilter(filter.getFilterBuilder(0));
        } else if (filter.getFilterCount() > 1) {
            builder.getFilterBuilder().setCompositeFilter(filter);
        }
        for (DatastorePb.Query.Order order : query.orders()) {
            DatastoreV4.PropertyOrder.Builder orderV4 = builder.addOrderBuilder();
            orderV4.getPropertyBuilder().setName(order.getProperty());
            if (!order.hasDirection()) continue;
            orderV4.setDirection(DatastoreV4.PropertyOrder.Direction.valueOf((int)order.getDirection()));
        }
        return builder;
    }

    public DatastorePb.Query toV3Query(EntityV4.PartitionIdOrBuilder partitionId, DatastoreV4.QueryOrBuilder query) throws InvalidConversionException {
        DatastorePb.Query result = new DatastorePb.Query();
        result.setApp(partitionId.getDatasetId());
        if (partitionId.hasNamespace()) {
            result.setNameSpace(partitionId.getNamespace());
        }
        result.setPersistOffset(true);
        result.setRequirePerfectPlan(true);
        result.setCompile(true);
        if (query.hasLimit()) {
            result.setLimit(query.getLimit());
        }
        if (query.getOffset() != 0) {
            result.setOffset(query.getOffset());
        }
        if (query.hasStartCursor()) {
            result.setCompiledCursor(this.toV3CompiledCursor(query.getStartCursor()));
        }
        if (query.hasEndCursor()) {
            result.setEndCompiledCursor(this.toV3CompiledCursor(query.getEndCursor()));
        }
        if (query.getKindCount() > 0) {
            InvalidConversionException.checkConversion(query.getKindCount() == 1, "multiple kinds not supported", new Object[0]);
            result.setKind(query.getKind(0).getName());
        }
        boolean hasKeyProjection = false;
        for (DatastoreV4.PropertyExpression prop : query.getProjectionList()) {
            if (prop.getProperty().getName().equals("__key__")) {
                hasKeyProjection = true;
                continue;
            }
            result.addPropertyName(prop.getProperty().getName());
        }
        if (hasKeyProjection && result.propertyNameSize() == 0) {
            result.setKeysOnly(true);
        }
        for (DatastoreV4.PropertyExpression prop : query.getGroupByList()) {
            result.addGroupByPropertyName(prop.getName());
        }
        this.populateV3Filters(query.getFilterOrBuilder(), result);
        for (DatastoreV4.PropertyOrder order : query.getOrderList()) {
            DatastorePb.Query.Order orderV3 = result.addOrder();
            orderV3.setProperty(order.getProperty().getName());
            if (!order.hasDirection()) continue;
            orderV3.setDirection(order.getDirection().getNumber());
        }
        return result;
    }

    private void populateV3Filters(DatastoreV4.FilterOrBuilder filter, DatastorePb.Query query) throws InvalidConversionException {
        if (filter.hasPropertyFilter()) {
            DatastoreV4.PropertyFilterOrBuilder propertyFilter = filter.getPropertyFilterOrBuilder();
            if (propertyFilter.getOperator().equals((Object)DatastoreV4.PropertyFilter.Operator.HAS_ANCESTOR)) {
                InvalidConversionException.checkConversion(propertyFilter.getValue().hasKeyValue(), "HAS_ANCESTOR requires a reference value", new Object[0]);
                InvalidConversionException.checkConversion(propertyFilter.getProperty().getName().equals("__key__"), "unsupported property", new Object[0]);
                InvalidConversionException.checkConversion(!query.hasAncestor(), "duplicate ancestor constraint", new Object[0]);
                query.setAncestor(this.entityProtoConverter.toV3Reference(propertyFilter.getValueOrBuilder().getKeyValueOrBuilder()));
            } else {
                DatastorePb.Query.Filter result = query.addFilter();
                String propertyName = propertyFilter.getPropertyOrBuilder().getName();
                result.setOp(propertyFilter.getOperator().getNumber());
                InvalidConversionException.checkConversion(propertyFilter.getValueOrBuilder().getListValueCount() == 0, "unsupported value type, %s, in property filter on '%s'", "list_value", propertyName);
                result.addProperty().setMultiple(false).setName(propertyName).setValue(this.entityProtoConverter.toV3PropertyValue(propertyFilter.getValueOrBuilder()));
            }
        } else if (filter.hasCompositeFilter()) {
            InvalidConversionException.checkConversion(filter.getCompositeFilter().getOperator() == DatastoreV4.CompositeFilter.Operator.AND, "unsupported composite property operator", new Object[0]);
            for (DatastoreV4.FilterOrBuilder subFilter : filter.getCompositeFilterOrBuilder().getFilterOrBuilderList()) {
                this.populateV3Filters(subFilter, query);
            }
        }
    }

    public DatastorePb.QueryResult toV3QueryResult(DatastoreV4.QueryResultBatchOrBuilder batch) throws InvalidConversionException {
        DatastorePb.QueryResult result = new DatastorePb.QueryResult();
        result.setMoreResults(batch.getMoreResults() == DatastoreV4.QueryResultBatch.MoreResultsType.NOT_FINISHED);
        if (batch.hasEndCursor()) {
            result.setCompiledCursor(this.toV3CompiledCursor(batch.getEndCursor()));
        }
        if (batch.getEntityResultType() == DatastoreV4.EntityResult.ResultType.PROJECTION) {
            result.setIndexOnly(true);
        } else if (batch.getEntityResultType() == DatastoreV4.EntityResult.ResultType.KEY_ONLY) {
            result.setKeysOnly(true);
        }
        if (batch.hasSkippedResults()) {
            result.setSkippedResults(batch.getSkippedResults());
        }
        for (DatastoreV4.EntityResult entityResult : batch.getEntityResultList()) {
            OnestoreEntity.EntityProto entity = this.entityProtoConverter.toV3Entity((EntityV4.EntityOrBuilder)entityResult.getEntity());
            if (batch.getEntityResultType() != DatastoreV4.EntityResult.ResultType.FULL) {
                entity.setEntityGroup(OnestoreEntity.Path.IMMUTABLE_DEFAULT_INSTANCE);
            }
            result.addResult(entity);
            if (!entityResult.hasVersion()) continue;
            result.addVersion(entityResult.getVersion());
        }
        int numOfVersions = result.versionSize();
        InvalidConversionException.checkConversion(numOfVersions == 0 || numOfVersions == batch.getEntityResultCount(), "query results contain inconsistent number of versions", new Object[0]);
        return result;
    }

    public DatastoreV4.QueryResultBatch.Builder toV4QueryResultBatch(DatastorePb.QueryResult result) throws InvalidConversionException {
        DatastoreV4.QueryResultBatch.Builder builder = DatastoreV4.QueryResultBatch.newBuilder();
        builder.setMoreResults(result.isMoreResults() ? DatastoreV4.QueryResultBatch.MoreResultsType.NOT_FINISHED : DatastoreV4.QueryResultBatch.MoreResultsType.MORE_RESULTS_AFTER_LIMIT);
        if (result.hasCompiledCursor()) {
            builder.setEndCursor(this.toV4QueryCursor(result.getCompiledCursor()));
        }
        builder.setEntityResultType(result.isKeysOnly() ? DatastoreV4.EntityResult.ResultType.KEY_ONLY : (result.isIndexOnly() ? DatastoreV4.EntityResult.ResultType.PROJECTION : DatastoreV4.EntityResult.ResultType.FULL));
        if (result.hasSkippedResults()) {
            builder.setSkippedResults(result.getSkippedResults());
        }
        int numOfResults = result.resultSize();
        int numOfVersions = result.versionSize();
        InvalidConversionException.checkConversion(numOfVersions == 0 || numOfVersions == numOfResults, "query results contain inconsistent number of versions", new Object[0]);
        for (int i = 0; i < numOfResults; ++i) {
            DatastoreV4.EntityResult.Builder entity = builder.addEntityResultBuilder();
            entity.setEntity(this.entityProtoConverter.toV4Entity(result.getResult(i)));
            if (numOfVersions != numOfResults) continue;
            entity.setVersion(result.getVersion(i));
        }
        return builder;
    }

    public DatastoreV4.EntityResult.Builder toV4EntityResult(DatastorePb.GetResponse.Entity entityV3) throws InvalidConversionException {
        InvalidConversionException.checkConversion(!entityV3.hasEntity() || !entityV3.hasKey(), "Get Response cannot have both an entity and key", new Object[0]);
        DatastoreV4.EntityResult.Builder builder = DatastoreV4.EntityResult.newBuilder();
        if (entityV3.hasEntity()) {
            builder.setEntity(this.entityProtoConverter.toV4Entity(entityV3.getEntity()));
        } else if (entityV3.hasKey()) {
            builder.getEntityBuilder().setKey(this.entityProtoConverter.toV4Key(entityV3.getKey()));
        }
        if (entityV3.hasVersion()) {
            builder.setVersion(entityV3.getVersion());
        }
        return builder;
    }

    public DatastorePb.GetResponse.Entity toV3Entity(DatastoreV4.EntityResultOrBuilder entityResult, boolean isMissing) {
        EntityV4.Entity entityV4 = entityResult.getEntity();
        DatastorePb.GetResponse.Entity entityV3 = new DatastorePb.GetResponse.Entity();
        if (isMissing) {
            entityV3.setKey(this.entityProtoConverter.toV3Reference((EntityV4.KeyOrBuilder)entityV4.getKey()));
        } else {
            entityV3.setEntity(this.entityProtoConverter.toV3Entity((EntityV4.EntityOrBuilder)entityV4));
        }
        if (entityResult.hasVersion()) {
            entityV3.setVersion(entityResult.getVersion());
        }
        return entityV3;
    }
}

