/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.org.apache.http.impl.nio;

import com.google.appengine.repackaged.org.apache.http.ConnectionClosedException;
import com.google.appengine.repackaged.org.apache.http.Header;
import com.google.appengine.repackaged.org.apache.http.HttpConnectionMetrics;
import com.google.appengine.repackaged.org.apache.http.HttpEntity;
import com.google.appengine.repackaged.org.apache.http.HttpException;
import com.google.appengine.repackaged.org.apache.http.HttpInetConnection;
import com.google.appengine.repackaged.org.apache.http.HttpMessage;
import com.google.appengine.repackaged.org.apache.http.HttpRequest;
import com.google.appengine.repackaged.org.apache.http.HttpResponse;
import com.google.appengine.repackaged.org.apache.http.annotation.NotThreadSafe;
import com.google.appengine.repackaged.org.apache.http.entity.BasicHttpEntity;
import com.google.appengine.repackaged.org.apache.http.entity.ContentLengthStrategy;
import com.google.appengine.repackaged.org.apache.http.impl.HttpConnectionMetricsImpl;
import com.google.appengine.repackaged.org.apache.http.impl.entity.LaxContentLengthStrategy;
import com.google.appengine.repackaged.org.apache.http.impl.entity.StrictContentLengthStrategy;
import com.google.appengine.repackaged.org.apache.http.impl.io.HttpTransportMetricsImpl;
import com.google.appengine.repackaged.org.apache.http.impl.nio.SessionHttpContext;
import com.google.appengine.repackaged.org.apache.http.impl.nio.codecs.ChunkDecoder;
import com.google.appengine.repackaged.org.apache.http.impl.nio.codecs.ChunkEncoder;
import com.google.appengine.repackaged.org.apache.http.impl.nio.codecs.IdentityDecoder;
import com.google.appengine.repackaged.org.apache.http.impl.nio.codecs.IdentityEncoder;
import com.google.appengine.repackaged.org.apache.http.impl.nio.codecs.LengthDelimitedDecoder;
import com.google.appengine.repackaged.org.apache.http.impl.nio.codecs.LengthDelimitedEncoder;
import com.google.appengine.repackaged.org.apache.http.impl.nio.reactor.SessionInputBufferImpl;
import com.google.appengine.repackaged.org.apache.http.impl.nio.reactor.SessionOutputBufferImpl;
import com.google.appengine.repackaged.org.apache.http.io.HttpTransportMetrics;
import com.google.appengine.repackaged.org.apache.http.nio.ContentDecoder;
import com.google.appengine.repackaged.org.apache.http.nio.ContentEncoder;
import com.google.appengine.repackaged.org.apache.http.nio.NHttpConnection;
import com.google.appengine.repackaged.org.apache.http.nio.reactor.IOSession;
import com.google.appengine.repackaged.org.apache.http.nio.reactor.SessionBufferStatus;
import com.google.appengine.repackaged.org.apache.http.nio.reactor.SessionInputBuffer;
import com.google.appengine.repackaged.org.apache.http.nio.reactor.SessionOutputBuffer;
import com.google.appengine.repackaged.org.apache.http.nio.reactor.SocketAccessor;
import com.google.appengine.repackaged.org.apache.http.nio.util.ByteBufferAllocator;
import com.google.appengine.repackaged.org.apache.http.params.HttpConnectionParams;
import com.google.appengine.repackaged.org.apache.http.params.HttpParams;
import com.google.appengine.repackaged.org.apache.http.protocol.HttpContext;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;

@NotThreadSafe
public class NHttpConnectionBase
implements NHttpConnection,
HttpInetConnection,
SessionBufferStatus,
SocketAccessor {
    protected final ContentLengthStrategy incomingContentStrategy;
    protected final ContentLengthStrategy outgoingContentStrategy;
    protected final SessionInputBufferImpl inbuf;
    protected final SessionOutputBufferImpl outbuf;
    protected final HttpTransportMetricsImpl inTransportMetrics;
    protected final HttpTransportMetricsImpl outTransportMetrics;
    protected final HttpConnectionMetricsImpl connMetrics;
    protected HttpContext context;
    protected IOSession session;
    protected SocketAddress remote;
    protected volatile ContentDecoder contentDecoder;
    protected volatile boolean hasBufferedInput;
    protected volatile ContentEncoder contentEncoder;
    protected volatile boolean hasBufferedOutput;
    protected volatile HttpRequest request;
    protected volatile HttpResponse response;
    protected volatile int status;

    public NHttpConnectionBase(IOSession session, ByteBufferAllocator allocator, HttpParams params) {
        int linebuffersize;
        if (session == null) {
            throw new IllegalArgumentException("I/O session may not be null");
        }
        if (params == null) {
            throw new IllegalArgumentException("HTTP params may not be null");
        }
        int buffersize = HttpConnectionParams.getSocketBufferSize(params);
        if (buffersize <= 0) {
            buffersize = 4096;
        }
        if ((linebuffersize = buffersize) > 512) {
            linebuffersize = 512;
        }
        this.inbuf = new SessionInputBufferImpl(buffersize, linebuffersize, allocator, params);
        this.outbuf = new SessionOutputBufferImpl(buffersize, linebuffersize, allocator, params);
        this.incomingContentStrategy = this.createIncomingContentStrategy();
        this.outgoingContentStrategy = this.createOutgoingContentStrategy();
        this.inTransportMetrics = this.createTransportMetrics();
        this.outTransportMetrics = this.createTransportMetrics();
        this.connMetrics = this.createConnectionMetrics(this.inTransportMetrics, this.outTransportMetrics);
        this.setSession(session);
        this.status = 0;
    }

    private void setSession(IOSession session) {
        this.session = session;
        this.context = new SessionHttpContext(this.session);
        this.session.setBufferStatus(this);
        this.remote = this.session.getRemoteAddress();
    }

    protected void bind(IOSession session) {
        if (session == null) {
            throw new IllegalArgumentException("I/O session may not be null");
        }
        this.session.setBufferStatus(null);
        this.setSession(session);
    }

    protected ContentLengthStrategy createIncomingContentStrategy() {
        return new LaxContentLengthStrategy();
    }

    protected ContentLengthStrategy createOutgoingContentStrategy() {
        return new StrictContentLengthStrategy();
    }

    protected HttpTransportMetricsImpl createTransportMetrics() {
        return new HttpTransportMetricsImpl();
    }

    protected HttpConnectionMetricsImpl createConnectionMetrics(HttpTransportMetrics inTransportMetric, HttpTransportMetrics outTransportMetric) {
        return new HttpConnectionMetricsImpl(inTransportMetric, outTransportMetric);
    }

    public int getStatus() {
        return this.status;
    }

    public HttpContext getContext() {
        return this.context;
    }

    public HttpRequest getHttpRequest() {
        return this.request;
    }

    public HttpResponse getHttpResponse() {
        return this.response;
    }

    public void requestInput() {
        this.session.setEvent(1);
    }

    public void requestOutput() {
        this.session.setEvent(4);
    }

    public void suspendInput() {
        this.session.clearEvent(1);
    }

    public void suspendOutput() {
        this.session.clearEvent(4);
    }

    protected HttpEntity prepareDecoder(HttpMessage message) throws HttpException {
        Header contentEncodingHeader;
        BasicHttpEntity entity = new BasicHttpEntity();
        long len = this.incomingContentStrategy.determineLength(message);
        this.contentDecoder = this.createContentDecoder(len, this.session.channel(), this.inbuf, this.inTransportMetrics);
        if (len == -2L) {
            entity.setChunked(true);
            entity.setContentLength(-1L);
        } else if (len == -1L) {
            entity.setChunked(false);
            entity.setContentLength(-1L);
        } else {
            entity.setChunked(false);
            entity.setContentLength(len);
        }
        Header contentTypeHeader = message.getFirstHeader("Content-Type");
        if (contentTypeHeader != null) {
            entity.setContentType(contentTypeHeader);
        }
        if ((contentEncodingHeader = message.getFirstHeader("Content-Encoding")) != null) {
            entity.setContentEncoding(contentEncodingHeader);
        }
        return entity;
    }

    protected ContentDecoder createContentDecoder(long len, ReadableByteChannel channel, SessionInputBuffer buffer, HttpTransportMetricsImpl metrics) {
        if (len == -2L) {
            return new ChunkDecoder(channel, buffer, metrics);
        }
        if (len == -1L) {
            return new IdentityDecoder(channel, buffer, metrics);
        }
        return new LengthDelimitedDecoder(channel, buffer, metrics, len);
    }

    protected void prepareEncoder(HttpMessage message) throws HttpException {
        long len = this.outgoingContentStrategy.determineLength(message);
        this.contentEncoder = this.createContentEncoder(len, this.session.channel(), this.outbuf, this.outTransportMetrics);
    }

    protected ContentEncoder createContentEncoder(long len, WritableByteChannel channel, SessionOutputBuffer buffer, HttpTransportMetricsImpl metrics) {
        if (len == -2L) {
            return new ChunkEncoder(channel, buffer, metrics);
        }
        if (len == -1L) {
            return new IdentityEncoder(channel, buffer, metrics);
        }
        return new LengthDelimitedEncoder(channel, buffer, metrics, len);
    }

    public boolean hasBufferedInput() {
        return this.hasBufferedInput;
    }

    public boolean hasBufferedOutput() {
        return this.hasBufferedOutput;
    }

    protected void assertNotClosed() throws ConnectionClosedException {
        if (this.status != 0) {
            throw new ConnectionClosedException("Connection is closed");
        }
    }

    public void close() throws IOException {
        if (this.status != 0) {
            return;
        }
        this.status = 1;
        if (this.outbuf.hasData()) {
            this.session.setEvent(4);
        } else {
            this.session.close();
            this.status = 2;
        }
    }

    public boolean isOpen() {
        return this.status == 0 && !this.session.isClosed();
    }

    public boolean isStale() {
        return this.session.isClosed();
    }

    public InetAddress getLocalAddress() {
        SocketAddress address = this.session.getLocalAddress();
        if (address instanceof InetSocketAddress) {
            return ((InetSocketAddress)address).getAddress();
        }
        return null;
    }

    public int getLocalPort() {
        SocketAddress address = this.session.getLocalAddress();
        if (address instanceof InetSocketAddress) {
            return ((InetSocketAddress)address).getPort();
        }
        return -1;
    }

    public InetAddress getRemoteAddress() {
        SocketAddress address = this.session.getRemoteAddress();
        if (address instanceof InetSocketAddress) {
            return ((InetSocketAddress)address).getAddress();
        }
        return null;
    }

    public int getRemotePort() {
        SocketAddress address = this.session.getRemoteAddress();
        if (address instanceof InetSocketAddress) {
            return ((InetSocketAddress)address).getPort();
        }
        return -1;
    }

    public void setSocketTimeout(int timeout) {
        this.session.setSocketTimeout(timeout);
    }

    public int getSocketTimeout() {
        return this.session.getSocketTimeout();
    }

    public void shutdown() throws IOException {
        this.status = 2;
        this.session.shutdown();
    }

    public HttpConnectionMetrics getMetrics() {
        return this.connMetrics;
    }

    private static void formatAddress(StringBuilder buffer, SocketAddress socketAddress) {
        if (socketAddress instanceof InetSocketAddress) {
            InetSocketAddress addr = (InetSocketAddress)socketAddress;
            buffer.append(addr.getAddress() != null ? addr.getAddress().getHostAddress() : addr.getAddress()).append(':').append(addr.getPort());
        } else {
            buffer.append(socketAddress);
        }
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        SocketAddress remoteAddress = this.session.getRemoteAddress();
        SocketAddress localAddress = this.session.getLocalAddress();
        if (remoteAddress != null && localAddress != null) {
            NHttpConnectionBase.formatAddress(buffer, localAddress);
            buffer.append("<->");
            NHttpConnectionBase.formatAddress(buffer, remoteAddress);
        }
        buffer.append("[");
        switch (this.status) {
            case 0: {
                buffer.append("ACTIVE");
                break;
            }
            case 1: {
                buffer.append("CLOSING");
                break;
            }
            case 2: {
                buffer.append("CLOSED");
            }
        }
        buffer.append("]");
        return buffer.toString();
    }

    public Socket getSocket() {
        if (this.session instanceof SocketAccessor) {
            return ((SocketAccessor)((Object)this.session)).getSocket();
        }
        return null;
    }
}

