/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.org.apache.lucene.analysis.miscellaneous;

import com.google.appengine.repackaged.org.apache.lucene.analysis.Token;
import com.google.appengine.repackaged.org.apache.lucene.analysis.TokenStream;
import com.google.appengine.repackaged.org.apache.lucene.analysis.miscellaneous.PrefixAwareTokenFilter;
import java.io.IOException;

public class PrefixAndSuffixAwareTokenFilter
extends TokenStream {
    private PrefixAwareTokenFilter suffix;

    public PrefixAndSuffixAwareTokenFilter(TokenStream prefix, TokenStream input, TokenStream suffix) {
        super(suffix);
        prefix = new PrefixAwareTokenFilter(prefix, input){

            public Token updateSuffixToken(Token suffixToken, Token lastInputToken) {
                return PrefixAndSuffixAwareTokenFilter.this.updateInputToken(suffixToken, lastInputToken);
            }
        };
        this.suffix = new PrefixAwareTokenFilter(prefix, suffix){

            public Token updateSuffixToken(Token suffixToken, Token lastInputToken) {
                return PrefixAndSuffixAwareTokenFilter.this.updateSuffixToken(suffixToken, lastInputToken);
            }
        };
    }

    public Token updateInputToken(Token inputToken, Token lastPrefixToken) {
        inputToken.setStartOffset(lastPrefixToken.endOffset() + inputToken.startOffset());
        inputToken.setEndOffset(lastPrefixToken.endOffset() + inputToken.endOffset());
        return inputToken;
    }

    public Token updateSuffixToken(Token suffixToken, Token lastInputToken) {
        suffixToken.setStartOffset(lastInputToken.endOffset() + suffixToken.startOffset());
        suffixToken.setEndOffset(lastInputToken.endOffset() + suffixToken.endOffset());
        return suffixToken;
    }

    public final boolean incrementToken() throws IOException {
        return this.suffix.incrementToken();
    }

    public final Token next(Token reusableToken) throws IOException {
        return super.next(reusableToken);
    }

    public final Token next() throws IOException {
        return super.next();
    }

    public void reset() throws IOException {
        this.suffix.reset();
    }

    public void close() throws IOException {
        this.suffix.close();
    }
}

