/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.taskqueue.dev;

import com.google.appengine.api.taskqueue.TaskQueuePb;
import com.google.appengine.api.taskqueue.dev.QueueStateInfo;
import com.google.apphosting.utils.config.QueueXml;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Logger;

abstract class DevQueue {
    protected static final Logger logger = Logger.getLogger(DevQueue.class.getName());
    protected final QueueXml.Entry queueXmlEntry;
    protected final AtomicInteger taskNameGenerator;

    DevQueue(QueueXml.Entry queueXmlEntry, AtomicInteger taskNameGenerator) {
        this.queueXmlEntry = queueXmlEntry;
        this.taskNameGenerator = taskNameGenerator;
    }

    String genTaskName() {
        Integer newId = this.taskNameGenerator.incrementAndGet();
        return "task" + newId.toString();
    }

    abstract TaskQueuePb.TaskQueueAddResponse add(TaskQueuePb.TaskQueueAddRequest var1);

    protected String getQueueName() {
        return this.queueXmlEntry.getName();
    }

    abstract QueueStateInfo getStateInfo();

    abstract boolean deleteTask(String var1);

    abstract void flush();

    abstract TaskQueuePb.TaskQueueMode.Mode getMode();

    abstract boolean runTask(String var1);
}

