/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.channel.dev;

import com.google.appengine.api.channel.dev.ChannelManager;
import com.google.appengine.api.channel.dev.LocalChannelFailureException;
import java.io.IOException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class LocalChannelServlet
extends HttpServlet {
    public static final String COMMAND_PARAM = "command";
    public static final String CHANNEL_PARAM = "channel";
    public static final String CLIENT_PARAM = "client";

    String getChannelId(HttpServletRequest req) {
        String channelId = req.getParameter(CHANNEL_PARAM);
        if (channelId != null) {
            channelId = channelId.trim();
        }
        return channelId;
    }

    String getClientId(HttpServletRequest req) {
        String clientId = req.getParameter(CLIENT_PARAM);
        if (clientId != null) {
            clientId = clientId.trim();
        }
        return clientId;
    }

    public void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        ChannelManager channelManager = ChannelManager.getInstance();
        String action = req.getParameter(COMMAND_PARAM);
        String channelId = this.getChannelId(req);
        String clientId = this.getClientId(req);
        if (action == null) {
            throw new LocalChannelFailureException("Action cannot be null.");
        }
        if (action.equals("connect")) {
            resp.setContentType("text/plain");
            resp.getWriter().println(channelManager.connectClient(channelId));
        } else if (action.equals("disconnect")) {
            channelManager.disconnectClient(channelId, clientId);
        } else if (action.equals("poll")) {
            String message = channelManager.getNextClientMessage(channelId, clientId);
            if (message != null) {
                resp.setContentType("text/plain");
                resp.getWriter().println(message);
            }
        } else {
            throw new LocalChannelFailureException("Unrecognized action: " + action);
        }
    }
}

