/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.appstats;

import com.google.appengine.tools.appstats.Recorder;
import com.google.appengine.tools.appstats.RecordingData;
import com.google.apphosting.api.ApiProxy;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class RecordingFuture
implements Future<byte[]> {
    final Future<byte[]> wrappedFuture;
    private final RecordingData recordingData;
    private final Recorder recorder;
    private final ApiProxy.Environment environment;

    public static RecordingFuture of(Future<byte[]> wrappedFuture, RecordingData recordingData, Recorder recorder, ApiProxy.Environment environment) {
        if (wrappedFuture instanceof ApiProxy.ApiResultFuture) {
            return new ExtendedFuture(wrappedFuture, recordingData, recorder, environment);
        }
        return new RecordingFuture(wrappedFuture, recordingData, recorder, environment);
    }

    private RecordingFuture(Future<byte[]> wrappedFuture, RecordingData recordingData, Recorder recorder, ApiProxy.Environment environment) {
        this.wrappedFuture = wrappedFuture;
        this.recordingData = recordingData;
        this.environment = environment;
        this.recorder = recorder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        try {
            boolean bl = this.wrappedFuture.cancel(mayInterruptIfRunning);
            return bl;
        }
        finally {
            this.maybeRecordStats();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] get() throws InterruptedException, ExecutionException {
        try {
            byte[] byArray = this.wrappedFuture.get();
            return byArray;
        }
        finally {
            this.maybeRecordStats();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        try {
            byte[] byArray = this.wrappedFuture.get(timeout, unit);
            return byArray;
        }
        finally {
            this.maybeRecordStats();
        }
    }

    @Override
    public boolean isCancelled() {
        return this.wrappedFuture.isCancelled();
    }

    @Override
    public boolean isDone() {
        return this.wrappedFuture.isDone();
    }

    public RecordingData getRecordingData() {
        return this.recordingData;
    }

    private void maybeRecordStats() {
        if (!this.recordingData.isProcessed()) {
            this.recorder.processAsyncRpc(this, this.environment);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ExtendedFuture
    extends RecordingFuture
    implements ApiProxy.ApiResultFuture<byte[]> {
        private final ApiProxy.ApiResultFuture<byte[]> extendedFuture;

        private ExtendedFuture(Future<byte[]> wrappedFuture, RecordingData recordingData, Recorder recorder, ApiProxy.Environment environment) {
            super(wrappedFuture, recordingData, recorder, environment);
            this.extendedFuture = (ApiProxy.ApiResultFuture)wrappedFuture;
        }

        public long getCpuTimeInMegaCycles() {
            return this.extendedFuture.getCpuTimeInMegaCycles();
        }

        public long getWallclockTimeInMillis() {
            return this.extendedFuture.getWallclockTimeInMillis();
        }
    }
}

