package com.cybelia.sandra.security;

/**
 * Class représentant les ajouts nécessaires à la requête pour un type d'objet
 * pour un profile.
 */
public class Filter {

    protected String from;
    protected String where;

    public static Filter NoFilter = new Filter();

    //FIXME: Fonctionne pas avec les requêtes avec plusieurs objets
    public static Filter AllFilter = new Filter("topiaId is null");

    public Filter(String from, String where) {
        this(where);
        this.from = from;
    }

    public Filter(String where) {
        this();
        this.where = where;
    }

    public Filter() {
        super();
    }

    public boolean needParameter(String name) {
        return where != null && where.contains(name);
    }

    /**
     * Ajout les éléments supplémentaires à la clause from de la requête
     */
    protected String addFrom(String query) {
        if (from != null) {
            String comma = ",";
            if (from.startsWith("JOIN")) {
                comma = "";
            }
            if (query.contains("WHERE")) {
                return query.replaceFirst("WHERE", comma + " " + from + " WHERE");
            } else {
                if (query.contains("ORDER BY")) {
                    return query.replaceFirst("ORDER BY", comma + " " + from + " ORDER BY");
                } else {
                    return query + comma + " " + from;
                }
            }
        } else {
            return query;
        }
    }

    /**
     * Ajout les éléments supplémentaires à la clause where de la requête
     */
    protected String addWhere(String query) {
        if (where != null) {
            if (query.contains("WHERE")) {
                return query.replaceFirst("WHERE", "WHERE (" + where + ") AND ");
            } else {
                if (query.contains("ORDER BY")) {
                    return query.replaceFirst("ORDER BY", "WHERE " + where + " ORDER BY ");
                } else {
                    return query + " WHERE " + where;
                }
            }
        } else {
            return query;
        }
    }

    /**
     * Ajout les éléments supplémentaires à la requête
     */
    public String addFilter(String query) {
        query = addFrom(query);
        query = addWhere(query);
        return query;
    }
}
