package com.cybelia.sandra.notifier;

import com.cybelia.sandra.SandraSchedulerConfigHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;

/**
 * @author sletellier
 */
public class ThreadNotifyEvent extends Thread {

    protected static final Log log = LogFactory.getLog(ThreadNotifyEvent.class);

    protected String type;
    protected String[] values;
    protected SandraNotifier notifier;

    public ThreadNotifyEvent(SandraNotifier notifier, String type, String[] values) {
        this.type = type;
        this.values = values;
        this.notifier = notifier;
    }

    @Override
    @SuppressWarnings("empty-statement")
    public void run() {
        if (log.isDebugEnabled()) {
            log.debug("Starting thread " + getName());
        }
        TopiaContext transaction = null;
        try {
            // New transaction
            TopiaContext ibuRootContext = SandraSchedulerConfigHelper.getSchedulerRootContext();
            transaction = ibuRootContext.beginTransaction();

            notifier.doNotifyEvent(transaction, type, values);


        } catch (Exception eee) {
            log.error("Error notify event", eee);
        } finally {
            // Close context
            if (transaction != null) {
                try {
                    if (!transaction.isClosed()) {
                        transaction.commitTransaction();
                        transaction.closeContext();
                    }
                } catch (TopiaException eee) {
                    log.error("Failed closing connection : ", eee);
                }
            }

            if (log.isDebugEnabled()) {
                log.debug("Stopping thread " + getName());
            }
        }
    }
}