package com.cybelia.sandra.ibu.csv.reader;

import com.cybelia.sandra.ibu.csv.CSVReaderGeneric;
import com.cybelia.sandra.ibu.csv.bean.IbuEleveurGPS;
import java.util.HashMap;
import java.util.Map;

/**
 * Permet de parser un fichier CSV et de recuperer les beans EleveurGPS associes.
 *
 * @author sletellier
 */
public class CSVReaderEleveurGPS extends CSVReaderGeneric<IbuEleveurGPS> {
    protected void initStrategy() {
        strategy.setType(IbuEleveurGPS.class);

        Map<String, String> mapping = new HashMap<String, String>();
        strategy.setColumnMapping(mapping);
        mapping.put("STE", "codeSociete");
        mapping.put("TIE", "codeEleveur");
        mapping.put("X", "x");
        mapping.put("Y", "y");
    }
}
