package com.cybelia.sandra.ibu;

import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class MigrationContext {

    protected List<String> errorMsgs;
    protected List<String> lines;
    protected List<Integer> parserErrorLineNumbers;
    protected List<Integer> injectorErrorLineNumbers;
    protected String errorBaseFileName;
    protected String sourceFilePath;
    protected String sourceFileName;

    public MigrationContext() {
        this.errorMsgs = new ArrayList<String>();
        this.parserErrorLineNumbers = new ArrayList<Integer>();
        this.injectorErrorLineNumbers = new ArrayList<Integer>();
        this.lines = new ArrayList<String>();
    }

    public List<String> getErrorMsgs() {
        return errorMsgs;
    }

    public void addErrorMsg(String errorMsg) {
        errorMsgs.add(errorMsg);
    }

    public void setFilePath(String inputFileName) {
        sourceFilePath = inputFileName;
        sourceFileName = new File(inputFileName).getName();
    }

    public void setErrorFilePath(String outputFolder) {
        errorBaseFileName = outputFolder + File.separatorChar + sourceFileName;
    }

    public List<Integer> getParserErrorLineNumbers() {
        return parserErrorLineNumbers;
    }

    public String getParserErrorFilePath() {
        return errorBaseFileName + "_parsing.err";
    }

    public String getInjectorErrorFilePath() {
        return errorBaseFileName + "_injector.err";
    }

    public List<String> getLines() {
        return lines;
    }

    public String getLinesAsString() {
        String result = "";
        for (String l : lines) {
            result += l;
        }
        return result;
    }

    public String getParserErrorLinesAsString() {
        String result = "";
        for (int i : parserErrorLineNumbers) {
            result += lines.get(i);
        }
        return result;
    }

    public List<String> getParserErrorLines() {
        List<String> result = new ArrayList<String>();
        for (int i : parserErrorLineNumbers) {
            result.add(lines.get(i));
        }
        return result;
    }

    public String getInjectorErrorLinesAsString() {
        String result = "";
        for (int i : injectorErrorLineNumbers) {
            result += lines.get(i);
        }
        return result;
    }

    public List<String> getInjectorErrorLines() {
        List<String> result = new ArrayList<String>();
        for (int i : injectorErrorLineNumbers) {
            result.add(lines.get(i));
        }
        return result;
    }

    public void setLines(List<String> lines) {
        this.lines = lines;
    }

    public List<Integer> getInjectorErrorLineNumbers() {
        return injectorErrorLineNumbers;
    }

    public void setSourceFileName(String sourceFileName) {
        this.sourceFileName = sourceFileName;
    }

    public synchronized String getSourceFileName() {
        return sourceFileName;
    }

    public synchronized String getSourceFilePath() {
        return sourceFilePath;
    }

    public String getErrorBaseFileName() {
        return errorBaseFileName;
    }
} //MigrationContext
