/*
 * Decompiled with CFR 0.152.
 */
package smile.sequence;

import java.util.Arrays;
import java.util.function.Function;
import smile.data.Tuple;
import smile.sequence.CRF;
import smile.sequence.SequenceLabeler;

public class CRFLabeler<T>
implements SequenceLabeler<T> {
    private static final long serialVersionUID = 2L;
    private final CRF model;
    private final Function<T, Tuple> features;

    public CRFLabeler(CRF model, Function<T, Tuple> features) {
        this.model = model;
        this.features = features;
    }

    public static <T> CRFLabeler<T> fit(T[][] sequences, int[][] labels, Function<T, Tuple> features) {
        return CRFLabeler.fit(sequences, labels, features, new CRF.Options());
    }

    public static <T> CRFLabeler<T> fit(T[][] sequences, int[][] labels, Function<T, Tuple> features, CRF.Options options) {
        if (sequences.length != labels.length) {
            throw new IllegalArgumentException("The number of observation sequences and that of label sequences are different.");
        }
        CRF model = CRF.fit((Tuple[][])Arrays.stream(sequences).map(sequence -> (Tuple[])Arrays.stream(sequence).map(features).toArray(Tuple[]::new)).toArray(x$0 -> new Tuple[x$0][]), labels, options);
        return new CRFLabeler<T>(model, features);
    }

    public String toString() {
        return this.model.toString();
    }

    private Tuple[] translate(T[] o) {
        return (Tuple[])Arrays.stream(o).map(this.features).toArray(Tuple[]::new);
    }

    @Override
    public int[] predict(T[] o) {
        return this.model.predict(this.translate(o));
    }

    public int[] viterbi(T[] o) {
        return this.model.viterbi(this.translate(o));
    }
}

