/*
 * Decompiled with CFR 0.152.
 */
package smile.manifold;

import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import smile.linalg.UPLO;
import smile.math.MathEx;
import smile.tensor.ARPACK;
import smile.tensor.DenseMatrix;
import smile.tensor.EVD;
import smile.tensor.Matrix;
import smile.tensor.ScalarType;
import smile.tensor.Vector;

public record MDS(double[] scores, double[] proportion, double[][] coordinates) {
    private static final Logger logger = LoggerFactory.getLogger(MDS.class);

    public static MDS fit(double[][] proximity) {
        return MDS.fit(proximity, new Options());
    }

    public static MDS fit(double[][] proximity, Options options) {
        int m = proximity.length;
        int n = proximity[0].length;
        if (m != n) {
            throw new IllegalArgumentException("The proximity matrix is not square.");
        }
        int d = options.d;
        if (d >= n) {
            throw new IllegalArgumentException("Invalid d = " + d);
        }
        DenseMatrix B = MDS.getGram(proximity);
        if (options.positive) {
            int i;
            DenseMatrix Z = B.zeros(2 * n, 2 * n);
            for (i = 0; i < n; ++i) {
                for (int j = 0; j < n; ++j) {
                    Z.set(i, n + j, 2.0 * B.get(i, j));
                }
            }
            for (i = 0; i < n; ++i) {
                Z.set(n + i, i, -1.0);
            }
            double[] mean = MathEx.rowMeans((double[][])proximity);
            double mu = MathEx.mean((double[])mean);
            for (int i2 = 0; i2 < n; ++i2) {
                for (int j = 0; j < n; ++j) {
                    Z.set(n + i2, n + j, 2.0 * (proximity[i2][j] - mean[i2] - mean[j] + mu));
                }
            }
            Vector eigvalues = Z.eigen(false, false).wr();
            double c = eigvalues.max();
            for (int i3 = 0; i3 < n; ++i3) {
                B.set(i3, i3, 0.0);
                for (int j = 0; j < i3; ++j) {
                    double x = -0.5 * MathEx.pow2((double)(proximity[i3][j] + c));
                    B.set(i3, j, x);
                    B.set(j, i3, x);
                }
            }
        }
        B.withUplo(UPLO.LOWER);
        EVD eigen = ARPACK.syev((Matrix)B, (ARPACK.SymmOption)ARPACK.SymmOption.LA, (int)d);
        if (eigen.wr().size() < d) {
            logger.warn("eigen({}) returns only {} eigen vectors", (Object)d, (Object)eigen.wr().size());
            d = eigen.wr().size();
        }
        double[][] coordinates = new double[n][d];
        for (int j = 0; j < d; ++j) {
            if (eigen.wr().get(j) < 0.0) {
                throw new IllegalArgumentException(String.format("Some of the first %d eigenvalues are < 0.", d));
            }
            double scale = Math.sqrt(eigen.wr().get(j));
            for (int i = 0; i < n; ++i) {
                coordinates[i][j] = eigen.Vr().get(i, j) * scale;
            }
        }
        double[] eigenvalues = eigen.wr().toArray(new double[0]);
        double[] proportion = (double[])eigenvalues.clone();
        MathEx.unitize1((double[])proportion);
        return new MDS(eigenvalues, proportion, coordinates);
    }

    private static DenseMatrix getGram(double[][] proximity) {
        int n = proximity[0].length;
        DenseMatrix A = DenseMatrix.zeros((ScalarType)ScalarType.Float64, (int)n, (int)n);
        DenseMatrix B = DenseMatrix.zeros((ScalarType)ScalarType.Float64, (int)n, (int)n);
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < i; ++j) {
                double x = -0.5 * MathEx.pow2((double)proximity[i][j]);
                A.set(i, j, x);
                A.set(j, i, x);
            }
        }
        Vector mean = A.rowMeans();
        double mu = mean.mean();
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j <= i; ++j) {
                double x = A.get(i, j) - mean.get(i) - mean.get(j) + mu;
                B.set(i, j, x);
                B.set(j, i, x);
            }
        }
        return B;
    }

    public record Options(int d, boolean positive) {
        public Options {
            if (d < 2) {
                throw new IllegalArgumentException("Invalid dimension of feature space: " + d);
            }
        }

        public Options() {
            this(2, false);
        }

        public Properties toProperties() {
            Properties props = new Properties();
            props.setProperty("smile.mds.d", Integer.toString(this.d));
            props.setProperty("smile.mds.positive", Boolean.toString(this.positive));
            return props;
        }

        public static Options of(Properties props) {
            int d = Integer.parseInt(props.getProperty("smile.mds.d", "2"));
            boolean positive = Boolean.parseBoolean(props.getProperty("smile.mds.positive", "false"));
            return new Options(d, positive);
        }
    }
}

