/*
 * Decompiled with CFR 0.152.
 */
package smile.manifold;

import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import smile.graph.AdjacencyList;
import smile.graph.NearestNeighborGraph;
import smile.linalg.UPLO;
import smile.math.MathEx;
import smile.math.distance.Distance;
import smile.tensor.ARPACK;
import smile.tensor.DenseMatrix;
import smile.tensor.EVD;
import smile.tensor.Matrix;
import smile.tensor.ScalarType;

public class IsoMap {
    private static final Logger logger = LoggerFactory.getLogger(IsoMap.class);

    private IsoMap() {
    }

    public static double[][] fit(double[][] data, Options options) {
        return IsoMap.fit(data, MathEx::distance, options);
    }

    public static <T> double[][] fit(T[] data, Distance<T> distance, Options options) {
        NearestNeighborGraph nng = NearestNeighborGraph.of((Object[])data, distance, (int)options.k);
        return IsoMap.fit(nng.largest(false), options);
    }

    public static double[][] fit(NearestNeighborGraph nng, Options options) {
        int i;
        int d = options.d;
        boolean conformal = options.conformal;
        AdjacencyList graph = nng.graph(false);
        if (conformal) {
            double[] M2 = MathEx.rowMeans((double[][])nng.distances());
            int n = M2.length;
            for (i = 0; i < n; ++i) {
                M2[i] = Math.sqrt(M2[i]);
            }
            for (i = 0; i < n; ++i) {
                double Mi = M2[i];
                graph.updateEdges(i, (j, w) -> w / (Mi * M2[j]));
            }
        }
        int n = graph.getVertexCount();
        double[][] D = graph.dijkstra();
        for (i = 0; i < n; ++i) {
            for (int j2 = 0; j2 < i; ++j2) {
                D[i][j2] = -0.5 * D[i][j2] * D[i][j2];
                D[j2][i] = D[i][j2];
            }
        }
        double[] mean = MathEx.rowMeans((double[][])D);
        double mu = MathEx.mean((double[])mean);
        DenseMatrix B = DenseMatrix.zeros((ScalarType)ScalarType.Float64, (int)n, (int)n);
        for (int i2 = 0; i2 < n; ++i2) {
            for (int j3 = 0; j3 <= i2; ++j3) {
                double b = D[i2][j3] - mean[i2] - mean[j3] + mu;
                B.set(i2, j3, b);
                B.set(j3, i2, b);
            }
        }
        B.withUplo(UPLO.LOWER);
        EVD eigen = ARPACK.syev((Matrix)B, (ARPACK.SymmOption)ARPACK.SymmOption.LA, (int)d);
        if (eigen.wr().size() < d) {
            logger.warn("eigen({}) returns only {} eigen vectors", (Object)d, (Object)eigen.wr().size());
            d = eigen.wr().size();
        }
        DenseMatrix V = eigen.Vr();
        double[][] coordinates = new double[n][d];
        for (int j4 = 0; j4 < d; ++j4) {
            if (eigen.wr().get(j4) < 0.0) {
                throw new IllegalArgumentException(String.format("Some of the first %d eigenvalues are < 0.", d));
            }
            double scale = Math.sqrt(eigen.wr().get(j4));
            for (int i3 = 0; i3 < n; ++i3) {
                coordinates[i3][j4] = V.get(i3, j4) * scale;
            }
        }
        return coordinates;
    }

    public record Options(int k, int d, boolean conformal) {
        public Options {
            if (k < 2) {
                throw new IllegalArgumentException("Invalid number of nearest neighbors: " + k);
            }
            if (d < 2) {
                throw new IllegalArgumentException("Invalid dimension of feature space: " + d);
            }
        }

        public Options(int k) {
            this(k, 2, true);
        }

        public Properties toProperties() {
            Properties props = new Properties();
            props.setProperty("smile.isomap.k", Integer.toString(this.k));
            props.setProperty("smile.isomap.d", Integer.toString(this.d));
            props.setProperty("smile.isomap.conformal", Boolean.toString(this.conformal));
            return props;
        }

        public static Options of(Properties props) {
            int k = Integer.parseInt(props.getProperty("smile.isomap.k", "7"));
            int d = Integer.parseInt(props.getProperty("smile.isomap.d", "2"));
            boolean conformal = Boolean.parseBoolean(props.getProperty("smile.isomap.conformal", "true"));
            return new Options(k, d, conformal);
        }
    }
}

