/*
 * Decompiled with CFR 0.152.
 */
package smile.anomaly;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Properties;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import smile.anomaly.IsolationTree;
import smile.math.MathEx;

public class IsolationForest
implements Serializable {
    private static final long serialVersionUID = 2L;
    private static final Logger logger = LoggerFactory.getLogger(IsolationForest.class);
    private static final double EULER = 0.5772156649;
    private final IsolationTree[] trees;
    private final double c;
    private final int extensionLevel;

    public IsolationForest(int n, int extensionLevel, IsolationTree ... trees) {
        this.trees = trees;
        this.extensionLevel = extensionLevel;
        this.c = IsolationForest.factor(n);
    }

    public static IsolationForest fit(double[][] data) {
        return IsolationForest.fit(data, new Options());
    }

    public static IsolationForest fit(double[][] data, Options options) {
        int extensionLevel;
        int n = extensionLevel = options.extensionLevel > 0 ? options.extensionLevel : data[0].length - 1;
        if (options.extensionLevel >= data[0].length) {
            throw new IllegalArgumentException("Invalid extension level: " + extensionLevel);
        }
        int maxDepth = options.maxDepth > 0 ? options.maxDepth : (int)MathEx.log2((double)data.length);
        int n2 = data.length;
        int m = (int)Math.round((double)n2 * options.subsample);
        IsolationTree[] trees = (IsolationTree[])IntStream.range(0, options.ntrees).parallel().mapToObj(k -> {
            ArrayList<double[]> samples = new ArrayList<double[]>(m);
            for (int i : MathEx.permutate((int)n2)) {
                samples.add(data[i]);
            }
            return new IsolationTree(samples, maxDepth, extensionLevel);
        }).toArray(IsolationTree[]::new);
        return new IsolationForest(n2, extensionLevel, trees);
    }

    public int size() {
        return this.trees.length;
    }

    public IsolationTree[] trees() {
        return this.trees;
    }

    public int getExtensionLevel() {
        return this.extensionLevel;
    }

    public double score(double[] x) {
        double length = 0.0;
        for (IsolationTree tree : this.trees) {
            length += tree.path(x);
        }
        return Math.pow(2.0, -(length /= (double)this.trees.length) / this.c);
    }

    public double[] score(double[][] x) {
        return ((Stream)Arrays.stream(x).parallel()).mapToDouble(this::score).toArray();
    }

    static double factor(int n) {
        return 2.0 * (Math.log(n - 1) + 0.5772156649 - ((double)n - 1.0) / (double)n);
    }

    public record Options(int ntrees, int maxDepth, double subsample, int extensionLevel) {
        public Options {
            if (ntrees < 1) {
                throw new IllegalArgumentException("Invalid number of trees: " + ntrees);
            }
            if (subsample <= 0.0 || subsample >= 1.0) {
                throw new IllegalArgumentException("Invalid sampling rating: " + subsample);
            }
        }

        public Options() {
            this(100, 0, 0.7, 0);
        }

        public Properties toProperties() {
            Properties props = new Properties();
            props.setProperty("smile.isolation_forest.trees", Integer.toString(this.ntrees));
            props.setProperty("smile.isolation_forest.max_depth", Integer.toString(this.maxDepth));
            props.setProperty("smile.isolation_forest.sampling_rate", Double.toString(this.subsample));
            props.setProperty("smile.isolation_forest.extension_level", Integer.toString(this.extensionLevel));
            return props;
        }

        public static Options of(Properties props) {
            int ntrees = Integer.parseInt(props.getProperty("smile.isolation_forest.trees", "100"));
            int maxDepth = Integer.parseInt(props.getProperty("smile.isolation_forest.max_depth", "0"));
            double subsample = Double.parseDouble(props.getProperty("smile.isolation_forest.sampling_rate", "0.7"));
            int extensionLevel = Integer.parseInt(props.getProperty("smile.isolation_forest.extension_level", "0"));
            return new Options(ntrees, maxDepth, subsample, extensionLevel);
        }
    }
}

