/*
 * Copyright (c) 2010-2021 Haifeng Li. All rights reserved.
 *
 * Smile is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Smile is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Smile.  If not, see <https://www.gnu.org/licenses/>.
 */

/**
 * Regression analysis. In statistics, regression analysis includes any
 * techniques for modeling and analyzing several variables, when the focus
 * is on the relationship between a dependent variable and one or more
 * independent variables. Most commonly, regression analysis estimates the
 * conditional expectation of the dependent variable given the independent
 * variables. Therefore, the estimation target is a function of the independent
 * variables called the regression function. Regression analysis is widely
 * used for prediction and forecasting, where its use has substantial overlap
 * with the field of machine learning. 
 * 
 * @author Haifeng Li
 */
package smile.regression;
