/*
 * Decompiled with CFR 0.152.
 */
package smile.tensor;

import java.lang.runtime.SwitchBootstraps;
import java.util.Arrays;
import java.util.Objects;
import smile.tensor.ScalarType;
import smile.tensor.Tensor;

public record Scalar(Number value) implements Tensor
{
    private static final int[] shape = new int[]{1};

    @Override
    public ScalarType scalarType() {
        Number number = this.value;
        Objects.requireNonNull(number);
        Number number2 = number;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Byte.class, Short.class, Integer.class, Long.class, Float.class, Double.class}, (Number)number2, n)) {
            case 0 -> {
                Byte b = (Byte)number2;
                yield ScalarType.Int8;
            }
            case 1 -> {
                Short b = (Short)number2;
                yield ScalarType.Int16;
            }
            case 2 -> {
                Integer b = (Integer)number2;
                yield ScalarType.Int32;
            }
            case 3 -> {
                Long b = (Long)number2;
                yield ScalarType.Int64;
            }
            case 4 -> {
                Float b = (Float)number2;
                yield ScalarType.Int32;
            }
            case 5 -> {
                Double b = (Double)number2;
                yield ScalarType.Int64;
            }
            default -> throw new RuntimeException("Unsupported Scalar value type: " + String.valueOf(this.value.getClass()));
        };
    }

    @Override
    public int dim() {
        return 0;
    }

    @Override
    public int size(int dim) {
        return 1;
    }

    @Override
    public long length() {
        return 1L;
    }

    @Override
    public int[] shape() {
        return shape;
    }

    @Override
    public Tensor reshape(int ... shape) {
        if (shape.length > 1 || shape[0] != 1) {
            throw new UnsupportedOperationException("Cannot reshape a scalar to higher rank: " + Arrays.toString(shape));
        }
        return this;
    }

    @Override
    public Tensor set(Tensor value, int ... index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Tensor get(int ... index) {
        throw new UnsupportedOperationException();
    }

    public boolean toBoolean() {
        return this.value.intValue() != 0;
    }

    public byte toByte() {
        return this.value.byteValue();
    }

    public short toShort() {
        return this.value.shortValue();
    }

    public int toInt() {
        return this.value.intValue();
    }

    public long toLong() {
        return this.value.longValue();
    }

    public float toFloat() {
        return this.value.floatValue();
    }

    public double toDouble() {
        return this.value.doubleValue();
    }
}

