/*
 * Decompiled with CFR 0.152.
 */
package smile.io;

import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.avro.Schema;
import org.apache.avro.file.DataFileStream;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.io.DatumReader;
import org.apache.avro.util.Utf8;
import smile.data.DataFrame;
import smile.data.Tuple;
import smile.data.measure.Measure;
import smile.data.measure.NominalScale;
import smile.data.type.DataType;
import smile.data.type.DataTypes;
import smile.data.type.StructField;
import smile.data.type.StructType;

public class Avro {
    private final Schema schema;

    public Avro(Schema schema) {
        if (schema.getType() != Schema.Type.RECORD) {
            throw new IllegalArgumentException("The type of schema is not Record");
        }
        this.schema = schema;
    }

    public Avro(InputStream schema) throws IOException {
        this(new Schema.Parser().parse(schema));
    }

    public Avro(Path schema) throws IOException {
        this(Files.newInputStream(schema, new OpenOption[0]));
    }

    public DataFrame read(Path path) throws IOException {
        return this.read(Files.newInputStream(path, new OpenOption[0]), Integer.MAX_VALUE);
    }

    public DataFrame read(String path) throws IOException, URISyntaxException {
        return this.read(Files.newInputStream(Path.of(path, new String[0]), new OpenOption[0]), Integer.MAX_VALUE);
    }

    public DataFrame read(InputStream input, int limit) throws IOException {
        GenericDatumReader datumReader = new GenericDatumReader(this.schema);
        try (DataFileStream dataFileReader = new DataFileStream(input, (DatumReader)datumReader);){
            StructType struct = Avro.toStructType(this.schema);
            ArrayList<Tuple> rows = new ArrayList<Tuple>();
            GenericRecord record = null;
            while (dataFileReader.hasNext() && rows.size() < limit) {
                record = (GenericRecord)dataFileReader.next(record);
                Object[] row = new Object[struct.length()];
                for (int i = 0; i < row.length; ++i) {
                    row[i] = record.get(struct.field(i).name());
                    if (!(row[i] instanceof Utf8)) continue;
                    String str = row[i].toString();
                    Measure measure = struct.field(i).measure();
                    row[i] = measure != null ? measure.valueOf(str) : str;
                }
                rows.add(Tuple.of(struct, row));
            }
            DataFrame dataFrame = DataFrame.of(struct, rows);
            return dataFrame;
        }
    }

    public static DataType toDataType(Schema schema) {
        return Avro.toDataType(schema, false);
    }

    private static DataType toDataType(Schema schema, boolean nullable) {
        return switch (schema.getType()) {
            case Schema.Type.BOOLEAN -> {
                if (nullable) {
                    yield DataTypes.NullableBooleanType;
                }
                yield DataTypes.BooleanType;
            }
            case Schema.Type.INT -> {
                if (nullable) {
                    yield DataTypes.NullableIntType;
                }
                yield DataTypes.IntType;
            }
            case Schema.Type.LONG -> {
                if (nullable) {
                    yield DataTypes.NullableLongType;
                }
                yield DataTypes.LongType;
            }
            case Schema.Type.FLOAT -> {
                if (nullable) {
                    yield DataTypes.NullableFloatType;
                }
                yield DataTypes.FloatType;
            }
            case Schema.Type.DOUBLE -> {
                if (nullable) {
                    yield DataTypes.NullableDoubleType;
                }
                yield DataTypes.DoubleType;
            }
            case Schema.Type.STRING -> DataTypes.StringType;
            case Schema.Type.FIXED, Schema.Type.BYTES -> DataTypes.ByteArrayType;
            case Schema.Type.ENUM -> new NominalScale(schema.getEnumSymbols()).type();
            case Schema.Type.ARRAY -> DataTypes.array(Avro.toDataType(schema.getElementType(), nullable));
            case Schema.Type.MAP -> DataTypes.object(Map.class);
            case Schema.Type.UNION -> Avro.avroUnion(schema.getTypes());
            default -> throw new UnsupportedOperationException("Unsupported Avro type: " + String.valueOf(schema));
        };
    }

    private static DataType avroUnion(List<Schema> union) {
        if (union.isEmpty()) {
            throw new IllegalArgumentException("Empty type list of Union");
        }
        if (union.size() > 2) {
            String s = union.stream().map(Schema::getType).map(Object::toString).collect(Collectors.joining(", "));
            throw new UnsupportedOperationException(String.format("Unsupported type Union(%s)", s));
        }
        if (union.size() == 1) {
            return Avro.toDataType(union.getFirst(), false);
        }
        Schema a = union.get(0);
        Schema b = union.get(1);
        if (a.getType() == Schema.Type.NULL && b.getType() != Schema.Type.NULL) {
            return Avro.toDataType(b, true);
        }
        if (a.getType() != Schema.Type.NULL && b.getType() == Schema.Type.NULL) {
            return Avro.toDataType(a, true);
        }
        return DataTypes.object(Object.class);
    }

    public static StructField toStructField(Schema.Field field) {
        NominalScale scale = null;
        if (field.schema().getType() == Schema.Type.ENUM) {
            scale = new NominalScale(field.schema().getEnumSymbols());
        }
        return new StructField(field.name(), Avro.toDataType(field.schema()), scale);
    }

    public static StructType toStructType(Schema schema) {
        ArrayList<StructField> fields = new ArrayList<StructField>();
        for (Schema.Field field : schema.getFields()) {
            fields.add(Avro.toStructField(field));
        }
        return new StructType(fields);
    }
}

