/*
 * Decompiled with CFR 0.152.
 */
package smile.interpolation;

import smile.interpolation.Interpolation;

public abstract class AbstractInterpolation
implements Interpolation {
    private final int dj;
    private int jsav;
    private boolean cor;
    int n;
    double[] xx;
    double[] yy;

    public AbstractInterpolation(double[] x, double[] y) {
        if (x.length != y.length) {
            throw new IllegalArgumentException("x and y have different length");
        }
        this.n = x.length;
        if (this.n < 2) {
            throw new IllegalArgumentException("locate size error");
        }
        this.xx = x;
        this.yy = y;
        this.jsav = 0;
        this.cor = false;
        this.dj = Math.min(1, (int)Math.pow(this.n, 0.25));
    }

    @Override
    public double interpolate(double x) {
        int jlo = this.search(x);
        return this.rawinterp(jlo, x);
    }

    protected int search(double x) {
        return this.cor ? this.hunt(x) : this.locate(x);
    }

    private int locate(double x) {
        boolean ascnd = this.xx[this.n - 1] >= this.xx[0];
        int jl = 0;
        int ju = this.n - 1;
        while (ju - jl > 1) {
            int jm = ju + jl >> 1;
            if (x >= this.xx[jm] == ascnd) {
                jl = jm;
                continue;
            }
            ju = jm;
        }
        this.cor = Math.abs(jl - this.jsav) <= this.dj;
        this.jsav = jl;
        return Math.max(0, Math.min(this.n - 2, jl));
    }

    private int hunt(double x) {
        int ju;
        boolean ascnd;
        int jl = this.jsav;
        int inc = 1;
        boolean bl = ascnd = this.xx[this.n - 1] >= this.xx[0];
        if (jl < 0 || jl > this.n - 1) {
            jl = 0;
            ju = this.n - 1;
        } else if (x >= this.xx[jl] == ascnd) {
            while (true) {
                if ((ju = jl + inc) >= this.n - 1) {
                    ju = this.n - 1;
                } else if (x < this.xx[ju] != ascnd) {
                    jl = ju;
                    inc += inc;
                    continue;
                }
                break;
            }
        } else {
            ju = jl;
            while (true) {
                if ((jl -= inc) <= 0) {
                    jl = 0;
                    break;
                }
                if (x >= this.xx[jl] == ascnd) break;
                ju = jl;
                inc += inc;
            }
        }
        while (ju - jl > 1) {
            int jm = ju + jl >> 1;
            if (x >= this.xx[jm] == ascnd) {
                jl = jm;
                continue;
            }
            ju = jm;
        }
        this.cor = Math.abs(jl - this.jsav) <= this.dj;
        this.jsav = jl;
        return Math.max(0, Math.min(this.n - 2, jl));
    }

    public abstract double rawinterp(int var1, double var2);
}

