/*
 * Decompiled with CFR 0.152.
 */
package smile.data.type;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.lang.reflect.RecordComponent;
import java.util.Arrays;
import smile.data.type.StructField;

public record Property(String name, Class<?> type, Method accessor, StructField field) {
    public static Property of(RecordComponent prop) {
        return new Property(prop.getName(), prop.getType(), prop.getAccessor(), StructField.of(prop));
    }

    public static Property of(PropertyDescriptor prop) {
        return new Property(prop.getName(), prop.getPropertyType(), prop.getReadMethod(), StructField.of(prop));
    }

    public static Property[] of(Class<?> clazz) throws IntrospectionException {
        if (clazz.isRecord()) {
            return (Property[])Arrays.stream(clazz.getRecordComponents()).map(Property::of).toArray(Property[]::new);
        }
        BeanInfo bean = Introspector.getBeanInfo(clazz);
        PropertyDescriptor[] props = bean.getPropertyDescriptors();
        return (Property[])Arrays.stream(props).filter(prop -> !prop.getName().equals("class")).map(Property::of).toArray(Property[]::new);
    }
}

