/*
 * Decompiled with CFR 0.152.
 */
package com.github.blagerweij.sessionlock;

import java.sql.Connection;
import java.sql.SQLException;
import liquibase.Scope;
import liquibase.database.Database;
import liquibase.database.DatabaseConnection;
import liquibase.database.jvm.JdbcConnection;
import liquibase.exception.DatabaseException;
import liquibase.exception.LockException;
import liquibase.lockservice.DatabaseChangeLogLock;
import liquibase.lockservice.StandardLockService;
import liquibase.logging.Logger;

public abstract class SessionLockService
extends StandardLockService {
    public int getPriority() {
        return super.getPriority() + 1;
    }

    public boolean supports(Database database) {
        return false;
    }

    public void init() throws DatabaseException {
    }

    private Connection getConnection() throws LockException {
        DatabaseConnection dbCon = this.database.getConnection();
        if (dbCon instanceof JdbcConnection) {
            return ((JdbcConnection)dbCon).getUnderlyingConnection();
        }
        throw new LockException("Not a JdbcConnection: " + dbCon);
    }

    public boolean acquireLock() throws LockException {
        if (this.hasChangeLogLock) {
            return true;
        }
        try {
            if (this.acquireLock(this.getConnection())) {
                this.hasChangeLogLock = true;
                SessionLockService.getLog(((Object)((Object)this)).getClass()).info("Successfully acquired change log lock");
                this.database.setCanCacheLiquibaseTableInfo(true);
                return true;
            }
            return false;
        }
        catch (SQLException e) {
            throw new LockException((Throwable)e);
        }
    }

    protected abstract boolean acquireLock(Connection var1) throws SQLException, LockException;

    public void releaseLock() throws LockException {
        try {
            this.releaseLock(this.getConnection());
            SessionLockService.getLog(((Object)((Object)this)).getClass()).info("Successfully released change log lock");
        }
        catch (SQLException e) {
            throw new LockException((Throwable)e);
        }
        finally {
            this.hasChangeLogLock = false;
            this.database.setCanCacheLiquibaseTableInfo(false);
        }
    }

    protected abstract void releaseLock(Connection var1) throws SQLException, LockException;

    public DatabaseChangeLogLock[] listLocks() throws LockException {
        try {
            DatabaseChangeLogLock[] databaseChangeLogLockArray;
            DatabaseChangeLogLock usedLock = this.usedLock(this.getConnection());
            if (usedLock == null) {
                databaseChangeLogLockArray = new DatabaseChangeLogLock[]{};
            } else {
                DatabaseChangeLogLock[] databaseChangeLogLockArray2 = new DatabaseChangeLogLock[1];
                databaseChangeLogLockArray = databaseChangeLogLockArray2;
                databaseChangeLogLockArray2[0] = usedLock;
            }
            return databaseChangeLogLockArray;
        }
        catch (SQLException e) {
            throw new LockException((Throwable)e);
        }
    }

    protected DatabaseChangeLogLock usedLock(Connection con) throws SQLException, LockException {
        return null;
    }

    protected static Logger getLog(Class<?> clazz) {
        return Scope.getCurrentScope().getLog(clazz);
    }
}

