/*
 * Decompiled with CFR 0.152.
 */
package com.franciaflex.faxtomail.web.action;

import com.franciaflex.faxtomail.persistence.entities.FaxToMailUser;
import com.franciaflex.faxtomail.services.service.LdapService;
import com.franciaflex.faxtomail.services.service.ldap.AuthenticationException;
import com.franciaflex.faxtomail.web.FaxToMailActionSupport;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.Result;

public class LoginAction
extends FaxToMailActionSupport {
    protected LdapService ldapService;
    protected String login;
    protected String password;

    public void setLdapService(LdapService ldapService) {
        this.ldapService = ldapService;
    }

    public void setLogin(String login) {
        this.login = login;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    @Action(value="login-input")
    public String input() throws Exception {
        return super.input();
    }

    @Action(results={@Result(type="redirectAction", params={"actionName", "index", "namespace", "/"})})
    public String execute() {
        String result = "success";
        try {
            FaxToMailUser user = this.ldapService.authenticateUser(this.login, this.password);
            this.getSession().setAuthenticatedUserId(user.getTopiaId());
        }
        catch (AuthenticationException ex) {
            result = "input";
            this.addActionError("Impossible de se connecter (Le serveur \u00e0 r\u00e9pondu : " + ex.getMessage() + ")");
        }
        return result;
    }
}

