/*
 * Decompiled with CFR 0.152.
 */
package com.franciaflex.faxtomail.ui.swing.content.demande.actions;

import com.franciaflex.faxtomail.persistence.entities.MailAction;
import com.franciaflex.faxtomail.ui.swing.actions.AbstractFaxToMailAction;
import com.franciaflex.faxtomail.ui.swing.content.demande.DemandeListUI;
import com.franciaflex.faxtomail.ui.swing.content.demande.DemandeListUIHandler;
import com.franciaflex.faxtomail.ui.swing.content.demande.DemandeListUIModel;
import com.franciaflex.faxtomail.ui.swing.content.demande.DemandeUIModel;
import com.franciaflex.faxtomail.ui.swing.content.transmit.MailFolderChooserUI;
import com.franciaflex.faxtomail.ui.swing.content.transmit.MailFolderChooserUIModel;
import com.franciaflex.faxtomail.ui.swing.util.FaxToMailUI;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import org.nuiton.i18n.I18n;

public class OpenMailFolderChooserFromListAction
extends AbstractFaxToMailAction<DemandeListUIModel, DemandeListUI, DemandeListUIHandler> {
    protected List<DemandeUIModel> demandsToTransmit;
    protected MailFolderChooserUI frameContent;
    protected JFrame frame;

    public OpenMailFolderChooserFromListAction(DemandeListUIHandler handler) {
        super(handler, false);
        this.setActionDescription(I18n.t((String)"faxtomail.action.openMailFolderChooser.tip", (Object[])new Object[0]));
    }

    public boolean prepareAction() throws Exception {
        boolean result = super.prepareAction();
        List<DemandeUIModel> selectedEmails = ((DemandeListUIModel)this.getModel()).getSelectedEmails();
        this.demandsToTransmit = new ArrayList<DemandeUIModel>();
        String notTransmitableDemandsTitle = "";
        for (DemandeUIModel demandeUIModel : selectedEmails) {
            if (!demandeUIModel.isEditable() || !((DemandeListUIHandler)this.handler).isActionEnabled(demandeUIModel, MailAction.TRANSMIT, ((DemandeListUIHandler)this.handler).getConfiguration())) {
                notTransmitableDemandsTitle = notTransmitableDemandsTitle + "- " + demandeUIModel.getTitle() + "<br/>";
                continue;
            }
            this.demandsToTransmit.add(demandeUIModel);
        }
        if (this.demandsToTransmit.isEmpty()) {
            this.displayWarningMessage(I18n.t((String)"faxtomail.alert.noDemandToTransmit.title", (Object[])new Object[0]), I18n.t((String)"faxtomail.alert.noDemandToTransmit.message", (Object[])new Object[]{notTransmitableDemandsTitle}));
            result = false;
        } else if (!notTransmitableDemandsTitle.isEmpty()) {
            this.displayWarningMessage(I18n.t((String)"faxtomail.alert.demandsNotTransmittable.title", (Object[])new Object[0]), I18n.t((String)"faxtomail.alert.demandsNotTransmittable.message", (Object[])new Object[]{notTransmitableDemandsTitle}));
        }
        return result;
    }

    @Override
    public void doAction() throws Exception {
        MailFolderChooserUIModel model = new MailFolderChooserUIModel();
        model.setDemandeUIModels(this.demandsToTransmit);
        this.frameContent = new MailFolderChooserUI((FaxToMailUI)this.getUI(), model);
    }

    public void postSuccessAction() {
        super.postSuccessAction();
        this.frame = ((DemandeListUIHandler)this.getHandler()).openModalFrame(this.frameContent, I18n.t((String)"faxtomail.chooseMailFolder.title", (Object[])new Object[0]), new Dimension(350, 500));
    }

    protected void releaseAction() {
        super.releaseAction();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (OpenMailFolderChooserFromListAction.this.frame != null) {
                    OpenMailFolderChooserFromListAction.this.frame.toFront();
                    OpenMailFolderChooserFromListAction.this.frame = null;
                }
            }
        });
    }
}

