/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jaxx.widgets.extra;

import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.Point;
import java.io.ByteArrayInputStream;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.xml.sax.Attributes;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

class XMLGridParseConstraints
extends DefaultHandler {
    XMLReader xr;
    private int td;
    private int tr;
    private Map<String, GridBagConstraints> constraints;
    private Map<String, GridBagConstraints> styles;
    private GridBagConstraints constraint;
    private int cellpadding;
    private int cellspacing;
    int anchor;
    private static final int TOP = 1;
    private static final int BOTTOM = 16;
    private static final int LEFT = 256;
    private static final int RIGHT = 4096;
    private static final int CENTER = 69905;
    private boolean styleMode = false;
    private String id;
    private Map<Point, GridBagConstraints> table;
    private CharArrayWriter contents = new CharArrayWriter();

    public XMLGridParseConstraints() throws SAXException {
        this.xr = XMLReaderFactory.createXMLReader();
        this.xr.setContentHandler(this);
        this.xr.setErrorHandler(new MyErrorHandler());
    }

    public Map<String, GridBagConstraints> parse(String s) throws SAXException {
        this.constraints = new HashMap<String, GridBagConstraints>();
        this.styles = new HashMap<String, GridBagConstraints>();
        try {
            this.xr.parse(new InputSource(new ByteArrayInputStream(s.getBytes())));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return this.constraints;
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.contents.write(ch, start, length);
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (localName.equals("td")) {
            this.handleOpenTD(attributes);
        } else if (localName.equals("table")) {
            this.handleOpenTable(attributes);
        } else if (localName.equals("style")) {
            this.handleOpenStyle(attributes);
        } else if (localName.equals("styles")) {
            this.handleOpenStyles();
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (localName.equals("td")) {
            this.handleCloseTD();
        } else if (localName.equals("tr")) {
            this.td = 0;
            ++this.tr;
        } else if (localName.equals("table")) {
            this.handleCloseTable();
        } else if (localName.equals("style")) {
            this.handleCloseTD();
        } else if (localName.equals("styles")) {
            this.handleCloseStyles();
        }
    }

    private void handleOpenStyles() {
        this.styleMode = true;
    }

    private void handleCloseStyles() {
        this.styleMode = false;
    }

    private void handleOpenTable(Attributes attributes) {
        this.table = new HashMap<Point, GridBagConstraints>();
        for (int i = 0; i < attributes.getLength(); ++i) {
            String name = attributes.getLocalName(i);
            String value = attributes.getValue(i);
            if (name.equals("cellpadding")) {
                this.cellpadding = Integer.parseInt(value);
                continue;
            }
            if (!name.equals("cellspacing")) continue;
            this.cellspacing = Integer.parseInt(value);
        }
    }

    private void handleCloseTable() {
        this.cellpadding = -1;
        this.cellspacing = -1;
    }

    private void handleOpenStyle(Attributes attributes) {
        this.constraint = new GridBagConstraints();
        this.fillConstraint(attributes);
    }

    private void handleOpenTD(Attributes attributes) {
        String tdStyle = attributes.getValue("", "class");
        GridBagConstraints constraintStyle = null;
        if (tdStyle != null) {
            constraintStyle = this.styles.get(tdStyle);
        }
        this.constraint = constraintStyle != null ? (GridBagConstraints)constraintStyle.clone() : new GridBagConstraints();
        this.fillConstraint(attributes);
    }

    private void fillConstraint(Attributes attributes) {
        this.constraint.gridx = this.td;
        this.constraint.gridy = this.tr;
        this.constraint.ipadx = this.cellpadding;
        this.constraint.ipady = this.cellpadding;
        this.constraint.insets = new Insets(this.cellspacing, this.cellspacing, this.cellspacing, this.cellspacing);
        this.contents.reset();
        int colspan = this.constraint.gridwidth;
        int rowspan = this.constraint.gridheight;
        for (int i = 0; i < attributes.getLength(); ++i) {
            String name = attributes.getLocalName(i);
            String value = attributes.getValue(i);
            if (name.equals("colspan")) {
                colspan = Integer.parseInt(value);
                continue;
            }
            if (name.equals("rowspan")) {
                rowspan = Integer.parseInt(value);
                continue;
            }
            if (name.equals("fill")) {
                if (value.equalsIgnoreCase("BOTH")) {
                    this.constraint.fill = 1;
                    continue;
                }
                if (value.equalsIgnoreCase("HORIZONTAL")) {
                    this.constraint.fill = 2;
                    continue;
                }
                if (value.equalsIgnoreCase("VERTICAL")) {
                    this.constraint.fill = 3;
                    continue;
                }
                if (!value.equalsIgnoreCase("NONE")) continue;
                this.constraint.fill = 0;
                continue;
            }
            if (name.equals("valign")) {
                if (value.equalsIgnoreCase("TOP")) {
                    this.anchor |= 1;
                    continue;
                }
                if (value.equalsIgnoreCase("BOTTOM")) {
                    this.anchor |= 0x10;
                    continue;
                }
                if (!value.equalsIgnoreCase("MIDDLE")) continue;
                this.anchor |= 0x11111;
                continue;
            }
            if (name.equals("align")) {
                if (value.equalsIgnoreCase("LEFT")) {
                    this.anchor |= 0x100;
                    continue;
                }
                if (value.equalsIgnoreCase("RIGHT")) {
                    this.anchor |= 0x1000;
                    continue;
                }
                if (!value.equalsIgnoreCase("CENTER")) continue;
                this.anchor |= 0x11111;
                continue;
            }
            if (name.equals("width")) {
                this.constraint.weightx = Double.parseDouble(value.substring(0, value.length() - 1)) / 100.0;
                continue;
            }
            if (name.equals("height")) {
                this.constraint.weighty = Double.parseDouble(value.substring(0, value.length() - 1)) / 100.0;
                continue;
            }
            if (!name.equals("id")) continue;
            this.id = value;
        }
        this.constraint.gridwidth = colspan;
        this.constraint.gridheight = rowspan;
        if (!this.styleMode) {
            Point p = new Point(this.constraint.gridx, this.constraint.gridy);
            GridBagConstraints old = this.table.get(p);
            while (old != null) {
                p.translate(1, 0);
                old = this.table.get(p);
            }
            this.constraint.gridx = (int)p.getX();
            this.constraint.gridy = (int)p.getY();
            for (int x = 0; x < colspan; ++x) {
                for (int y = 0; y < rowspan; ++y) {
                    Point newPoint = p.getLocation();
                    newPoint.translate(x, y);
                    this.table.put(newPoint, this.constraint);
                }
            }
        }
    }

    private void handleCloseTD() {
        switch (this.anchor) {
            case 256: {
                this.constraint.anchor = 17;
                break;
            }
            case 4096: {
                this.constraint.anchor = 13;
                break;
            }
            case 69905: {
                this.constraint.anchor = 10;
                break;
            }
            case 1: {
                this.constraint.anchor = 11;
                break;
            }
            case 16: {
                this.constraint.anchor = 15;
                break;
            }
            case 257: {
                this.constraint.anchor = 18;
                break;
            }
            case 4097: {
                this.constraint.anchor = 12;
                break;
            }
            case 272: {
                this.constraint.anchor = 16;
                break;
            }
            case 4112: {
                this.constraint.anchor = 14;
            }
        }
        if (this.styleMode) {
            this.styles.put(this.id, this.constraint);
        } else {
            this.constraints.put(this.contents.toString().trim(), this.constraint);
        }
        this.contents.reset();
        this.anchor = 0;
    }

    public String getErrors() {
        MyErrorHandler errorHandler = (MyErrorHandler)this.xr.getErrorHandler();
        return errorHandler.getErrors();
    }

    public Map<String, GridBagConstraints> getStyles() {
        return Collections.unmodifiableMap(this.styles);
    }

    class MyErrorHandler
    implements ErrorHandler {
        StringBuffer errors = new StringBuffer();

        MyErrorHandler() {
        }

        @Override
        public void error(SAXParseException e) throws SAXException {
            this.errors.append(e.getMessage()).append("\n");
        }

        @Override
        public void fatalError(SAXParseException e) throws SAXException {
            this.errors.append(e.getMessage()).append("\n");
        }

        @Override
        public void warning(SAXParseException e) throws SAXException {
            this.errors.append(e.getMessage()).append(13);
        }

        public String getErrors() {
            return this.errors.toString();
        }
    }
}

