/*
 * Decompiled with CFR 0.152.
 */
package com.franciaflex.faxtomail.ui.swing.content.reply.actions;

import com.franciaflex.faxtomail.persistence.entities.FaxToMailUser;
import com.franciaflex.faxtomail.persistence.entities.Stamp;
import com.franciaflex.faxtomail.services.service.UserService;
import com.franciaflex.faxtomail.ui.swing.actions.AbstractFaxToMailAction;
import com.franciaflex.faxtomail.ui.swing.content.reply.SigningSettingsUI;
import com.franciaflex.faxtomail.ui.swing.content.reply.SigningSettingsUIHandler;
import com.franciaflex.faxtomail.ui.swing.content.reply.SigningSettingsUIModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SaveSigningAction
extends AbstractFaxToMailAction<SigningSettingsUIModel, SigningSettingsUI, SigningSettingsUIHandler> {
    private static final Log log = LogFactory.getLog(SaveSigningAction.class);

    public SaveSigningAction(SigningSettingsUIHandler handler) {
        super(handler, false);
    }

    @Override
    public void doAction() throws Exception {
        SigningSettingsUIModel model = (SigningSettingsUIModel)this.getModel();
        Stamp signing = model.getSelectedSigning();
        signing.setLabel(model.getSelectedSigningName());
        signing.setText(model.getSelectedSigningText());
        FaxToMailUser user = this.getContext().getCurrentUser();
        UserService userService = this.getContext().newServiceContext().getUserService();
        userService.saveSigning(user, signing, user.isSigningsEmpty());
    }

    public void postSuccessAction() {
        super.postSuccessAction();
        SigningSettingsUIModel model = (SigningSettingsUIModel)this.getModel();
        model.updateSetDefaultButtonEnabled();
        model.setModified(false);
        ((SigningSettingsUI)this.getUI()).getSigningList().repaint();
    }
}

