/*
 * Decompiled with CFR 0.152.
 */
package com.franciaflex.faxtomail.ui.swing.content.demande.demandgroup;

import com.franciaflex.faxtomail.ui.swing.FaxToMailUIContext;
import com.franciaflex.faxtomail.ui.swing.content.demande.demandgroup.ButtonEmailGroup;
import com.franciaflex.faxtomail.ui.swing.util.CloseButton;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.HierarchyBoundsAdapter;
import java.awt.event.HierarchyEvent;
import javax.swing.AbstractAction;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.Timer;
import org.nuiton.i18n.I18n;

public class DemandGroupHighlightDialog
extends JDialog {
    protected final ButtonEmailGroup buttonEmailGroup;
    protected boolean popupMoving;
    protected final Timer timer;

    public DemandGroupHighlightDialog(FaxToMailUIContext context, ButtonEmailGroup buttonEmailGroup) {
        super(context.getMainUI());
        this.buttonEmailGroup = buttonEmailGroup;
        this.timer = new Timer(context.getConfig().getDelayGroupedDemandWarningDialog(), new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DemandGroupHighlightDialog.this.dispose();
            }
        });
        this.init(context.getConfig().getColorGroupedDemandWarningDialog(), context.getConfig().getFontSizeGroupedDemandWarningDialog());
    }

    protected void init(Color bgColor, float fontSize) {
        this.setUndecorated(true);
        this.setAlwaysOnTop(true);
        this.setResizable(false);
        this.getContentPane().setLayout(new BorderLayout());
        JLabel jLabel = new JLabel(I18n.t((String)"faxtomail.demandGroup.warning.label", (Object[])new Object[0]));
        jLabel.setFont(jLabel.getFont().deriveFont(1, fontSize));
        JPanel messagePanel = new JPanel();
        messagePanel.setBackground(bgColor);
        messagePanel.add(jLabel);
        messagePanel.add(new CloseButton(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DemandGroupHighlightDialog.this.dispose();
            }
        }));
        this.getContentPane().add((Component)messagePanel, "Center");
        this.getContentPane().add((Component)new ArrowPanel(bgColor), "South");
        this.pack();
        this.buttonEmailGroup.addHierarchyBoundsListener(new HierarchyBoundsAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void ancestorMoved(HierarchyEvent e) {
                if (DemandGroupHighlightDialog.this.isShowing()) {
                    DemandGroupHighlightDialog.this.popupMoving = true;
                    try {
                        DemandGroupHighlightDialog.this.place();
                    }
                    finally {
                        DemandGroupHighlightDialog.this.popupMoving = false;
                    }
                }
            }
        });
    }

    protected void place() {
        Point point = new Point(this.buttonEmailGroup.getLocationOnScreen());
        point.translate(-this.getWidth() + this.buttonEmailGroup.getWidth(), -this.getHeight() - 5);
        this.setLocation(point.getLocation());
    }

    @Override
    public void setVisible(boolean b) {
        if (!this.isVisible() && b) {
            this.place();
            this.timer.start();
        } else if (!b) {
            this.timer.stop();
        }
        super.setVisible(b);
    }

    private class ArrowPanel
    extends JPanel {
        private final int width = 10;
        private final int height = 5;
        private final Color arrowColor;

        ArrowPanel(Color color) {
            this.arrowColor = color;
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension(10, 5);
        }

        @Override
        public Color getBackground() {
            return null;
        }

        @Override
        public void paint(Graphics g) {
            Point point1 = new Point(this.getWidth() - 10, 0);
            Point point2 = new Point(point1.x - 10, point1.y);
            Point point3 = new Point(point1.x - 5, point1.y + 5);
            g.setColor(this.arrowColor);
            g.drawLine(point1.x, point1.y, point2.x, point2.y);
            g.drawLine(point1.x, point1.y, point3.x, point3.y);
            g.drawLine(point2.x, point2.y, point3.x, point3.y);
            g.fillPolygon(new int[]{point1.x, point2.x, point3.x}, new int[]{point1.y, point2.y, point3.y}, 3);
        }
    }
}

