/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel;

import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSDocument;
import org.apache.pdfbox.cos.COSInteger;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSObject;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.io.IOUtils;
import org.apache.pdfbox.io.RandomAccessBufferedFileInputStream;
import org.apache.pdfbox.pdfparser.BaseParser;
import org.apache.pdfbox.pdfparser.PDFParser;
import org.apache.pdfbox.pdfwriter.COSWriter;
import org.apache.pdfbox.pdmodel.PDDocumentCatalog;
import org.apache.pdfbox.pdmodel.PDDocumentInformation;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageTree;
import org.apache.pdfbox.pdmodel.common.COSArrayList;
import org.apache.pdfbox.pdmodel.common.COSObjectable;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.common.PDStream;
import org.apache.pdfbox.pdmodel.encryption.AccessPermission;
import org.apache.pdfbox.pdmodel.encryption.PDEncryption;
import org.apache.pdfbox.pdmodel.encryption.ProtectionPolicy;
import org.apache.pdfbox.pdmodel.encryption.SecurityHandler;
import org.apache.pdfbox.pdmodel.encryption.SecurityHandlerFactory;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotation;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAppearanceDictionary;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAppearanceStream;
import org.apache.pdfbox.pdmodel.interactive.digitalsignature.PDSignature;
import org.apache.pdfbox.pdmodel.interactive.digitalsignature.SignatureInterface;
import org.apache.pdfbox.pdmodel.interactive.digitalsignature.SignatureOptions;
import org.apache.pdfbox.pdmodel.interactive.form.PDAcroForm;
import org.apache.pdfbox.pdmodel.interactive.form.PDFieldTreeNode;
import org.apache.pdfbox.pdmodel.interactive.form.PDSignatureField;

public class PDDocument
implements Closeable {
    private static final Log LOG = LogFactory.getLog(PDDocument.class);
    private final COSDocument document;
    private PDDocumentInformation documentInformation;
    private PDDocumentCatalog documentCatalog;
    private PDEncryption encryption;
    private boolean allSecurityToBeRemoved;
    private Long documentId;
    private final BaseParser parser;
    private File incrementalFile;
    private AccessPermission accessPermission;
    private final Set<PDFont> fontsToSubset = new HashSet<PDFont>();
    private SignatureInterface signInterface;

    public PDDocument() {
        this.document = new COSDocument();
        this.parser = null;
        COSDictionary trailer = new COSDictionary();
        this.document.setTrailer(trailer);
        COSDictionary rootDictionary = new COSDictionary();
        trailer.setItem(COSName.ROOT, (COSBase)rootDictionary);
        rootDictionary.setItem(COSName.TYPE, (COSBase)COSName.CATALOG);
        rootDictionary.setItem(COSName.VERSION, (COSBase)COSName.getPDFName("1.4"));
        COSDictionary pages = new COSDictionary();
        rootDictionary.setItem(COSName.PAGES, (COSBase)pages);
        pages.setItem(COSName.TYPE, (COSBase)COSName.PAGES);
        COSArray kidsArray = new COSArray();
        pages.setItem(COSName.KIDS, (COSBase)kidsArray);
        pages.setItem(COSName.COUNT, (COSBase)COSInteger.ZERO);
    }

    public void addPage(PDPage page) {
        this.getPages().add(page);
    }

    public void addSignature(PDSignature sigObject, SignatureInterface signatureInterface) throws IOException {
        this.addSignature(sigObject, signatureInterface, new SignatureOptions());
    }

    public void addSignature(PDSignature sigObject, SignatureInterface signatureInterface, SignatureOptions options) throws IOException {
        PDSignatureField signatureField;
        int preferedSignatureSize = options.getPreferedSignatureSize();
        if (preferedSignatureSize > 0) {
            sigObject.setContents(new byte[preferedSignatureSize]);
        } else {
            sigObject.setContents(new byte[9472]);
        }
        sigObject.setByteRange(new int[]{0, 1000000000, 1000000000, 1000000000});
        this.signInterface = signatureInterface;
        PDDocumentCatalog catalog = this.getDocumentCatalog();
        int pageCount = catalog.getPages().getCount();
        if (pageCount == 0) {
            throw new IllegalStateException("Cannot sign an empty document");
        }
        int startIndex = Math.min(Math.max(options.getPage(), 0), pageCount - 1);
        PDPage page = catalog.getPages().get(startIndex);
        PDAcroForm acroForm = catalog.getAcroForm();
        catalog.getCOSObject().setNeedToBeUpdated(true);
        if (acroForm == null) {
            acroForm = new PDAcroForm(this);
            catalog.setAcroForm(acroForm);
        } else {
            acroForm.getDictionary().setNeedToBeUpdated(true);
        }
        List<PDAnnotation> annotations = page.getAnnotations();
        List<PDFieldTreeNode> fields = acroForm.getFields();
        if (fields == null) {
            fields = new ArrayList<PDFieldTreeNode>();
            acroForm.setFields(fields);
        }
        if ((signatureField = this.findSignatureField(fields, sigObject)) == null) {
            signatureField = this.createSignatureField(acroForm, sigObject, page);
        }
        List<PDFieldTreeNode> acroFormFields = acroForm.getFields();
        acroForm.getDictionary().setDirect(true);
        acroForm.setSignaturesExist(true);
        acroForm.setAppendOnly(true);
        boolean checkFields = this.checkSignatureField(acroFormFields, signatureField);
        COSDocument visualSignature = options.getVisualSignature();
        if (visualSignature == null) {
            this.prepareNonVisibleSignature(signatureField, acroForm);
        } else {
            this.prepareVisibleSignature(signatureField, acroForm, visualSignature);
        }
        if (!(annotations instanceof COSArrayList && acroFormFields instanceof COSArrayList && ((COSArrayList)annotations).toList().equals(((COSArrayList)acroFormFields).toList()) && checkFields)) {
            annotations.add(signatureField.getWidget());
        }
        page.getCOSObject().setNeedToBeUpdated(true);
    }

    private PDSignatureField createSignatureField(PDAcroForm acroForm, PDSignature sigObject, PDPage page) throws IOException {
        PDSignatureField signatureField = new PDSignatureField(acroForm);
        signatureField.setSignature(sigObject);
        signatureField.getWidget().setPage(page);
        return signatureField;
    }

    private PDSignatureField findSignatureField(List<PDFieldTreeNode> fields, PDSignature sigObject) {
        PDSignatureField signatureField = null;
        for (PDFieldTreeNode pdField : fields) {
            PDSignature signature;
            if (!(pdField instanceof PDSignatureField) || (signature = ((PDSignatureField)pdField).getSignature()) == null || !signature.getCOSObject().equals(sigObject.getCOSObject())) continue;
            signatureField = (PDSignatureField)pdField;
        }
        return signatureField;
    }

    private boolean checkSignatureField(List<PDFieldTreeNode> acroFormFields, PDSignatureField signatureField) {
        boolean checkFields = false;
        for (PDFieldTreeNode field : acroFormFields) {
            if (!(field instanceof PDSignatureField) || !field.getCOSObject().equals(signatureField.getCOSObject())) continue;
            checkFields = true;
            signatureField.getCOSObject().setNeedToBeUpdated(true);
            break;
        }
        if (!checkFields) {
            acroFormFields.add(signatureField);
        }
        return checkFields;
    }

    private void prepareVisibleSignature(PDSignatureField signatureField, PDAcroForm acroForm, COSDocument visualSignature) {
        boolean annotNotFound = true;
        boolean sigFieldNotFound = true;
        for (COSObject cosObject : visualSignature.getObjects()) {
            if (!annotNotFound && !sigFieldNotFound) break;
            COSBase base = cosObject.getObject();
            if (!(base instanceof COSDictionary)) continue;
            COSDictionary cosBaseDict = (COSDictionary)base;
            COSBase type = cosBaseDict.getDictionaryObject(COSName.TYPE);
            if (annotNotFound && COSName.ANNOT.equals(type)) {
                this.assignSignatureRectangle(signatureField, cosBaseDict);
                annotNotFound = false;
            }
            COSBase ft = cosBaseDict.getDictionaryObject(COSName.FT);
            COSBase apDict = cosBaseDict.getDictionaryObject(COSName.AP);
            if (!sigFieldNotFound || !COSName.SIG.equals(ft) || apDict == null) continue;
            this.assignAppearanceDictionary(signatureField, cosBaseDict);
            this.assignAcroFormDefaultResource(acroForm, cosBaseDict);
            sigFieldNotFound = false;
        }
        if (annotNotFound || sigFieldNotFound) {
            throw new IllegalArgumentException("Template is missing required objects");
        }
    }

    private void assignSignatureRectangle(PDSignatureField signatureField, COSDictionary cosBaseDict) {
        COSArray rectAry = (COSArray)cosBaseDict.getDictionaryObject(COSName.RECT);
        PDRectangle rect = new PDRectangle(rectAry);
        signatureField.getWidget().setRectangle(rect);
    }

    private void assignAppearanceDictionary(PDSignatureField signatureField, COSDictionary dict) {
        PDAppearanceDictionary ap = new PDAppearanceDictionary((COSDictionary)dict.getDictionaryObject(COSName.AP));
        ap.getCOSObject().setDirect(true);
        signatureField.getWidget().setAppearance(ap);
    }

    private void assignAcroFormDefaultResource(PDAcroForm acroForm, COSDictionary dict) {
        COSDictionary dr = (COSDictionary)dict.getDictionaryObject(COSName.DR);
        if (dr != null) {
            dr.setDirect(true);
            dr.setNeedToBeUpdated(true);
            COSDictionary acroFormDict = acroForm.getDictionary();
            acroFormDict.setItem(COSName.DR, (COSBase)dr);
        }
    }

    private void prepareNonVisibleSignature(PDSignatureField signatureField, PDAcroForm acroForm) throws IOException {
        signatureField.getWidget().setRectangle(new PDRectangle());
        acroForm.setDefaultResources(null);
        PDAppearanceDictionary ap = new PDAppearanceDictionary();
        COSStream apsStream = this.getDocument().createCOSStream();
        apsStream.createUnfilteredStream().close();
        PDAppearanceStream aps = new PDAppearanceStream(apsStream);
        COSDictionary cosObject = (COSDictionary)aps.getCOSObject();
        cosObject.setItem(COSName.SUBTYPE, (COSBase)COSName.FORM);
        cosObject.setItem(COSName.BBOX, (COSObjectable)new PDRectangle());
        ap.setNormalAppearance(aps);
        ap.getCOSObject().setDirect(true);
        signatureField.getWidget().setAppearance(ap);
    }

    public void addSignatureField(List<PDSignatureField> sigFields, SignatureInterface signatureInterface, SignatureOptions options) throws IOException {
        PDDocumentCatalog catalog = this.getDocumentCatalog();
        catalog.getCOSObject().setNeedToBeUpdated(true);
        PDAcroForm acroForm = catalog.getAcroForm();
        if (acroForm == null) {
            acroForm = new PDAcroForm(this);
            catalog.setAcroForm(acroForm);
        }
        COSDictionary acroFormDict = acroForm.getDictionary();
        acroFormDict.setDirect(true);
        acroFormDict.setNeedToBeUpdated(true);
        if (!acroForm.isSignaturesExist()) {
            acroForm.setSignaturesExist(true);
        }
        List<PDFieldTreeNode> acroformFields = acroForm.getFields();
        for (PDSignatureField sigField : sigFields) {
            sigField.getCOSObject().setNeedToBeUpdated(true);
            this.checkSignatureField(acroformFields, sigField);
            if (sigField.getSignature() == null) continue;
            sigField.getCOSObject().setNeedToBeUpdated(true);
            if (options == null) {
                // empty if block
            }
            this.addSignature(sigField.getSignature(), signatureInterface, options);
        }
    }

    public void removePage(PDPage page) {
        this.getPages().remove(page);
    }

    public void removePage(int pageNumber) {
        this.getPages().remove(pageNumber);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PDPage importPage(PDPage page) throws IOException {
        PDPage importedPage = new PDPage(new COSDictionary(page.getCOSObject()));
        InputStream is = null;
        OutputStream os = null;
        try {
            PDStream src = page.getStream();
            if (src != null) {
                PDStream dest = new PDStream(this.document.createCOSStream());
                dest.addCompression();
                importedPage.setContents(dest);
                is = src.createInputStream();
                os = dest.createOutputStream();
                IOUtils.copy(is, os);
            }
            this.addPage(importedPage);
        }
        finally {
            if (is != null) {
                is.close();
            }
            if (os != null) {
                os.close();
            }
        }
        return importedPage;
    }

    public PDDocument(COSDocument doc) {
        this(doc, null);
    }

    public PDDocument(COSDocument doc, BaseParser usedParser) {
        this(doc, usedParser, null);
    }

    public PDDocument(COSDocument doc, BaseParser usedParser, AccessPermission permission) {
        this.document = doc;
        this.parser = usedParser;
        this.accessPermission = permission;
    }

    public COSDocument getDocument() {
        return this.document;
    }

    public PDDocumentInformation getDocumentInformation() {
        if (this.documentInformation == null) {
            COSDictionary trailer = this.document.getTrailer();
            COSDictionary infoDic = (COSDictionary)trailer.getDictionaryObject(COSName.INFO);
            if (infoDic == null) {
                infoDic = new COSDictionary();
                trailer.setItem(COSName.INFO, (COSBase)infoDic);
            }
            this.documentInformation = new PDDocumentInformation(infoDic);
        }
        return this.documentInformation;
    }

    public void setDocumentInformation(PDDocumentInformation info) {
        this.documentInformation = info;
        this.document.getTrailer().setItem(COSName.INFO, (COSBase)info.getCOSObject());
    }

    public PDDocumentCatalog getDocumentCatalog() {
        if (this.documentCatalog == null) {
            COSDictionary trailer = this.document.getTrailer();
            COSBase dictionary = trailer.getDictionaryObject(COSName.ROOT);
            this.documentCatalog = dictionary instanceof COSDictionary ? new PDDocumentCatalog(this, (COSDictionary)dictionary) : new PDDocumentCatalog(this);
        }
        return this.documentCatalog;
    }

    public boolean isEncrypted() {
        return this.document.isEncrypted();
    }

    public PDEncryption getEncryption() {
        if (this.encryption == null && this.isEncrypted()) {
            this.encryption = new PDEncryption(this.document.getEncryptionDictionary());
        }
        return this.encryption;
    }

    public void setEncryptionDictionary(PDEncryption encryption) throws IOException {
        this.encryption = encryption;
    }

    public PDSignature getLastSignatureDictionary() throws IOException {
        List<PDSignature> signatureDictionaries = this.getSignatureDictionaries();
        int size = signatureDictionaries.size();
        if (size > 0) {
            return signatureDictionaries.get(size - 1);
        }
        return null;
    }

    public List<PDSignatureField> getSignatureFields() throws IOException {
        LinkedList<PDSignatureField> fields = new LinkedList<PDSignatureField>();
        PDAcroForm acroForm = this.getDocumentCatalog().getAcroForm();
        if (acroForm != null) {
            List<COSDictionary> signatureDictionary = this.document.getSignatureFields(false);
            for (COSDictionary dict : signatureDictionary) {
                fields.add(new PDSignatureField(acroForm, dict, null));
            }
        }
        return fields;
    }

    public List<PDSignature> getSignatureDictionaries() throws IOException {
        List<COSDictionary> signatureDictionary = this.document.getSignatureDictionaries();
        LinkedList<PDSignature> signatures = new LinkedList<PDSignature>();
        for (COSDictionary dict : signatureDictionary) {
            signatures.add(new PDSignature(dict));
        }
        return signatures;
    }

    Set<PDFont> getFontsToSubset() {
        return this.fontsToSubset;
    }

    public static PDDocument load(File file) throws IOException {
        return PDDocument.load(file, "", false);
    }

    public static PDDocument load(File file, boolean useScratchFiles) throws IOException {
        return PDDocument.load(file, "", null, null, useScratchFiles);
    }

    public static PDDocument load(File file, String password) throws IOException {
        return PDDocument.load(file, password, null, null, false);
    }

    public static PDDocument load(File file, String password, boolean useScratchFiles) throws IOException {
        return PDDocument.load(file, password, null, null, useScratchFiles);
    }

    public static PDDocument load(File file, String password, InputStream keyStore, String alias) throws IOException {
        return PDDocument.load(file, password, keyStore, alias, false);
    }

    public static PDDocument load(File file, String password, InputStream keyStore, String alias, boolean useScratchFiles) throws IOException {
        PDFParser parser = new PDFParser(file, password, keyStore, alias, useScratchFiles);
        parser.parse();
        PDDocument doc = parser.getPDDocument();
        doc.incrementalFile = file;
        return doc;
    }

    public static PDDocument load(InputStream input) throws IOException {
        return PDDocument.load(input, "", null, null, false);
    }

    public static PDDocument load(InputStream input, boolean useScratchFiles) throws IOException {
        return PDDocument.load(input, "", null, null, useScratchFiles);
    }

    public static PDDocument load(InputStream input, String password) throws IOException {
        return PDDocument.load(input, password, null, null, false);
    }

    public static PDDocument load(InputStream input, String password, InputStream keyStore, String alias) throws IOException {
        return PDDocument.load(input, password, keyStore, alias, false);
    }

    public static PDDocument load(InputStream input, String password, boolean useScratchFiles) throws IOException {
        PDFParser parser = new PDFParser(input, password, null, null, useScratchFiles);
        parser.parse();
        return parser.getPDDocument();
    }

    public static PDDocument load(InputStream input, String password, InputStream keyStore, String alias, boolean useScratchFiles) throws IOException {
        PDFParser parser = new PDFParser(input, password, keyStore, alias, useScratchFiles);
        parser.parse();
        return parser.getPDDocument();
    }

    public void save(String fileName) throws IOException {
        this.save(new File(fileName));
    }

    public void save(File file) throws IOException {
        this.save(new FileOutputStream(file));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(OutputStream output) throws IOException {
        if (this.document.isClosed()) {
            throw new IOException("Cannot save a document which has been closed");
        }
        for (PDFont font : this.fontsToSubset) {
            font.subset();
        }
        this.fontsToSubset.clear();
        COSWriter writer = new COSWriter(output);
        try {
            writer.write(this);
            writer.close();
        }
        finally {
            writer.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveIncremental(OutputStream output) throws IOException {
        if (this.incrementalFile == null) {
            throw new IllegalStateException("Incremental save is only possible if the document was loaded from a file");
        }
        RandomAccessBufferedFileInputStream input = new RandomAccessBufferedFileInputStream(this.incrementalFile);
        COSWriter writer = null;
        try {
            writer = new COSWriter(output, input);
            writer.write(this, this.signInterface);
            writer.close();
        }
        finally {
            if (writer != null) {
                writer.close();
            }
        }
    }

    public PDPage getPage(int pageIndex) {
        return this.getDocumentCatalog().getPages().get(pageIndex);
    }

    public PDPageTree getPages() {
        return this.getDocumentCatalog().getPages();
    }

    public int getNumberOfPages() {
        return this.getDocumentCatalog().getPages().getCount();
    }

    @Override
    public void close() throws IOException {
        if (!this.document.isClosed()) {
            this.document.close();
            if (this.parser != null) {
                this.parser.close();
            }
        }
    }

    public void protect(ProtectionPolicy policy) throws IOException {
        SecurityHandler securityHandler;
        if (!this.isEncrypted()) {
            this.encryption = new PDEncryption();
        }
        if ((securityHandler = SecurityHandlerFactory.INSTANCE.newSecurityHandlerForPolicy(policy)) == null) {
            throw new IOException("No security handler for policy " + policy);
        }
        this.getEncryption().setSecurityHandler(securityHandler);
    }

    public AccessPermission getCurrentAccessPermission() {
        if (this.accessPermission == null) {
            this.accessPermission = AccessPermission.getOwnerAccessPermission();
        }
        return this.accessPermission;
    }

    public boolean isAllSecurityToBeRemoved() {
        return this.allSecurityToBeRemoved;
    }

    public void setAllSecurityToBeRemoved(boolean removeAllSecurity) {
        this.allSecurityToBeRemoved = removeAllSecurity;
    }

    public Long getDocumentId() {
        return this.documentId;
    }

    public void setDocumentId(Long docId) {
        this.documentId = docId;
    }

    public float getVersion() {
        float headerVersionFloat = this.getDocument().getVersion();
        if (headerVersionFloat >= 1.4f) {
            String catalogVersion = this.getDocumentCatalog().getVersion();
            float catalogVersionFloat = -1.0f;
            if (catalogVersion != null) {
                try {
                    catalogVersionFloat = Float.parseFloat(catalogVersion);
                }
                catch (NumberFormatException exception) {
                    LOG.error((Object)"Can't extract the version number of the document catalog.", (Throwable)exception);
                }
            }
            return Math.max(catalogVersionFloat, headerVersionFloat);
        }
        return headerVersionFloat;
    }

    public void setVersion(float newVersion) {
        float currentVersion = this.getVersion();
        if (newVersion == currentVersion) {
            return;
        }
        if (newVersion < currentVersion) {
            LOG.error((Object)"It's not allowed to downgrade the version of a pdf.");
            return;
        }
        if (this.getDocument().getVersion() >= 1.4f) {
            this.getDocumentCatalog().setVersion(Float.toString(newVersion));
        } else {
            this.getDocument().setVersion(newVersion);
        }
    }
}

