package com.franciaflex.faxtomail.ui.swing.content.pdfeditor;

/*
 * #%L
 * FaxToMail :: UI
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2014 - 2015 Mac-Groupe, Code Lutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.context.DefaultJAXXContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static org.nuiton.i18n.I18n.t;

public class PDFEditorLineUI extends JPanel implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_HORIZONTAL = "horizontal";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAJVUTU8TQRgelrbQgh9IRAwYV72gIdtq4sFgFNraCFYlEBNiL053p3RwdmeYmaULRONP8Cfo3YuJN0/Gg2cPXox/wRgPXo3vbBeWjxq0h+1m5n2feZ7nfWbffEdZJdGFNRxFjgwDTX3iLMytrDxsrhFXV4lyJRWaS9T99VnIaqAhb3ddaXSpUTftxaS9WOG+4AEJ9nTP1FFB6U1GVJsQrdG5/R2uUsXl3e2ZSIRyB3WXVC/UVz9/WC+9F68thCIB7PpBin1UV6okU0cW9TQ6BSdt4CLDwSrQkDRYBb7HzFqFYaUeYJ+so+dooI5yAksA0+jiv0uOMeL+SGiUZzQgizggTKOqy32nJXHgUtxiJHJaONLcx5Q5IXVUB4g4Lg804DrCaxGPAq6zWK3did/qgPRoXogYPKdRoc0l3YJ6DNgjhr5jJDllzhnBQVo4LInPN0g51Bqq0agpjZLzFrqrpjIvwM6JfXbCoJx0UKmTfQ2UlSEsazTeODzbJdjqTnX8wFQNYLz7e2z0y/tv72o7o8zA2ad7lu5JIlgsJBdEamqOPtGdY6gpK97HYqaB8oowiHEc08kexJaTbSAH53U9M+3OXazaAJEd+Prh49iTz/3IqqEC49irYVM/j/K6LcEFzrxI3J6NGQ13BuF50nADLj6OqB/6S7xT4aGJjHWtFIEDkz0c2KXRzH/6Nbr8dnbHBQtYnf1reepE9jHK0cBEK450ktaeER4SioQeT1PZK6cIkjpWhtDUKNNE4iZsc7/JyzxKYnTBlAybkgMbZ+LnxCFPMhrluMDrIeQm28JMwX+hid2nqxL8gVs4uG0HIWP2MyhscunBVNGVbbscv3Zt33RcSbAmVZgO8bo7U6bpsunKKLoFoBOAQzp2FdwKFOXB1PVSadq+WipBURQacueNaYmKvTdSHCEBrk5Gkwhm2W+v2CC/xd1QLWIKV9RLVf2/zBu9ZZoLnoiscAZXv1yfq9wDLdN2jByrHkm+EHPQAtNiKZNeYvdd/aP0QoxzDG9yKEbHb3pYY7tJAw8+E7cOYfeZZwEQ/wDzWXegUgYAAA==";
    private static final Log log = LogFactory.getLog(PDFEditorLineUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected Boolean horizontal;
    protected PDFEditorLineUI linePanel = this;
    protected JButton removeButton;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    protected void removeLine() {
            JPanel container = getParentContainer(JPanel.class);
            container.remove(this);
            container.updateUI();
        }
    
        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
    
            Graphics2D g2 = (Graphics2D) g.create();
            g2.setStroke(new BasicStroke(3));
            g2.setColor(Color.BLUE);
            if (Boolean.TRUE.equals(horizontal)) {
              g2.drawLine(0, getHeight() / 2, getWidth(), getHeight() / 2);
    
            } else {
              g2.drawLine(getWidth() / 2, 0, getWidth() / 2, getHeight());
            }
            g2.dispose();
        }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public PDFEditorLineUI() {
        $initialize();
    }

    public PDFEditorLineUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public PDFEditorLineUI(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public PDFEditorLineUI(JAXXContext parentContext, LayoutManager param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public PDFEditorLineUI(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public PDFEditorLineUI(JAXXContext parentContext, LayoutManager param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public PDFEditorLineUI(boolean param0) {
        super(param0);
        $initialize();
    }

    public PDFEditorLineUI(JAXXContext parentContext, boolean param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__removeButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        removeLine();
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public Boolean getHorizontal() {
        return horizontal;
    }

    public JButton getRemoveButton() {
        return removeButton;
    }

    public Boolean isHorizontal() {
        return horizontal !=null && horizontal;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setHorizontal(Boolean horizontal) {
        Boolean oldValue = this.horizontal;
        this.horizontal = horizontal;
        firePropertyChange(PROPERTY_HORIZONTAL, oldValue, horizontal);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToLinePanel() {
        if (!allComponentsCreated) {
            return;
        }
        add(removeButton);
    }

    protected void createHorizontal() {
        $objectMap.put("horizontal", horizontal = true);
    }

    protected void createRemoveButton() {
        $objectMap.put("removeButton", removeButton = new JButton());
        
        removeButton.setName("removeButton");
        removeButton.setText(t(" X "));
        removeButton.setOpaque(false);
        removeButton.setFocusPainted(false);
        removeButton.setContentAreaFilled(false);
        removeButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__removeButton"));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToLinePanel();
        
        // apply 6 property setters
        setBackground( null );
        setBorder( BorderFactory.createDashedBorder(null) );
        setSize( new Dimension(500, 100) );
        removeButton.setBackground( null );
        removeButton.setBorder( BorderFactory.createLineBorder(Color.BLACK, 1, false) );
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("linePanel", linePanel);
        createHorizontal();
        createRemoveButton();
        // inline creation of linePanel
        setName("linePanel");
        setLayout(new FlowLayout(FlowLayout.TRAILING));
        setOpaque(false);
        
        $completeSetup();
    }

}