/*
 * Decompiled with CFR 0.152.
 */
package com.franciaflex.faxtomail.ui.swing.util;

import com.franciaflex.faxtomail.persistence.entities.Attachment;
import com.franciaflex.faxtomail.persistence.entities.AttachmentFile;
import com.franciaflex.faxtomail.persistence.entities.DemandType;
import com.franciaflex.faxtomail.persistence.entities.ExtensionCommand;
import com.franciaflex.faxtomail.persistence.entities.MailField;
import com.franciaflex.faxtomail.persistence.entities.MailFolder;
import com.franciaflex.faxtomail.persistence.entities.Reply;
import com.franciaflex.faxtomail.persistence.entities.ReplyContent;
import com.franciaflex.faxtomail.services.FaxToMailServiceContext;
import com.franciaflex.faxtomail.services.FaxToMailServiceUtils;
import com.franciaflex.faxtomail.services.service.ConfigurationService;
import com.franciaflex.faxtomail.services.service.EmailService;
import com.franciaflex.faxtomail.ui.swing.FaxToMailUIContext;
import com.franciaflex.faxtomail.ui.swing.content.demande.DemandeUIHandler;
import com.franciaflex.faxtomail.ui.swing.content.demande.DemandeUIModel;
import com.franciaflex.faxtomail.ui.swing.content.demande.RangeRowModel;
import com.franciaflex.faxtomail.ui.swing.util.AbstractFaxToMailUIHandler;
import com.franciaflex.faxtomail.ui.swing.util.FaxToMailUI;
import com.franciaflex.faxtomail.ui.swing.util.FolderTreeNode;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Element;
import com.itextpdf.text.PageSize;
import com.itextpdf.text.Paragraph;
import com.itextpdf.text.pdf.PdfWriter;
import com.sun.media.jai.codec.ByteArraySeekableStream;
import com.sun.media.jai.codec.ImageCodec;
import com.sun.media.jai.codec.ImageDecoder;
import com.sun.media.jai.codec.SeekableStream;
import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.net.URI;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.media.jai.PlanarImage;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import javax.swing.JTree;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXUtil;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.Predicate;
import org.apache.commons.io.Charsets;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.rendering.PDFRenderer;
import org.nuiton.i18n.I18n;
import org.nuiton.jaxx.application.ApplicationTechnicalException;
import org.nuiton.jaxx.application.swing.ApplicationUIContext;
import org.nuiton.jaxx.application.swing.util.ApplicationUIUtil;
import org.nuiton.util.FileUtil;
import org.nuiton.util.StringUtil;

public final class FaxToMailUIUtil
extends ApplicationUIUtil {
    private static final Log log = LogFactory.getLog(FaxToMailUIUtil.class);
    public static final List<String> EDITABLE_EXTENSIONS = Lists.newArrayList((Object[])new String[]{"PDF", "PNG", "JPG", "JPEG", "GIF", "TIF", "BMP", "TXT"});

    private FaxToMailUIUtil() {
    }

    public static FaxToMailUIContext getApplicationContext(JAXXObject ui) {
        return (FaxToMailUIContext)ApplicationUIUtil.getApplicationContext((JAXXObject)ui);
    }

    public static void setParentUI(JAXXObject ui, FaxToMailUI<?, ?> parentUI) {
        JAXXUtil.initContext((JAXXObject)ui, parentUI);
        FaxToMailUIUtil.setApplicationContext((JAXXObject)ui, (ApplicationUIContext)((AbstractFaxToMailUIHandler)parentUI.getHandler()).getContext());
    }

    public static Map<MailFolder, FolderTreeNode> initFolderTree(final FaxToMailUIContext context, JTree navigationTree, Collection<MailFolder> folders, List<MailFolder> foldersToExpand, final boolean colorNotAffectedFolders) {
        DefaultMutableTreeNode root = new DefaultMutableTreeNode("root");
        HashMap<MailFolder, FolderTreeNode> nodesByFolder = new HashMap<MailFolder, FolderTreeNode>();
        ArrayList<MailFolder> orderedFolders = new ArrayList<MailFolder>(folders);
        Collections.sort(orderedFolders, Ordering.natural().onResultOf((Function)new Function<MailFolder, Comparable>(){

            public Comparable apply(MailFolder folder) {
                return folder.getName();
            }
        }));
        for (MailFolder folder : orderedFolders) {
            nodesByFolder.putAll(FaxToMailUIUtil.createFolderTree(context, root, folder));
            FolderTreeNode node = (FolderTreeNode)nodesByFolder.get(folder);
            for (MailFolder parent = folder.getParent(); parent != null; parent = parent.getParent()) {
                FolderTreeNode parentNode = (FolderTreeNode)nodesByFolder.get(parent);
                if (parentNode == null) {
                    parentNode = new FolderTreeNode(parent);
                    parentNode.setCanRead(false);
                    parentNode.setCanSelect(true);
                    nodesByFolder.put(parent, parentNode);
                }
                parentNode.add(node);
                node = parentNode;
            }
            root.add(node);
        }
        DefaultTreeModel treeModel = new DefaultTreeModel(root);
        navigationTree.setModel(treeModel);
        DefaultTreeCellRenderer renderer = new DefaultTreeCellRenderer(){

            @Override
            public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                Component component = super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
                if (FolderTreeNode.class.isAssignableFrom(value.getClass())) {
                    FolderTreeNode node = (FolderTreeNode)value;
                    this.setEnabled(node.isCanSelect());
                    Font font = component.getFont();
                    font = node.isCanRead() ? font.deriveFont(0) : font.deriveFont(2);
                    component.setFont(font);
                    Color foreground = !colorNotAffectedFolders || context.getCurrentUser().isAffectedFoldersEmpty() || context.getCurrentUser().containsAffectedFolders(node.getMailFolder()) ? (sel ? Color.WHITE : Color.BLACK) : Color.GRAY;
                    component.setForeground(foreground);
                }
                return component;
            }
        };
        Icon folderIcon = renderer.getDefaultClosedIcon();
        renderer.setLeafIcon(folderIcon);
        navigationTree.setCellRenderer(renderer);
        for (MailFolder folder : foldersToExpand) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)nodesByFolder.get(folder);
            if (node == null) continue;
            TreePath treePath = new TreePath(node.getPath());
            navigationTree.expandPath(treePath);
        }
        return nodesByFolder;
    }

    public static List<MailFolder> getExpandedFolders(JTree tree) {
        TreeModel treeModel = tree.getModel();
        Enumeration<TreePath> paths = tree.getExpandedDescendants(new TreePath(treeModel.getRoot()));
        ArrayList<MailFolder> folders = new ArrayList<MailFolder>();
        if (paths != null) {
            while (paths.hasMoreElements()) {
                TreePath path = paths.nextElement();
                Object lastPathComponent = path.getLastPathComponent();
                if (!FolderTreeNode.class.isAssignableFrom(lastPathComponent.getClass())) continue;
                folders.add(((FolderTreeNode)lastPathComponent).getMailFolder());
            }
        }
        return folders;
    }

    protected static Map<MailFolder, FolderTreeNode> createFolderTree(FaxToMailUIContext context, DefaultMutableTreeNode parent, MailFolder folder) {
        MailFolder currentFolder;
        HashMap<MailFolder, FolderTreeNode> result = new HashMap<MailFolder, FolderTreeNode>();
        FolderTreeNode node = new FolderTreeNode(folder);
        node.setCanSelect(true);
        node.setCanRead(true);
        result.put(folder, node);
        parent.add(node);
        if (folder.isChildrenNotEmpty()) {
            ArrayList children = new ArrayList(folder.getChildren());
            CollectionUtils.filter(children, (Predicate)new Predicate<MailFolder>(){

                public boolean evaluate(MailFolder object) {
                    return !object.isArchiveFolder();
                }
            });
            Collections.sort(children, new Comparator<MailFolder>(){

                @Override
                public int compare(MailFolder o1, MailFolder o2) {
                    return o1.getName().compareTo(o2.getName());
                }
            });
            for (MailFolder child : children) {
                result.putAll(FaxToMailUIUtil.createFolderTree(context, node, child));
            }
        }
        if ((currentFolder = context.getCurrentMailFolder()) != null && currentFolder.getTopiaId().equals(folder.getTopiaId())) {
            context.setCurrentMailFolder(folder);
        }
        return result;
    }

    public static Map<String, Integer> computeQuantities(Collection<RangeRowModel> rangeRows) {
        int quotationNb = 0;
        int pfNb = 0;
        int savNb = 0;
        for (RangeRowModel rangeRow : rangeRows) {
            Integer savQuantity;
            Integer productQuantity;
            if (!rangeRow.isValid()) continue;
            Integer quotationQuantity = rangeRow.getQuotationQuantity();
            if (quotationQuantity != null) {
                quotationNb += quotationQuantity.intValue();
            }
            if ((productQuantity = rangeRow.getProductQuantity()) != null) {
                pfNb += productQuantity.intValue();
            }
            if ((savQuantity = rangeRow.getSavQuantity()) == null) continue;
            savNb += savQuantity.intValue();
        }
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        result.put("quotationNb", quotationNb);
        result.put("pfNb", pfNb);
        result.put("savNb", savNb);
        return result;
    }

    public static boolean isFileAPDF(AttachmentFile file) {
        return FileUtil.extension((String)file.getFilename(), (String[])new String[0]).toUpperCase().equals("PDF");
    }

    public static boolean isFileATxt(AttachmentFile file) {
        return FileUtil.extension((String)file.getFilename(), (String[])new String[0]).toUpperCase().equals("TXT");
    }

    public static boolean isFileATif(AttachmentFile file) {
        return FileUtil.extension((String)file.getFilename(), (String[])new String[0]).toUpperCase().equals("TIF");
    }

    public static boolean isFileTypeEditable(String fileName) {
        String extension = FileUtil.extension((String)fileName, (String[])new String[0]);
        return EDITABLE_EXTENSIONS.contains(extension.toUpperCase());
    }

    public static void setEmailContentInTextPane(DemandeUIHandler handler, DemandeUIModel demandeUIModel, JPanel textPanePanel) {
        List<String> contents = demandeUIModel.getHtmlContent();
        if (contents != null) {
            for (String content : contents) {
                FaxToMailUIUtil.addHtmlTextPane(handler, demandeUIModel, textPanePanel, content);
            }
        } else {
            contents = demandeUIModel.getPlainContent();
            for (String content : contents) {
                JTextPane textPane = new JTextPane();
                textPane.setText(content);
                textPanePanel.add(textPane);
                textPanePanel.add(Box.createVerticalStrut(3));
            }
        }
    }

    public static void forceAttachmentFileLoading(FaxToMailUIContext context, Attachment attachment) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Force attachment loading " + attachment.getOriginalFileName()));
        }
        if (attachment.isPersisted()) {
            AttachmentFile file;
            FaxToMailServiceContext serviceContext = context.newServiceContext();
            EmailService service = serviceContext.getEmailService();
            if (attachment.getOriginalFile() == null) {
                file = service.getAttachmentFile(attachment.getTopiaId(), true);
                attachment.setOriginalFile(file);
            }
            if (attachment.getEditedFile() == null) {
                file = service.getAttachmentFile(attachment.getTopiaId(), false);
                attachment.setEditedFile(file);
            }
        }
    }

    public static void forceReplyContentLoading(FaxToMailUIContext context, Reply reply) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Force source loading " + reply.getSubject()));
        }
        if (reply.isPersisted() && reply.getReplyContent() == null) {
            FaxToMailServiceContext serviceContext = context.newServiceContext();
            EmailService service = serviceContext.getEmailService();
            ReplyContent replyContent = service.getReplyContent(reply.getTopiaId());
            reply.setReplyContent(replyContent);
        }
    }

    public static boolean print(AttachmentFile attachmentFile, boolean defaultPrinter) {
        boolean result = false;
        FileInputStream fileInputStream = null;
        try {
            File file = !FaxToMailUIUtil.isFileAPDF(attachmentFile) ? FaxToMailUIUtil.convertFileToPdf(attachmentFile) : attachmentFile.getFile();
            fileInputStream = new FileInputStream(file);
            result = FaxToMailUIUtil.printWithPdfRenderer(attachmentFile.getFilename(), fileInputStream, defaultPrinter);
        }
        catch (DocumentException | IOException e) {
            try {
                throw new ApplicationTechnicalException(I18n.t((String)"jaxx.application.error.cannot.print", (Object[])new Object[0]), e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(fileInputStream);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)fileInputStream);
        return result;
    }

    public static boolean printText(String printName, String text, boolean defaultPrinter) {
        boolean result = false;
        FileInputStream fileInputStream = null;
        ByteArrayInputStream byteArrayInputStream = null;
        try {
            byte[] content = text.getBytes(Charsets.UTF_8);
            byteArrayInputStream = new ByteArrayInputStream(content);
            File file = FaxToMailUIUtil.convertFileToPdf(byteArrayInputStream, FileType.TEXT);
            fileInputStream = new FileInputStream(file);
            result = FaxToMailUIUtil.printWithPdfRenderer(printName, fileInputStream, defaultPrinter);
        }
        catch (DocumentException | IOException e) {
            try {
                throw new ApplicationTechnicalException(I18n.t((String)"jaxx.application.error.cannot.print", (Object[])new Object[0]), e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(fileInputStream);
                IOUtils.closeQuietly(byteArrayInputStream);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)fileInputStream);
        IOUtils.closeQuietly((InputStream)byteArrayInputStream);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected static boolean printWithPdfRenderer(String printName, FileInputStream fis, boolean defaultPrinter) {
        boolean result;
        block12: {
            PDDocument pdDocument;
            block11: {
                result = false;
                pdDocument = null;
                try {
                    PrinterJob printJob = PrinterJob.getPrinterJob();
                    printJob.setJobName(printName);
                    HashPrintRequestAttributeSet attributes = new HashPrintRequestAttributeSet();
                    boolean bl = result = defaultPrinter || printJob.printDialog(attributes);
                    if (result) {
                        pdDocument = PDDocument.load((InputStream)fis);
                        final PDFRenderer renderer = new PDFRenderer(pdDocument);
                        final int numOfPages = pdDocument.getNumberOfPages();
                        printJob.setPrintable(new Printable(){

                            @Override
                            public int print(Graphics graphics, PageFormat pageFormat, int pageIndex) throws PrinterException {
                                try {
                                    int height;
                                    int width;
                                    if (pageIndex >= numOfPages) {
                                        return 1;
                                    }
                                    double paperWidth = (int)pageFormat.getImageableWidth();
                                    double paperHeight = (int)pageFormat.getImageableHeight();
                                    int paperX = (int)pageFormat.getImageableX();
                                    int paperY = (int)pageFormat.getImageableY();
                                    if (log.isDebugEnabled()) {
                                        log.debug((Object)("page width " + paperWidth));
                                        log.debug((Object)("page height " + paperHeight));
                                        log.debug((Object)("page x " + paperX));
                                        log.debug((Object)("page y " + paperY));
                                    }
                                    BufferedImage image = renderer.renderImageWithDPI(pageIndex, 300.0f);
                                    int imageWidth = image.getWidth();
                                    int imageHeight = image.getHeight();
                                    double widthRatio = paperWidth / (double)imageWidth;
                                    double heightRatio = paperHeight / (double)imageHeight;
                                    if (log.isDebugEnabled()) {
                                        log.debug((Object)("width ratio : " + widthRatio));
                                        log.debug((Object)("height ratio : " + heightRatio));
                                    }
                                    if (widthRatio >= 1.0 && heightRatio >= 1.0) {
                                        width = imageWidth;
                                        height = imageHeight;
                                    } else {
                                        double minRatio = Math.min(widthRatio, heightRatio);
                                        width = (int)(minRatio * (double)imageWidth);
                                        height = (int)(minRatio * (double)imageHeight);
                                    }
                                    if (log.isDebugEnabled()) {
                                        log.debug((Object)("image width : " + width));
                                        log.debug((Object)("image height : " + height));
                                    }
                                    graphics.drawImage(image, paperX, paperY, width, height, null);
                                    return 0;
                                }
                                catch (Exception e) {
                                    if (log.isErrorEnabled()) {
                                        log.error((Object)"error while printing", (Throwable)e);
                                    }
                                    return 1;
                                }
                            }
                        });
                        printJob.print(attributes);
                    }
                    if (!log.isDebugEnabled()) break block11;
                }
                catch (PrinterException ex) {
                    if (log.isErrorEnabled()) {
                        log.error((Object)"can't print", (Throwable)ex);
                    }
                    break block12;
                }
                catch (IOException e) {
                    if (log.isErrorEnabled()) {
                        log.error((Object)"", (Throwable)e);
                    }
                    break block12;
                    {
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                }
                finally {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"finally close the pdf file");
                    }
                    IOUtils.closeQuietly(pdDocument);
                }
                log.debug((Object)"finally close the pdf file");
            }
            IOUtils.closeQuietly((Closeable)pdDocument);
        }
        return result;
    }

    public static File convertFileToPdf(AttachmentFile attachmentFile) throws IOException, DocumentException {
        File file = attachmentFile.getFile();
        FileType type = FaxToMailUIUtil.isFileATxt(attachmentFile) ? FileType.TEXT : (FaxToMailUIUtil.isFileATif(attachmentFile) ? FileType.TIF : FileType.OTHER);
        File result = FaxToMailUIUtil.convertFileToPdf(new FileInputStream(file), type);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static File convertFileToPdf(InputStream inputStream, FileType type) throws IOException, DocumentException {
        PdfWriter writer;
        Document document;
        File target;
        block11: {
            block10: {
                target = File.createTempFile("faxtomail-", ".tmp");
                target.deleteOnExit();
                document = new Document();
                FileOutputStream fos = new FileOutputStream(target);
                writer = PdfWriter.getInstance((Document)document, (OutputStream)fos);
                writer.open();
                document.setPageSize(PageSize.A4);
                document.open();
                if (type != FileType.TEXT) break block10;
                BufferedReader br = null;
                try {
                    br = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));
                    StringBuilder text = new StringBuilder();
                    String line = br.readLine();
                    while (line != null) {
                        text.append(line).append("\n");
                        line = br.readLine();
                    }
                    document.add((Element)new Paragraph(text.toString()));
                    br.close();
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(br);
                    throw throwable;
                }
                IOUtils.closeQuietly((Reader)br);
                break block11;
            }
            if (type == FileType.TIF) {
                try {
                    FileInputStream fis = (FileInputStream)inputStream;
                    FileChannel channel = fis.getChannel();
                    ByteBuffer buffer = ByteBuffer.allocate((int)channel.size());
                    channel.read(buffer);
                    ByteArraySeekableStream stream = new ByteArraySeekableStream(buffer.array());
                    String[] names = ImageCodec.getDecoderNames((SeekableStream)stream);
                    ImageDecoder tifImageDecoder = ImageCodec.createImageDecoder((String)names[0], (SeekableStream)stream, null);
                    for (int i = 0; i < tifImageDecoder.getNumPages(); ++i) {
                        RenderedImage renderedImage = tifImageDecoder.decodeAsRenderedImage(i);
                        BufferedImage awtImage = PlanarImage.wrapRenderedImage((RenderedImage)renderedImage).getAsBufferedImage();
                        document.newPage();
                        com.itextpdf.text.Image image = com.itextpdf.text.Image.getInstance((PdfWriter)writer, (Image)awtImage, (float)1.0f);
                        image.scaleToFit(PageSize.A4.getWidth() - document.leftMargin() - document.rightMargin(), PageSize.A4.getHeight() - document.topMargin() - document.bottomMargin());
                        document.add((Element)image);
                    }
                    fis.close();
                }
                finally {
                    IOUtils.closeQuietly((InputStream)inputStream);
                }
            } else {
                byte[] bytes = IOUtils.toByteArray((InputStream)inputStream);
                com.itextpdf.text.Image image = com.itextpdf.text.Image.getInstance((byte[])bytes);
                float pageWidth = document.getPageSize().getWidth() - document.leftMargin() - document.rightMargin();
                float pageHeight = document.getPageSize().getHeight() - document.topMargin() - document.bottomMargin();
                float imageWidth = image.getWidth();
                float imageHeight = image.getHeight();
                if (pageWidth < imageWidth || pageHeight < imageHeight) {
                    float scaler = Math.min(pageWidth / imageWidth, pageHeight / imageHeight) * 100.0f;
                    image.scalePercent(scaler);
                }
                document.add((Element)image);
            }
        }
        document.close();
        writer.close();
        return target;
    }

    public static String getEditedFileName(String originalFileName) {
        return I18n.t((String)"faxtomail.attachment.editedFile.name", (Object[])new Object[]{originalFileName}) + ".pdf";
    }

    public static void openFile(FaxToMailUIContext context, AttachmentFile attachment) {
        block12: {
            String command;
            File file = attachment.getFile();
            String filename = attachment.getFilename();
            String extension = FilenameUtils.getExtension((String)filename);
            ExtensionCommand extCommand = null;
            if (StringUtils.isNotBlank((CharSequence)extension)) {
                FaxToMailServiceContext serviceContext = context.newServiceContext();
                ConfigurationService service = serviceContext.getConfigurationService();
                extCommand = service.getExtensionCommand(extension);
            }
            if (extCommand != null && StringUtils.isNotBlank((CharSequence)extCommand.getOpenAttachmentCommand())) {
                command = extCommand.getOpenAttachmentCommand();
                String[] args = StringUtil.split((String)command, (String)" ");
                ArrayList<String> comArgs = new ArrayList<String>();
                String[] arr$ = args;
                int len$ = arr$.length;
                for (int i$ = 0; i$ < len$; ++i$) {
                    String arg;
                    String localArg = arg = arr$[i$];
                    localArg = localArg.replace("%f", file.getAbsolutePath());
                    comArgs.add(localArg);
                }
                ProcessBuilder pb = new ProcessBuilder(comArgs);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Open attachment with command : " + comArgs));
                }
                try {
                    pb.start();
                }
                catch (IOException e) {
                    if (log.isErrorEnabled()) {
                        log.error((Object)"Cannot run convert command", (Throwable)e);
                    }
                    break block12;
                }
            }
            try {
                if (SystemUtils.IS_OS_WINDOWS) {
                    command = "rundll32 SHELL32.DLL,ShellExec_RunDLL " + file.getAbsoluteFile();
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Opening file with command : " + command));
                    }
                    Runtime.getRuntime().exec(command);
                } else {
                    Desktop desktop = FaxToMailUIUtil.getDesktopForOpen();
                    desktop.open(file);
                }
            }
            catch (Exception ex) {
                throw new ApplicationTechnicalException(I18n.t((String)"jaxx.application.error.cannot.open", (Object[])new Object[0]), (Throwable)ex);
            }
        }
    }

    public static void email(String subject, String body) {
        try {
            URI mailtoURI = new URI("mailto", null, null, "subject=" + subject + "&body=" + body, null);
            Desktop desktop = FaxToMailUIUtil.getDesktopForMail();
            desktop.mail(mailtoURI);
        }
        catch (Exception e) {
            throw new ApplicationTechnicalException(I18n.t((String)"jaxx.application.error.cannot.mail", (Object[])new Object[0]), (Throwable)e);
        }
    }

    public static boolean isRangePanelVisible(DemandType demandType) {
        return demandType != null && FaxToMailServiceUtils.contains((Collection)demandType.getRequiredFields(), (Enum)MailField.RANGE_ROW);
    }

    protected static void addHtmlTextPane(DemandeUIHandler handler, DemandeUIModel demandeUIModel, JPanel textPanePanel, String content) {
        JTextPane textPane = FaxToMailUIUtil.createHtmlTextPane();
        content = content.replaceAll("<meta (.*?)>(</meta>)?", "");
        if (log.isTraceEnabled()) {
            log.trace((Object)("Content before mail = " + content));
        }
        for (Attachment attachment : demandeUIModel.getAttachment()) {
            String key = attachment.getContentId();
            if (key == null) {
                key = attachment.getOriginalFileName();
            }
            FaxToMailUIUtil.forceAttachmentFileLoading(handler.getContext(), attachment);
            AttachmentFile attachmentFile = attachment.getOriginalFile();
            File file = attachmentFile.getFile();
            content = content.replaceAll("(\\w+)=([\"'])cid:" + Pattern.quote(key) + "([\"'])", "$1=$2" + file.toURI() + "$3");
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)("Mapping attachment id " + key + " to file " + file.toURI()));
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("Content after mail = " + content));
        }
        textPane.setText(content);
        textPanePanel.add(textPane);
        textPanePanel.add(Box.createVerticalStrut(3));
    }

    protected static JTextPane createHtmlTextPane() {
        JTextPane textPane = new JTextPane();
        textPane.setEditable(false);
        textPane.setContentType("text/html");
        HTMLEditorKit htmlEditorKit = new HTMLEditorKit();
        textPane.setEditorKit(htmlEditorKit);
        textPane.putClientProperty("JEditorPane.honorDisplayProperties", true);
        Font font = new Font("Monospaced", 0, 16);
        textPane.setFont(font);
        textPane.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    FaxToMailUIUtil.openLink((URL)e.getURL());
                }
            }
        });
        return textPane;
    }

    protected static enum FileType {
        TEXT,
        TIF,
        OTHER;

    }
}

