/*
 * Decompiled with CFR 0.152.
 */
package com.franciaflex.faxtomail.ui.swing.content.demande;

import com.franciaflex.faxtomail.persistence.entities.Attachment;
import com.franciaflex.faxtomail.persistence.entities.AttachmentImpl;
import com.franciaflex.faxtomail.persistence.entities.Client;
import com.franciaflex.faxtomail.persistence.entities.DemandStatus;
import com.franciaflex.faxtomail.persistence.entities.DemandType;
import com.franciaflex.faxtomail.persistence.entities.Email;
import com.franciaflex.faxtomail.persistence.entities.EmailGroup;
import com.franciaflex.faxtomail.persistence.entities.EmailImpl;
import com.franciaflex.faxtomail.persistence.entities.FaxToMailUser;
import com.franciaflex.faxtomail.persistence.entities.History;
import com.franciaflex.faxtomail.persistence.entities.MailField;
import com.franciaflex.faxtomail.persistence.entities.MailFolder;
import com.franciaflex.faxtomail.persistence.entities.OriginalEmail;
import com.franciaflex.faxtomail.persistence.entities.Priority;
import com.franciaflex.faxtomail.persistence.entities.RangeRow;
import com.franciaflex.faxtomail.persistence.entities.Reply;
import com.franciaflex.faxtomail.persistence.entities.ReplyImpl;
import com.franciaflex.faxtomail.persistence.entities.WaitingState;
import com.franciaflex.faxtomail.services.FaxToMailServiceUtils;
import com.franciaflex.faxtomail.ui.swing.content.attachment.AttachmentModelAware;
import com.franciaflex.faxtomail.ui.swing.content.demande.RangeRowModel;
import com.franciaflex.faxtomail.ui.swing.util.AbstractFaxToMailBeanUIModel;
import com.google.common.collect.Lists;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import javax.activation.DataSource;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.Part;
import javax.mail.Session;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimeUtility;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.mail.util.MimeMessageUtils;
import org.nuiton.i18n.I18n;
import org.nuiton.jaxx.application.swing.tab.TabContentModel;
import org.nuiton.util.beans.Binder;
import org.nuiton.util.beans.BinderFactory;

public class DemandeUIModel
extends AbstractFaxToMailBeanUIModel<Email, DemandeUIModel>
implements AttachmentModelAware,
TabContentModel {
    private static final Log log = LogFactory.getLog(DemandeUIModel.class);
    public static final String PROPERTY_QUOTATION_NB = "quotationNb";
    public static final String PROPERTY_PF_NB = "pfNb";
    public static final String PROPERTY_SAV_NB = "savNb";
    public static final String PROPERTY_CLIENT_CODE = "clientCode";
    public static final String PROPERTY_CLIENT_BRAND = "clientBrand";
    public static final String PROPERTY_REFERENCE = "reference";
    public static final String PROPERTY_EDITABLE = "editable";
    public static final String PROPERTY_LAST_ATTACHMENT_OPENING_IN_THIS_FOLDER_USER = "lastAttachmentOpeningInThisFolderUser";
    public static final String PROPERTY_GROUPED_DEMANDES = "groupedDemandes";
    public static final String PROPERTY_VALID_RANGE_ROW_MODELS = "validRangeRowModels";
    protected final Email editObject = new EmailImpl();
    protected final List<Attachment> attachments = new ArrayList<Attachment>();
    protected final List<Reply> replies = new ArrayList<Reply>();
    protected final List<DemandeUIModel> groupedDemandes = new ArrayList<DemandeUIModel>();
    protected final List<RangeRowModel> validRangeRowModels = new ArrayList<RangeRowModel>();
    protected int quotationNb;
    protected int pfNb;
    protected int savNb;
    protected String clientCode;
    protected String clientBrand;
    protected boolean editable = true;
    protected String htmlContent;
    protected String plainContent;
    protected String subject;
    protected List<String> toRecipients;
    protected List<String> ccRecipients;
    protected boolean closeable;
    protected static final Binder<DemandeUIModel, Email> toBeanBinder = BinderFactory.newBinder(DemandeUIModel.class, Email.class);
    protected static final Binder<Email, DemandeUIModel> fromBeanBinder = BinderFactory.newBinder(Email.class, DemandeUIModel.class);
    protected static Binder<Attachment, Attachment> fromAttachmentBinder = BinderFactory.newBinder(Attachment.class);
    protected static Binder<Reply, Reply> fromReplyBinder = BinderFactory.newBinder(Reply.class);

    public DemandeUIModel() {
        super(fromBeanBinder, toBeanBinder);
        this.addPropertyChangeListener("rangeRow", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                Collection rangeRows = (Collection)evt.getNewValue();
                int quotationNb = 0;
                int pfNb = 0;
                int savNb = 0;
                if (rangeRows != null) {
                    for (RangeRow rangeRow : rangeRows) {
                        Integer savQuantity;
                        Integer productQuantity;
                        if (rangeRow == null) continue;
                        Integer quotationQuantity = rangeRow.getQuotationQuantity();
                        if (quotationQuantity != null) {
                            quotationNb += quotationQuantity.intValue();
                        }
                        if ((productQuantity = rangeRow.getProductQuantity()) != null) {
                            pfNb += productQuantity.intValue();
                        }
                        if ((savQuantity = rangeRow.getSavQuantity()) == null) continue;
                        savNb += savQuantity.intValue();
                    }
                }
                DemandeUIModel.this.setQuotationNb(quotationNb);
                DemandeUIModel.this.setPfNb(pfNb);
                DemandeUIModel.this.setSavNb(savNb);
            }
        });
    }

    @Override
    public void fromEntity(Email entity) {
        fromBeanBinder.copyExcluding((Object)entity, (Object)this, new String[]{"attachment", "replies", "emailGroup"});
        this.loadAttachments(entity);
        this.setGroupedDemandes(entity.getEmailGroup());
        this.loadReplies(entity);
    }

    public void fromEntityExcluding(Email entity, Set<String> properties) {
        boolean includeAttachment = properties.add("attachment");
        boolean includeDemandGroup = properties.add("emailGroup");
        boolean includeReply = properties.add("replies");
        fromBeanBinder.copyExcluding((Object)entity, (Object)this, properties.toArray(new String[properties.size()]));
        if (includeAttachment) {
            this.loadAttachments(entity);
        }
        if (includeDemandGroup) {
            this.setGroupedDemandes(entity.getEmailGroup());
        }
        if (includeReply) {
            this.loadReplies(entity);
        }
    }

    public void fromEntityIncluding(Email entity, Set<String> properties) {
        fromBeanBinder.copy((Object)entity, (Object)this, properties.toArray(new String[properties.size()]));
        if (properties.isEmpty() || properties.contains("attachment")) {
            this.loadAttachments(entity);
        }
        if (properties.isEmpty() || properties.contains("emailGroup")) {
            this.setGroupedDemandes(entity.getEmailGroup());
        }
        if (properties.isEmpty() || properties.contains("replies")) {
            this.loadReplies(entity);
        }
    }

    protected void loadAttachments(Email entity) {
        ArrayList<Attachment> attachmentCopy = new ArrayList<Attachment>();
        if (entity.getAttachment() != null) {
            for (Attachment attachment : entity.getAttachment()) {
                AttachmentImpl clone = new AttachmentImpl();
                fromAttachmentBinder.copyExcluding((Object)attachment, (Object)clone, new String[]{"editedFile", "originalFile"});
                attachmentCopy.add(clone);
            }
        }
        this.setAttachment(attachmentCopy);
    }

    protected void loadReplies(Email entity) {
        ArrayList<Reply> replyCopy = new ArrayList<Reply>();
        if (entity.getReplies() != null) {
            for (Reply reply : entity.getReplies()) {
                ReplyImpl clone = new ReplyImpl();
                fromReplyBinder.copyExcluding((Object)reply, (Object)clone, new String[]{"replyContent"});
                replyCopy.add(clone);
            }
        }
        this.setReplies(replyCopy);
    }

    @Override
    public Email toEntity() {
        Email result = this.newEntity();
        toBeanBinder.copyExcluding((Object)this, (Object)result, new String[]{"attachment", "originalEmail"});
        return result;
    }

    @Override
    public Email toEntity(Email entity) {
        toBeanBinder.copyExcluding((Object)this, (Object)entity, new String[]{"attachment", "originalEmail"});
        return entity;
    }

    public String getTopiaId() {
        return this.editObject.getTopiaId();
    }

    public void setTopiaId(String id) {
        this.editObject.setTopiaId(id);
    }

    public void setSender(String sender) {
        String oldValue = this.getSender();
        this.editObject.setSender(sender);
        this.firePropertyChanged("sender", oldValue, sender);
    }

    public String getSender() {
        String sender = this.editObject.getSender();
        if (sender == null) {
            sender = I18n.t((String)"faxtomail.demande.sender.manualCreation", (Object[])new Object[0]);
        }
        return sender;
    }

    public void setRecipient(String recipient) {
        String oldValue = this.getRecipient();
        this.editObject.setRecipient(recipient);
        this.firePropertyChanged("recipient", oldValue, recipient);
    }

    public String getRecipient() {
        return this.editObject.getRecipient();
    }

    public void setObject(String object) {
        String oldValue = this.getObject();
        this.editObject.setObject(object);
        this.firePropertyChanged("object", oldValue, object);
    }

    public String getObject() {
        return this.editObject.getObject();
    }

    public String getSubject() {
        if (this.subject == null) {
            this.decomposeEmail();
        }
        return this.subject;
    }

    public String getToRecipients() {
        if (this.toRecipients == null) {
            this.decomposeEmail();
        }
        return StringUtils.join(this.toRecipients, (String)", ");
    }

    public String getCcRecipients() {
        if (this.ccRecipients == null) {
            this.decomposeEmail();
        }
        return StringUtils.join(this.ccRecipients, (String)", ");
    }

    public String getPlainContent() {
        if (this.plainContent == null) {
            this.decomposeEmail();
        }
        return this.plainContent;
    }

    public String getHtmlContent() {
        if (this.htmlContent == null) {
            this.decomposeEmail();
        }
        return this.htmlContent;
    }

    public void setOriginalEmail(OriginalEmail originalEmail) {
        this.editObject.setOriginalEmail(originalEmail);
    }

    public OriginalEmail getOriginalEmail() {
        return this.editObject.getOriginalEmail();
    }

    public String getOriginalEmailContent() {
        OriginalEmail originalEmail = this.getOriginalEmail();
        return originalEmail != null ? originalEmail.getContent() : null;
    }

    public void setClientCode(String clientCode) {
        String oldValue = this.getClientCode();
        this.clientCode = clientCode;
        this.firePropertyChanged(PROPERTY_CLIENT_CODE, oldValue, clientCode);
    }

    public boolean isFax() {
        return this.editObject.isFax();
    }

    public void setFax(boolean fax) {
        Boolean oldValue = this.isFax();
        this.editObject.setFax(fax);
        this.firePropertyChanged("fax", oldValue, fax);
    }

    public void setClient(Client client) {
        Client oldValue = this.getClient();
        this.editObject.setClient(client);
        if (client != null) {
            this.clientCode = client.getCode();
            this.clientBrand = client.getBrand();
        }
        this.firePropertyChanged("client", oldValue, client);
    }

    public Client getClient() {
        return this.editObject.getClient();
    }

    public String getClientCode() {
        return this.clientCode;
    }

    public void setClientBrand(String clientBrand) {
        String oldValue = this.getClientBrand();
        this.clientBrand = clientBrand;
        this.firePropertyChanged(PROPERTY_CLIENT_BRAND, oldValue, clientBrand);
    }

    public String getClientBrand() {
        return this.clientBrand;
    }

    public void setWaitingState(WaitingState waitingState) {
        WaitingState oldValue = this.getWaitingState();
        this.editObject.setWaitingState(waitingState);
        this.firePropertyChanged("waitingState", oldValue, waitingState);
    }

    public WaitingState getWaitingState() {
        return this.editObject.getWaitingState();
    }

    public void setTakenBy(FaxToMailUser faxToMailUser) {
        FaxToMailUser oldValue = this.getTakenBy();
        this.editObject.setTakenBy(faxToMailUser);
        this.firePropertyChanged("takenBy", oldValue, faxToMailUser);
    }

    public FaxToMailUser getTakenBy() {
        return this.editObject.getTakenBy();
    }

    public Priority getPriority() {
        return this.editObject.getPriority();
    }

    public void setPriority(Priority priority) {
        Priority oldValue = this.getPriority();
        this.editObject.setPriority(priority);
        this.firePropertyChanged("priority", oldValue, priority);
    }

    public DemandType getDemandType() {
        return this.editObject.getDemandType();
    }

    public void setDemandType(DemandType demandType) {
        DemandType oldValue = this.getDemandType();
        this.editObject.setDemandType(demandType);
        this.firePropertyChanged("demandType", oldValue, demandType);
    }

    public DemandStatus getDemandStatus() {
        return this.editObject.getDemandStatus();
    }

    public void setDemandStatus(DemandStatus demandStatus) {
        DemandStatus oldValue = this.getDemandStatus();
        this.editObject.setDemandStatus(demandStatus);
        this.firePropertyChanged("demandStatus", oldValue, demandStatus);
    }

    public void setReceptionDate(Date receptionDate) {
        Date oldValue = this.getReceptionDate();
        this.editObject.setReceptionDate(receptionDate);
        this.firePropertyChanged("receptionDate", oldValue, receptionDate);
    }

    public Date getReceptionDate() {
        return this.editObject.getReceptionDate();
    }

    public void setEdiError(String ediCodeNumber) {
        String oldValue = this.getEdiError();
        this.editObject.setEdiError(ediCodeNumber);
        this.firePropertyChanged("ediError", oldValue, ediCodeNumber);
    }

    public String getEdiError() {
        return this.editObject.getEdiError();
    }

    public void setProjectReference(String projectReference) {
        String oldValue = this.getProjectReference();
        this.editObject.setProjectReference(projectReference);
        this.firePropertyChanged("projectReference", oldValue, projectReference);
    }

    public String getProjectReference() {
        return this.editObject.getProjectReference();
    }

    public void setCompanyReference(String companyReference) {
        String oldValue = this.getCompanyReference();
        String refOldValue = this.getReference();
        this.editObject.setCompanyReference(companyReference);
        this.firePropertyChanged("companyReference", oldValue, companyReference);
        this.firePropertyChanged(PROPERTY_REFERENCE, refOldValue, this.getReference());
    }

    public String getCompanyReference() {
        return this.editObject.getCompanyReference();
    }

    public String getReference() {
        return this.editObject.getReference();
    }

    public void setHistory(Collection<History> history) {
        this.editObject.setHistory(history);
        this.firePropertyChanged("history", null, history);
    }

    public Collection<History> getHistory() {
        return this.editObject.getHistory();
    }

    public int sizeHistory() {
        return this.editObject.sizeHistory();
    }

    public FaxToMailUser getFirstOpeningUser() {
        return this.editObject.getFirstOpeningUser();
    }

    public Date getFirstOpeningDate() {
        return this.editObject.getFirstOpeningDate();
    }

    public FaxToMailUser getLastModificationUser() {
        return this.editObject.getLastModificationUser();
    }

    public Date getLastModificationDate() {
        return this.editObject.getLastModificationDate();
    }

    public FaxToMailUser getLastAttachmentOpener() {
        return this.editObject.getLastAttachmentOpener();
    }

    public void setLastAttachmentOpener(FaxToMailUser lastAttachmentOpener) {
        this.editObject.setLastAttachmentOpener(lastAttachmentOpener);
    }

    public FaxToMailUser getLastAttachmentOpeningInFolderUser() {
        return this.editObject.getLastAttachmentOpeningInFolderUser();
    }

    public Date getLastAttachmentOpeningInFolderDate() {
        return this.editObject.getLastAttachmentOpeningInFolderDate();
    }

    @Override
    public List<Attachment> getAttachment() {
        return new ArrayList<Attachment>(this.attachments);
    }

    @Override
    public void addAllAttachment(List<Attachment> attachment) {
        ArrayList<Attachment> oldValue = new ArrayList<Attachment>(this.getAttachment());
        this.attachments.addAll(attachment);
        this.firePropertyChange("attachment", oldValue, this.getAttachment());
    }

    @Override
    public void addAttachment(Attachment attachment) {
        ArrayList<Attachment> oldValue = new ArrayList<Attachment>(this.getAttachment());
        this.attachments.add(attachment);
        this.firePropertyChange("attachment", oldValue, this.getAttachment());
    }

    @Override
    public void removeAttachment(Attachment attachment) {
        ArrayList<Attachment> oldValue = new ArrayList<Attachment>(this.getAttachment());
        this.attachments.remove(attachment);
        this.firePropertyChange("attachment", oldValue, this.getAttachment());
    }

    public void setAttachment(List<Attachment> attachment) {
        ArrayList<Attachment> oldValue = new ArrayList<Attachment>(this.getAttachment());
        this.attachments.clear();
        if (attachment != null) {
            this.attachments.addAll(attachment);
        }
        this.firePropertyChange("attachment", oldValue, this.getAttachment());
    }

    public List<RangeRow> getRangeRow() {
        return this.editObject.getRangeRow();
    }

    public void addRangeRow(RangeRow rangeRow) {
        ArrayList<RangeRow> oldValue = null;
        if (this.getRangeRow() != null) {
            oldValue = new ArrayList<RangeRow>(this.getRangeRow());
        }
        String refOldValue = this.getReference();
        this.editObject.addRangeRow(rangeRow);
        this.firePropertyChange("rangeRow", oldValue, this.getRangeRow());
        this.firePropertyChanged(PROPERTY_REFERENCE, refOldValue, this.getReference());
    }

    public void addAllRangeRow(List<RangeRow> rangeRow) {
        ArrayList<RangeRow> oldValue = null;
        if (this.getRangeRow() != null) {
            oldValue = new ArrayList<RangeRow>(this.getRangeRow());
        }
        String refOldValue = this.getReference();
        this.editObject.addAllRangeRow(rangeRow);
        this.firePropertyChange("rangeRow", oldValue, this.getRangeRow());
        this.firePropertyChanged(PROPERTY_REFERENCE, refOldValue, this.getReference());
    }

    public void removeRangeRow(RangeRow rangeRow) {
        ArrayList<RangeRow> oldValue = null;
        if (this.getRangeRow() != null) {
            oldValue = new ArrayList<RangeRow>(this.getRangeRow());
        }
        String refOldValue = this.getReference();
        this.editObject.removeRangeRow(rangeRow);
        this.firePropertyChange("rangeRow", oldValue, this.getRangeRow());
        this.firePropertyChanged(PROPERTY_REFERENCE, refOldValue, this.getReference());
    }

    public void setRangeRow(List<RangeRow> rangeRow) {
        ArrayList<RangeRow> oldValue = new ArrayList<RangeRow>();
        if (this.getRangeRow() != null) {
            oldValue.addAll(this.getRangeRow());
        }
        if (rangeRow == null) {
            rangeRow = new ArrayList<RangeRow>();
        }
        String refOldValue = this.getReference();
        this.editObject.setRangeRow(rangeRow);
        this.firePropertyChange("rangeRow", oldValue, this.getRangeRow());
        this.firePropertyChanged(PROPERTY_REFERENCE, refOldValue, this.getReference());
    }

    public MailFolder getMailFolder() {
        return this.editObject.getMailFolder();
    }

    public void setMailFolder(MailFolder mailFolder) {
        MailFolder oldValue = this.getMailFolder();
        this.editObject.setMailFolder(mailFolder);
        mailFolder.getTopiaId();
        this.firePropertyChanged("mailFolder", oldValue, mailFolder);
    }

    public Date getArchiveDate() {
        return this.editObject.getArchiveDate();
    }

    public void setArchiveDate(Date archiveDate) {
        Date oldValue = this.getArchiveDate();
        this.editObject.setArchiveDate(archiveDate);
        this.firePropertyChanged("archiveDate", oldValue, archiveDate);
    }

    public int getQuotationNb() {
        return this.quotationNb;
    }

    public void setQuotationNb(int quotationNb) {
        Integer oldValue = this.getQuotationNb();
        this.quotationNb = quotationNb;
        this.firePropertyChange(PROPERTY_QUOTATION_NB, oldValue, quotationNb);
    }

    public int getPfNb() {
        return this.pfNb;
    }

    public void setPfNb(int pfNb) {
        Integer oldValue = this.getPfNb();
        this.pfNb = pfNb;
        this.firePropertyChange(PROPERTY_PF_NB, oldValue, pfNb);
    }

    public int getSavNb() {
        return this.savNb;
    }

    public void setSavNb(int savNb) {
        Integer oldValue = this.getSavNb();
        this.savNb = savNb;
        this.firePropertyChange(PROPERTY_SAV_NB, oldValue, savNb);
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setEditable(boolean editable) {
        Boolean oldValue = this.isEditable();
        this.editable = editable;
        this.firePropertyChange(PROPERTY_EDITABLE, oldValue, editable);
    }

    public void setComment(String comment) {
        String oldValue = this.getComment();
        this.editObject.setComment(comment);
        this.firePropertyChange("comment", oldValue, comment);
    }

    public String getComment() {
        return this.editObject.getComment();
    }

    public void setGroupedDemandes(EmailGroup emailGroup) {
        ArrayList<DemandeUIModel> oldValue = new ArrayList<DemandeUIModel>(this.getGroupedDemandes());
        this.groupedDemandes.clear();
        if (emailGroup != null) {
            Set<Email> emails = emailGroup.getEmail();
            if (emails != null) {
                for (Email email : emails) {
                    DemandeUIModel demandeUIModel = new DemandeUIModel();
                    demandeUIModel.setObject(email.getObject());
                    demandeUIModel.setCompanyReference(email.getCompanyReference());
                    demandeUIModel.setTopiaId(email.getTopiaId());
                    demandeUIModel.setMailFolder(email.getMailFolder());
                    demandeUIModel.setDemandStatus(email.getDemandStatus());
                    demandeUIModel.loadAttachments(email);
                    this.groupedDemandes.add(demandeUIModel);
                }
            }
        } else {
            this.groupedDemandes.add(this);
        }
        this.firePropertyChange(PROPERTY_GROUPED_DEMANDES, oldValue, this.getGroupedDemandes());
    }

    public void addGroupedDemande(DemandeUIModel demand) {
        ArrayList<DemandeUIModel> oldValue = new ArrayList<DemandeUIModel>(this.getGroupedDemandes());
        this.groupedDemandes.add(demand);
        this.firePropertyChange(PROPERTY_GROUPED_DEMANDES, oldValue, this.getGroupedDemandes());
    }

    public List<DemandeUIModel> getGroupedDemandes() {
        return this.groupedDemandes;
    }

    public int sizeGroupedDemandes() {
        return this.groupedDemandes.size();
    }

    public void addAllReplies(List<Reply> replies) {
        ArrayList<Reply> oldValue = new ArrayList<Reply>(this.getReplies());
        this.editObject.addAllReplies(replies);
        this.firePropertyChange("replies", oldValue, this.getAttachment());
    }

    public void addReplies(Reply reply) {
        this.editObject.addReplies(reply);
        this.firePropertyChange("replies", null, this.getReplies());
    }

    public void removeReply(Reply reply) {
        ArrayList<Reply> oldValue = new ArrayList<Reply>(this.getReplies());
        this.editObject.removeReplies(reply);
        this.firePropertyChange("replies", oldValue, this.getReplies());
    }

    public void setReplies(List<Reply> replies) {
        this.editObject.setReplies(replies);
        this.firePropertyChange("replies", null, this.getReplies());
    }

    public List<Reply> getReplies() {
        return this.editObject.getReplies();
    }

    public int sizeReplies() {
        return this.editObject.sizeReplies();
    }

    public List<RangeRowModel> getValidRangeRowModels() {
        return this.validRangeRowModels;
    }

    public void setValidRangeRowModels(List<RangeRowModel> validRangeRowModels) {
        ArrayList<RangeRowModel> oldValue = new ArrayList<RangeRowModel>(validRangeRowModels);
        this.validRangeRowModels.clear();
        this.validRangeRowModels.addAll(validRangeRowModels);
        this.firePropertyChanged(PROPERTY_VALID_RANGE_ROW_MODELS, oldValue, validRangeRowModels);
    }

    public void addValidRangeRow(RangeRowModel row) {
        ArrayList<RangeRowModel> oldValue = new ArrayList<RangeRowModel>(this.validRangeRowModels);
        if (!this.validRangeRowModels.contains((Object)row)) {
            this.validRangeRowModels.add(row);
        }
        this.firePropertyChanged(PROPERTY_VALID_RANGE_ROW_MODELS, oldValue, this.validRangeRowModels);
    }

    public void removeValidRangeRow(RangeRowModel row) {
        ArrayList<RangeRowModel> oldValue = new ArrayList<RangeRowModel>(this.validRangeRowModels);
        this.validRangeRowModels.remove((Object)row);
        this.firePropertyChanged(PROPERTY_VALID_RANGE_ROW_MODELS, oldValue, this.validRangeRowModels);
    }

    public void recomputeValidRangeRows() {
        ArrayList<RangeRowModel> validRangeRowModels = new ArrayList<RangeRowModel>();
        List<RangeRow> rangeRows = this.getRangeRow();
        if (rangeRows != null) {
            for (RangeRow rangeRow : rangeRows) {
                if (rangeRow == null) continue;
                RangeRowModel rangeRowModel = new RangeRowModel();
                rangeRowModel.fromEntity(rangeRow);
                if (!rangeRowModel.isValid()) continue;
                validRangeRowModels.add(rangeRowModel);
            }
        }
        this.setValidRangeRowModels(validRangeRowModels);
    }

    public boolean isValid(String field) {
        boolean result;
        DemandType demandType = this.getDemandType();
        boolean bl = result = demandType == null;
        if (!result) {
            if (PROPERTY_CLIENT_CODE.equals(field)) {
                result = !FaxToMailServiceUtils.contains(demandType.getRequiredFields(), (Enum)MailField.CLIENT) || StringUtils.isNotBlank((CharSequence)this.getClientCode());
            } else if (PROPERTY_VALID_RANGE_ROW_MODELS.equals(field)) {
                result = !FaxToMailServiceUtils.contains(demandType.getRequiredFields(), (Enum)MailField.RANGE_ROW) || CollectionUtils.isNotEmpty(this.getValidRangeRowModels());
            } else if ("projectReference".equals(field)) {
                result = !FaxToMailServiceUtils.contains(demandType.getRequiredFields(), (Enum)MailField.PROJECT_REFERENCE) || StringUtils.isNotBlank((CharSequence)this.getProjectReference());
            } else if ("object".equals(field)) {
                result = !FaxToMailServiceUtils.contains(demandType.getRequiredFields(), (Enum)MailField.OBJECT) || StringUtils.isNotBlank((CharSequence)this.getObject());
            } else if ("comment".equals(field)) {
                result = !FaxToMailServiceUtils.contains(demandType.getRequiredFields(), (Enum)MailField.COMMENT) || StringUtils.isNotBlank((CharSequence)this.getComment());
            } else if ("companyReference".equals(field)) {
                result = !FaxToMailServiceUtils.contains(demandType.getRequiredFields(), (Enum)MailField.COMPANY_REFERENCE) || StringUtils.isNotBlank((CharSequence)this.getCompanyReference());
            } else if ("priority".equals(field)) {
                result = !FaxToMailServiceUtils.contains(demandType.getRequiredFields(), (Enum)MailField.PRIORITY) || this.getPriority() != null;
            } else if ("waitingState".equals(field)) {
                result = !FaxToMailServiceUtils.contains(demandType.getRequiredFields(), (Enum)MailField.WAITING_STATE) || this.getWaitingState() != null;
            }
        }
        return result;
    }

    @Override
    protected Email newEntity() {
        return new EmailImpl();
    }

    public int hashCode() {
        return this.editObject.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null || !obj.getClass().isAssignableFrom(DemandeUIModel.class)) {
            return false;
        }
        DemandeUIModel other = (DemandeUIModel)obj;
        return this.editObject.equals(other.editObject);
    }

    protected void decomposeEmail() {
        try {
            Properties properties = new Properties();
            properties.setProperty("mail.mime.address.strict", "false");
            Session session = Session.getInstance((Properties)properties);
            MimeMessage message = MimeMessageUtils.createMimeMessage((Session)session, (String)this.getOriginalEmailContent());
            Charset charset = FaxToMailServiceUtils.getCharset((Part)message);
            this.subject = MimeUtility.decodeText((String)message.getSubject());
            this.toRecipients = new ArrayList<String>();
            this.ccRecipients = new ArrayList<String>();
            Address[] recipients = message.getRecipients(Message.RecipientType.TO);
            if (recipients != null) {
                for (Address address : recipients) {
                    this.toRecipients.add(address.toString());
                }
            }
            if ((recipients = message.getRecipients(Message.RecipientType.CC)) != null) {
                for (Address address : recipients) {
                    this.ccRecipients.add(address.toString());
                }
            }
            if (message.isMimeType("multipart/*")) {
                this.decomposeMultipartEmail((Part)message);
            } else if (message.isMimeType("text/*")) {
                String content;
                this.plainContent = content = IOUtils.toString((InputStream)message.getInputStream(), (Charset)charset);
            }
        }
        catch (Exception e) {
            if (log.isWarnEnabled()) {
                log.warn((Object)"error while parsing the original email content, may come from the imported archives", (Throwable)e);
            }
            this.plainContent = this.getOriginalEmailContent();
            this.toRecipients = Lists.newArrayList((Object[])new String[]{this.getRecipient()});
        }
    }

    protected void decomposeMultipartEmail(Part part) throws Exception {
        DataSource dataSource = part.getDataHandler().getDataSource();
        MimeMultipart mimeMultipart = new MimeMultipart(dataSource);
        int multiPartCount = mimeMultipart.getCount();
        for (int j = 0; j < multiPartCount; ++j) {
            BodyPart bp = mimeMultipart.getBodyPart(j);
            String disposition = bp.getDisposition();
            if (bp.isMimeType("text/*") && !"attachment".equals(disposition)) {
                Charset charset = FaxToMailServiceUtils.getCharset((Part)bp);
                String content = IOUtils.toString((InputStream)bp.getInputStream(), (Charset)charset);
                if (bp.isMimeType("text/plain")) {
                    this.plainContent = content;
                    continue;
                }
                this.htmlContent = content;
                continue;
            }
            if (!bp.isMimeType("multipart/*")) continue;
            this.decomposeMultipartEmail((Part)bp);
        }
    }

    public boolean isEmpty() {
        return false;
    }

    public String getTitle() {
        return this.editObject.getTitle();
    }

    public String getIcon() {
        return "email";
    }

    public boolean isCloseable() {
        return this.closeable;
    }

    public void setCloseable(boolean closeable) {
        this.closeable = closeable;
    }
}

