/*
 * Decompiled with CFR 0.152.
 */
package com.franciaflex.faxtomail.ui.swing.actions;

import com.franciaflex.faxtomail.persistence.entities.MailFolder;
import com.franciaflex.faxtomail.persistence.entities.Range;
import com.franciaflex.faxtomail.services.FaxToMailServiceContext;
import com.franciaflex.faxtomail.ui.swing.actions.AbstractFaxToMailAction;
import com.franciaflex.faxtomail.ui.swing.content.demande.QuantitiesByRangeUI;
import com.franciaflex.faxtomail.ui.swing.content.demande.QuantitiesByRangeUIHandler;
import com.franciaflex.faxtomail.ui.swing.content.demande.QuantitiesByRangeUIModel;
import com.franciaflex.faxtomail.ui.swing.content.demande.RangeRowModel;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Map;
import org.nuiton.i18n.I18n;

public class ComputeQuantitiesByRangeAction
extends AbstractFaxToMailAction<QuantitiesByRangeUIModel, QuantitiesByRangeUI, QuantitiesByRangeUIHandler> {
    public ComputeQuantitiesByRangeAction(QuantitiesByRangeUIHandler handler) {
        super(handler, false);
        this.setActionDescription(I18n.t((String)"faxtomail.action.computeQuantitiesByRange.tip", (Object[])new Object[0]));
    }

    @Override
    public void doAction() throws Exception {
        MailFolder folder = ((QuantitiesByRangeUIModel)this.getModel()).getRootFolder();
        FaxToMailServiceContext serviceContext = this.getContext().newServiceContext();
        Map quantitiesByRange = serviceContext.getEmailService().computeQuantitiesByRange(folder);
        ArrayList<RangeRowModel> rangeRows = new ArrayList<RangeRowModel>();
        for (Range range : quantitiesByRange.keySet()) {
            RangeRowModel row = new RangeRowModel();
            row.setRange(range);
            Long[] quantities = (Long[])quantitiesByRange.get(range);
            Long productQuantity = quantities[0];
            if (productQuantity == null) {
                productQuantity = 0L;
            }
            row.setProductQuantity(productQuantity.intValue());
            Long savQuantity = quantities[1];
            if (savQuantity == null) {
                savQuantity = 0L;
            }
            row.setSavQuantity(savQuantity.intValue());
            Long quotationQuantity = quantities[2];
            if (quotationQuantity == null) {
                quotationQuantity = 0L;
            }
            row.setQuotationQuantity(quotationQuantity.intValue());
            rangeRows.add(row);
        }
        ((QuantitiesByRangeUIModel)this.getModel()).setRangeRows(rangeRows);
    }

    public void postSuccessAction() {
        super.postSuccessAction();
        ((QuantitiesByRangeUIHandler)this.handler).openDialog(this.getUI(), I18n.t((String)"faxtomail.quantitiesByRange.title", (Object[])new Object[0]), new Dimension(350, 300));
    }
}

