/*
 * Decompiled with CFR 0.152.
 */
package com.franciaflex.faxtomail.ui.swing.content.pdfeditor;

import com.franciaflex.faxtomail.persistence.entities.Attachment;
import com.franciaflex.faxtomail.persistence.entities.AttachmentFile;
import com.franciaflex.faxtomail.persistence.entities.AttachmentImpl;
import com.franciaflex.faxtomail.ui.swing.content.demande.DemandeUIModel;
import com.franciaflex.faxtomail.ui.swing.content.pdfeditor.PDFEditorCrossUI;
import com.franciaflex.faxtomail.ui.swing.content.pdfeditor.PDFEditorHighlighterUI;
import com.franciaflex.faxtomail.ui.swing.content.pdfeditor.PDFEditorLineUI;
import com.franciaflex.faxtomail.ui.swing.content.pdfeditor.PDFEditorNoteUI;
import com.franciaflex.faxtomail.ui.swing.util.AbstractFaxToMailBeanUIModel;
import java.util.ArrayList;
import java.util.List;
import org.nuiton.util.beans.Binder;
import org.nuiton.util.beans.BinderFactory;

public class PDFEditorUIModel
extends AbstractFaxToMailBeanUIModel<Attachment, PDFEditorUIModel> {
    public static final String PROPERTY_PAGES = "pages";
    public static final String PROPERTY_CURRENT_PAGE_INDEX = "currentPageIndex";
    public static final String PROPERTY_ZOOM = "zoom";
    public static final String PROPERTY_ROTATION = "rotation";
    protected final Attachment editObject = new AttachmentImpl();
    protected DemandeUIModel demand;
    protected EditionComponent selectedComponent;
    protected Page[] pages;
    protected int currentPageIndex = -1;
    protected float zoom = 1.0f;
    protected int rotation = 0;
    protected static Binder<PDFEditorUIModel, Attachment> toBeanBinder = BinderFactory.newBinder(PDFEditorUIModel.class, Attachment.class);
    protected static Binder<Attachment, PDFEditorUIModel> fromBeanBinder = BinderFactory.newBinder(Attachment.class, PDFEditorUIModel.class);

    public PDFEditorUIModel() {
        super(fromBeanBinder, toBeanBinder);
    }

    public void setOriginalFile(AttachmentFile file) {
        AttachmentFile oldValue = this.getOriginalFile();
        this.editObject.setOriginalFile(file);
        this.firePropertyChange("originalFile", oldValue, file);
    }

    public AttachmentFile getOriginalFile() {
        return this.editObject.getOriginalFile();
    }

    public void setEditedFile(AttachmentFile file) {
        AttachmentFile oldValue = this.getEditedFile();
        this.editObject.setEditedFile(file);
        this.firePropertyChange("editedFile", oldValue, file);
        this.setRotation(file != null ? file.getRotation() : 0);
    }

    public AttachmentFile getEditedFile() {
        return this.editObject.getEditedFile();
    }

    public AttachmentFile getNotNullFile() {
        AttachmentFile file = this.getEditedFile();
        if (file == null) {
            file = this.getOriginalFile();
        }
        return file;
    }

    public String getTopiaId() {
        return this.editObject.getTopiaId();
    }

    public void setTopiaId(String id) {
        String oldValue = this.getTopiaId();
        this.editObject.setTopiaId(id);
        this.firePropertyChange("topiaId", oldValue, id);
    }

    public Page[] getPages() {
        return this.pages;
    }

    public void setPageNumber(int nb) {
        this.pages = new Page[nb];
        for (int i = 0; i < nb; ++i) {
            this.pages[i] = new Page();
        }
        this.firePropertyChanged(PROPERTY_PAGES, null, this.pages);
    }

    public Page getCurrentPage() {
        if (this.pages == null || this.currentPageIndex < 0 || this.currentPageIndex >= this.pages.length) {
            return null;
        }
        return this.pages[this.currentPageIndex];
    }

    public Page getPage(int i) {
        if (this.pages == null || i < 0 || i >= this.pages.length) {
            return null;
        }
        return this.pages[i];
    }

    public int getCurrentPageIndex() {
        return this.currentPageIndex;
    }

    public void setCurrentPageIndex(int currentPageIndex) {
        Integer oldValue = this.getCurrentPageIndex();
        currentPageIndex = Math.max(0, currentPageIndex);
        if (this.pages != null) {
            currentPageIndex = Math.min(this.pages.length - 1, currentPageIndex);
        }
        this.currentPageIndex = currentPageIndex;
        this.firePropertyChange(PROPERTY_CURRENT_PAGE_INDEX, oldValue, currentPageIndex);
    }

    public void decPageIndex() {
        this.setCurrentPageIndex(this.currentPageIndex - 1);
    }

    public void incPageIndex() {
        this.setCurrentPageIndex(this.currentPageIndex + 1);
    }

    public float getZoom() {
        return this.zoom;
    }

    public void setZoom(float zoom) {
        if (zoom >= 1.0f && zoom <= 15.0f) {
            Float oldValue = Float.valueOf(this.getZoom());
            this.zoom = zoom;
            this.firePropertyChanged(PROPERTY_ZOOM, oldValue, Float.valueOf(zoom));
        }
    }

    public int getRotation() {
        return this.rotation;
    }

    public void setRotation(int rotation) {
        Integer oldValue = this.getRotation();
        this.rotation = rotation;
        this.firePropertyChanged(PROPERTY_ROTATION, oldValue, rotation);
    }

    public DemandeUIModel getDemand() {
        return this.demand;
    }

    public void setDemand(DemandeUIModel demand) {
        this.demand = demand;
    }

    public EditionComponent getSelectedComponent() {
        return this.selectedComponent;
    }

    public void setSelectedComponent(EditionComponent selectedComponent) {
        this.selectedComponent = selectedComponent;
    }

    @Override
    protected Attachment newEntity() {
        return new AttachmentImpl();
    }

    public class Page {
        protected List<PDFEditorNoteUI> notes = new ArrayList<PDFEditorNoteUI>();
        protected List<PDFEditorCrossUI> crosses = new ArrayList<PDFEditorCrossUI>();
        protected List<PDFEditorLineUI> lines = new ArrayList<PDFEditorLineUI>();
        protected List<PDFEditorHighlighterUI> highlighters = new ArrayList<PDFEditorHighlighterUI>();

        public List<PDFEditorNoteUI> getNotes() {
            return this.notes;
        }

        public void addNote(PDFEditorNoteUI note) {
            this.notes.add(note);
            PDFEditorUIModel.this.setModify(true);
        }

        public void removeNote(PDFEditorNoteUI note) {
            this.notes.remove(note);
            PDFEditorUIModel.this.setModify(true);
        }

        public List<PDFEditorCrossUI> getCrosses() {
            return this.crosses;
        }

        public void addCross(PDFEditorCrossUI cross) {
            this.crosses.add(cross);
            PDFEditorUIModel.this.setModify(true);
        }

        public void removeCross(PDFEditorCrossUI cross) {
            this.crosses.remove(cross);
            PDFEditorUIModel.this.setModify(true);
        }

        public List<PDFEditorLineUI> getLines() {
            return this.lines;
        }

        public void addLine(PDFEditorLineUI line) {
            this.lines.add(line);
            PDFEditorUIModel.this.setModify(true);
        }

        public void removeLine(PDFEditorLineUI line) {
            this.lines.remove(line);
            PDFEditorUIModel.this.setModify(true);
        }

        public List<PDFEditorHighlighterUI> getHighlighters() {
            return this.highlighters;
        }

        public void addHighlighter(PDFEditorHighlighterUI highlighter) {
            this.highlighters.add(highlighter);
            PDFEditorUIModel.this.setModify(true);
        }

        public void removeHighlighter(PDFEditorHighlighterUI highlighter) {
            this.highlighters.remove(highlighter);
            PDFEditorUIModel.this.setModify(true);
        }
    }

    public static enum EditionComponent {
        NOTE,
        CROSS,
        HLINE,
        VLINE,
        HIGHLIGHTER;

    }
}

