/*
 * Decompiled with CFR 0.152.
 */
package com.franciaflex.faxtomail.ui.swing.actions;

import com.franciaflex.faxtomail.persistence.entities.Attachment;
import com.franciaflex.faxtomail.persistence.entities.DemandStatus;
import com.franciaflex.faxtomail.persistence.entities.Email;
import com.franciaflex.faxtomail.persistence.entities.EmailImpl;
import com.franciaflex.faxtomail.persistence.entities.FaxToMailUser;
import com.franciaflex.faxtomail.persistence.entities.RangeRow;
import com.franciaflex.faxtomail.persistence.entities.Reply;
import com.franciaflex.faxtomail.services.FaxToMailServiceContext;
import com.franciaflex.faxtomail.services.service.exceptions.InvalidClientException;
import com.franciaflex.faxtomail.ui.swing.FaxToMailUIContext;
import com.franciaflex.faxtomail.ui.swing.actions.AbstractFaxToMailAction;
import com.franciaflex.faxtomail.ui.swing.content.demande.DemandeUI;
import com.franciaflex.faxtomail.ui.swing.content.demande.DemandeUIHandler;
import com.franciaflex.faxtomail.ui.swing.content.demande.DemandeUIModel;
import com.franciaflex.faxtomail.ui.swing.content.demande.RangeRowModel;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.nuiton.i18n.I18n;
import org.nuiton.topia.persistence.TopiaEntities;
import org.nuiton.util.beans.BeanMonitor;

public class SaveDemandeAction
extends AbstractFaxToMailAction<DemandeUIModel, DemandeUI, DemandeUIHandler> {
    protected boolean takeIfNotTaken;

    public SaveDemandeAction(DemandeUIHandler handler) {
        super(handler, false);
        this.setActionDescription(I18n.t((String)"faxtomail.action.save.tip", (Object[])new Object[0]));
    }

    public boolean isTakeIfNotTaken() {
        return this.takeIfNotTaken;
    }

    public void setTakeIfNotTaken(boolean takeIfNotTaken) {
        this.takeIfNotTaken = takeIfNotTaken;
    }

    @Override
    public void doAction() throws Exception {
        DemandeUIModel model = (DemandeUIModel)this.getModel();
        FaxToMailUIContext context = this.getContext();
        String topiaId = model.getTopiaId();
        FaxToMailServiceContext serviceContext = context.newServiceContext();
        Email persistedEmail = !StringUtils.isBlank((CharSequence)topiaId) ? serviceContext.getEmailService().getFullEmailById(topiaId) : new EmailImpl();
        List<RangeRowModel> rows = model.getValidRangeRowModels();
        boolean cont = true;
        while (cont) {
            try {
                model.removeRangeRow(null);
            }
            catch (IllegalArgumentException eee) {
                cont = false;
            }
        }
        List<RangeRow> rangeRows = model.getRangeRow();
        if (rangeRows == null) {
            rangeRows = new ArrayList<RangeRow>();
        }
        ImmutableMap rangeRowsById = Maps.uniqueIndex(rangeRows, (Function)TopiaEntities.getTopiaIdFunction());
        model.setRangeRow(new ArrayList<RangeRow>());
        for (RangeRowModel rangeRowModel : rows) {
            RangeRow rangeRow = (RangeRow)rangeRowsById.get(rangeRowModel.getTopiaId());
            if (rangeRow == null) {
                model.addRangeRow((RangeRow)rangeRowModel.toEntity());
                continue;
            }
            model.addRangeRow(rangeRowModel.toEntity(rangeRow));
        }
        FaxToMailUser currentUser = context.getCurrentUser();
        if (model.getDemandStatus() != DemandStatus.ARCHIVED && this.takeIfNotTaken && model.getTakenBy() == null) {
            model.setTakenBy(this.getContext().getCurrentUser());
        }
        Email email = model.toEntity(persistedEmail);
        List<Attachment> attachments = model.getAttachment();
        List<Reply> replies = model.getReplies();
        String clientCode = model.getClientCode();
        BeanMonitor monitor = ((DemandeUIHandler)this.getHandler()).getMonitor();
        String[] modifiedProperties = monitor.getModifiedProperties();
        email = serviceContext.getEmailService().saveEmail(email, attachments, replies, clientCode, currentUser, modifiedProperties);
        model.fromEntity(email);
        ((DemandeUIModel)this.getModel()).setModify(false);
        monitor.clearModified();
    }

    public void postFailedAction(Throwable error) {
        if (error instanceof InvalidClientException) {
            DemandeUIModel model = (DemandeUIModel)this.getModel();
            model.setClientCode(null);
            BeanMonitor monitor = ((DemandeUIHandler)this.getHandler()).getMonitor();
            List rangeRows = (List)monitor.getOriginalValues().get("rangeRow");
            model.setRangeRow(rangeRows);
        }
    }
}

