/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.util.ssl;

import com.unboundid.util.Debug;
import com.unboundid.util.NotMutable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.ssl.SSLMessages;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.security.MessageDigest;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.concurrent.ConcurrentHashMap;
import javax.net.ssl.X509TrustManager;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class PromptTrustManager
implements X509TrustManager {
    private static final MessageDigest MD5;
    private static final MessageDigest SHA1;
    private final boolean examineValidityDates;
    private final ConcurrentHashMap<String, Boolean> acceptedCerts;
    private final InputStream in;
    private final PrintStream out;
    private final String acceptedCertsFile;

    public PromptTrustManager() {
        this(null, true, null, null);
    }

    public PromptTrustManager(String acceptedCertsFile) {
        this(acceptedCertsFile, true, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public PromptTrustManager(String acceptedCertsFile, boolean examineValidityDates, InputStream in, PrintStream out) {
        this.acceptedCertsFile = acceptedCertsFile;
        this.examineValidityDates = examineValidityDates;
        this.in = in == null ? System.in : in;
        this.out = out == null ? System.out : out;
        this.acceptedCerts = new ConcurrentHashMap();
        if (acceptedCertsFile == null) return;
        BufferedReader r = null;
        File f = new File(acceptedCertsFile);
        if (f.exists()) {
            String line;
            r = new BufferedReader(new FileReader(f));
            while ((line = r.readLine()) != null) {
                this.acceptedCerts.put(line, false);
            }
        }
        Object var9_9 = null;
        if (r == null) return;
        try {
            r.close();
            return;
        }
        catch (Exception e2) {
            Debug.debugException(e2);
        }
        return;
        {
            catch (Exception e) {
                Debug.debugException(e);
                Object var9_10 = null;
                if (r == null) return;
                try {
                    r.close();
                    return;
                }
                catch (Exception e2) {
                    Debug.debugException(e2);
                }
                return;
            }
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            if (r == null) throw throwable;
            try {
                r.close();
                throw throwable;
            }
            catch (Exception e2) {
                Debug.debugException(e2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void writeCacheFile() throws IOException {
        File cacheFile;
        File tempFile;
        block6: {
            tempFile = new File(this.acceptedCertsFile + ".new");
            BufferedWriter w = null;
            try {
                w = new BufferedWriter(new FileWriter(tempFile));
                for (String certBytes : this.acceptedCerts.keySet()) {
                    w.write(certBytes);
                    w.newLine();
                }
                Object var6_5 = null;
                if (w == null) break block6;
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                if (w != null) {
                    w.close();
                }
                throw throwable;
            }
            w.close();
        }
        if ((cacheFile = new File(this.acceptedCertsFile)).exists()) {
            File oldFile = new File(this.acceptedCertsFile + ".previous");
            if (oldFile.exists()) {
                oldFile.delete();
            }
            cacheFile.renameTo(oldFile);
        }
        tempFile.renameTo(cacheFile);
    }

    public synchronized boolean wouldPrompt(X509Certificate[] chain) {
        X509Certificate c = chain[0];
        String certBytes = StaticUtils.toLowerCase(StaticUtils.toHex(c.getSignature()));
        Boolean acceptedRegardlessOfValidity = this.acceptedCerts.get(certBytes);
        if (acceptedRegardlessOfValidity == null) {
            return true;
        }
        if (acceptedRegardlessOfValidity.booleanValue() || !this.examineValidityDates) {
            return false;
        }
        Date currentDate = new Date();
        return !currentDate.before(c.getNotBefore()) && !currentDate.after(c.getNotAfter());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private synchronized void checkCertificateChain(X509Certificate[] chain, boolean serverCert) throws CertificateException {
        String certBytes;
        Boolean accepted;
        String validityWarning = null;
        Date currentDate = new Date();
        X509Certificate c = chain[0];
        if (this.examineValidityDates) {
            if (currentDate.before(c.getNotBefore())) {
                validityWarning = SSLMessages.WARN_PROMPT_NOT_YET_VALID.get();
            } else if (currentDate.after(c.getNotAfter())) {
                validityWarning = SSLMessages.WARN_PROMPT_EXPIRED.get();
            }
        }
        if (!(this.examineValidityDates && validityWarning != null || (accepted = this.acceptedCerts.get(certBytes = StaticUtils.toLowerCase(StaticUtils.toHex(c.getSignature())))) == null)) {
            if (validityWarning == null) return;
            if (!this.examineValidityDates) return;
            if (Boolean.TRUE.equals(accepted)) {
                return;
            }
        }
        if (serverCert) {
            this.out.println(SSLMessages.INFO_PROMPT_SERVER_HEADING.get());
        } else {
            this.out.println(SSLMessages.INFO_PROMPT_CLIENT_HEADING.get());
        }
        this.out.println('\t' + SSLMessages.INFO_PROMPT_SUBJECT.get(c.getSubjectX500Principal().getName("CANONICAL")));
        this.out.println("\t\t" + SSLMessages.INFO_PROMPT_MD5_FINGERPRINT.get(PromptTrustManager.getFingerprint(c, MD5)));
        this.out.println("\t\t" + SSLMessages.INFO_PROMPT_SHA1_FINGERPRINT.get(PromptTrustManager.getFingerprint(c, SHA1)));
        for (int i = 1; i < chain.length; ++i) {
            this.out.println('\t' + SSLMessages.INFO_PROMPT_ISSUER_SUBJECT.get(i, chain[i].getSubjectX500Principal().getName("CANONICAL")));
            this.out.println("\t\t" + SSLMessages.INFO_PROMPT_MD5_FINGERPRINT.get(PromptTrustManager.getFingerprint(chain[i], MD5)));
            this.out.println("\t\t" + SSLMessages.INFO_PROMPT_SHA1_FINGERPRINT.get(PromptTrustManager.getFingerprint(chain[i], SHA1)));
        }
        this.out.println(SSLMessages.INFO_PROMPT_VALIDITY.get(String.valueOf(c.getNotBefore()), String.valueOf(c.getNotAfter())));
        if (chain.length == 1) {
            this.out.println();
            this.out.println(SSLMessages.WARN_PROMPT_SELF_SIGNED.get());
        }
        if (validityWarning != null) {
            this.out.println();
            this.out.println(validityWarning);
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader(this.in));
        block6: while (true) {
            try {
                String line;
                do {
                    this.out.println();
                    this.out.print(SSLMessages.INFO_PROMPT_MESSAGE.get());
                    this.out.flush();
                    line = reader.readLine();
                    if (line.equalsIgnoreCase("y") || line.equalsIgnoreCase("yes")) break block6;
                    if (line.equalsIgnoreCase("n")) throw new CertificateException(SSLMessages.ERR_CERTIFICATE_REJECTED_BY_USER.get());
                } while (!line.equalsIgnoreCase("no"));
                throw new CertificateException(SSLMessages.ERR_CERTIFICATE_REJECTED_BY_USER.get());
            }
            catch (CertificateException ce) {
                throw ce;
            }
            catch (Exception e) {
                Debug.debugException(e);
                continue;
            }
            break;
        }
        String certBytes2 = StaticUtils.toLowerCase(StaticUtils.toHex(c.getSignature()));
        this.acceptedCerts.put(certBytes2, validityWarning != null);
        if (this.acceptedCertsFile == null) return;
        try {
            this.writeCacheFile();
            return;
        }
        catch (Exception e) {
            Debug.debugException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getFingerprint(X509Certificate c, MessageDigest d) throws CertificateException {
        byte[] digestBytes;
        byte[] encodedCertBytes = c.getEncoded();
        MessageDigest messageDigest = d;
        synchronized (messageDigest) {
            digestBytes = d.digest(encodedCertBytes);
        }
        StringBuilder buffer = new StringBuilder(3 * encodedCertBytes.length);
        StaticUtils.toHex(digestBytes, ":", buffer);
        return buffer.toString();
    }

    public boolean examineValidityDates() {
        return this.examineValidityDates;
    }

    public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        this.checkCertificateChain(chain, false);
    }

    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        this.checkCertificateChain(chain, true);
    }

    public X509Certificate[] getAcceptedIssuers() {
        return new X509Certificate[0];
    }

    static {
        MessageDigest d = null;
        try {
            d = MessageDigest.getInstance("MD5");
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new RuntimeException(e);
        }
        MD5 = d;
        d = null;
        try {
            d = MessageDigest.getInstance("SHA-1");
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new RuntimeException(e);
        }
        SHA1 = d;
    }
}

