package com.franciaflex.faxtomail.ui.swing.content.print;

/*
 * #%L
 * FaxToMail :: UI
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2014 Mac-Groupe, Code Lutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import com.franciaflex.faxtomail.ui.swing.content.demande.DemandeUIModel;
import com.franciaflex.faxtomail.ui.swing.util.FaxToMailUI;
import com.franciaflex.faxtomail.ui.swing.util.FaxToMailUIUtil;
import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static org.nuiton.i18n.I18n.t;

public class AttachmentToPrintChooserUI extends JPanel implements FaxToMailUI<AttachmentToPrintChooserUIModel, AttachmentToPrintChooserUIHandler>, JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_MODEL = "model";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_VALIDATE_BUTTON_ENABLED = "validateButton.enabled";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAK1VTW8TRxh+s8TOJx8lIgQ1lUybQyJF4wDiFMRH0kZNMDQiKUX40vHuJB40uzPMzJKNEIifwE+Aey+Veuup4sC5By6ofwEhDr1WvLO73o0dRwZRy1pp34/nfebx+4x/ewcVo+H8A5okRMeR5SEjGzfu3fup9YD59ntmfM2VlRqyz5AHXhMmgiJuLHzXbLj2et5eX5WhkhGLDnQvN2Dc2H3BTJsxa+Gb7g7fmPpWkV5OVKw7qAWpfqgvPrz3ngfPXnoAiUJ2o3iU2qCu8iTDDfB4YOE0TnpE64JGu0hD82gX+R53sVVBjblNQ/YQnsJIA6qKagSz8O2nHznFSPsTZWGGWkv9doi123ITZ9nVtpSGaQs3fRmSHU0jn9MdwRKyQxMrQ8oFiTkxe8iL+DKy2EqU6yQ3jsD6eV2pdGTVQiWUARMWNv9H9FsOshwxEjJj6C5DJZ1oSY620aAtJlzNWFF6fG5jy9dSiE0asSULZ7saylR318lSNJcUvYPSoKs9XbSMzmXRJfd+thtu0kcVmFiJrcUDw1QXVhZ1lTNFw4lHVPCAWlYmZ/MKDV93LRyuMilXudy1oSZUdIxhXIHm4e2/g6ls72d69t4Bptn/pqfe/PnPH2udZR/B2Wf6lh7wKi6h0lLhenE3+mS26bHlon6LquUmjBkm0OipkWf7ENvK00gO533l2olrJz9S00aIysjbv15N//r3MfDWYFxIGqxRV78OY7atUQUpgkRdu54ymtwbxecpxw25hDThYRzekXurMnam8i4uJajAbB8FChqtsdf/Tm39fr2jgoeszh1ZXipRuQ9VHgkesdT0uZ/7mnxCGRYHsvRtPycDenl6hdFojQvLNG1hWoYtuSKT3BjElUy6kp7EXPqcP6SJZ2HYsgSFWCi96aeeO2RFUliu2pI6cNfH8uPawUVeScPZj7FPfM1wfX8Ild3PEvOXF2v5d6H2JIkdpUUnVc69dLUaQPtYQbs+mDbS4TIimQEtjGfv6+7igWonOmGlFNtcbaeolz4TlViu+p2ny/WDDjWM52eR+1Xx/2Hxce18eosSFLycbvLx8wuEm1TaeZSyUOPCJ/Pu3C49eoyW8W5FLn828lGa9Fxsg1RB11YF3ZdYDCeuYB+ttXgU4LpdPYQ+5J7jAxFd+K57/NIfYfqLEc4hwkd5Bw0w5wgAAA==";
    private static final Log log = LogFactory.getLog(AttachmentToPrintChooserUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JPanel attachmentPanel;
    protected AttachmentToPrintChooserUI attachmentToPrintChooser = this;
    protected JButton cancelButton;
    protected final AttachmentToPrintChooserUIHandler handler = new AttachmentToPrintChooserUIHandler();
    protected JLabel message;
    protected AttachmentToPrintChooserUIModel model;
    protected JButton validateButton;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JPanel $JPanel0;
    private JScrollPane $JScrollPane0;

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public AttachmentToPrintChooserUI(FaxToMailUI parentUI, DemandeUIModel demande) {
        FaxToMailUIUtil.setParentUI(this, parentUI);
                AttachmentToPrintChooserUIModel model = new AttachmentToPrintChooserUIModel();
                model.setDemand(demande);
                setContextValue(model);
            $initialize();
    }

    public AttachmentToPrintChooserUI(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public AttachmentToPrintChooserUI(JAXXContext parentContext, LayoutManager param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public AttachmentToPrintChooserUI(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public AttachmentToPrintChooserUI(JAXXContext parentContext, LayoutManager param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public AttachmentToPrintChooserUI() {
        $initialize();
    }

    public AttachmentToPrintChooserUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public AttachmentToPrintChooserUI(boolean param0) {
        super(param0);
        $initialize();
    }

    public AttachmentToPrintChooserUI(JAXXContext parentContext, boolean param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__cancelButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.cancel();
    }

    public void doActionPerformed__on__validateButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.print();
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JPanel getAttachmentPanel() {
        return attachmentPanel;
    }

    public JButton getCancelButton() {
        return cancelButton;
    }

    public AttachmentToPrintChooserUIHandler getHandler() {
        return handler;
    }

    public JLabel getMessage() {
        return message;
    }

    public AttachmentToPrintChooserUIModel getModel() {
        return model;
    }

    public JButton getValidateButton() {
        return validateButton;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setModel(AttachmentToPrintChooserUIModel model) {
        AttachmentToPrintChooserUIModel oldValue = this.model;
        this.model = model;
        firePropertyChange(PROPERTY_MODEL, oldValue, model);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JPanel get$JPanel0() {
        return $JPanel0;
    }

    protected JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToAttachmentToPrintChooser() {
        if (!allComponentsCreated) {
            return;
        }
        add(message, BorderLayout.NORTH);
        add($JScrollPane0, BorderLayout.CENTER);
        add($JPanel0, BorderLayout.SOUTH);
    }

    protected void createAttachmentPanel() {
        $objectMap.put("attachmentPanel", attachmentPanel = new JPanel());
        
        attachmentPanel.setName("attachmentPanel");
        attachmentPanel.setLayout( new BoxLayout(attachmentPanel, BoxLayout.Y_AXIS) );
    }

    protected void createCancelButton() {
        $objectMap.put("cancelButton", cancelButton = new JButton());
        
        cancelButton.setName("cancelButton");
        cancelButton.setText(t("faxtomail.chooseAttachmentToPrint.action.cancel"));
        cancelButton.setToolTipText(t("faxtomail.chooseAttachmentToPrint.action.cancel.tip"));
        cancelButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__cancelButton"));
    }

    protected void createMessage() {
        $objectMap.put("message", message = new JLabel());
        
        message.setName("message");
        message.setText(t("faxtomail.chooseAttachmentToPrint.message"));
    }

    protected void createModel() {
        $objectMap.put("model", model = getContextValue(AttachmentToPrintChooserUIModel.class));
    }

    protected void createValidateButton() {
        $objectMap.put("validateButton", validateButton = new JButton());
        
        validateButton.setName("validateButton");
        validateButton.setText(t("faxtomail.chooseAttachmentToPrint.action.validate"));
        validateButton.setToolTipText(t("faxtomail.chooseAttachmentToPrint.action.validate.tip"));
        validateButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__validateButton"));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToAttachmentToPrintChooser();
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add(attachmentPanel);
        // inline complete setup of $JPanel0
        $JPanel0.add(cancelButton);
        $JPanel0.add(validateButton);
        
        // apply 1 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 6 property setters
        message.setBorder( javax.swing.BorderFactory.createEmptyBorder(5, 5, 5, 5) );
        cancelButton.setIcon(SwingUtil.createActionIcon("cancel"));
        validateButton.setIcon(SwingUtil.createActionIcon("validate"));
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        handler.beforeInit(this);
        $objectMap.put("attachmentToPrintChooser", attachmentToPrintChooser);
        createModel();
        createMessage();
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new JScrollPane());
        
        $JScrollPane0.setName("$JScrollPane0");
        createAttachmentPanel();
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new JPanel());
        
        $JPanel0.setName("$JPanel0");
        $JPanel0.setLayout( new GridLayout(1, 0) );
        createCancelButton();
        createValidateButton();
        // inline creation of attachmentToPrintChooser
        setName("attachmentToPrintChooser");
        setLayout(new BorderLayout());
        
        // registers 1 data bindings
        $registerDefaultBindings();
        $completeSetup();
        handler.afterInit(this);
    }

    private void $registerDefaultBindings() {
        // register 1 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_VALIDATE_BUTTON_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("attachmentsToPrint", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null && model.getAttachmentsToPrint() != null) {
                    validateButton.setEnabled( !model.getAttachmentsToPrint().isEmpty() );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("attachmentsToPrint", this);
                }
            }
        });
    }

}