/*
 * Decompiled with CFR 0.152.
 */
package com.franciaflex.faxtomail.ui.swing.actions;

import com.franciaflex.faxtomail.persistence.entities.Email;
import com.franciaflex.faxtomail.persistence.entities.EmailFilter;
import com.franciaflex.faxtomail.ui.swing.actions.AbstractFaxToMailAction;
import com.franciaflex.faxtomail.ui.swing.content.demande.DemandeUIModel;
import com.franciaflex.faxtomail.ui.swing.content.search.SearchUI;
import com.franciaflex.faxtomail.ui.swing.content.search.SearchUIHandler;
import com.franciaflex.faxtomail.ui.swing.content.search.SearchUIModel;
import java.util.ArrayList;
import java.util.List;
import org.nuiton.i18n.I18n;

public class SearchAction
extends AbstractFaxToMailAction<SearchUIModel, SearchUI, SearchUIHandler> {
    public SearchAction(SearchUIHandler handler) {
        super(handler, false);
        this.setActionDescription(I18n.t((String)"faxtomail.action.search.tip", (Object[])new Object[0]));
    }

    @Override
    public void doAction() throws Exception {
        SearchUIModel model = (SearchUIModel)this.getModel();
        this.getContext().setSearch(model);
        EmailFilter emailFilter = (EmailFilter)((Object)model.toEntity());
        List emails = this.getContext().getEmailService().search(emailFilter);
        ArrayList<DemandeUIModel> result = new ArrayList<DemandeUIModel>();
        for (Email email : emails) {
            DemandeUIModel demand = new DemandeUIModel();
            demand.fromEntity(email);
            demand.setValid(((SearchUIHandler)this.handler).isDemandeValid(demand));
            result.add(demand);
            if (!model.isShowGroupesDemandsInResults()) continue;
            demand.setGroupedDemandes(email.getEmailGroup());
            result.addAll(demand.getGroupedDemandes());
        }
        model.setResults(result);
    }
}

