package com.franciaflex.faxtomail.ui.swing.content.search;

/*
 * #%L
 * FaxToMail :: UI
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2014 Franciaflex, Code Lutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import com.franciaflex.faxtomail.persistence.entities.DemandStatus;
import com.franciaflex.faxtomail.persistence.entities.DemandType;
import com.franciaflex.faxtomail.persistence.entities.Email;
import com.franciaflex.faxtomail.persistence.entities.EtatAttente;
import com.franciaflex.faxtomail.persistence.entities.FaxToMailUser;
import com.franciaflex.faxtomail.persistence.entities.HasLabel;
import com.franciaflex.faxtomail.persistence.entities.Priority;
import com.franciaflex.faxtomail.persistence.entities.Range;
import com.franciaflex.faxtomail.ui.swing.FaxToMailUIContext;
import com.franciaflex.faxtomail.ui.swing.util.FaxToMailUI;
import com.franciaflex.faxtomail.ui.swing.util.FaxToMailUIUtil;
import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.Table;
import jaxx.runtime.swing.editor.bean.BeanFilterableComboBox;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXDatePicker;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.JXTitledPanel;
import static org.nuiton.i18n.I18n.t;

public class SearchToGroupUI extends JPanel implements FaxToMailUI<SearchUIModel, SearchToGroupUIHandler>, JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_ARCHIVED_BETWEEN_END_DATE_PICKER_DATE = "archivedBetweenEndDatePicker.date";
    public static final String BINDING_ARCHIVED_BETWEEN_START_DATE_PICKER_DATE = "archivedBetweenStartDatePicker.date";
    public static final String BINDING_ARCHIVED_BY_COMBO_BOX_SELECTED_ITEM = "archivedByComboBox.selectedItem";
    public static final String BINDING_BODY_FIELD_TEXT = "bodyField.text";
    public static final String BINDING_EDI_CODE_NUMBER_FIELD_TEXT = "ediCodeNumberField.text";
    public static final String BINDING_GROUP_BUTTON_ENABLED = "groupButton.enabled";
    public static final String BINDING_LOCAL_REFERENCE_FIELD_TEXT = "localReferenceField.text";
    public static final String BINDING_MESSAGE_FIELD_TEXT = "messageField.text";
    public static final String BINDING_MODIFIED_BETWEEN_END_DATE_PICKER_DATE = "modifiedBetweenEndDatePicker.date";
    public static final String BINDING_MODIFIED_BETWEEN_START_DATE_PICKER_DATE = "modifiedBetweenStartDatePicker.date";
    public static final String BINDING_OBJECT_FIELD_TEXT = "objectField.text";
    public static final String BINDING_PRINTED_BETWEEN_END_DATE_PICKER_DATE = "printedBetweenEndDatePicker.date";
    public static final String BINDING_PRINTED_BETWEEN_START_DATE_PICKER_DATE = "printedBetweenStartDatePicker.date";
    public static final String BINDING_PRINTED_BY_COMBO_BOX_SELECTED_ITEM = "printedByComboBox.selectedItem";
    public static final String BINDING_PROJECT_REFERENCE_FIELD_TEXT = "projectReferenceField.text";
    public static final String BINDING_RECEIVED_BETWEEN_END_DATE_PICKER_DATE = "receivedBetweenEndDatePicker.date";
    public static final String BINDING_RECEIVED_BETWEEN_START_DATE_PICKER_DATE = "receivedBetweenStartDatePicker.date";
    public static final String BINDING_REPLIED_BETWEEN_END_DATE_PICKER_DATE = "repliedBetweenEndDatePicker.date";
    public static final String BINDING_REPLIED_BETWEEN_START_DATE_PICKER_DATE = "repliedBetweenStartDatePicker.date";
    public static final String BINDING_REPLIED_BY_COMBO_BOX_SELECTED_ITEM = "repliedByComboBox.selectedItem";
    public static final String BINDING_SENDER_FIELD_TEXT = "senderField.text";
    public static final String BINDING_TAKEN_BY_COMBO_BOX_SELECTED_ITEM = "takenByComboBox.selectedItem";
    public static final String BINDING_TRANSFER_BETWEEN_END_DATE_PICKER_DATE = "transferBetweenEndDatePicker.date";
    public static final String BINDING_TRANSFER_BETWEEN_START_DATE_PICKER_DATE = "transferBetweenStartDatePicker.date";
    public static final String BINDING_TRANSFER_BY_COMBO_BOX_SELECTED_ITEM = "transferByComboBox.selectedItem";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "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";
    private static final Log log = LogFactory.getLog(SearchToGroupUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JXDatePicker archivedBetweenEndDatePicker;
    protected JLabel archivedBetweenLabel;
    protected JXDatePicker archivedBetweenStartDatePicker;
    protected BeanFilterableComboBox<FaxToMailUser> archivedByComboBox;
    protected JLabel archivedByLabel;
    protected JTextField bodyField;
    protected JLabel bodyLabel;
    protected JButton cancelButton;
    protected JTextField clientField;
    protected JLabel clientLabel;
    protected JXTable dataTable;
    protected JComboBox docTypeComboBox;
    protected JLabel docTypeLabel;
    protected JTextField ediCodeNumberField;
    protected JLabel ediCodeNumberLabel;
    protected JComboBox etatAttenteComboBox;
    protected JLabel etatAttenteLabel;
    protected JComboBox gammeComboBox;
    protected JLabel gammeLabel;
    protected JButton groupButton;
    protected final SearchToGroupUIHandler handler = new SearchToGroupUIHandler();
    protected JTextField localReferenceField;
    protected JLabel localReferenceLabel;
    protected JTextField messageField;
    protected JLabel messageLabel;
    protected SearchUIModel model;
    protected JXDatePicker modifiedBetweenEndDatePicker;
    protected JLabel modifiedBetweenLabel;
    protected JXDatePicker modifiedBetweenStartDatePicker;
    protected BeanFilterableComboBox<FaxToMailUser> modifiedByComboBox;
    protected JLabel modifiedByLabel;
    protected JTextField objectField;
    protected JLabel objectLabel;
    protected JXDatePicker printedBetweenEndDatePicker;
    protected JLabel printedBetweenLabel;
    protected JXDatePicker printedBetweenStartDatePicker;
    protected BeanFilterableComboBox<FaxToMailUser> printedByComboBox;
    protected JLabel printedByLabel;
    protected JComboBox priorityComboBox;
    protected JLabel priorityLabel;
    protected JTextField projectReferenceField;
    protected JLabel projectReferenceLabel;
    protected JXDatePicker receivedBetweenEndDatePicker;
    protected JLabel receivedBetweenLabel;
    protected JXDatePicker receivedBetweenStartDatePicker;
    protected JXDatePicker repliedBetweenEndDatePicker;
    protected JLabel repliedBetweenLabel;
    protected JXDatePicker repliedBetweenStartDatePicker;
    protected BeanFilterableComboBox<FaxToMailUser> repliedByComboBox;
    protected JLabel repliedByLabel;
    protected JButton searchButton;
    protected JScrollPane searchScrollPane;
    protected SearchToGroupUI searchToGroupPanel = this;
    protected JTextField senderField;
    protected JLabel senderLabel;
    protected JComboBox statusComboBox;
    protected JLabel statusLabel;
    protected BeanFilterableComboBox<FaxToMailUser> takenByComboBox;
    protected JLabel takenByLabel;
    protected JXDatePicker transferBetweenEndDatePicker;
    protected JLabel transferBetweenLabel;
    protected JXDatePicker transferBetweenStartDatePicker;
    protected BeanFilterableComboBox<FaxToMailUser> transferByComboBox;
    protected JLabel transferByLabel;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JLabel $JLabel0;
    private JLabel $JLabel1;
    private JLabel $JLabel2;
    private JLabel $JLabel3;
    private JLabel $JLabel4;
    private JLabel $JLabel5;
    private JPanel $JPanel0;
    private JPanel $JPanel1;
    private JPanel $JPanel2;
    private JPanel $JPanel3;
    private JScrollPane $JScrollPane0;
    private JSplitPane $JSplitPane0;
    private Table $Table0;

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public SearchToGroupUI(FaxToMailUI parentUI) {
        FaxToMailUIUtil.setParentUI(this, parentUI);
            $initialize();
    }

    public SearchToGroupUI(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public SearchToGroupUI(JAXXContext parentContext, LayoutManager param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public SearchToGroupUI() {
        $initialize();
    }

    public SearchToGroupUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public SearchToGroupUI(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public SearchToGroupUI(JAXXContext parentContext, LayoutManager param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public SearchToGroupUI(boolean param0) {
        super(param0);
        $initialize();
    }

    public SearchToGroupUI(JAXXContext parentContext, boolean param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__archivedBetweenEndDatePicker(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        model.setMaxArchivedDate(archivedBetweenEndDatePicker.getDate());
    }

    public void doActionPerformed__on__archivedBetweenStartDatePicker(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        model.setMinArchivedDate(archivedBetweenStartDatePicker.getDate());
    }

    public void doActionPerformed__on__cancelButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.cancel();
    }

    public void doActionPerformed__on__groupButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.group();
    }

    public void doActionPerformed__on__modifiedBetweenEndDatePicker(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        model.setMaxModificationDate(modifiedBetweenEndDatePicker.getDate());
    }

    public void doActionPerformed__on__modifiedBetweenStartDatePicker(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        model.setMinModificationDate(modifiedBetweenStartDatePicker.getDate());
    }

    public void doActionPerformed__on__printedBetweenEndDatePicker(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        model.setMaxPrintingDate(printedBetweenEndDatePicker.getDate());
    }

    public void doActionPerformed__on__printedBetweenStartDatePicker(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        model.setMinPrintingDate(printedBetweenStartDatePicker.getDate());
    }

    public void doActionPerformed__on__receivedBetweenEndDatePicker(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        model.setMaxReceptionDate(receivedBetweenEndDatePicker.getDate());
    }

    public void doActionPerformed__on__receivedBetweenStartDatePicker(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        model.setMinReceptionDate(receivedBetweenStartDatePicker.getDate());
    }

    public void doActionPerformed__on__repliedBetweenEndDatePicker(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        model.setMaxReplyDate(repliedBetweenEndDatePicker.getDate());
    }

    public void doActionPerformed__on__repliedBetweenStartDatePicker(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        model.setMinReplyDate(repliedBetweenStartDatePicker.getDate());
    }

    public void doActionPerformed__on__transferBetweenEndDatePicker(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        model.setMaxTransferDate(transferBetweenEndDatePicker.getDate());
    }

    public void doActionPerformed__on__transferBetweenStartDatePicker(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        model.setMinTransferDate(transferBetweenStartDatePicker.getDate());
    }

    public void doKeyReleased__on__bodyField(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.setText(event, "body");
    }

    public void doKeyReleased__on__clientField(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.setText(event, "clientCode");
    }

    public void doKeyReleased__on__ediCodeNumberField(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.setText(event, "ediCodeNumber");
    }

    public void doKeyReleased__on__localReferenceField(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.setText(event, "localReference");
    }

    public void doKeyReleased__on__messageField(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.setText(event, "message");
    }

    public void doKeyReleased__on__objectField(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.setText(event, "demandObject");
    }

    public void doKeyReleased__on__projectReferenceField(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.setText(event, "projectReference");
    }

    public void doKeyReleased__on__senderField(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.setText(event, "sender");
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JXDatePicker getArchivedBetweenEndDatePicker() {
        return archivedBetweenEndDatePicker;
    }

    public JLabel getArchivedBetweenLabel() {
        return archivedBetweenLabel;
    }

    public JXDatePicker getArchivedBetweenStartDatePicker() {
        return archivedBetweenStartDatePicker;
    }

    public BeanFilterableComboBox<FaxToMailUser> getArchivedByComboBox() {
        return archivedByComboBox;
    }

    public JLabel getArchivedByLabel() {
        return archivedByLabel;
    }

    public JTextField getBodyField() {
        return bodyField;
    }

    public JLabel getBodyLabel() {
        return bodyLabel;
    }

    public JButton getCancelButton() {
        return cancelButton;
    }

    public JTextField getClientField() {
        return clientField;
    }

    public JLabel getClientLabel() {
        return clientLabel;
    }

    public JXTable getDataTable() {
        return dataTable;
    }

    public JComboBox getDocTypeComboBox() {
        return docTypeComboBox;
    }

    public JLabel getDocTypeLabel() {
        return docTypeLabel;
    }

    public JTextField getEdiCodeNumberField() {
        return ediCodeNumberField;
    }

    public JLabel getEdiCodeNumberLabel() {
        return ediCodeNumberLabel;
    }

    public JComboBox getEtatAttenteComboBox() {
        return etatAttenteComboBox;
    }

    public JLabel getEtatAttenteLabel() {
        return etatAttenteLabel;
    }

    public JComboBox getGammeComboBox() {
        return gammeComboBox;
    }

    public JLabel getGammeLabel() {
        return gammeLabel;
    }

    public JButton getGroupButton() {
        return groupButton;
    }

    public SearchToGroupUIHandler getHandler() {
        return handler;
    }

    public JTextField getLocalReferenceField() {
        return localReferenceField;
    }

    public JLabel getLocalReferenceLabel() {
        return localReferenceLabel;
    }

    public JTextField getMessageField() {
        return messageField;
    }

    public JLabel getMessageLabel() {
        return messageLabel;
    }

    public SearchUIModel getModel() {
        return model;
    }

    public JXDatePicker getModifiedBetweenEndDatePicker() {
        return modifiedBetweenEndDatePicker;
    }

    public JLabel getModifiedBetweenLabel() {
        return modifiedBetweenLabel;
    }

    public JXDatePicker getModifiedBetweenStartDatePicker() {
        return modifiedBetweenStartDatePicker;
    }

    public BeanFilterableComboBox<FaxToMailUser> getModifiedByComboBox() {
        return modifiedByComboBox;
    }

    public JLabel getModifiedByLabel() {
        return modifiedByLabel;
    }

    public JTextField getObjectField() {
        return objectField;
    }

    public JLabel getObjectLabel() {
        return objectLabel;
    }

    public JXDatePicker getPrintedBetweenEndDatePicker() {
        return printedBetweenEndDatePicker;
    }

    public JLabel getPrintedBetweenLabel() {
        return printedBetweenLabel;
    }

    public JXDatePicker getPrintedBetweenStartDatePicker() {
        return printedBetweenStartDatePicker;
    }

    public BeanFilterableComboBox<FaxToMailUser> getPrintedByComboBox() {
        return printedByComboBox;
    }

    public JLabel getPrintedByLabel() {
        return printedByLabel;
    }

    public JComboBox getPriorityComboBox() {
        return priorityComboBox;
    }

    public JLabel getPriorityLabel() {
        return priorityLabel;
    }

    public JTextField getProjectReferenceField() {
        return projectReferenceField;
    }

    public JLabel getProjectReferenceLabel() {
        return projectReferenceLabel;
    }

    public JXDatePicker getReceivedBetweenEndDatePicker() {
        return receivedBetweenEndDatePicker;
    }

    public JLabel getReceivedBetweenLabel() {
        return receivedBetweenLabel;
    }

    public JXDatePicker getReceivedBetweenStartDatePicker() {
        return receivedBetweenStartDatePicker;
    }

    public JXDatePicker getRepliedBetweenEndDatePicker() {
        return repliedBetweenEndDatePicker;
    }

    public JLabel getRepliedBetweenLabel() {
        return repliedBetweenLabel;
    }

    public JXDatePicker getRepliedBetweenStartDatePicker() {
        return repliedBetweenStartDatePicker;
    }

    public BeanFilterableComboBox<FaxToMailUser> getRepliedByComboBox() {
        return repliedByComboBox;
    }

    public JLabel getRepliedByLabel() {
        return repliedByLabel;
    }

    public JButton getSearchButton() {
        return searchButton;
    }

    public JScrollPane getSearchScrollPane() {
        return searchScrollPane;
    }

    public JTextField getSenderField() {
        return senderField;
    }

    public JLabel getSenderLabel() {
        return senderLabel;
    }

    public JComboBox getStatusComboBox() {
        return statusComboBox;
    }

    public JLabel getStatusLabel() {
        return statusLabel;
    }

    public BeanFilterableComboBox<FaxToMailUser> getTakenByComboBox() {
        return takenByComboBox;
    }

    public JLabel getTakenByLabel() {
        return takenByLabel;
    }

    public JXDatePicker getTransferBetweenEndDatePicker() {
        return transferBetweenEndDatePicker;
    }

    public JLabel getTransferBetweenLabel() {
        return transferBetweenLabel;
    }

    public JXDatePicker getTransferBetweenStartDatePicker() {
        return transferBetweenStartDatePicker;
    }

    public BeanFilterableComboBox<FaxToMailUser> getTransferByComboBox() {
        return transferByComboBox;
    }

    public JLabel getTransferByLabel() {
        return transferByLabel;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected JLabel get$JLabel1() {
        return $JLabel1;
    }

    protected JLabel get$JLabel2() {
        return $JLabel2;
    }

    protected JLabel get$JLabel3() {
        return $JLabel3;
    }

    protected JLabel get$JLabel4() {
        return $JLabel4;
    }

    protected JLabel get$JLabel5() {
        return $JLabel5;
    }

    protected JPanel get$JPanel0() {
        return $JPanel0;
    }

    protected JPanel get$JPanel1() {
        return $JPanel1;
    }

    protected JPanel get$JPanel2() {
        return $JPanel2;
    }

    protected JPanel get$JPanel3() {
        return $JPanel3;
    }

    protected JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    protected JSplitPane get$JSplitPane0() {
        return $JSplitPane0;
    }

    protected Table get$Table0() {
        return $Table0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToSearchScrollPane() {
        if (!allComponentsCreated) {
            return;
        }
        searchScrollPane.getViewport().add($Table0);
    }

    protected void addChildrenToSearchToGroupPanel() {
        if (!allComponentsCreated) {
            return;
        }
        add($JSplitPane0, BorderLayout.CENTER);
        add($JPanel3, BorderLayout.SOUTH);
    }

    protected void createArchivedBetweenEndDatePicker() {
        $objectMap.put("archivedBetweenEndDatePicker", archivedBetweenEndDatePicker = new JXDatePicker());
        
        archivedBetweenEndDatePicker.setName("archivedBetweenEndDatePicker");
        archivedBetweenEndDatePicker.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__archivedBetweenEndDatePicker"));
        archivedBetweenEndDatePicker.putClientProperty("selectOnFocus", true);
    }

    protected void createArchivedBetweenLabel() {
        $objectMap.put("archivedBetweenLabel", archivedBetweenLabel = new JLabel());
        
        archivedBetweenLabel.setName("archivedBetweenLabel");
        archivedBetweenLabel.setText(t("faxtomail.search.archivedBetween.label"));
    }

    protected void createArchivedBetweenStartDatePicker() {
        $objectMap.put("archivedBetweenStartDatePicker", archivedBetweenStartDatePicker = new JXDatePicker());
        
        archivedBetweenStartDatePicker.setName("archivedBetweenStartDatePicker");
        archivedBetweenStartDatePicker.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__archivedBetweenStartDatePicker"));
        archivedBetweenStartDatePicker.putClientProperty("selectOnFocus", true);
    }

    protected void createArchivedByComboBox() {
        $objectMap.put("archivedByComboBox", archivedByComboBox = new BeanFilterableComboBox<FaxToMailUser>(this));
        
        archivedByComboBox.setName("archivedByComboBox");
        archivedByComboBox.setShowDecorator(false);
        archivedByComboBox.setProperty("archivedBy");
        archivedByComboBox.setShowReset(true);
    }

    protected void createArchivedByLabel() {
        $objectMap.put("archivedByLabel", archivedByLabel = new JLabel());
        
        archivedByLabel.setName("archivedByLabel");
        archivedByLabel.setText(t("faxtomail.demande.archivedBy.label"));
    }

    protected void createBodyField() {
        $objectMap.put("bodyField", bodyField = new JTextField());
        
        bodyField.setName("bodyField");
        bodyField.setColumns(15);
        bodyField.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__bodyField"));
    }

    protected void createBodyLabel() {
        $objectMap.put("bodyLabel", bodyLabel = new JLabel());
        
        bodyLabel.setName("bodyLabel");
        bodyLabel.setText(t("faxtomail.demande.body.label"));
    }

    protected void createCancelButton() {
        $objectMap.put("cancelButton", cancelButton = new JButton());
        
        cancelButton.setName("cancelButton");
        cancelButton.setText(t("faxtomail.searchToGroup.action.cancel"));
        cancelButton.setToolTipText(t("faxtomail.searchToGroup.action.cancel.tip"));
        cancelButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__cancelButton"));
    }

    protected void createClientField() {
        $objectMap.put("clientField", clientField = new JTextField());
        
        clientField.setName("clientField");
        clientField.setColumns(15);
        clientField.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__clientField"));
    }

    protected void createClientLabel() {
        $objectMap.put("clientLabel", clientLabel = new JLabel());
        
        clientLabel.setName("clientLabel");
        clientLabel.setText(t("faxtomail.demande.client.label"));
    }

    protected void createDataTable() {
        $objectMap.put("dataTable", dataTable = new JXTable());
        
        dataTable.setName("dataTable");
        dataTable.setEditable(true);
        dataTable.setAutoCreateRowSorter(true);
    }

    protected void createDocTypeComboBox() {
        $objectMap.put("docTypeComboBox", docTypeComboBox = new JComboBox());
        
        docTypeComboBox.setName("docTypeComboBox");
    }

    protected void createDocTypeLabel() {
        $objectMap.put("docTypeLabel", docTypeLabel = new JLabel());
        
        docTypeLabel.setName("docTypeLabel");
        docTypeLabel.setText(t("faxtomail.demande.docType.label"));
    }

    protected void createEdiCodeNumberField() {
        $objectMap.put("ediCodeNumberField", ediCodeNumberField = new JTextField());
        
        ediCodeNumberField.setName("ediCodeNumberField");
        ediCodeNumberField.setColumns(15);
        ediCodeNumberField.setEditable(false);
        ediCodeNumberField.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__ediCodeNumberField"));
    }

    protected void createEdiCodeNumberLabel() {
        $objectMap.put("ediCodeNumberLabel", ediCodeNumberLabel = new JLabel());
        
        ediCodeNumberLabel.setName("ediCodeNumberLabel");
        ediCodeNumberLabel.setText(t("faxtomail.demande.ediCodeNumber.label"));
    }

    protected void createEtatAttenteComboBox() {
        $objectMap.put("etatAttenteComboBox", etatAttenteComboBox = new JComboBox());
        
        etatAttenteComboBox.setName("etatAttenteComboBox");
    }

    protected void createEtatAttenteLabel() {
        $objectMap.put("etatAttenteLabel", etatAttenteLabel = new JLabel());
        
        etatAttenteLabel.setName("etatAttenteLabel");
        etatAttenteLabel.setText(t("faxtomail.demande.etatAttente.label"));
    }

    protected void createGammeComboBox() {
        $objectMap.put("gammeComboBox", gammeComboBox = new JComboBox());
        
        gammeComboBox.setName("gammeComboBox");
    }

    protected void createGammeLabel() {
        $objectMap.put("gammeLabel", gammeLabel = new JLabel());
        
        gammeLabel.setName("gammeLabel");
        gammeLabel.setText(t("faxtomail.demande.gamme.label"));
    }

    protected void createGroupButton() {
        $objectMap.put("groupButton", groupButton = new JButton());
        
        groupButton.setName("groupButton");
        groupButton.setText(t("faxtomail.searchToGroup.action.group"));
        groupButton.setToolTipText(t("faxtomail.searchToGroup.action.group.tip"));
        groupButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__groupButton"));
    }

    protected void createLocalReferenceField() {
        $objectMap.put("localReferenceField", localReferenceField = new JTextField());
        
        localReferenceField.setName("localReferenceField");
        localReferenceField.setColumns(15);
        localReferenceField.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__localReferenceField"));
    }

    protected void createLocalReferenceLabel() {
        $objectMap.put("localReferenceLabel", localReferenceLabel = new JLabel());
        
        localReferenceLabel.setName("localReferenceLabel");
        localReferenceLabel.setText(t("faxtomail.demande.localReference.label"));
    }

    protected void createMessageField() {
        $objectMap.put("messageField", messageField = new JTextField());
        
        messageField.setName("messageField");
        messageField.setColumns(15);
        messageField.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__messageField"));
    }

    protected void createMessageLabel() {
        $objectMap.put("messageLabel", messageLabel = new JLabel());
        
        messageLabel.setName("messageLabel");
        messageLabel.setText(t("faxtomail.demande.comment.label"));
    }

    protected void createModel() {
        $objectMap.put("model", model = getContextValue(SearchUIModel.class));
    }

    protected void createModifiedBetweenEndDatePicker() {
        $objectMap.put("modifiedBetweenEndDatePicker", modifiedBetweenEndDatePicker = new JXDatePicker());
        
        modifiedBetweenEndDatePicker.setName("modifiedBetweenEndDatePicker");
        modifiedBetweenEndDatePicker.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__modifiedBetweenEndDatePicker"));
        modifiedBetweenEndDatePicker.putClientProperty("selectOnFocus", true);
    }

    protected void createModifiedBetweenLabel() {
        $objectMap.put("modifiedBetweenLabel", modifiedBetweenLabel = new JLabel());
        
        modifiedBetweenLabel.setName("modifiedBetweenLabel");
        modifiedBetweenLabel.setText(t("faxtomail.search.modifiedBetween.label"));
    }

    protected void createModifiedBetweenStartDatePicker() {
        $objectMap.put("modifiedBetweenStartDatePicker", modifiedBetweenStartDatePicker = new JXDatePicker());
        
        modifiedBetweenStartDatePicker.setName("modifiedBetweenStartDatePicker");
        modifiedBetweenStartDatePicker.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__modifiedBetweenStartDatePicker"));
        modifiedBetweenStartDatePicker.putClientProperty("selectOnFocus", true);
    }

    protected void createModifiedByComboBox() {
        $objectMap.put("modifiedByComboBox", modifiedByComboBox = new BeanFilterableComboBox<FaxToMailUser>(this));
        
        modifiedByComboBox.setName("modifiedByComboBox");
        modifiedByComboBox.setShowDecorator(false);
        modifiedByComboBox.setShowReset(true);
    }

    protected void createModifiedByLabel() {
        $objectMap.put("modifiedByLabel", modifiedByLabel = new JLabel());
        
        modifiedByLabel.setName("modifiedByLabel");
        modifiedByLabel.setText(t("faxtomail.search.modifiedBy.label"));
    }

    protected void createObjectField() {
        $objectMap.put("objectField", objectField = new JTextField());
        
        objectField.setName("objectField");
        objectField.setColumns(15);
        objectField.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__objectField"));
    }

    protected void createObjectLabel() {
        $objectMap.put("objectLabel", objectLabel = new JLabel());
        
        objectLabel.setName("objectLabel");
        objectLabel.setText(t("faxtomail.demande.object.label"));
    }

    protected void createPrintedBetweenEndDatePicker() {
        $objectMap.put("printedBetweenEndDatePicker", printedBetweenEndDatePicker = new JXDatePicker());
        
        printedBetweenEndDatePicker.setName("printedBetweenEndDatePicker");
        printedBetweenEndDatePicker.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__printedBetweenEndDatePicker"));
        printedBetweenEndDatePicker.putClientProperty("selectOnFocus", true);
    }

    protected void createPrintedBetweenLabel() {
        $objectMap.put("printedBetweenLabel", printedBetweenLabel = new JLabel());
        
        printedBetweenLabel.setName("printedBetweenLabel");
        printedBetweenLabel.setText(t("faxtomail.search.printedBetween.label"));
    }

    protected void createPrintedBetweenStartDatePicker() {
        $objectMap.put("printedBetweenStartDatePicker", printedBetweenStartDatePicker = new JXDatePicker());
        
        printedBetweenStartDatePicker.setName("printedBetweenStartDatePicker");
        printedBetweenStartDatePicker.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__printedBetweenStartDatePicker"));
        printedBetweenStartDatePicker.putClientProperty("selectOnFocus", true);
    }

    protected void createPrintedByComboBox() {
        $objectMap.put("printedByComboBox", printedByComboBox = new BeanFilterableComboBox<FaxToMailUser>(this));
        
        printedByComboBox.setName("printedByComboBox");
        printedByComboBox.setShowDecorator(false);
        printedByComboBox.setProperty("printingBy");
        printedByComboBox.setShowReset(true);
    }

    protected void createPrintedByLabel() {
        $objectMap.put("printedByLabel", printedByLabel = new JLabel());
        
        printedByLabel.setName("printedByLabel");
        printedByLabel.setText(t("faxtomail.demande.printedBy.label"));
    }

    protected void createPriorityComboBox() {
        $objectMap.put("priorityComboBox", priorityComboBox = new JComboBox());
        
        priorityComboBox.setName("priorityComboBox");
    }

    protected void createPriorityLabel() {
        $objectMap.put("priorityLabel", priorityLabel = new JLabel());
        
        priorityLabel.setName("priorityLabel");
        priorityLabel.setText(t("faxtomail.demande.priority.label"));
    }

    protected void createProjectReferenceField() {
        $objectMap.put("projectReferenceField", projectReferenceField = new JTextField());
        
        projectReferenceField.setName("projectReferenceField");
        projectReferenceField.setColumns(15);
        projectReferenceField.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__projectReferenceField"));
    }

    protected void createProjectReferenceLabel() {
        $objectMap.put("projectReferenceLabel", projectReferenceLabel = new JLabel());
        
        projectReferenceLabel.setName("projectReferenceLabel");
        projectReferenceLabel.setText(t("faxtomail.demande.projectReference.label"));
    }

    protected void createReceivedBetweenEndDatePicker() {
        $objectMap.put("receivedBetweenEndDatePicker", receivedBetweenEndDatePicker = new JXDatePicker());
        
        receivedBetweenEndDatePicker.setName("receivedBetweenEndDatePicker");
        receivedBetweenEndDatePicker.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__receivedBetweenEndDatePicker"));
        receivedBetweenEndDatePicker.putClientProperty("selectOnFocus", true);
    }

    protected void createReceivedBetweenLabel() {
        $objectMap.put("receivedBetweenLabel", receivedBetweenLabel = new JLabel());
        
        receivedBetweenLabel.setName("receivedBetweenLabel");
        receivedBetweenLabel.setText(t("faxtomail.search.receivedBetween.label"));
    }

    protected void createReceivedBetweenStartDatePicker() {
        $objectMap.put("receivedBetweenStartDatePicker", receivedBetweenStartDatePicker = new JXDatePicker());
        
        receivedBetweenStartDatePicker.setName("receivedBetweenStartDatePicker");
        receivedBetweenStartDatePicker.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__receivedBetweenStartDatePicker"));
        receivedBetweenStartDatePicker.putClientProperty("selectOnFocus", true);
    }

    protected void createRepliedBetweenEndDatePicker() {
        $objectMap.put("repliedBetweenEndDatePicker", repliedBetweenEndDatePicker = new JXDatePicker());
        
        repliedBetweenEndDatePicker.setName("repliedBetweenEndDatePicker");
        repliedBetweenEndDatePicker.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__repliedBetweenEndDatePicker"));
        repliedBetweenEndDatePicker.putClientProperty("selectOnFocus", true);
    }

    protected void createRepliedBetweenLabel() {
        $objectMap.put("repliedBetweenLabel", repliedBetweenLabel = new JLabel());
        
        repliedBetweenLabel.setName("repliedBetweenLabel");
        repliedBetweenLabel.setText(t("faxtomail.search.repliedBetween.label"));
    }

    protected void createRepliedBetweenStartDatePicker() {
        $objectMap.put("repliedBetweenStartDatePicker", repliedBetweenStartDatePicker = new JXDatePicker());
        
        repliedBetweenStartDatePicker.setName("repliedBetweenStartDatePicker");
        repliedBetweenStartDatePicker.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__repliedBetweenStartDatePicker"));
        repliedBetweenStartDatePicker.putClientProperty("selectOnFocus", true);
    }

    protected void createRepliedByComboBox() {
        $objectMap.put("repliedByComboBox", repliedByComboBox = new BeanFilterableComboBox<FaxToMailUser>(this));
        
        repliedByComboBox.setName("repliedByComboBox");
        repliedByComboBox.setShowDecorator(false);
        repliedByComboBox.setProperty("replyBy");
        repliedByComboBox.setShowReset(true);
    }

    protected void createRepliedByLabel() {
        $objectMap.put("repliedByLabel", repliedByLabel = new JLabel());
        
        repliedByLabel.setName("repliedByLabel");
        repliedByLabel.setText(t("faxtomail.demande.repliedBy.label"));
    }

    protected void createSearchButton() {
        $objectMap.put("searchButton", searchButton = new JButton());
        
        searchButton.setName("searchButton");
        searchButton.setText(t("faxtomail.search.button.label"));
        searchButton.putClientProperty("applicationAction",  com.franciaflex.faxtomail.ui.swing.actions.SearchToGroupAction.class );
    }

    protected void createSearchScrollPane() {
        $objectMap.put("searchScrollPane", searchScrollPane = new JScrollPane());
        
        searchScrollPane.setName("searchScrollPane");
    }

    protected void createSenderField() {
        $objectMap.put("senderField", senderField = new JTextField());
        
        senderField.setName("senderField");
        senderField.setColumns(15);
        senderField.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__senderField"));
    }

    protected void createSenderLabel() {
        $objectMap.put("senderLabel", senderLabel = new JLabel());
        
        senderLabel.setName("senderLabel");
        senderLabel.setText(t("faxtomail.demande.sender.label"));
    }

    protected void createStatusComboBox() {
        $objectMap.put("statusComboBox", statusComboBox = new JComboBox());
        
        statusComboBox.setName("statusComboBox");
    }

    protected void createStatusLabel() {
        $objectMap.put("statusLabel", statusLabel = new JLabel());
        
        statusLabel.setName("statusLabel");
        statusLabel.setText(t("faxtomail.demande.status.label"));
    }

    protected void createTakenByComboBox() {
        $objectMap.put("takenByComboBox", takenByComboBox = new BeanFilterableComboBox<FaxToMailUser>(this));
        
        takenByComboBox.setName("takenByComboBox");
        takenByComboBox.setShowDecorator(false);
        takenByComboBox.setProperty("takenBy");
        takenByComboBox.setShowReset(true);
    }

    protected void createTakenByLabel() {
        $objectMap.put("takenByLabel", takenByLabel = new JLabel());
        
        takenByLabel.setName("takenByLabel");
        takenByLabel.setText(t("faxtomail.demande.takenBy.label"));
    }

    protected void createTransferBetweenEndDatePicker() {
        $objectMap.put("transferBetweenEndDatePicker", transferBetweenEndDatePicker = new JXDatePicker());
        
        transferBetweenEndDatePicker.setName("transferBetweenEndDatePicker");
        transferBetweenEndDatePicker.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__transferBetweenEndDatePicker"));
        transferBetweenEndDatePicker.putClientProperty("selectOnFocus", true);
    }

    protected void createTransferBetweenLabel() {
        $objectMap.put("transferBetweenLabel", transferBetweenLabel = new JLabel());
        
        transferBetweenLabel.setName("transferBetweenLabel");
        transferBetweenLabel.setText(t("faxtomail.search.transferBetween.label"));
    }

    protected void createTransferBetweenStartDatePicker() {
        $objectMap.put("transferBetweenStartDatePicker", transferBetweenStartDatePicker = new JXDatePicker());
        
        transferBetweenStartDatePicker.setName("transferBetweenStartDatePicker");
        transferBetweenStartDatePicker.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__transferBetweenStartDatePicker"));
        transferBetweenStartDatePicker.putClientProperty("selectOnFocus", true);
    }

    protected void createTransferByComboBox() {
        $objectMap.put("transferByComboBox", transferByComboBox = new BeanFilterableComboBox<FaxToMailUser>(this));
        
        transferByComboBox.setName("transferByComboBox");
        transferByComboBox.setShowDecorator(false);
        transferByComboBox.setProperty("transferBy");
        transferByComboBox.setShowReset(true);
    }

    protected void createTransferByLabel() {
        $objectMap.put("transferByLabel", transferByLabel = new JLabel());
        
        transferByLabel.setName("transferByLabel");
        transferByLabel.setText(t("faxtomail.demande.transferBy.label"));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToSearchToGroupPanel();
        // inline complete setup of $JSplitPane0
        $JSplitPane0.add($JPanel0, JSplitPane.LEFT);
        $JSplitPane0.add($JPanel2, JSplitPane.RIGHT);
        // inline complete setup of $JPanel0
        $JPanel0.add(searchScrollPane, BorderLayout.CENTER);
        $JPanel0.add($JPanel1, BorderLayout.SOUTH);
        addChildrenToSearchScrollPane();
        // inline complete setup of $Table0
        $Table0.add(receivedBetweenLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(receivedBetweenStartDatePicker, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JLabel0, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(receivedBetweenEndDatePicker, new GridBagConstraints(3, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(takenByLabel, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(takenByComboBox, new GridBagConstraints(5, 0, 3, 1, 2.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(modifiedBetweenLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(modifiedBetweenStartDatePicker, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JLabel1, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(modifiedBetweenEndDatePicker, new GridBagConstraints(3, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(modifiedByLabel, new GridBagConstraints(4, 1, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(modifiedByComboBox, new GridBagConstraints(5, 1, 3, 1, 2.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(transferBetweenLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(transferBetweenStartDatePicker, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JLabel2, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(transferBetweenEndDatePicker, new GridBagConstraints(3, 2, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(transferByLabel, new GridBagConstraints(4, 2, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(transferByComboBox, new GridBagConstraints(5, 2, 3, 1, 2.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(archivedBetweenLabel, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(archivedBetweenStartDatePicker, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JLabel3, new GridBagConstraints(2, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(archivedBetweenEndDatePicker, new GridBagConstraints(3, 3, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(archivedByLabel, new GridBagConstraints(4, 3, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(archivedByComboBox, new GridBagConstraints(5, 3, 3, 1, 2.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(printedBetweenLabel, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(printedBetweenStartDatePicker, new GridBagConstraints(1, 4, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JLabel4, new GridBagConstraints(2, 4, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(printedBetweenEndDatePicker, new GridBagConstraints(3, 4, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(printedByLabel, new GridBagConstraints(4, 4, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(printedByComboBox, new GridBagConstraints(5, 4, 3, 1, 2.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(repliedBetweenLabel, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(repliedBetweenStartDatePicker, new GridBagConstraints(1, 5, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JLabel5, new GridBagConstraints(2, 5, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(repliedBetweenEndDatePicker, new GridBagConstraints(3, 5, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(repliedByLabel, new GridBagConstraints(4, 5, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(repliedByComboBox, new GridBagConstraints(5, 5, 3, 1, 2.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(senderLabel, new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(senderField, new GridBagConstraints(1, 6, 3, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(gammeLabel, new GridBagConstraints(4, 6, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(gammeComboBox, new GridBagConstraints(5, 6, 3, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(objectLabel, new GridBagConstraints(0, 7, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(objectField, new GridBagConstraints(1, 7, 3, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(docTypeLabel, new GridBagConstraints(4, 7, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(docTypeComboBox, new GridBagConstraints(5, 7, 3, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(ediCodeNumberLabel, new GridBagConstraints(0, 8, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(ediCodeNumberField, new GridBagConstraints(1, 8, 3, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(projectReferenceLabel, new GridBagConstraints(4, 8, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(projectReferenceField, new GridBagConstraints(5, 8, 3, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(priorityLabel, new GridBagConstraints(0, 9, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(priorityComboBox, new GridBagConstraints(1, 9, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(statusLabel, new GridBagConstraints(2, 9, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(statusComboBox, new GridBagConstraints(3, 9, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(etatAttenteLabel, new GridBagConstraints(4, 9, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(etatAttenteComboBox, new GridBagConstraints(5, 9, 3, 1, 2.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(messageLabel, new GridBagConstraints(0, 10, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(messageField, new GridBagConstraints(1, 10, 3, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(clientLabel, new GridBagConstraints(4, 10, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(clientField, new GridBagConstraints(5, 10, 3, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(bodyLabel, new GridBagConstraints(0, 11, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(bodyField, new GridBagConstraints(1, 11, 3, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(localReferenceLabel, new GridBagConstraints(4, 11, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(localReferenceField, new GridBagConstraints(5, 11, 3, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $JPanel1
        $JPanel1.add(searchButton);
        // inline complete setup of $JPanel2
        $JPanel2.add($JScrollPane0, BorderLayout.CENTER);
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add(dataTable);
        // inline complete setup of $JPanel3
        $JPanel3.add(cancelButton);
        $JPanel3.add(groupButton);
        
        // apply 25 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 19 property setters
        $JSplitPane0.setOrientation(JSplitPane.VERTICAL_SPLIT);
        takenByComboBox.setBeanType(FaxToMailUser.class);
        modifiedByComboBox.setBeanType(FaxToMailUser.class);
        transferByComboBox.setBeanType(FaxToMailUser.class);
        archivedByComboBox.setBeanType(FaxToMailUser.class);
        printedByComboBox.setBeanType(FaxToMailUser.class);
        repliedByComboBox.setBeanType(FaxToMailUser.class);
        takenByComboBox.setBean(model);
        modifiedByComboBox.setBean(model);
        transferByComboBox.setBean(model);
        archivedByComboBox.setBean(model);
        printedByComboBox.setBean(model);
        repliedByComboBox.setBean(model);
        cancelButton.setIcon(SwingUtil.createActionIcon("cancel"));
        groupButton.setIcon(SwingUtil.createActionIcon("group"));
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        handler.beforeInit(this);
        $objectMap.put("searchToGroupPanel", searchToGroupPanel);
        createModel();
        // inline creation of $JSplitPane0
        $objectMap.put("$JSplitPane0", $JSplitPane0 = new JSplitPane());
        
        $JSplitPane0.setName("$JSplitPane0");
        $JSplitPane0.setOneTouchExpandable(true);
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new JPanel());
        
        $JPanel0.setName("$JPanel0");
        $JPanel0.setLayout(new BorderLayout());
        createSearchScrollPane();
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new Table());
        
        $Table0.setName("$Table0");
        createReceivedBetweenLabel();
        createReceivedBetweenStartDatePicker();
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new JLabel());
        
        $JLabel0.setName("$JLabel0");
        $JLabel0.setText(t("faxtomail.search.between2ndPart.label"));
        createReceivedBetweenEndDatePicker();
        createTakenByLabel();
        createTakenByComboBox();
        createModifiedBetweenLabel();
        createModifiedBetweenStartDatePicker();
        // inline creation of $JLabel1
        $objectMap.put("$JLabel1", $JLabel1 = new JLabel());
        
        $JLabel1.setName("$JLabel1");
        $JLabel1.setText(t("faxtomail.search.between2ndPart.label"));
        createModifiedBetweenEndDatePicker();
        createModifiedByLabel();
        createModifiedByComboBox();
        createTransferBetweenLabel();
        createTransferBetweenStartDatePicker();
        // inline creation of $JLabel2
        $objectMap.put("$JLabel2", $JLabel2 = new JLabel());
        
        $JLabel2.setName("$JLabel2");
        $JLabel2.setText(t("faxtomail.search.between2ndPart.label"));
        createTransferBetweenEndDatePicker();
        createTransferByLabel();
        createTransferByComboBox();
        createArchivedBetweenLabel();
        createArchivedBetweenStartDatePicker();
        // inline creation of $JLabel3
        $objectMap.put("$JLabel3", $JLabel3 = new JLabel());
        
        $JLabel3.setName("$JLabel3");
        $JLabel3.setText(t("faxtomail.search.between2ndPart.label"));
        createArchivedBetweenEndDatePicker();
        createArchivedByLabel();
        createArchivedByComboBox();
        createPrintedBetweenLabel();
        createPrintedBetweenStartDatePicker();
        // inline creation of $JLabel4
        $objectMap.put("$JLabel4", $JLabel4 = new JLabel());
        
        $JLabel4.setName("$JLabel4");
        $JLabel4.setText(t("faxtomail.search.between2ndPart.label"));
        createPrintedBetweenEndDatePicker();
        createPrintedByLabel();
        createPrintedByComboBox();
        createRepliedBetweenLabel();
        createRepliedBetweenStartDatePicker();
        // inline creation of $JLabel5
        $objectMap.put("$JLabel5", $JLabel5 = new JLabel());
        
        $JLabel5.setName("$JLabel5");
        $JLabel5.setText(t("faxtomail.search.between2ndPart.label"));
        createRepliedBetweenEndDatePicker();
        createRepliedByLabel();
        createRepliedByComboBox();
        createSenderLabel();
        createSenderField();
        createGammeLabel();
        createGammeComboBox();
        createObjectLabel();
        createObjectField();
        createDocTypeLabel();
        createDocTypeComboBox();
        createEdiCodeNumberLabel();
        createEdiCodeNumberField();
        createProjectReferenceLabel();
        createProjectReferenceField();
        createPriorityLabel();
        createPriorityComboBox();
        createStatusLabel();
        createStatusComboBox();
        createEtatAttenteLabel();
        createEtatAttenteComboBox();
        createMessageLabel();
        createMessageField();
        createClientLabel();
        createClientField();
        createBodyLabel();
        createBodyField();
        createLocalReferenceLabel();
        createLocalReferenceField();
        // inline creation of $JPanel1
        $objectMap.put("$JPanel1", $JPanel1 = new JPanel());
        
        $JPanel1.setName("$JPanel1");
        createSearchButton();
        // inline creation of $JPanel2
        $objectMap.put("$JPanel2", $JPanel2 = new JPanel());
        
        $JPanel2.setName("$JPanel2");
        $JPanel2.setLayout(new BorderLayout());
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new JScrollPane());
        
        $JScrollPane0.setName("$JScrollPane0");
        createDataTable();
        // inline creation of $JPanel3
        $objectMap.put("$JPanel3", $JPanel3 = new JPanel());
        
        $JPanel3.setName("$JPanel3");
        $JPanel3.setLayout(new GridLayout(1, 0));
        createCancelButton();
        createGroupButton();
        // inline creation of searchToGroupPanel
        setName("searchToGroupPanel");
        setLayout(new BorderLayout());
        
        // registers 25 data bindings
        $registerDefaultBindings();
        $completeSetup();
        handler.afterInit(this);
    }

    private void $registerDefaultBindings() {
        // register 25 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_RECEIVED_BETWEEN_START_DATE_PICKER_DATE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("minReceptionDate", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    receivedBetweenStartDatePicker.setDate( model.getMinReceptionDate() );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("minReceptionDate", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_RECEIVED_BETWEEN_END_DATE_PICKER_DATE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("maxReceptionDate", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    receivedBetweenEndDatePicker.setDate( model.getMaxReceptionDate() );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("maxReceptionDate", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_TAKEN_BY_COMBO_BOX_SELECTED_ITEM, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("takenBy", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    takenByComboBox.setSelectedItem( model.getTakenBy() );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("takenBy", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_MODIFIED_BETWEEN_START_DATE_PICKER_DATE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("minModificationDate", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    modifiedBetweenStartDatePicker.setDate( model.getMinModificationDate() );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("minModificationDate", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_MODIFIED_BETWEEN_END_DATE_PICKER_DATE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("maxModificationDate", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    modifiedBetweenEndDatePicker.setDate( model.getMaxModificationDate() );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("maxModificationDate", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_TRANSFER_BETWEEN_START_DATE_PICKER_DATE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("minTransferDate", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    transferBetweenStartDatePicker.setDate( model.getMinTransferDate() );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("minTransferDate", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_TRANSFER_BETWEEN_END_DATE_PICKER_DATE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("maxTransferDate", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    transferBetweenEndDatePicker.setDate( model.getMaxTransferDate() );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("maxTransferDate", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_TRANSFER_BY_COMBO_BOX_SELECTED_ITEM, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("transferBy", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    transferByComboBox.setSelectedItem( model.getTransferBy() );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("transferBy", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_ARCHIVED_BETWEEN_START_DATE_PICKER_DATE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("minArchivedDate", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    archivedBetweenStartDatePicker.setDate( model.getMinArchivedDate() );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("minArchivedDate", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_ARCHIVED_BETWEEN_END_DATE_PICKER_DATE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("maxArchivedDate", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    archivedBetweenEndDatePicker.setDate( model.getMaxArchivedDate() );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("maxArchivedDate", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_ARCHIVED_BY_COMBO_BOX_SELECTED_ITEM, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("archivedBy", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    archivedByComboBox.setSelectedItem( model.getArchivedBy() );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("archivedBy", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_PRINTED_BETWEEN_START_DATE_PICKER_DATE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("minPrintingDate", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    printedBetweenStartDatePicker.setDate( model.getMinPrintingDate() );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("minPrintingDate", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_PRINTED_BETWEEN_END_DATE_PICKER_DATE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("maxPrintingDate", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    printedBetweenEndDatePicker.setDate( model.getMaxPrintingDate() );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("maxPrintingDate", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_PRINTED_BY_COMBO_BOX_SELECTED_ITEM, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("printingBy", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    printedByComboBox.setSelectedItem( model.getPrintingBy() );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("printingBy", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_REPLIED_BETWEEN_START_DATE_PICKER_DATE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("minReplyDate", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    repliedBetweenStartDatePicker.setDate( model.getMinReplyDate() );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("minReplyDate", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_REPLIED_BETWEEN_END_DATE_PICKER_DATE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("maxReplyDate", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    repliedBetweenEndDatePicker.setDate( model.getMaxReplyDate() );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("maxReplyDate", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_REPLIED_BY_COMBO_BOX_SELECTED_ITEM, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("replyBy", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    repliedByComboBox.setSelectedItem( model.getReplyBy() );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("replyBy", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SENDER_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("sender", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    SwingUtil.setText(senderField, model.getSender());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("sender", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_OBJECT_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("demandObject", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    SwingUtil.setText(objectField, model.getDemandObject());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("demandObject", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_EDI_CODE_NUMBER_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("ediCodeNumber", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    SwingUtil.setText(ediCodeNumberField,  model.getEdiCodeNumber() );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("ediCodeNumber", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_PROJECT_REFERENCE_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("projectReference", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    SwingUtil.setText(projectReferenceField,  model.getProjectReference() );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("projectReference", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_MESSAGE_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("message", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    SwingUtil.setText(messageField,  model.getMessage() );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("message", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_BODY_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("body", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    SwingUtil.setText(bodyField,  model.getBody() );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("body", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_LOCAL_REFERENCE_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("localReference", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    SwingUtil.setText(localReferenceField,  model.getLocalReference() );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("localReference", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_GROUP_BUTTON_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("groupEnabled", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    groupButton.setEnabled( model.isGroupEnabled() );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("groupEnabled", this);
                }
            }
        });
    }

}