package com.franciaflex.faxtomail.ui.swing.content.demande;

/*
 * #%L
 * FaxToMail :: UI
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2014 Franciaflex, Code Lutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import com.franciaflex.faxtomail.ui.swing.FaxToMailUIContext;
import com.franciaflex.faxtomail.ui.swing.content.demande.demandgroup.ButtonEmailGroup;
import com.franciaflex.faxtomail.ui.swing.util.FaxToMailUI;
import com.franciaflex.faxtomail.ui.swing.util.FaxToMailUIUtil;
import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static org.nuiton.i18n.I18n.t;

public class DemandesUI extends JPanel implements FaxToMailUI<DemandesUIModel, DemandesUIHandler>, JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_ARCHIVE_BUTTON_ENABLED = "archiveButton.enabled";
    public static final String BINDING_GROUP_BUTTON_ENABLED = "groupButton.enabled";
    public static final String BINDING_REPLY_BUTTON_ENABLED = "replyButton.enabled";
    public static final String BINDING_SAVE_BUTTON_ENABLED = "saveButton.enabled";
    public static final String BINDING_TRANSMIT_BUTTON_ENABLED = "transmitButton.enabled";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAANVWzW8bRRQfu7ETO036ESipaCSXVtBcxkgcQ6D5LIkSGpEgVVgCZnfHzpTxznRmNt2oLeIOB/4EuHNB4sYJceDMgQviX0CIA1fEm9m111uvHbc9ESm70fv4ze+9t+83+e5PVNEKXb9P4hirKDSsS/Hu2r17d7371DebVPuKSSMUSn5KZVRuodmgb9cG3Wjt2fRmmt7cEF0pQhoOZK/sobo2p5zqY0qNQUv5DF/r5mHfvRLLSPVQ+6SKUL/5+6/y18EX35YRiiWwm4NSGmdlZZVM7aEyCwy6DCedkCYnYQdoKBZ2gO+ctW1wovX7pEsfoM/R9B6qSqIAzKDXJi/ZYbj8WBp0PqBdEgb6gISUG7Tqiy5uKxL6jLQ5jXGbxEZ0CeM4Ylg/BC7YF6EBaJxkUryZvPWHO1I64KpBla4ILN76C+HtW5AMtG6EPBKCrxNl0Eu2H3EKsZuabWCtH38pQbyjRCTXI2PgHHT3OQgl746FwQnOlk1wuPaoC/0T59NuHhHPNtSgV/IsiefRwHryRGdu7rr+vwmzzyU4az627hH/s141C7noxGrjFrNwTU5o5ljKe+cNdEJ3mRkZMSvh+xvtniPKP2ZjTphVVPLT0e5ONpxBt0Kv5vYGNhJnG5mtTKmFKioCs0GLreEl/gBcyfouPrW+FtB5/72y8NuPf/yw3dvZOpz9cmHogOTALkklJFWG2aMvJAsbGcab+0SutFBNUw565fToWgGxw9QN5OC8SzYd23T8HtHHAFGZ/v2nn698+us5VN5GdS5IsE1s/A6qmWMFXRA8iOW7tx2j8w9n4HkRfs8ZVGtDtCEehzZV2oRreFeFJA+iAcOcJ1RA1QGB2dKgZ4+hT9cK+tQn69V++Wfh8PvbvV6VgPvVkeFZvyofoSoLOQupU7hUvAoVbVZqGgUiE6ki2UI5LZCpQjTd862ipkwZGoNK3siWvbfbdpuw574/zIlnNasOnWYi3LEygKo+SIW1Xv6ESMmZT6xvzUUYtP+oMYGeJHga3xFH4kDREyYifegrSlMc7NvaGk/iyBaw4hpr/1pFuXWfoM5pGtrJw0SXHzWcBOMONRuRUu4usCXfWsZMbwXMfSK3lhtPxnXHise47kzZgELamew8E+2lHm2mj1Jp2kp8OapvDFPtKdk4ujO9oCLKT2nhWbTLfTI3h8k40RzHpOIiimgMCu4EHF5o4q8PM0/1PMe9iGZe+J9pxh9PSvTx49GBYFpLGGwSY4OvrzbCiPOB6grm4i6jsXNxEYVzGbjI/i/lJv+yjCvXRRSWO3Axn1VuCWSSk1MBwWj+7QBun4bHwgCk750h6JJ91s9EtOYv7eOrYoSrgPAfYUcXEiwMAAA=";
    private static final Log log = LogFactory.getLog(DemandesUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JButton archiveButton;
    protected JButton backButton;
    protected ButtonEmailGroup demandGroupButton;
    protected DemandesUI demandsPanel = this;
    protected JTabbedPane demandsTabPane;
    protected JButton groupButton;
    protected final DemandesUIHandler handler = new DemandesUIHandler();
    protected DemandesUIModel model;
    protected JButton printButton;
    protected JButton replyButton;
    protected JButton saveButton;
    protected JToolBar topToolBar;
    protected JButton transmitButton;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JPanel $JPanel0;

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public DemandesUI(FaxToMailUI parentUI) {
        FaxToMailUIUtil.setParentUI(this, parentUI);
            $initialize();
    }

    public DemandesUI(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public DemandesUI(JAXXContext parentContext, LayoutManager param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public DemandesUI() {
        $initialize();
    }

    public DemandesUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public DemandesUI(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public DemandesUI(JAXXContext parentContext, LayoutManager param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public DemandesUI(boolean param0) {
        super(param0);
        $initialize();
    }

    public DemandesUI(JAXXContext parentContext, boolean param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__archiveButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.archive();
    }

    public void doActionPerformed__on__groupButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.group();
    }

    public void doActionPerformed__on__printButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.print();
    }

    public void doActionPerformed__on__replyButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.reply();
    }

    public void doActionPerformed__on__saveButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.save();
    }

    public void doActionPerformed__on__transmitButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.transmitDemande();
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JButton getArchiveButton() {
        return archiveButton;
    }

    public JButton getBackButton() {
        return backButton;
    }

    public ButtonEmailGroup getDemandGroupButton() {
        return demandGroupButton;
    }

    public JTabbedPane getDemandsTabPane() {
        return demandsTabPane;
    }

    public JButton getGroupButton() {
        return groupButton;
    }

    public DemandesUIHandler getHandler() {
        return handler;
    }

    public DemandesUIModel getModel() {
        return model;
    }

    public JButton getPrintButton() {
        return printButton;
    }

    public JButton getReplyButton() {
        return replyButton;
    }

    public JButton getSaveButton() {
        return saveButton;
    }

    public JToolBar getTopToolBar() {
        return topToolBar;
    }

    public JButton getTransmitButton() {
        return transmitButton;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JPanel get$JPanel0() {
        return $JPanel0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToDemandsPanel() {
        if (!allComponentsCreated) {
            return;
        }
        add(topToolBar);
        add(demandsTabPane, BorderLayout.CENTER);
        add($JPanel0, BorderLayout.SOUTH);
    }

    protected void addChildrenToTopToolBar() {
        if (!allComponentsCreated) {
            return;
        }
        topToolBar.add(demandGroupButton);
    }

    protected void createArchiveButton() {
        $objectMap.put("archiveButton", archiveButton = new JButton());
        
        archiveButton.setName("archiveButton");
        archiveButton.setText(t("faxtomail.demande.archive.button.label"));
        archiveButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__archiveButton"));
    }

    protected void createBackButton() {
        $objectMap.put("backButton", backButton = new JButton());
        
        backButton.setName("backButton");
        backButton.setText(t("faxtomail.demande.back.button.label"));
        backButton.putClientProperty("applicationAction",  com.franciaflex.faxtomail.ui.swing.actions.GoToPreviousScreenAction.class );
    }

    protected void createDemandGroupButton() {
        $objectMap.put("demandGroupButton", demandGroupButton = new ButtonEmailGroup());
        
        demandGroupButton.setName("demandGroupButton");
    }

    protected void createDemandsTabPane() {
        $objectMap.put("demandsTabPane", demandsTabPane = new JTabbedPane());
        
        demandsTabPane.setName("demandsTabPane");
    }

    protected void createGroupButton() {
        $objectMap.put("groupButton", groupButton = new JButton());
        
        groupButton.setName("groupButton");
        groupButton.setText(t("faxtomail.demande.group.button.label"));
        groupButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__groupButton"));
    }

    protected void createModel() {
        $objectMap.put("model", model = getContextValue(DemandesUIModel.class));
    }

    protected void createPrintButton() {
        $objectMap.put("printButton", printButton = new JButton());
        
        printButton.setName("printButton");
        printButton.setText(t("faxtomail.demande.print.button.label"));
        printButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__printButton"));
    }

    protected void createReplyButton() {
        $objectMap.put("replyButton", replyButton = new JButton());
        
        replyButton.setName("replyButton");
        replyButton.setText(t("faxtomail.demande.reply.button.label"));
        replyButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__replyButton"));
    }

    protected void createSaveButton() {
        $objectMap.put("saveButton", saveButton = new JButton());
        
        saveButton.setName("saveButton");
        saveButton.setText(t("faxtomail.demande.save.button.label"));
        saveButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__saveButton"));
    }

    protected void createTopToolBar() {
        $objectMap.put("topToolBar", topToolBar = new JToolBar());
        
        topToolBar.setName("topToolBar");
        topToolBar.setFloatable(false);
        topToolBar.setOpaque(false);
        topToolBar.setBorderPainted(false);
    }

    protected void createTransmitButton() {
        $objectMap.put("transmitButton", transmitButton = new JButton());
        
        transmitButton.setName("transmitButton");
        transmitButton.setText(t("faxtomail.demande.transmit.button.label"));
        transmitButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__transmitButton"));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToDemandsPanel();
        addChildrenToTopToolBar();
        // inline complete setup of $JPanel0
        $JPanel0.add(backButton);
        $JPanel0.add(saveButton);
        $JPanel0.add(transmitButton);
        $JPanel0.add(printButton);
        $JPanel0.add(archiveButton);
        $JPanel0.add(replyButton);
        $JPanel0.add(groupButton);
        
        // apply 5 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 8 property setters
        backButton.setIcon(SwingUtil.createActionIcon("cancel"));
        saveButton.setIcon(SwingUtil.createActionIcon("save"));
        transmitButton.setIcon(SwingUtil.createActionIcon("transmit"));
        printButton.setIcon(SwingUtil.createActionIcon("print"));
        replyButton.setIcon(SwingUtil.createActionIcon("reply"));
        groupButton.setIcon(SwingUtil.createActionIcon("group"));
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        handler.beforeInit(this);
        $objectMap.put("demandsPanel", demandsPanel);
        createModel();
        createTopToolBar();
        createDemandGroupButton();
        createDemandsTabPane();
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new JPanel());
        
        $JPanel0.setName("$JPanel0");
        $JPanel0.setLayout(new GridLayout(1,0));
        createBackButton();
        createSaveButton();
        createTransmitButton();
        createPrintButton();
        createArchiveButton();
        createReplyButton();
        createGroupButton();
        // inline creation of demandsPanel
        setName("demandsPanel");
        setLayout( new BorderLayout() );
        
        // registers 5 data bindings
        $registerDefaultBindings();
        $completeSetup();
        handler.afterInit(this);
    }

    private void $registerDefaultBindings() {
        // register 5 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SAVE_BUTTON_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("currentDemand", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null && model.getCurrentDemand() != null) {
                    saveButton.setEnabled( model.getCurrentDemand().isEditable() );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("currentDemand", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_TRANSMIT_BUTTON_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("transmitEnabled", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    transmitButton.setEnabled( model.isTransmitEnabled() );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("transmitEnabled", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_ARCHIVE_BUTTON_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("currentDemand", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null && model.getCurrentDemand() != null) {
                    archiveButton.setEnabled( model.getCurrentDemand().isEditable() );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("currentDemand", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_REPLY_BUTTON_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("currentDemand", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null && model.getCurrentDemand() != null) {
                    replyButton.setEnabled( model.getCurrentDemand().isEditable() || model.getCurrentDemand().getArchiveDate() != null );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("currentDemand", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_GROUP_BUTTON_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("currentDemand", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null && model.getCurrentDemand() != null) {
                    groupButton.setEnabled( model.getCurrentDemand().isEditable() || model.getCurrentDemand().getArchiveDate() != null );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("currentDemand", this);
                }
            }
        });
    }

}