/*
 * Decompiled with CFR 0.152.
 */
package com.franciaflex.faxtomail.ui.swing.content.demande;

import com.franciaflex.faxtomail.persistence.entities.Attachment;
import com.franciaflex.faxtomail.persistence.entities.AttachmentImpl;
import com.franciaflex.faxtomail.persistence.entities.Client;
import com.franciaflex.faxtomail.persistence.entities.DemandStatus;
import com.franciaflex.faxtomail.persistence.entities.DemandType;
import com.franciaflex.faxtomail.persistence.entities.Email;
import com.franciaflex.faxtomail.persistence.entities.EmailGroup;
import com.franciaflex.faxtomail.persistence.entities.EmailImpl;
import com.franciaflex.faxtomail.persistence.entities.EtatAttente;
import com.franciaflex.faxtomail.persistence.entities.FaxToMailUser;
import com.franciaflex.faxtomail.persistence.entities.History;
import com.franciaflex.faxtomail.persistence.entities.HistoryType;
import com.franciaflex.faxtomail.persistence.entities.MailField;
import com.franciaflex.faxtomail.persistence.entities.MailFolder;
import com.franciaflex.faxtomail.persistence.entities.Priority;
import com.franciaflex.faxtomail.persistence.entities.RangeRow;
import com.franciaflex.faxtomail.persistence.entities.Reply;
import com.franciaflex.faxtomail.ui.swing.content.attachment.AttachmentModelAware;
import com.franciaflex.faxtomail.ui.swing.content.demande.RangeRowModel;
import com.franciaflex.faxtomail.ui.swing.util.AbstractFaxToMailBeanUIModel;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.activation.DataSource;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Part;
import javax.mail.internet.ContentType;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.io.Charsets;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.jaxx.application.swing.tab.TabContentModel;
import org.nuiton.util.beans.Binder;
import org.nuiton.util.beans.BinderFactory;

public class DemandeUIModel
extends AbstractFaxToMailBeanUIModel<Email, DemandeUIModel>
implements AttachmentModelAware,
TabContentModel {
    private static final Log log = LogFactory.getLog(DemandeUIModel.class);
    public static final String PROPERTY_QUOTATION_NB = "quotationNb";
    public static final String PROPERTY_PF_NB = "pfNb";
    public static final String PROPERTY_SAV_NB = "savNb";
    public static final String PROPERTY_RANGE_PANEL_VISIBLE = "rangePanelVisible";
    public static final String PROPERTY_CLIENT_CODE = "clientCode";
    public static final String PROPERTY_CLIENT_BRAND = "clientBrand";
    public static final String PROPERTY_REFERENCE = "reference";
    public static final String PROPERTY_EDITABLE = "editable";
    public static final String PROPERTY_LAST_ATTACHMENT_OPENING_IN_THIS_FOLDER_USER = "lastAttachmentOpeningInThisFolderUser";
    public static final String PROPERTY_GROUPED_DEMANDES = "groupedDemandes";
    public static final String PROPERTY_VALID_RANGE_ROW_MODELS = "validRangeRowModels";
    protected final Email editObject = new EmailImpl();
    protected final Collection<Attachment> attachments = new ArrayList<Attachment>();
    protected final Collection<DemandeUIModel> groupedDemandes = new ArrayList<DemandeUIModel>();
    protected final Collection<RangeRowModel> validRangeRowModels = new ArrayList<RangeRowModel>();
    protected History firstOpeningHistory;
    protected History lastModificationHistory;
    protected History lastAttachmentOpeningInThisFolderHistory;
    protected int quotationNb;
    protected int pfNb;
    protected int savNb;
    protected String clientCode;
    protected String clientBrand;
    protected boolean editable = true;
    protected String htmlContent;
    protected String plainContent;
    protected String subject;
    protected List<String> toRecipients;
    protected List<String> ccRecipients;
    protected boolean closeable;
    protected static Binder<DemandeUIModel, Email> toBeanBinder = BinderFactory.newBinder(DemandeUIModel.class, Email.class);
    protected static Binder<Email, DemandeUIModel> fromBeanBinder = BinderFactory.newBinder(Email.class, DemandeUIModel.class);
    protected static Binder<Attachment, Attachment> fromAttachmentBinder = BinderFactory.newBinder(Attachment.class, Attachment.class);

    public DemandeUIModel() {
        super(fromBeanBinder, toBeanBinder);
        this.addPropertyChangeListener("history", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                DemandeUIModel.this.findFirstOpeningHistory();
                DemandeUIModel.this.findLastModificationHistory();
                DemandeUIModel.this.findLastAttachmentOpeningInThisFolderHistory();
            }
        });
        this.addPropertyChangeListener("rangeRow", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                Collection rangeRows = (Collection)evt.getNewValue();
                int quotationNb = 0;
                int pfNb = 0;
                int savNb = 0;
                if (rangeRows != null) {
                    for (RangeRow rangeRow : rangeRows) {
                        Integer savQuantity;
                        Integer productQuantity;
                        Integer quotationQuantity = rangeRow.getQuotationQuantity();
                        if (quotationQuantity != null) {
                            quotationNb += quotationQuantity.intValue();
                        }
                        if ((productQuantity = rangeRow.getProductQuantity()) != null) {
                            pfNb += productQuantity.intValue();
                        }
                        if ((savQuantity = rangeRow.getSavQuantity()) == null) continue;
                        savNb += savQuantity.intValue();
                    }
                }
                DemandeUIModel.this.setQuotationNb(quotationNb);
                DemandeUIModel.this.setPfNb(pfNb);
                DemandeUIModel.this.setSavNb(savNb);
            }
        });
    }

    @Override
    public void fromEntity(Email entity) {
        this.fromEntity(entity, true);
    }

    public void fromEntity(Email entity, boolean full) {
        String[] propertiesToIgnore = new String[]{"attachment"};
        fromBeanBinder.copyExcluding((Object)entity, (Object)this, propertiesToIgnore);
        ArrayList<Attachment> attachmentCopy = new ArrayList<Attachment>();
        if (entity.getAttachment() != null) {
            for (Attachment attachment : entity.getAttachment()) {
                AttachmentImpl clone = new AttachmentImpl();
                fromAttachmentBinder.copy((Object)attachment, (Object)clone, new String[0]);
                attachmentCopy.add((Attachment)clone);
            }
        }
        this.setAttachment(attachmentCopy);
    }

    @Override
    public Email toEntity() {
        Email result = this.newEntity();
        toBeanBinder.copyExcluding((Object)this, (Object)result, new String[]{"attachment"});
        return result;
    }

    @Override
    public Email toEntity(Email entity) {
        toBeanBinder.copyExcluding((Object)this, (Object)entity, new String[]{"attachment"});
        return entity;
    }

    public Boolean getFax() {
        return this.editObject.getFax();
    }

    public void setFax(Boolean fax) {
        this.editObject.setFax(fax.booleanValue());
    }

    public String getTopiaId() {
        return this.editObject.getTopiaId();
    }

    public void setTopiaId(String id) {
        this.editObject.setTopiaId(id);
    }

    public void setSender(String sender) {
        String oldValue = this.getSender();
        this.editObject.setSender(sender);
        this.firePropertyChanged("sender", oldValue, sender);
    }

    public String getSender() {
        String sender = this.editObject.getSender();
        if (sender == null) {
            sender = I18n.t((String)"faxtomail.demande.sender.manualCreation", (Object[])new Object[0]);
        }
        return sender;
    }

    public void setRecipient(String recipient) {
        String oldValue = this.getRecipient();
        this.editObject.setRecipient(recipient);
        this.firePropertyChanged("recipient", oldValue, recipient);
    }

    public String getRecipient() {
        return this.editObject.getRecipient();
    }

    public void setObject(String object) {
        String oldValue = this.getObject();
        this.editObject.setObject(object);
        this.firePropertyChanged("object", oldValue, object);
    }

    public String getObject() {
        return this.editObject.getObject();
    }

    public String getSubject() {
        if (this.subject == null) {
            this.decomposeEmail();
        }
        return this.subject;
    }

    public String getToRecipients() {
        if (this.toRecipients == null) {
            this.decomposeEmail();
        }
        return StringUtils.join(this.toRecipients, (String)", ");
    }

    public String getCcRecipients() {
        if (this.ccRecipients == null) {
            this.decomposeEmail();
        }
        return StringUtils.join(this.ccRecipients, (String)", ");
    }

    public String getPlainContent() {
        if (this.plainContent == null) {
            this.decomposeEmail();
        }
        return this.plainContent;
    }

    public String getHtmlContent() {
        if (this.htmlContent == null) {
            this.decomposeEmail();
        }
        return this.htmlContent;
    }

    public void setOriginalEmail(String originalEmail) {
        this.editObject.setOriginalEmail(originalEmail);
    }

    public String getOriginalEmail() {
        return this.editObject.getOriginalEmail();
    }

    public void setClientCode(String clientCode) {
        String oldValue = this.getClientCode();
        this.clientCode = clientCode;
        this.firePropertyChanged(PROPERTY_CLIENT_CODE, oldValue, clientCode);
    }

    public void setClient(Client client) {
        Client oldValue = this.getClient();
        this.editObject.setClient(client);
        if (client != null) {
            this.clientCode = client.getCode();
            this.clientBrand = client.getBrand();
        }
        this.firePropertyChanged("client", oldValue, client);
    }

    public Client getClient() {
        return this.editObject.getClient();
    }

    public String getClientCode() {
        return this.clientCode;
    }

    public void setClientBrand(String clientBrand) {
        String oldValue = this.getClientBrand();
        this.clientBrand = clientBrand;
        this.firePropertyChanged(PROPERTY_CLIENT_BRAND, oldValue, clientBrand);
    }

    public String getClientBrand() {
        return this.clientBrand;
    }

    public void setEtatAttente(EtatAttente etatAttente) {
        EtatAttente oldValue = this.getEtatAttente();
        this.editObject.setEtatAttente(etatAttente);
        this.firePropertyChanged("etatAttente", oldValue, etatAttente);
    }

    public EtatAttente getEtatAttente() {
        return this.editObject.getEtatAttente();
    }

    public void setTakenBy(FaxToMailUser faxToMailUser) {
        FaxToMailUser oldValue = this.getTakenBy();
        this.editObject.setTakenBy(faxToMailUser);
        this.firePropertyChanged("takenBy", oldValue, faxToMailUser);
    }

    public FaxToMailUser getTakenBy() {
        return this.editObject.getTakenBy();
    }

    public Priority getPriority() {
        return this.editObject.getPriority();
    }

    public void setPriority(Priority priority) {
        Priority oldValue = this.getPriority();
        this.editObject.setPriority(priority);
        this.firePropertyChanged("priority", oldValue, priority);
    }

    public DemandType getDemandType() {
        return this.editObject.getDemandType();
    }

    public void setDemandType(DemandType demandType) {
        DemandType oldValue = this.getDemandType();
        Boolean rangePanelVisibleOldValue = this.isRangePanelVisible();
        this.editObject.setDemandType(demandType);
        this.firePropertyChanged("demandType", oldValue, demandType);
        this.firePropertyChanged(PROPERTY_RANGE_PANEL_VISIBLE, rangePanelVisibleOldValue, this.isRangePanelVisible());
    }

    public boolean isRangePanelVisible() {
        DemandType demandType = this.getDemandType();
        return demandType != null && demandType.containsFields(MailField.RANGE_ROW);
    }

    public DemandStatus getDemandStatus() {
        return this.editObject.getDemandStatus();
    }

    public void setDemandStatus(DemandStatus demandStatus) {
        DemandStatus oldValue = this.getDemandStatus();
        this.editObject.setDemandStatus(demandStatus);
        this.firePropertyChanged("demandStatus", oldValue, demandStatus);
    }

    public void setReceptionDate(Date receptionDate) {
        Date oldValue = this.getReceptionDate();
        this.editObject.setReceptionDate(receptionDate);
        this.firePropertyChanged("receptionDate", oldValue, receptionDate);
    }

    public Date getReceptionDate() {
        return this.editObject.getReceptionDate();
    }

    public void setEdiCodeNumber(String ediCodeNumber) {
        String oldValue = this.getEdiCodeNumber();
        this.editObject.setEdiCodeNumber(ediCodeNumber);
        this.firePropertyChanged("ediCodeNumber", oldValue, ediCodeNumber);
    }

    public String getEdiCodeNumber() {
        return this.editObject.getEdiCodeNumber();
    }

    public void setProjectReference(String projectReference) {
        String oldValue = this.getProjectReference();
        this.editObject.setProjectReference(projectReference);
        this.firePropertyChanged("projectReference", oldValue, projectReference);
    }

    public String getProjectReference() {
        return this.editObject.getProjectReference();
    }

    public void setCompanyReference(String companyReference) {
        String oldValue = this.getCompanyReference();
        String refOldValue = this.getReference();
        this.editObject.setCompanyReference(companyReference);
        this.firePropertyChanged("companyReference", oldValue, companyReference);
        this.firePropertyChanged(PROPERTY_REFERENCE, refOldValue, this.getReference());
    }

    public String getCompanyReference() {
        return this.editObject.getCompanyReference();
    }

    public String getReference() {
        Collection<RangeRow> rangeRow;
        ArrayList<String> reference = new ArrayList<String>();
        if (StringUtils.isNotBlank((CharSequence)this.getCompanyReference())) {
            reference.add(this.getCompanyReference());
        }
        if ((rangeRow = this.getRangeRow()) != null) {
            Collection commandNumbers = Collections2.transform(rangeRow, (Function)new Function<RangeRow, String>(){

                public String apply(RangeRow input) {
                    return input.getCommandNumber();
                }
            });
            Collections2.filter((Collection)commandNumbers, (Predicate)new Predicate<String>(){

                public boolean apply(String input) {
                    return StringUtils.isNotBlank((CharSequence)input);
                }
            });
            reference.addAll(commandNumbers);
        }
        return StringUtils.join(reference, (String)", ");
    }

    public void setHistory(Collection<History> history) {
        this.editObject.setHistory(history);
        this.firePropertyChanged("history", null, history);
    }

    public Collection<History> getHistory() {
        return this.editObject.getHistory();
    }

    public int sizeHistory() {
        return this.editObject.sizeHistory();
    }

    public void findFirstOpeningHistory() {
        History result = null;
        Date date = null;
        Collection<History> histories = this.getHistory();
        if (histories != null) {
            for (History history : histories) {
                if (!HistoryType.OPENING.equals((Object)history.getType()) || date != null && !date.after(history.getModificationDate())) continue;
                date = history.getModificationDate();
                result = history;
            }
        }
        this.firstOpeningHistory = result;
    }

    public void findLastModificationHistory() {
        History result = null;
        Date date = null;
        Collection<History> histories = this.getHistory();
        if (histories != null) {
            for (History history : histories) {
                if (!history.getType().isConsideredAsModification() || date != null && !date.before(history.getModificationDate())) continue;
                date = history.getModificationDate();
                result = history;
            }
        }
        this.lastModificationHistory = result;
    }

    public void findLastAttachmentOpeningInThisFolderHistory() {
        History result = null;
        Collection<History> histories = this.getHistory();
        if (histories != null) {
            History transmissionHistory = null;
            for (History history : histories) {
                Date modificationDate = history.getModificationDate();
                if (HistoryType.ATTACHMENT_OPENING.equals((Object)history.getType())) {
                    if (transmissionHistory != null && !transmissionHistory.getModificationDate().before(modificationDate) || result != null && !result.getModificationDate().before(modificationDate)) continue;
                    result = history;
                    continue;
                }
                if (!HistoryType.TRANSMISSION.equals((Object)history.getType()) || transmissionHistory != null && !transmissionHistory.getModificationDate().before(modificationDate)) continue;
                transmissionHistory = history;
                if (result == null || !result.getModificationDate().before(transmissionHistory.getModificationDate())) continue;
                result = null;
            }
        }
        this.lastAttachmentOpeningInThisFolderHistory = result;
    }

    public History getFirstOpeningHistory() {
        return this.firstOpeningHistory;
    }

    public FaxToMailUser getFirstOpeningUser() {
        History history = this.getFirstOpeningHistory();
        return history != null ? history.getFaxToMailUser() : null;
    }

    public Date getFirstOpeningDate() {
        History history = this.getFirstOpeningHistory();
        return history != null ? history.getModificationDate() : null;
    }

    public History getLastModificationHistory() {
        return this.lastModificationHistory;
    }

    public FaxToMailUser getLastModificationUser() {
        History history = this.getLastModificationHistory();
        return history != null ? history.getFaxToMailUser() : null;
    }

    public Date getLastModificationDate() {
        History history = this.getLastModificationHistory();
        return history != null ? history.getModificationDate() : null;
    }

    public History getLastAttachmentOpeningInThisFolderHistory() {
        return this.lastAttachmentOpeningInThisFolderHistory;
    }

    public FaxToMailUser getLastAttachmentOpeningInThisFolderUser() {
        History history = this.getLastAttachmentOpeningInThisFolderHistory();
        return history != null ? history.getFaxToMailUser() : null;
    }

    public Date getLastAttachmentOpeningInThisFolderDate() {
        History history = this.getLastAttachmentOpeningInThisFolderHistory();
        return history != null ? history.getModificationDate() : null;
    }

    @Override
    public Collection<Attachment> getAttachment() {
        return new ArrayList<Attachment>(this.attachments);
    }

    @Override
    public void addAllAttachment(Collection<Attachment> attachment) {
        ArrayList<Attachment> oldValue = new ArrayList<Attachment>(this.getAttachment());
        this.attachments.addAll(attachment);
        this.firePropertyChange("attachment", oldValue, this.getAttachment());
    }

    @Override
    public void addAttachment(Attachment attachment) {
        ArrayList<Attachment> oldValue = new ArrayList<Attachment>(this.getAttachment());
        this.attachments.add(attachment);
        this.firePropertyChange("attachment", oldValue, this.getAttachment());
    }

    @Override
    public void removeAttachment(Attachment attachment) {
        ArrayList<Attachment> oldValue = new ArrayList<Attachment>(this.getAttachment());
        this.attachments.remove(attachment);
        this.firePropertyChange("attachment", oldValue, this.getAttachment());
    }

    public void setAttachment(Collection<Attachment> attachment) {
        ArrayList<Attachment> oldValue = new ArrayList<Attachment>(this.getAttachment());
        this.attachments.clear();
        if (attachment != null) {
            this.attachments.addAll(attachment);
        }
        this.firePropertyChange("attachment", oldValue, this.getAttachment());
    }

    public Collection<RangeRow> getRangeRow() {
        return this.editObject.getRangeRow();
    }

    public void addRangeRow(RangeRow rangeRow) {
        ArrayList<RangeRow> oldValue = null;
        if (this.getRangeRow() != null) {
            oldValue = new ArrayList<RangeRow>(this.getRangeRow());
        }
        String refOldValue = this.getReference();
        this.editObject.addRangeRow(rangeRow);
        this.firePropertyChange("rangeRow", oldValue, this.getRangeRow());
        this.firePropertyChanged(PROPERTY_REFERENCE, refOldValue, this.getReference());
    }

    public void addAllRangeRow(Collection<RangeRow> rangeRow) {
        ArrayList<RangeRow> oldValue = null;
        if (this.getRangeRow() != null) {
            oldValue = new ArrayList<RangeRow>(this.getRangeRow());
        }
        String refOldValue = this.getReference();
        this.editObject.addAllRangeRow(rangeRow);
        this.firePropertyChange("rangeRow", oldValue, this.getRangeRow());
        this.firePropertyChanged(PROPERTY_REFERENCE, refOldValue, this.getReference());
    }

    public void removeRangeRow(RangeRow rangeRow) {
        ArrayList<RangeRow> oldValue = null;
        if (this.getRangeRow() != null) {
            oldValue = new ArrayList<RangeRow>(this.getRangeRow());
        }
        String refOldValue = this.getReference();
        this.editObject.removeRangeRow(rangeRow);
        this.firePropertyChange("rangeRow", oldValue, this.getRangeRow());
        this.firePropertyChanged(PROPERTY_REFERENCE, refOldValue, this.getReference());
    }

    public void setRangeRow(Collection<RangeRow> rangeRow) {
        ArrayList<RangeRow> oldValue = null;
        if (this.getRangeRow() != null) {
            oldValue = new ArrayList<RangeRow>(this.getRangeRow());
        }
        if (rangeRow == null) {
            rangeRow = new ArrayList<RangeRow>();
        }
        String refOldValue = this.getReference();
        this.editObject.setRangeRow(rangeRow);
        this.firePropertyChange("rangeRow", oldValue, this.getRangeRow());
        this.firePropertyChanged(PROPERTY_REFERENCE, refOldValue, this.getReference());
    }

    public MailFolder getMailFolder() {
        return this.editObject.getMailFolder();
    }

    public void setMailFolder(MailFolder mailFolder) {
        MailFolder oldValue = this.getMailFolder();
        this.editObject.setMailFolder(mailFolder);
        this.firePropertyChanged("mailFolder", oldValue, mailFolder);
    }

    public Date getArchiveDate() {
        return this.editObject.getArchiveDate();
    }

    public void setArchiveDate(Date archiveDate) {
        Date oldValue = this.getArchiveDate();
        this.editObject.setArchiveDate(archiveDate);
        this.firePropertyChanged("archiveDate", oldValue, archiveDate);
    }

    public int getQuotationNb() {
        return this.quotationNb;
    }

    public void setQuotationNb(int quotationNb) {
        Integer oldValue = this.getQuotationNb();
        this.quotationNb = quotationNb;
        this.firePropertyChange(PROPERTY_QUOTATION_NB, oldValue, quotationNb);
    }

    public int getPfNb() {
        return this.pfNb;
    }

    public void setPfNb(int pfNb) {
        Integer oldValue = this.getPfNb();
        this.pfNb = pfNb;
        this.firePropertyChange(PROPERTY_PF_NB, oldValue, pfNb);
    }

    public int getSavNb() {
        return this.savNb;
    }

    public void setSavNb(int savNb) {
        Integer oldValue = this.getSavNb();
        this.savNb = savNb;
        this.firePropertyChange(PROPERTY_SAV_NB, oldValue, savNb);
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setEditable(boolean editable) {
        Boolean oldValue = this.isEditable();
        this.editable = editable;
        this.firePropertyChange(PROPERTY_EDITABLE, oldValue, editable);
    }

    public void setComment(String comment) {
        String oldValue = this.getComment();
        this.editObject.setComment(comment);
        this.firePropertyChange("comment", oldValue, comment);
    }

    public String getComment() {
        return this.editObject.getComment();
    }

    public void setGroupedDemandes(EmailGroup emailGroup) {
        ArrayList<DemandeUIModel> oldValue = new ArrayList<DemandeUIModel>(this.getGroupedDemandes());
        if (emailGroup != null) {
            this.groupedDemandes.clear();
            Collection emails = emailGroup.getEmail();
            if (emails != null) {
                for (Email email : emails) {
                    if (email.getTopiaId().equals(this.getTopiaId())) continue;
                    DemandeUIModel demandeUIModel = new DemandeUIModel();
                    demandeUIModel.fromEntity(email);
                    this.groupedDemandes.add(demandeUIModel);
                }
            }
        }
        this.firePropertyChange(PROPERTY_GROUPED_DEMANDES, oldValue, this.getGroupedDemandes());
    }

    public void addGroupedDemande(DemandeUIModel demand) {
        ArrayList<DemandeUIModel> oldValue = new ArrayList<DemandeUIModel>(this.getGroupedDemandes());
        this.groupedDemandes.add(demand);
        this.firePropertyChange(PROPERTY_GROUPED_DEMANDES, oldValue, this.getGroupedDemandes());
    }

    public Collection<DemandeUIModel> getGroupedDemandes() {
        return this.groupedDemandes;
    }

    public int sizeGroupedDemandes() {
        return this.groupedDemandes.size();
    }

    public void addAllReplies(Collection<Reply> replies) {
        ArrayList<Reply> oldValue = new ArrayList<Reply>(this.getReplies());
        this.editObject.addAllReplies(replies);
        this.firePropertyChange("replies", oldValue, this.getAttachment());
    }

    public void addReplies(Reply reply) {
        ArrayList<Reply> oldValue = null;
        if (this.getReplies() != null) {
            oldValue = new ArrayList<Reply>(this.getReplies());
        }
        this.editObject.addReplies(reply);
        this.firePropertyChange("replies", null, this.getReplies());
    }

    public void removeReply(Reply reply) {
        ArrayList<Reply> oldValue = new ArrayList<Reply>(this.getReplies());
        this.editObject.removeReplies(reply);
        this.firePropertyChange("replies", oldValue, this.getReplies());
    }

    public void setReplies(Collection<Reply> replies) {
        ArrayList<Reply> oldValue = null;
        if (this.getReplies() != null) {
            oldValue = new ArrayList<Reply>(this.getReplies());
        }
        this.editObject.setReplies(replies);
        this.firePropertyChange("replies", null, this.getReplies());
    }

    public Collection<Reply> getReplies() {
        return this.editObject.getReplies();
    }

    public int sizeReplies() {
        return this.editObject.sizeReplies();
    }

    public Collection<RangeRowModel> getValidRangeRowModels() {
        return this.validRangeRowModels;
    }

    public void setValidRangeRowModels(Collection<RangeRowModel> validRangeRowModels) {
        ArrayList<RangeRowModel> oldValue = new ArrayList<RangeRowModel>(validRangeRowModels);
        this.validRangeRowModels.clear();
        this.validRangeRowModels.addAll(validRangeRowModels);
        this.firePropertyChanged(PROPERTY_VALID_RANGE_ROW_MODELS, oldValue, validRangeRowModels);
    }

    public void addValidRangeRow(RangeRowModel row) {
        ArrayList<RangeRowModel> oldValue = new ArrayList<RangeRowModel>(this.validRangeRowModels);
        this.validRangeRowModels.add(row);
        this.firePropertyChanged(PROPERTY_VALID_RANGE_ROW_MODELS, oldValue, this.validRangeRowModels);
    }

    public void removeValidRangeRow(RangeRowModel row) {
        ArrayList<RangeRowModel> oldValue = new ArrayList<RangeRowModel>(this.validRangeRowModels);
        this.validRangeRowModels.remove((Object)row);
        this.firePropertyChanged(PROPERTY_VALID_RANGE_ROW_MODELS, oldValue, this.validRangeRowModels);
    }

    public boolean isValid(String field) {
        boolean result;
        boolean bl = result = this.getDemandType() == null;
        if (!result) {
            if (PROPERTY_CLIENT_CODE.equals(field)) {
                result = !this.getDemandType().containsFields(MailField.CLIENT) || StringUtils.isNotBlank((CharSequence)this.getClientCode());
            } else if (PROPERTY_VALID_RANGE_ROW_MODELS.equals(field)) {
                result = !this.getDemandType().containsFields(MailField.RANGE_ROW) || CollectionUtils.isNotEmpty(this.getValidRangeRowModels());
            } else if ("projectReference".equals(field)) {
                result = !this.getDemandType().containsFields(MailField.PROJECT_REFERENCE) || StringUtils.isNotBlank((CharSequence)this.getProjectReference());
            } else if ("object".equals(field)) {
                result = !this.getDemandType().containsFields(MailField.OBJECT) || StringUtils.isNotBlank((CharSequence)this.getObject());
            } else if ("comment".equals(field)) {
                result = !this.getDemandType().containsFields(MailField.COMMENT) || StringUtils.isNotBlank((CharSequence)this.getComment());
            } else if ("companyReference".equals(field)) {
                result = !this.getDemandType().containsFields(MailField.COMPANY_REFERENCE) || StringUtils.isNotBlank((CharSequence)this.getCompanyReference());
            } else if ("priority".equals(field)) {
                result = !this.getDemandType().containsFields(MailField.PRIORITY) || this.getPriority() != null;
            } else if ("etatAttente".equals(field)) {
                result = !this.getDemandType().containsFields(MailField.ETAT_ATTENTE) || this.getEtatAttente() != null;
            }
        }
        return result;
    }

    @Override
    protected Email newEntity() {
        return new EmailImpl();
    }

    public boolean equals(Object obj) {
        if (obj == null || !obj.getClass().isAssignableFrom(DemandeUIModel.class)) {
            return false;
        }
        DemandeUIModel other = (DemandeUIModel)obj;
        return this.editObject.equals(other.editObject);
    }

    protected void decomposeEmail() {
        block8: {
            try {
                MimeMessage message = new MimeMessage(null, (InputStream)new ByteArrayInputStream(this.getOriginalEmail().getBytes()));
                this.subject = message.getSubject();
                this.toRecipients = new ArrayList<String>();
                this.ccRecipients = new ArrayList<String>();
                Address[] recipients = message.getRecipients(Message.RecipientType.TO);
                if (recipients != null) {
                    for (Address address : recipients) {
                        this.toRecipients.add(address.toString());
                    }
                }
                if ((recipients = message.getRecipients(Message.RecipientType.CC)) != null) {
                    for (Address address : recipients) {
                        this.ccRecipients.add(address.toString());
                    }
                }
                if (message.isMimeType("multipart/*")) {
                    this.decomposeMultipartEmail((Part)message);
                } else {
                    String content;
                    this.plainContent = content = IOUtils.toString((InputStream)message.getInputStream());
                }
            }
            catch (Exception e) {
                if (!log.isErrorEnabled()) break block8;
                log.error((Object)"", (Throwable)e);
            }
        }
    }

    protected void decomposeMultipartEmail(Part part) throws Exception {
        DataSource dataSource = part.getDataHandler().getDataSource();
        MimeMultipart mimeMultipart = new MimeMultipart(dataSource);
        int multiPartCount = mimeMultipart.getCount();
        for (int j = 0; j < multiPartCount; ++j) {
            BodyPart bp = mimeMultipart.getBodyPart(j);
            String disposition = bp.getDisposition();
            if (bp.isMimeType("text/*") && !"attachment".equals(disposition)) {
                Charset charset = this.getCharset((Part)bp);
                String content = IOUtils.toString((InputStream)bp.getInputStream(), (Charset)charset);
                if (bp.isMimeType("text/plain")) {
                    this.plainContent = content;
                    continue;
                }
                this.htmlContent = content;
                continue;
            }
            if (!bp.isMimeType("multipart/*")) continue;
            this.decomposeMultipartEmail((Part)bp);
        }
    }

    protected Charset getCharset(Part part) throws MessagingException {
        ContentType contentType = new ContentType(part.getContentType());
        String charsetName = contentType.getParameter("charset");
        Charset charset = Charsets.toCharset((String)charsetName);
        return charset;
    }

    public boolean isEmpty() {
        return false;
    }

    public String getTitle() {
        String result = this.getObject();
        String ref = this.getReference();
        if (!ref.isEmpty()) {
            result = ref + " - " + result;
        }
        return result;
    }

    public String getIcon() {
        return "email";
    }

    public boolean isCloseable() {
        return this.closeable;
    }

    public void setCloseable(boolean closeable) {
        this.closeable = closeable;
    }
}

