/* The following code was generated by JFlex 1.4.1 on 12/29/16 12:36 AM */

/*
 * 02/05/2012
 *
 * JavaScriptTokenMaker.java - Parses a document into JavaScript tokens.
 *
 * This library is distributed under a modified BSD license.  See the included
 * RSyntaxTextArea.License.txt file for details.
 */
package org.fife.ui.rsyntaxtextarea.modes;

import java.io.IOException;
import java.util.Stack;

import javax.swing.text.Segment;

import org.fife.ui.rsyntaxtextarea.AbstractJFlexCTokenMaker;
import org.fife.ui.rsyntaxtextarea.RSyntaxUtilities;
import org.fife.ui.rsyntaxtextarea.Token;
import org.fife.ui.rsyntaxtextarea.TokenImpl;
import org.fife.ui.rsyntaxtextarea.TokenTypes;


/**
 * Scanner for JavaScript files.  Its states could be simplified, but are
 * kept the way they are to keep a degree of similarity (i.e. copy/paste)
 * between it and HTML/JSP/PHPTokenMaker.  This should cause no difference in
 * performance.<p>
 *
 * This implementation was created using
 * <a href="http://www.jflex.de/">JFlex</a> 1.4.1; however, the generated file
 * was modified for performance.  Memory allocation needs to be almost
 * completely removed to be competitive with the handwritten lexers (subclasses
 * of <code>AbstractTokenMaker</code>, so this class has been modified so that
 * Strings are never allocated (via yytext()), and the scanner never has to
 * worry about refilling its buffer (needlessly copying chars around).
 * We can achieve this because RText always scans exactly 1 line of tokens at a
 * time, and hands the scanner this line as an array of characters (a Segment
 * really).  Since tokens contain pointers to char arrays instead of Strings
 * holding their contents, there is no need for allocating new memory for
 * Strings.<p>
 *
 * The actual algorithm generated for scanning has, of course, not been
 * modified.<p>
 *
 * If you wish to regenerate this file yourself, keep in mind the following:
 * <ul>
 *   <li>The generated <code>JavaScriptTokenMaker.java</code> file will contain two
 *       definitions of both <code>zzRefill</code> and <code>yyreset</code>.
 *       You should hand-delete the second of each definition (the ones
 *       generated by the lexer), as these generated methods modify the input
 *       buffer, which we'll never have to do.</li>
 *   <li>You should also change the declaration/definition of zzBuffer to NOT
 *       be initialized.  This is a needless memory allocation for us since we
 *       will be pointing the array somewhere else anyway.</li>
 *   <li>You should NOT call <code>yylex()</code> on the generated scanner
 *       directly; rather, you should use <code>getTokenList</code> as you would
 *       with any other <code>TokenMaker</code> instance.</li>
 * </ul>
 *
 * @author Robert Futrell
 * @version 0.9
 */

public class JavaScriptTokenMaker extends AbstractJFlexCTokenMaker {

  /** This character denotes the end of file */
  public static final int YYEOF = -1;

  /** lexical states */
  public static final int JS_STRING = 1;
  public static final int E4X = 6;
  public static final int E4X_INTAG = 10;
  public static final int E4X_PI = 8;
  public static final int JS_MLC = 3;
  public static final int JS_CHAR = 2;
  public static final int JS_EOL_COMMENT = 5;
  public static final int E4X_COMMENT = 7;
  public static final int JS_DOCCOMMENT = 4;
  public static final int E4X_DTD = 9;
  public static final int JS_TEMPLATE_LITERAL = 14;
  public static final int E4X_INATTR_SINGLE = 12;
  public static final int E4X_INATTR_DOUBLE = 11;
  public static final int JS_TEMPLATE_LITERAL_EXPR = 15;
  public static final int YYINITIAL = 0;
  public static final int E4X_CDATA = 13;

  /**
   * Translates characters to character classes
   */
  private static final String ZZ_CMAP_PACKED =
    "\11\0\1\75\1\2\1\0\1\1\1\11\22\0\1\75\1\36\1\77"+
    "\1\12\1\15\1\35\1\40\1\107\2\106\1\17\1\30\1\27\1\24"+
    "\1\25\1\16\1\5\7\7\2\4\1\41\1\76\1\31\1\32\1\34"+
    "\1\37\1\45\1\103\1\6\1\101\1\102\1\23\1\22\2\3\1\112"+
    "\2\3\1\21\1\3\1\111\5\3\1\104\3\3\1\20\2\3\1\100"+
    "\1\13\1\105\1\33\1\14\1\113\1\46\1\47\1\53\1\65\1\54"+
    "\1\70\1\57\1\61\1\56\1\3\1\64\1\55\1\44\1\60\1\62"+
    "\1\66\1\73\1\52\1\50\1\51\1\10\1\71\1\63\1\72\1\67"+
    "\1\110\1\74\1\43\1\26\1\42\uff81\0";

  /**
   * Translates characters to character classes
   */
  private static final char [] ZZ_CMAP = zzUnpackCMap(ZZ_CMAP_PACKED);

  /**
   * Translates DFA states to action switch labels.
   */
  private static final int [] ZZ_ACTION = zzUnpackAction();

  private static final String ZZ_ACTION_PACKED_0 =
    "\13\0\2\1\3\0\1\2\1\3\1\4\1\5\2\6"+
    "\1\5\1\2\3\7\1\5\1\10\1\5\6\7\2\2"+
    "\20\5\1\11\1\12\2\5\1\13\1\1\1\14\1\15"+
    "\1\16\1\1\1\17\1\20\1\21\1\1\1\22\5\1"+
    "\1\23\10\1\1\24\3\1\2\5\1\25\1\26\1\27"+
    "\1\30\1\1\1\31\5\1\1\32\2\1\1\33\1\1"+
    "\1\34\1\35\1\36\2\37\1\40\1\41\1\42\1\43"+
    "\1\1\1\44\4\1\1\45\1\46\1\47\1\50\1\1"+
    "\1\51\1\1\1\52\1\2\1\53\1\6\1\54\1\53"+
    "\1\54\1\53\1\55\1\53\1\5\2\0\1\56\1\57"+
    "\2\7\2\0\1\60\1\7\1\61\33\5\2\62\7\5"+
    "\1\62\13\5\1\63\1\64\1\65\1\66\4\0\1\67"+
    "\2\0\1\70\32\0\1\71\1\26\1\72\1\73\1\27"+
    "\5\0\1\74\2\0\1\75\1\76\1\2\1\54\1\0"+
    "\2\55\1\5\1\77\1\100\32\5\1\101\5\5\1\102"+
    "\25\5\64\0\1\103\2\0\1\104\5\0\1\105\1\2"+
    "\1\106\3\5\1\102\3\5\1\107\6\5\1\110\1\5"+
    "\1\111\24\5\1\0\1\1\1\0\1\112\15\0\1\113"+
    "\45\0\1\114\4\0\1\115\1\0\1\116\2\0\1\117"+
    "\1\0\1\120\1\2\5\5\1\62\17\5\1\62\1\5"+
    "\15\0\1\113\20\0\1\113\20\0\1\2\4\5\1\121"+
    "\13\5\33\0\10\5\1\113\4\0\1\113\12\0\3\5"+
    "\6\0\1\5\2\0\1\122\1\0";

  private static int [] zzUnpackAction() {
    int [] result = new int[634];
    int offset = 0;
    offset = zzUnpackAction(ZZ_ACTION_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAction(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /**
   * Translates a state to a row index in the transition table
   */
  private static final int [] ZZ_ROWMAP = zzUnpackRowMap();

  private static final String ZZ_ROWMAP_PACKED_0 =
    "\0\0\0\114\0\230\0\344\0\u0130\0\u017c\0\u01c8\0\u0214"+
    "\0\u0260\0\u02ac\0\u02f8\0\u0344\0\u0390\0\u03dc\0\u0428\0\u0474"+
    "\0\u04c0\0\u050c\0\u0558\0\u05a4\0\u05f0\0\u063c\0\u0688\0\u0558"+
    "\0\u06d4\0\u0720\0\u076c\0\u07b8\0\u0558\0\u0558\0\u0804\0\u0850"+
    "\0\u089c\0\u08e8\0\u0558\0\u0934\0\u0980\0\u09cc\0\u0a18\0\u0a64"+
    "\0\u0ab0\0\u0afc\0\u0b48\0\u0b94\0\u0be0\0\u0c2c\0\u0c78\0\u0cc4"+
    "\0\u0d10\0\u0d5c\0\u0da8\0\u0df4\0\u0e40\0\u0e8c\0\u0558\0\u0558"+
    "\0\u0ed8\0\u0f24\0\u0558\0\u0f70\0\u0558\0\u0fbc\0\u0558\0\u1008"+
    "\0\u0558\0\u0fbc\0\u0558\0\u1054\0\u0558\0\u10a0\0\u10ec\0\u1138"+
    "\0\u1184\0\u11d0\0\u0558\0\u121c\0\u1268\0\u12b4\0\u1300\0\u134c"+
    "\0\u1398\0\u13e4\0\u1430\0\u0558\0\u147c\0\u14c8\0\u1514\0\u1560"+
    "\0\u15ac\0\u0558\0\u15f8\0\u1644\0\u0558\0\u1690\0\u0558\0\u16dc"+
    "\0\u1728\0\u1774\0\u17c0\0\u180c\0\u0558\0\u1858\0\u18a4\0\u0558"+
    "\0\u18f0\0\u0558\0\u0558\0\u0558\0\u193c\0\u1988\0\u19d4\0\u0558"+
    "\0\u0558\0\u0558\0\u1a20\0\u0558\0\u1a6c\0\u1ab8\0\u1b04\0\u1b50"+
    "\0\u0558\0\u0fbc\0\u1b9c\0\u0558\0\u1be8\0\u0558\0\u1c34\0\u0558"+
    "\0\u1c80\0\u1ccc\0\u1ccc\0\u1ccc\0\u1d18\0\u1d64\0\u1db0\0\u1dfc"+
    "\0\u1e48\0\u1e94\0\u1ee0\0\u1f2c\0\u0558\0\u1f78\0\u1ee0\0\u1fc4"+
    "\0\u0720\0\u1fc4\0\u0558\0\u2010\0\u205c\0\u20a8\0\u20f4\0\u2140"+
    "\0\u218c\0\u21d8\0\u2224\0\u2270\0\u22bc\0\u2308\0\u2354\0\u23a0"+
    "\0\u23ec\0\u2438\0\u2484\0\u24d0\0\u251c\0\u2568\0\u25b4\0\u2600"+
    "\0\u264c\0\u2698\0\u26e4\0\u2730\0\u277c\0\u27c8\0\u2814\0\u2860"+
    "\0\u28ac\0\u05a4\0\u28f8\0\u2944\0\u2990\0\u29dc\0\u2a28\0\u2a74"+
    "\0\u2ac0\0\u2b0c\0\u2b58\0\u2ba4\0\u2bf0\0\u2c3c\0\u2c88\0\u2cd4"+
    "\0\u2d20\0\u2d6c\0\u2db8\0\u2e04\0\u2e50\0\u0558\0\u2e9c\0\u2ee8"+
    "\0\u0558\0\u2f34\0\u2f80\0\u2fcc\0\u3018\0\u0558\0\u3064\0\u30b0"+
    "\0\u0558\0\u30fc\0\u3148\0\u3194\0\u31e0\0\u322c\0\u3278\0\u32c4"+
    "\0\u3310\0\u335c\0\u33a8\0\u33f4\0\u3440\0\u348c\0\u34d8\0\u3524"+
    "\0\u3570\0\u35bc\0\u3608\0\u3654\0\u36a0\0\u36ec\0\u3738\0\u3784"+
    "\0\u37d0\0\u381c\0\u3868\0\u38b4\0\u3900\0\u394c\0\u0558\0\u0558"+
    "\0\u3998\0\u39e4\0\u3a30\0\u3a7c\0\u3ac8\0\u0558\0\u3b14\0\u3b60"+
    "\0\u0558\0\u0558\0\u3bac\0\u3bf8\0\u3c44\0\u1ccc\0\u3c90\0\u3cdc"+
    "\0\u3d28\0\u3d74\0\u3dc0\0\u3e0c\0\u3e58\0\u3ea4\0\u3ef0\0\u3f3c"+
    "\0\u3f88\0\u3fd4\0\u4020\0\u406c\0\u40b8\0\u4104\0\u4150\0\u419c"+
    "\0\u41e8\0\u4234\0\u4280\0\u42cc\0\u4318\0\u4364\0\u43b0\0\u43fc"+
    "\0\u4448\0\u4494\0\u44e0\0\u452c\0\u05a4\0\u4578\0\u45c4\0\u4610"+
    "\0\u465c\0\u46a8\0\u46f4\0\u4740\0\u478c\0\u47d8\0\u4824\0\u4870"+
    "\0\u48bc\0\u4908\0\u4954\0\u49a0\0\u49ec\0\u4a38\0\u4a84\0\u4ad0"+
    "\0\u4b1c\0\u4b68\0\u4bb4\0\u4c00\0\u4c4c\0\u4c98\0\u4ce4\0\u4d30"+
    "\0\u4d7c\0\u4dc8\0\u4e14\0\u4e60\0\u4eac\0\u4ef8\0\u4f44\0\u4f90"+
    "\0\u4fdc\0\u5028\0\u5074\0\u50c0\0\u510c\0\u5158\0\u51a4\0\u51f0"+
    "\0\u523c\0\u5288\0\u52d4\0\u5320\0\u536c\0\u53b8\0\u5404\0\u5450"+
    "\0\u549c\0\u54e8\0\u5534\0\u5580\0\u55cc\0\u5618\0\u5664\0\u56b0"+
    "\0\u56fc\0\u5748\0\u5794\0\u57e0\0\u582c\0\u5878\0\u58c4\0\u5910"+
    "\0\u595c\0\u59a8\0\u59f4\0\u5a40\0\u5a8c\0\u5ad8\0\u5b24\0\u5b70"+
    "\0\u5bbc\0\u5c08\0\u5c54\0\u5ca0\0\u5cec\0\u5d38\0\u5d84\0\u0558"+
    "\0\u5dd0\0\u5e1c\0\u5e68\0\u5eb4\0\u5f00\0\u0558\0\u5f4c\0\u0558"+
    "\0\u5f98\0\u5fe4\0\u6030\0\u05a4\0\u607c\0\u60c8\0\u6114\0\u05a4"+
    "\0\u6160\0\u61ac\0\u61f8\0\u6244\0\u6290\0\u62dc\0\u05a4\0\u6328"+
    "\0\u05a4\0\u6374\0\u63c0\0\u640c\0\u6458\0\u64a4\0\u64f0\0\u653c"+
    "\0\u6588\0\u65d4\0\u6620\0\u666c\0\u66b8\0\u6704\0\u6750\0\u679c"+
    "\0\u67e8\0\u6834\0\u6880\0\u68cc\0\u6918\0\u2ee8\0\u0558\0\u6964"+
    "\0\u69b0\0\u69fc\0\u6a48\0\u6a94\0\u6ae0\0\u6b2c\0\u6b78\0\u6bc4"+
    "\0\u6c10\0\u6c5c\0\u6ca8\0\u6cf4\0\u6d40\0\u6d8c\0\u0558\0\u6dd8"+
    "\0\u6e24\0\u6e70\0\u6ebc\0\u6f08\0\u6f54\0\u6fa0\0\u6fec\0\u7038"+
    "\0\u7084\0\u70d0\0\u711c\0\u7168\0\u71b4\0\u7200\0\u724c\0\u7298"+
    "\0\u72e4\0\u7330\0\u737c\0\u73c8\0\u7414\0\u7460\0\u74ac\0\u74f8"+
    "\0\u7544\0\u7590\0\u75dc\0\u7628\0\u7674\0\u76c0\0\u770c\0\u7758"+
    "\0\u77a4\0\u77f0\0\u783c\0\u7888\0\u78d4\0\u7920\0\u796c\0\u79b8"+
    "\0\u7a04\0\u7a50\0\u7a9c\0\u0558\0\u7ae8\0\u7b34\0\u7b80\0\u7bcc"+
    "\0\u0558\0\u7c18\0\u7c64\0\u7cb0\0\u7cfc\0\u7d48\0\u7d94\0\u4150"+
    "\0\u7de0\0\u7e2c\0\u7e78\0\u7ec4\0\u7f10\0\u7f5c\0\u7fa8\0\u7ff4"+
    "\0\u8040\0\u808c\0\u80d8\0\u8124\0\u8170\0\u81bc\0\u8208\0\u8254"+
    "\0\u82a0\0\u69b0\0\u82ec\0\u8338\0\u8384\0\u83d0\0\u841c\0\u8468"+
    "\0\u84b4\0\u8500\0\u854c\0\u8598\0\u85e4\0\u8630\0\u867c\0\u86c8"+
    "\0\u8714\0\u8760\0\u87ac\0\u87f8\0\u8844\0\u8890\0\u88dc\0\u8928"+
    "\0\u8974\0\u89c0\0\u8a0c\0\u8a58\0\u8aa4\0\u8af0\0\u8b3c\0\u8b88"+
    "\0\u8bd4\0\u8c20\0\u8c6c\0\u8cb8\0\u8d04\0\u8d50\0\u8d9c\0\u78d4"+
    "\0\u8de8\0\u8e34\0\u8e80\0\u7a50\0\u8ecc\0\u8f18\0\u7b80\0\u8f64"+
    "\0\u8fb0\0\u8ffc\0\u9048\0\u9094\0\u90e0\0\u05a4\0\u912c\0\u9178"+
    "\0\u91c4\0\u9210\0\u925c\0\u92a8\0\u92f4\0\u9340\0\u938c\0\u93d8"+
    "\0\u9424\0\u9470\0\u94bc\0\u9508\0\u9554\0\u95a0\0\u95ec\0\u9638"+
    "\0\u9684\0\u96d0\0\u971c\0\u9768\0\u97b4\0\u9800\0\u984c\0\u9898"+
    "\0\u98e4\0\u9930\0\u997c\0\u99c8\0\u9a14\0\u9a60\0\u9aac\0\u9af8"+
    "\0\u9b44\0\u9b90\0\u9bdc\0\u9c28\0\u9c74\0\u9cc0\0\u9d0c\0\u9d58"+
    "\0\u9da4\0\u9df0\0\u9e3c\0\u9e88\0\u9ed4\0\u9f20\0\u9f6c\0\u9fb8"+
    "\0\ua004\0\u6e70\0\ua050\0\ua09c\0\ua0e8\0\ua134\0\ua180\0\ua1cc"+
    "\0\ua218\0\ua264\0\ua2b0\0\ua2fc\0\ua348\0\ua394\0\ua3e0\0\ua42c"+
    "\0\ua478\0\ua4c4\0\ua510\0\ua55c\0\ua5a8\0\ua5f4\0\ua640\0\ua68c"+
    "\0\u0558\0\ua6d8";

  private static int [] zzUnpackRowMap() {
    int [] result = new int[634];
    int offset = 0;
    offset = zzUnpackRowMap(ZZ_ROWMAP_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackRowMap(String packed, int offset, int [] result) {
    int i = 0;  /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int high = packed.charAt(i++) << 16;
      result[j++] = high | packed.charAt(i++);
    }
    return j;
  }

  /**
   * The transition table of the DFA
   */
  private static final int [] ZZ_TRANS = zzUnpackTrans();

  private static final String ZZ_TRANS_PACKED_0 =
    "\1\21\1\22\1\23\1\24\1\25\1\26\1\24\1\25"+
    "\1\27\1\30\2\21\2\24\1\31\1\32\4\24\1\33"+
    "\1\34\1\35\1\36\1\37\1\40\1\41\1\32\1\42"+
    "\2\32\1\43\1\44\2\43\1\45\1\24\1\46\1\47"+
    "\1\50\1\51\1\52\1\53\1\54\1\55\1\56\1\57"+
    "\1\60\1\61\2\24\1\62\1\24\1\63\1\64\1\24"+
    "\1\65\1\66\2\24\1\35\1\22\1\36\1\67\1\35"+
    "\4\24\2\35\1\70\1\24\1\71\1\72\1\73\2\74"+
    "\1\75\10\74\1\76\63\74\1\77\14\74\2\100\1\101"+
    "\10\100\1\102\73\100\1\103\4\100\2\104\1\105\14\104"+
    "\1\106\41\104\1\107\1\104\1\110\4\104\1\111\23\104"+
    "\2\112\1\113\14\112\1\114\11\112\1\115\13\112\1\116"+
    "\13\112\1\117\1\112\1\120\4\112\1\121\3\112\1\122"+
    "\17\112\2\123\1\124\56\123\1\125\1\123\1\126\4\123"+
    "\1\127\23\123\1\130\1\131\1\132\26\130\1\133\6\130"+
    "\1\134\34\130\1\22\1\135\15\130\2\136\1\137\21\136"+
    "\1\140\34\136\1\141\1\136\1\142\4\136\1\143\23\136"+
    "\2\144\1\145\34\144\1\146\54\144\2\147\1\150\26\147"+
    "\1\151\2\147\1\152\43\147\1\153\4\147\1\154\6\147"+
    "\1\155\1\156\1\0\13\155\1\157\13\155\1\43\1\155"+
    "\1\160\40\155\1\22\1\155\1\161\7\155\1\162\4\155"+
    "\77\163\1\164\14\163\107\165\1\164\4\165\105\166\1\167"+
    "\6\166\2\170\1\171\10\170\1\172\1\170\1\173\75\170"+
    "\1\174\2\175\1\176\12\175\1\177\10\175\1\200\65\175"+
    "\1\21\2\0\6\21\1\0\4\21\2\0\4\21\20\0"+
    "\30\21\5\0\4\21\3\0\3\21\2\0\1\22\73\0"+
    "\1\22\132\0\1\21\2\0\6\24\1\0\1\21\1\201"+
    "\2\24\2\0\4\24\20\0\1\24\1\21\26\24\5\0"+
    "\4\24\3\0\3\24\1\0\1\202\2\0\1\202\2\25"+
    "\1\202\1\25\1\202\1\0\4\202\2\0\1\202\1\203"+
    "\1\204\1\205\1\0\1\206\16\0\10\202\1\205\1\203"+
    "\7\202\1\204\2\202\1\204\3\202\5\0\1\202\1\204"+
    "\2\202\3\0\3\202\1\0\1\202\2\0\1\202\1\207"+
    "\1\210\1\202\1\210\1\202\1\0\4\202\2\0\1\211"+
    "\1\203\1\204\1\205\1\0\1\206\16\0\10\202\1\205"+
    "\1\203\7\202\1\204\2\202\1\204\1\202\1\211\1\202"+
    "\5\0\1\202\1\204\2\202\3\0\3\202\1\0\1\21"+
    "\2\0\6\24\1\0\1\21\1\201\2\24\2\0\4\24"+
    "\20\0\1\24\1\21\12\24\1\212\13\24\5\0\4\24"+
    "\3\0\3\24\1\0\13\213\1\214\2\213\1\215\1\216"+
    "\12\213\1\217\61\213\32\0\1\43\105\0\1\43\5\0"+
    "\1\43\65\0\2\206\1\0\1\206\134\0\1\43\1\0"+
    "\1\220\112\0\1\221\1\43\62\0\1\222\27\0\1\223"+
    "\1\43\42\0\1\222\50\0\1\43\1\0\1\224\111\0"+
    "\1\43\5\0\1\43\105\0\1\43\10\0\1\43\50\0"+
    "\1\21\2\0\1\225\2\21\1\225\1\21\1\225\1\0"+
    "\4\21\2\0\4\225\20\0\1\225\1\21\26\225\5\0"+
    "\4\225\3\0\3\225\1\0\1\21\2\0\6\24\1\0"+
    "\1\21\1\201\2\24\2\0\4\24\20\0\1\24\1\21"+
    "\1\24\1\226\24\24\5\0\4\24\3\0\3\24\1\0"+
    "\1\21\2\0\6\24\1\0\1\21\1\201\2\24\2\0"+
    "\4\24\20\0\1\24\1\21\4\24\1\227\7\24\1\230"+
    "\4\24\1\231\4\24\5\0\4\24\3\0\3\24\1\0"+
    "\1\21\2\0\5\24\1\232\1\0\1\21\1\201\2\24"+
    "\2\0\4\24\20\0\1\24\1\21\3\24\1\233\7\24"+
    "\1\234\1\24\1\235\3\24\1\236\4\24\5\0\4\24"+
    "\3\0\3\24\1\0\1\21\2\0\6\24\1\0\1\21"+
    "\1\201\2\24\2\0\4\24\20\0\1\24\1\21\4\24"+
    "\1\237\6\24\1\240\5\24\1\241\4\24\5\0\4\24"+
    "\3\0\3\24\1\0\1\21\2\0\6\24\1\0\1\21"+
    "\1\201\2\24\2\0\4\24\20\0\1\24\1\21\6\24"+
    "\1\242\17\24\5\0\4\24\3\0\3\24\1\0\1\21"+
    "\2\0\6\24\1\0\1\21\1\201\2\24\2\0\4\24"+
    "\20\0\1\24\1\21\1\243\6\24\1\244\3\24\1\245"+
    "\1\246\11\24\5\0\4\24\3\0\3\24\1\0\1\21"+
    "\2\0\6\24\1\0\1\21\1\201\2\24\2\0\4\24"+
    "\20\0\1\24\1\21\1\247\1\24\1\250\4\24\1\251"+
    "\2\24\1\252\10\24\1\253\1\254\1\24\5\0\4\24"+
    "\3\0\3\24\1\0\1\21\2\0\6\24\1\0\1\21"+
    "\1\201\2\24\2\0\4\24\20\0\1\24\1\21\6\24"+
    "\1\255\5\24\1\256\11\24\5\0\4\24\3\0\3\24"+
    "\1\0\1\21\2\0\6\24\1\0\1\21\1\201\2\24"+
    "\2\0\4\24\20\0\1\257\1\21\2\24\1\260\7\24"+
    "\1\261\7\24\1\262\3\24\5\0\4\24\3\0\3\24"+
    "\1\0\1\21\2\0\6\24\1\0\1\21\1\201\2\24"+
    "\2\0\4\24\20\0\1\24\1\21\14\24\1\263\11\24"+
    "\5\0\4\24\3\0\3\24\1\0\1\21\2\0\5\24"+
    "\1\264\1\0\1\21\1\201\2\24\2\0\4\24\20\0"+
    "\1\24\1\21\1\265\5\24\1\266\17\24\5\0\4\24"+
    "\3\0\3\24\1\0\1\21\2\0\6\24\1\0\1\21"+
    "\1\201\2\24\2\0\4\24\20\0\1\24\1\21\10\24"+
    "\1\267\2\24\1\270\12\24\5\0\4\24\3\0\3\24"+
    "\1\0\1\21\2\0\6\24\1\0\1\21\1\201\2\24"+
    "\2\0\4\24\20\0\1\24\1\21\6\24\1\271\5\24"+
    "\1\272\11\24\5\0\4\24\3\0\3\24\1\0\1\21"+
    "\2\0\5\24\1\273\1\0\1\21\1\201\2\24\2\0"+
    "\4\24\20\0\1\24\1\21\1\274\3\24\1\275\21\24"+
    "\5\0\4\24\3\0\3\24\1\0\1\21\2\0\5\24"+
    "\1\276\1\0\1\21\1\201\2\24\2\0\4\24\20\0"+
    "\1\24\1\21\1\277\6\24\1\300\1\301\3\24\1\302"+
    "\11\24\5\0\4\24\3\0\3\24\1\0\1\21\2\0"+
    "\6\24\1\0\1\21\1\201\2\24\2\0\4\24\20\0"+
    "\1\24\1\21\1\302\13\24\1\303\11\24\5\0\4\24"+
    "\3\0\3\24\1\0\1\21\2\0\6\24\1\0\1\21"+
    "\1\201\2\24\2\0\4\24\20\0\1\24\1\21\1\304"+
    "\25\24\5\0\4\24\3\0\3\24\1\0\1\21\2\0"+
    "\6\24\1\0\1\21\1\201\2\24\2\0\4\24\20\0"+
    "\1\24\1\21\12\24\1\305\13\24\5\0\4\24\3\0"+
    "\3\24\1\0\2\74\1\0\10\74\1\0\63\74\1\0"+
    "\14\74\2\306\1\0\5\306\1\307\61\306\1\310\21\306"+
    "\2\100\1\0\10\100\1\0\73\100\1\0\4\100\2\104"+
    "\1\0\14\104\1\0\41\104\1\0\1\104\1\0\4\104"+
    "\1\0\23\104\16\0\1\311\146\0\1\312\125\0\1\313"+
    "\101\0\1\314\4\0\1\315\35\0\2\112\1\0\14\112"+
    "\1\0\11\112\1\0\13\112\1\0\13\112\1\0\1\112"+
    "\1\0\4\112\1\0\3\112\1\0\17\112\16\0\1\316"+
    "\100\0\1\317\2\0\1\317\1\0\1\317\5\0\1\320"+
    "\1\0\4\317\10\0\1\321\7\0\1\317\1\0\26\317"+
    "\5\0\4\317\3\0\3\317\45\0\1\322\1\0\1\323"+
    "\1\324\1\325\1\326\1\327\1\330\1\331\1\332\1\333"+
    "\1\334\1\335\3\0\1\336\1\337\1\340\1\0\1\341"+
    "\1\342\73\0\1\343\125\0\1\344\101\0\1\345\4\0"+
    "\1\346\102\0\1\347\46\0\2\123\1\0\56\123\1\0"+
    "\1\123\1\0\4\123\1\0\23\123\51\0\1\350\125\0"+
    "\1\351\101\0\1\352\4\0\1\353\35\0\2\130\1\0"+
    "\26\130\1\0\6\130\1\0\34\130\2\0\16\130\1\131"+
    "\1\0\26\130\1\0\6\130\1\0\34\130\1\22\1\0"+
    "\15\130\3\0\1\354\2\0\1\354\1\0\1\354\3\0"+
    "\1\354\1\0\1\355\1\0\4\354\12\0\1\356\1\357"+
    "\1\0\1\354\2\0\1\354\1\0\26\354\5\0\4\354"+
    "\3\0\3\354\1\0\75\134\1\0\1\360\15\134\2\136"+
    "\1\0\21\136\1\0\34\136\1\0\1\136\1\0\4\136"+
    "\1\0\23\136\24\0\1\361\140\0\1\362\125\0\1\363"+
    "\101\0\1\364\4\0\1\365\35\0\2\144\1\0\34\144"+
    "\1\0\54\144\34\0\1\366\57\0\2\147\1\0\26\147"+
    "\1\0\2\147\1\0\43\147\1\0\4\147\1\0\6\147"+
    "\36\0\1\367\55\0\2\155\1\0\13\155\1\0\13\155"+
    "\1\0\1\155\1\0\40\155\1\0\1\155\1\0\7\155"+
    "\1\0\5\155\1\156\1\0\13\155\1\0\13\155\1\0"+
    "\1\155\1\0\40\155\1\22\1\155\1\0\7\155\1\0"+
    "\4\155\34\0\1\160\57\0\77\163\1\0\14\163\107\165"+
    "\1\0\4\165\105\166\1\0\6\166\105\0\1\370\6\0"+
    "\2\170\1\0\10\170\1\0\1\170\1\0\75\170\75\0"+
    "\1\371\17\0\2\175\1\0\12\175\1\0\10\175\1\0"+
    "\65\175\74\0\1\372\17\0\1\21\2\0\5\21\1\373"+
    "\1\0\4\21\2\0\4\21\20\0\30\21\5\0\4\21"+
    "\3\0\3\21\1\0\1\202\2\0\6\202\1\0\4\202"+
    "\2\0\4\202\20\0\30\202\5\0\4\202\3\0\3\202"+
    "\1\0\1\202\2\0\1\202\2\374\1\202\1\374\1\202"+
    "\1\0\4\202\2\0\4\202\1\375\3\0\1\375\13\0"+
    "\30\202\5\0\4\202\3\0\3\202\1\0\1\202\2\0"+
    "\1\202\2\206\1\202\1\206\1\202\1\0\4\202\2\0"+
    "\2\202\1\204\1\205\20\0\10\202\1\205\10\202\1\204"+
    "\2\202\1\204\3\202\5\0\1\202\1\204\2\202\3\0"+
    "\3\202\1\0\1\202\2\0\1\202\2\207\1\202\1\207"+
    "\1\202\1\0\4\202\2\0\2\202\1\204\1\205\1\0"+
    "\1\206\16\0\10\202\1\205\10\202\1\204\2\202\1\204"+
    "\3\202\5\0\1\202\1\204\2\202\3\0\3\202\1\0"+
    "\1\202\2\0\1\202\1\207\1\210\1\202\1\210\1\202"+
    "\1\0\4\202\2\0\1\202\1\376\1\204\1\205\1\0"+
    "\1\206\16\0\10\202\1\205\1\376\7\202\1\204\2\202"+
    "\1\204\3\202\5\0\1\202\1\204\2\202\3\0\3\202"+
    "\1\0\1\202\2\0\1\202\4\377\1\202\1\0\4\202"+
    "\2\0\2\202\2\377\20\0\2\202\2\377\3\202\2\377"+
    "\10\202\1\377\2\202\1\377\3\202\5\0\3\377\1\202"+
    "\3\0\3\202\1\0\1\21\2\0\6\24\1\0\1\21"+
    "\1\201\2\24\2\0\4\24\20\0\1\24\1\21\6\24"+
    "\1\u0100\17\24\5\0\4\24\3\0\3\24\1\0\13\213"+
    "\1\214\2\213\1\u0101\77\213\1\0\111\213\17\0\1\u0102"+
    "\75\0\1\222\27\0\1\223\43\0\1\222\50\0\1\43"+
    "\1\0\1\32\57\0\1\21\2\0\6\225\1\0\4\21"+
    "\2\0\4\225\20\0\1\225\1\21\26\225\5\0\4\225"+
    "\3\0\3\225\1\0\1\21\2\0\6\24\1\0\1\21"+
    "\1\201\2\24\2\0\4\24\20\0\1\24\1\21\2\24"+
    "\1\u0103\23\24\5\0\4\24\3\0\3\24\1\0\1\21"+
    "\2\0\6\24\1\0\1\21\1\201\2\24\2\0\4\24"+
    "\20\0\1\24\1\21\6\24\1\u0104\17\24\5\0\4\24"+
    "\3\0\3\24\1\0\1\21\2\0\6\24\1\0\1\21"+
    "\1\201\2\24\2\0\4\24\20\0\1\24\1\21\14\24"+
    "\1\u0105\11\24\5\0\4\24\3\0\3\24\1\0\1\21"+
    "\2\0\6\24\1\0\1\21\1\201\2\24\2\0\4\24"+
    "\20\0\1\24\1\21\3\24\1\u0106\22\24\5\0\4\24"+
    "\3\0\3\24\1\0\1\21\2\0\6\24\1\0\1\21"+
    "\1\201\2\24\2\0\4\24\20\0\1\24\1\21\20\24"+
    "\1\u0107\5\24\5\0\4\24\3\0\3\24\1\0\1\21"+
    "\2\0\6\24\1\0\1\21\1\201\2\24\2\0\4\24"+
    "\20\0\1\24\1\21\1\u0108\25\24\5\0\4\24\3\0"+
    "\3\24\1\0\1\21\2\0\6\24\1\0\1\21\1\201"+
    "\2\24\2\0\4\24\20\0\1\24\1\21\14\24\1\u0109"+
    "\11\24\5\0\4\24\3\0\3\24\1\0\1\21\2\0"+
    "\6\24\1\0\1\21\1\201\2\24\2\0\4\24\20\0"+
    "\1\24\1\21\10\24\1\u010a\15\24\5\0\4\24\3\0"+
    "\3\24\1\0\1\21\2\0\6\24\1\0\1\21\1\201"+
    "\2\24\2\0\4\24\20\0\1\24\1\21\12\24\1\u010b"+
    "\13\24\5\0\4\24\3\0\3\24\1\0\1\21\2\0"+
    "\5\24\1\u010c\1\0\1\21\1\201\2\24\2\0\4\24"+
    "\20\0\1\24\1\21\1\u010d\20\24\1\262\4\24\5\0"+
    "\4\24\3\0\3\24\1\0\1\21\2\0\6\24\1\0"+
    "\1\21\1\201\2\24\2\0\4\24\20\0\1\24\1\21"+
    "\4\24\1\u010e\3\24\1\u010f\15\24\5\0\4\24\3\0"+
    "\3\24\1\0\1\21\2\0\6\24\1\0\1\21\1\201"+
    "\2\24\2\0\4\24\20\0\1\24\1\21\20\24\1\u0110"+
    "\5\24\5\0\4\24\3\0\3\24\1\0\1\21\2\0"+
    "\6\24\1\0\1\21\1\201\2\24\2\0\4\24\20\0"+
    "\1\24\1\21\3\24\1\u0111\22\24\5\0\4\24\3\0"+
    "\3\24\1\0\1\21\2\0\6\24\1\0\1\21\1\201"+
    "\2\24\2\0\4\24\20\0\1\24\1\21\2\24\1\u0112"+
    "\1\u0113\22\24\5\0\4\24\3\0\3\24\1\0\1\21"+
    "\2\0\6\24\1\0\1\21\1\201\2\24\2\0\4\24"+
    "\20\0\1\24\1\21\1\u0114\25\24\5\0\4\24\3\0"+
    "\3\24\1\0\1\21\2\0\6\24\1\0\1\21\1\201"+
    "\2\24\2\0\4\24\20\0\1\24\1\21\1\u0115\25\24"+
    "\5\0\4\24\3\0\3\24\1\0\1\21\2\0\6\24"+
    "\1\0\1\21\1\201\2\24\2\0\4\24\20\0\1\24"+
    "\1\21\12\24\1\u0116\13\24\5\0\4\24\3\0\3\24"+
    "\1\0\1\21\2\0\6\24\1\0\1\21\1\201\2\24"+
    "\2\0\4\24\20\0\1\24\1\21\5\24\1\u0117\20\24"+
    "\5\0\4\24\3\0\3\24\1\0\1\21\2\0\6\24"+
    "\1\0\1\21\1\201\2\24\2\0\4\24\20\0\1\24"+
    "\1\21\5\24\1\u0118\20\24\5\0\4\24\3\0\3\24"+
    "\1\0\1\21\2\0\6\24\1\0\1\21\1\201\2\24"+
    "\2\0\4\24\20\0\1\24\1\21\2\24\1\u0112\23\24"+
    "\5\0\4\24\3\0\3\24\1\0\1\21\2\0\5\24"+
    "\1\u0119\1\0\1\21\1\201\2\24\2\0\4\24\20\0"+
    "\1\24\1\21\26\24\5\0\4\24\3\0\3\24\1\0"+
    "\1\21\2\0\6\24\1\0\1\21\1\201\2\24\2\0"+
    "\4\24\20\0\1\24\1\21\1\u011a\25\24\5\0\4\24"+
    "\3\0\3\24\1\0\1\21\2\0\6\24\1\0\1\21"+
    "\1\201\2\24\2\0\4\24\20\0\1\24\1\21\3\24"+
    "\1\u011b\14\24\1\u011c\5\24\5\0\4\24\3\0\3\24"+
    "\1\0\1\21\2\0\6\24\1\0\1\21\1\201\2\24"+
    "\2\0\4\24\20\0\1\24\1\21\3\24\1\u011d\22\24"+
    "\5\0\4\24\3\0\3\24\1\0\1\21\2\0\6\24"+
    "\1\0\1\21\1\201\2\24\2\0\4\24\20\0\1\24"+
    "\1\21\12\24\1\u011e\13\24\5\0\4\24\3\0\3\24"+
    "\1\0\1\21\2\0\6\24\1\0\1\21\1\201\2\24"+
    "\2\0\4\24\20\0\1\24\1\21\20\24\1\u011f\5\24"+
    "\5\0\4\24\3\0\3\24\1\0\1\21\2\0\6\24"+
    "\1\0\1\21\1\201\2\24\2\0\2\24\1\u0120\1\24"+
    "\20\0\1\24\1\21\26\24\5\0\4\24\3\0\1\24"+
    "\1\u0121\1\24\1\0\1\21\2\0\6\24\1\0\1\21"+
    "\1\201\2\24\2\0\4\24\20\0\1\24\1\21\2\24"+
    "\1\u0122\1\u0123\22\24\5\0\4\24\3\0\3\24\1\0"+
    "\1\21\2\0\6\24\1\0\1\21\1\201\2\24\2\0"+
    "\4\24\20\0\1\24\1\21\3\24\1\u0124\22\24\5\0"+
    "\4\24\3\0\3\24\1\0\1\21\2\0\6\24\1\0"+
    "\1\21\1\201\2\24\2\0\4\24\20\0\1\24\1\21"+
    "\7\24\1\u0125\16\24\5\0\4\24\3\0\3\24\1\0"+
    "\1\21\2\0\6\24\1\0\1\21\1\201\2\24\2\0"+
    "\4\24\20\0\1\24\1\21\3\24\1\u0126\22\24\5\0"+
    "\4\24\3\0\3\24\1\0\1\21\2\0\6\24\1\0"+
    "\1\21\1\201\2\24\2\0\4\24\20\0\1\24\1\21"+
    "\15\24\1\262\10\24\5\0\4\24\3\0\3\24\1\0"+
    "\1\21\2\0\6\24\1\0\1\21\1\201\2\24\2\0"+
    "\4\24\20\0\1\24\1\21\3\24\1\u0127\22\24\5\0"+
    "\4\24\3\0\3\24\1\0\1\21\2\0\6\24\1\0"+
    "\1\21\1\201\2\24\2\0\4\24\20\0\1\24\1\21"+
    "\10\24\1\u0128\15\24\5\0\4\24\3\0\3\24\1\0"+
    "\1\21\2\0\6\24\1\0\1\21\1\201\2\24\2\0"+
    "\4\24\20\0\1\24\1\21\1\24\1\u0129\5\24\1\u012a"+
    "\12\24\1\u012b\3\24\5\0\4\24\3\0\3\24\1\0"+
    "\1\21\2\0\5\24\1\u012c\1\0\1\21\1\201\2\24"+
    "\2\0\4\24\20\0\1\24\1\21\26\24\5\0\4\24"+
    "\3\0\3\24\1\0\1\21\2\0\6\24\1\0\1\21"+
    "\1\201\2\24\2\0\4\24\20\0\1\24\1\21\1\24"+
    "\1\u012d\24\24\5\0\4\24\3\0\3\24\1\0\1\21"+
    "\2\0\6\24\1\0\1\21\1\201\2\24\2\0\4\24"+
    "\20\0\1\24\1\21\4\24\1\u012e\1\u012f\20\24\5\0"+
    "\4\24\3\0\3\24\1\0\1\21\2\0\6\24\1\0"+
    "\1\21\1\201\2\24\2\0\4\24\20\0\1\24\1\21"+
    "\10\24\1\u0130\3\24\1\u0131\11\24\5\0\4\24\3\0"+
    "\3\24\1\0\1\21\2\0\6\24\1\0\1\21\1\201"+
    "\2\24\2\0\4\24\20\0\1\24\1\21\12\24\1\u0132"+
    "\13\24\5\0\4\24\3\0\3\24\1\0\1\21\2\0"+
    "\6\24\1\0\1\21\1\201\2\24\2\0\4\24\20\0"+
    "\1\24\1\21\7\24\1\u0133\16\24\5\0\4\24\3\0"+
    "\3\24\1\0\1\21\2\0\6\24\1\0\1\21\1\201"+
    "\2\24\2\0\4\24\20\0\1\24\1\21\14\24\1\u0134"+
    "\11\24\5\0\4\24\3\0\3\24\1\0\1\21\2\0"+
    "\6\24\1\0\1\21\1\201\2\24\2\0\4\24\20\0"+
    "\1\24\1\21\12\24\1\u0135\13\24\5\0\4\24\3\0"+
    "\3\24\1\0\1\21\2\0\6\24\1\0\1\21\1\201"+
    "\2\24\2\0\4\24\20\0\1\24\1\21\4\24\1\262"+
    "\21\24\5\0\4\24\3\0\3\24\1\0\1\21\2\0"+
    "\6\24\1\0\1\21\1\201\2\24\2\0\4\24\20\0"+
    "\1\24\1\21\7\24\1\u0136\1\u0137\15\24\5\0\4\24"+
    "\3\0\3\24\1\0\1\21\2\0\6\24\1\0\1\21"+
    "\1\201\2\24\2\0\4\24\20\0\1\24\1\21\26\24"+
    "\5\0\4\24\3\0\1\24\1\262\1\24\1\0\1\21"+
    "\2\0\6\24\1\0\1\21\1\201\2\24\2\0\4\24"+
    "\20\0\1\24\1\21\22\24\1\u0138\3\24\5\0\4\24"+
    "\3\0\3\24\5\0\4\u0139\12\0\2\u0139\22\0\2\u0139"+
    "\3\0\2\u0139\10\0\1\u0139\2\0\1\u0139\10\0\3\u0139"+
    "\14\0\4\u013a\12\0\2\u013a\22\0\2\u013a\3\0\2\u013a"+
    "\10\0\1\u013a\2\0\1\u013a\10\0\3\u013a\61\0\1\u013b"+
    "\125\0\1\u013c\116\0\1\u013d\102\0\1\u013e\36\0\34\317"+
    "\1\321\57\317\3\0\1\317\2\0\1\317\1\0\1\317"+
    "\7\0\4\317\10\0\1\321\7\0\1\317\1\0\26\317"+
    "\5\0\4\317\3\0\3\317\55\0\1\u013f\1\0\1\u0140"+
    "\3\0\1\u0141\41\0\1\u0142\36\0\1\u0143\3\0\1\u0144"+
    "\1\0\1\u0145\120\0\1\u0146\41\0\1\u0147\40\0\1\u0148"+
    "\2\0\1\u0149\1\0\1\u014a\116\0\1\u014b\1\u014c\4\0"+
    "\1\u014d\100\0\1\u014e\105\0\1\u014f\6\0\1\u0150\4\0"+
    "\1\u0151\111\0\1\u0152\10\0\1\u0153\1\u0154\75\0\1\u0155"+
    "\1\0\1\u0156\114\0\1\u0157\1\u0158\110\0\1\u0159\104\0"+
    "\1\u015a\123\0\1\u015b\111\0\1\u015c\47\0\1\u015d\35\0"+
    "\1\u015e\3\0\1\u015f\117\0\1\u0160\103\0\1\u0161\5\0"+
    "\1\u0162\110\0\1\u0163\125\0\1\u0164\116\0\1\u0165\102\0"+
    "\1\u0166\107\0\1\u0167\3\0\1\u0168\107\0\1\u0169\125\0"+
    "\1\u016a\116\0\1\u016b\102\0\1\u016c\41\0\6\354\3\0"+
    "\1\354\3\0\6\354\13\0\1\354\2\0\1\354\1\0"+
    "\26\354\5\0\4\354\3\0\3\354\4\0\1\u016d\2\0"+
    "\1\u016d\1\0\1\u016d\3\0\1\u016d\3\0\4\u016d\15\0"+
    "\1\u016d\2\0\1\u016d\1\0\26\u016d\5\0\4\u016d\3\0"+
    "\3\u016d\25\0\1\u016e\53\0\1\u016f\47\0\1\u0170\130\0"+
    "\1\u0171\125\0\1\u0172\116\0\1\u0173\102\0\1\u0174\62\0"+
    "\1\u0175\123\0\1\u0176\57\0\1\21\2\0\1\21\4\u0177"+
    "\1\21\1\0\4\21\2\0\2\21\2\u0177\20\0\2\21"+
    "\2\u0177\3\21\2\u0177\10\21\1\u0177\2\21\1\u0177\3\21"+
    "\5\0\3\u0177\1\21\3\0\3\21\1\0\1\202\2\0"+
    "\1\202\2\374\1\202\1\374\1\202\1\0\4\202\2\0"+
    "\2\202\1\204\1\202\20\0\21\202\1\204\2\202\1\204"+
    "\3\202\5\0\1\202\1\204\2\202\3\0\3\202\5\0"+
    "\2\374\1\0\1\374\104\0\1\202\2\0\1\202\4\377"+
    "\1\202\1\0\4\202\2\0\1\202\1\376\2\377\20\0"+
    "\2\202\2\377\3\202\2\377\1\376\7\202\1\377\2\202"+
    "\1\377\3\202\5\0\3\377\1\202\3\0\3\202\1\0"+
    "\1\21\2\0\6\24\1\0\1\21\1\201\2\24\2\0"+
    "\4\24\20\0\1\24\1\21\2\24\1\250\23\24\5\0"+
    "\4\24\3\0\3\24\45\0\1\u0101\11\0\2\u0101\52\0"+
    "\1\u0178\75\0\1\21\2\0\6\24\1\0\1\21\1\201"+
    "\2\24\2\0\4\24\20\0\1\24\1\21\3\24\1\u0179"+
    "\22\24\5\0\4\24\3\0\3\24\1\0\1\21\2\0"+
    "\6\24\1\0\1\21\1\201\2\24\2\0\4\24\20\0"+
    "\1\24\1\21\1\u017a\25\24\5\0\4\24\3\0\3\24"+
    "\1\0\1\21\2\0\6\24\1\0\1\21\1\201\2\24"+
    "\2\0\4\24\20\0\1\24\1\21\7\24\1\u017b\16\24"+
    "\5\0\4\24\3\0\3\24\1\0\1\21\2\0\6\24"+
    "\1\0\1\21\1\201\2\24\2\0\4\24\20\0\1\24"+
    "\1\21\6\24\1\u017c\17\24\5\0\4\24\3\0\3\24"+
    "\1\0\1\21\2\0\6\24\1\0\1\21\1\201\2\24"+
    "\2\0\4\24\20\0\1\24\1\21\6\24\1\302\17\24"+
    "\5\0\4\24\3\0\3\24\1\0\1\21\2\0\6\24"+
    "\1\0\1\21\1\201\2\24\2\0\4\24\20\0\1\24"+
    "\1\21\3\24\1\u017d\22\24\5\0\4\24\3\0\3\24"+
    "\1\0\1\21\2\0\6\24\1\0\1\21\1\201\2\24"+
    "\2\0\4\24\20\0\1\24\1\21\4\24\1\u017e\21\24"+
    "\5\0\4\24\3\0\3\24\1\0\1\21\2\0\6\24"+
    "\1\0\1\21\1\201\2\24\2\0\4\24\20\0\1\24"+
    "\1\21\3\24\1\u0113\22\24\5\0\4\24\3\0\3\24"+
    "\1\0\1\21\2\0\6\24\1\0\1\21\1\201\2\24"+
    "\2\0\4\24\20\0\1\24\1\21\5\24\1\u017f\20\24"+
    "\5\0\4\24\3\0\3\24\1\0\1\21\2\0\6\24"+
    "\1\0\1\21\1\201\2\24\2\0\4\24\20\0\1\24"+
    "\1\21\6\24\1\u0180\17\24\5\0\4\24\3\0\3\24"+
    "\1\0\1\21\2\0\6\24\1\0\1\21\1\201\2\24"+
    "\2\0\4\24\20\0\1\24\1\21\12\24\1\u0181\13\24"+
    "\5\0\4\24\3\0\3\24\1\0\1\21\2\0\6\24"+
    "\1\0\1\21\1\201\2\24\2\0\4\24\20\0\1\24"+
    "\1\21\14\24\1\u0182\11\24\5\0\4\24\3\0\3\24"+
    "\1\0\1\21\2\0\6\24\1\0\1\21\1\201\2\24"+
    "\2\0\4\24\20\0\1\24\1\21\2\24\1\262\23\24"+
    "\5\0\4\24\3\0\3\24\1\0\1\21\2\0\6\24"+
    "\1\0\1\21\1\201\2\24\2\0\4\24\20\0\1\24"+
    "\1\21\6\24\1\u0183\17\24\5\0\4\24\3\0\3\24"+
    "\1\0\1\21\2\0\5\24\1\u0184\1\0\1\21\1\201"+
    "\2\24\2\0\4\24\20\0\1\24\1\21\26\24\5\0"+
    "\4\24\3\0\3\24\1\0\1\21\2\0\6\24\1\0"+
    "\1\21\1\201\2\24\2\0\4\24\20\0\1\24\1\21"+
    "\6\24\1\262\17\24\5\0\4\24\3\0\3\24\1\0"+
    "\1\21\2\0\6\24\1\0\1\21\1\201\2\24\2\0"+
    "\4\24\20\0\1\24\1\21\5\24\1\u0127\20\24\5\0"+
    "\4\24\3\0\3\24\1\0\1\21\2\0\6\24\1\0"+
    "\1\21\1\201\2\24\2\0\4\24\20\0\1\24\1\21"+
    "\2\24\1\u010f\23\24\5\0\4\24\3\0\3\24\1\0"+
    "\1\21\2\0\6\24\1\0\1\21\1\201\2\24\2\0"+
    "\4\24\20\0\1\24\1\21\4\24\1\u017c\21\24\5\0"+
    "\4\24\3\0\3\24\1\0\1\21\2\0\6\24\1\0"+
    "\1\21\1\201\2\24\2\0\4\24\20\0\1\24\1\21"+
    "\2\24\1\u0185\1\u0186\22\24\5\0\4\24\3\0\3\24"+
    "\1\0\1\21\2\0\6\24\1\0\1\21\1\201\2\24"+
    "\2\0\4\24\20\0\1\24\1\21\13\24\1\u0187\12\24"+
    "\5\0\4\24\3\0\3\24\1\0\1\21\2\0\6\24"+
    "\1\0\1\21\1\201\2\24\2\0\4\24\20\0\1\24"+
    "\1\21\1\u0188\25\24\5\0\4\24\3\0\3\24\1\0"+
    "\1\21\2\0\6\24\1\0\1\21\1\201\2\24\2\0"+
    "\4\24\20\0\1\262\1\21\26\24\5\0\4\24\3\0"+
    "\3\24\1\0\1\21\2\0\6\24\1\0\1\21\1\201"+
    "\2\24\2\0\4\24\20\0\1\24\1\21\7\24\1\u0189"+
    "\16\24\5\0\4\24\3\0\3\24\1\0\1\21\2\0"+
    "\6\24\1\0\1\21\1\201\2\24\2\0\4\24\20\0"+
    "\1\24\1\21\6\24\1\u018a\17\24\5\0\4\24\3\0"+
    "\3\24\1\0\1\21\2\0\6\24\1\0\1\21\1\201"+
    "\2\24\2\0\4\24\20\0\1\24\1\21\14\24\1\u018b"+
    "\11\24\5\0\4\24\3\0\3\24\1\0\1\21\2\0"+
    "\6\24\1\0\1\21\1\201\2\24\2\0\4\24\20\0"+
    "\1\24\1\21\11\24\1\u017c\14\24\5\0\4\24\3\0"+
    "\3\24\1\0\1\21\2\0\6\24\1\0\1\21\1\201"+
    "\2\24\2\0\4\24\20\0\1\24\1\21\7\24\1\u018c"+
    "\4\24\1\u018b\11\24\5\0\4\24\3\0\3\24\1\0"+
    "\1\21\2\0\6\24\1\0\1\21\1\201\2\24\2\0"+
    "\4\24\20\0\1\24\1\21\10\24\1\u018d\15\24\5\0"+
    "\4\24\3\0\3\24\1\0\1\21\2\0\6\24\1\0"+
    "\1\21\1\201\2\24\2\0\4\24\20\0\1\24\1\21"+
    "\1\u018e\25\24\5\0\4\24\3\0\3\24\1\0\1\21"+
    "\2\0\6\24\1\0\1\21\1\201\2\24\2\0\4\24"+
    "\20\0\1\24\1\21\3\24\1\u018f\22\24\5\0\4\24"+
    "\3\0\3\24\1\0\1\21\2\0\6\24\1\0\1\21"+
    "\1\201\2\24\2\0\4\24\20\0\1\24\1\21\6\24"+
    "\1\u0190\17\24\5\0\4\24\3\0\3\24\1\0\1\21"+
    "\2\0\6\24\1\0\1\21\1\201\2\24\2\0\4\24"+
    "\20\0\1\24\1\21\14\24\1\262\11\24\5\0\4\24"+
    "\3\0\3\24\1\0\1\21\2\0\6\24\1\0\1\21"+
    "\1\201\2\24\2\0\4\24\20\0\1\24\1\21\7\24"+
    "\1\262\16\24\5\0\4\24\3\0\3\24\1\0\1\21"+
    "\2\0\6\24\1\0\1\21\1\201\2\24\2\0\4\24"+
    "\20\0\1\24\1\21\10\24\1\u0191\15\24\5\0\4\24"+
    "\3\0\3\24\1\0\1\21\2\0\6\24\1\0\1\21"+
    "\1\201\2\24\2\0\4\24\20\0\1\24\1\21\13\24"+
    "\1\262\12\24\5\0\4\24\3\0\3\24\1\0\1\21"+
    "\2\0\6\24\1\0\1\21\1\201\2\24\2\0\4\24"+
    "\20\0\1\24\1\21\7\24\1\u0112\16\24\5\0\4\24"+
    "\3\0\3\24\1\0\1\21\2\0\5\24\1\u0192\1\0"+
    "\1\21\1\201\2\24\2\0\4\24\20\0\1\24\1\21"+
    "\26\24\5\0\4\24\3\0\3\24\1\0\1\21\2\0"+
    "\6\24\1\0\1\21\1\201\2\24\2\0\4\24\20\0"+
    "\1\24\1\21\6\24\1\u0193\17\24\5\0\4\24\3\0"+
    "\3\24\1\0\1\21\2\0\6\24\1\0\1\21\1\201"+
    "\2\24\2\0\4\24\20\0\1\24\1\21\1\u0194\25\24"+
    "\5\0\4\24\3\0\3\24\1\0\1\21\2\0\6\24"+
    "\1\0\1\21\1\201\2\24\2\0\4\24\20\0\1\24"+
    "\1\21\1\24\1\u0195\24\24\5\0\4\24\3\0\3\24"+
    "\1\0\1\21\2\0\6\24\1\0\1\21\1\201\2\24"+
    "\2\0\4\24\20\0\1\24\1\21\7\24\1\u017d\16\24"+
    "\5\0\4\24\3\0\3\24\1\0\1\21\2\0\6\24"+
    "\1\0\1\21\1\201\2\24\2\0\4\24\20\0\1\24"+
    "\1\21\2\24\1\u0196\23\24\5\0\4\24\3\0\3\24"+
    "\1\0\1\21\2\0\6\24\1\0\1\21\1\201\2\24"+
    "\2\0\4\24\20\0\1\24\1\21\16\24\1\u0197\7\24"+
    "\5\0\4\24\3\0\3\24\1\0\1\21\2\0\6\24"+
    "\1\0\1\21\1\201\2\24\2\0\4\24\20\0\1\24"+
    "\1\21\23\24\1\u0198\2\24\5\0\4\24\3\0\3\24"+
    "\1\0\1\21\2\0\6\24\1\0\1\21\1\201\2\24"+
    "\2\0\4\24\20\0\1\24\1\21\3\24\1\u0199\22\24"+
    "\5\0\4\24\3\0\3\24\1\0\1\21\2\0\6\24"+
    "\1\0\1\21\1\201\2\24\2\0\4\24\20\0\1\24"+
    "\1\21\5\24\1\u019a\20\24\5\0\4\24\3\0\3\24"+
    "\1\0\1\21\2\0\6\24\1\0\1\21\1\201\2\24"+
    "\2\0\4\24\20\0\1\24\1\21\2\24\1\u010c\23\24"+
    "\5\0\4\24\3\0\3\24\1\0\1\21\2\0\6\24"+
    "\1\0\1\21\1\201\2\24\2\0\4\24\20\0\1\24"+
    "\1\21\1\u017e\25\24\5\0\4\24\3\0\3\24\1\0"+
    "\1\21\2\0\6\24\1\0\1\21\1\201\2\24\2\0"+
    "\4\24\20\0\1\24\1\21\1\u019b\25\24\5\0\4\24"+
    "\3\0\3\24\1\0\1\21\2\0\6\24\1\0\1\21"+
    "\1\201\2\24\2\0\4\24\20\0\1\24\1\21\1\u019c"+
    "\25\24\5\0\4\24\3\0\3\24\1\0\1\21\2\0"+
    "\6\24\1\0\1\21\1\201\2\24\2\0\4\24\20\0"+
    "\1\24\1\21\17\24\1\262\6\24\5\0\4\24\3\0"+
    "\3\24\1\0\1\21\2\0\6\24\1\0\1\21\1\201"+
    "\2\24\2\0\4\24\20\0\1\24\1\21\10\24\1\u019d"+
    "\15\24\5\0\4\24\3\0\3\24\5\0\4\u019e\12\0"+
    "\2\u019e\22\0\2\u019e\3\0\2\u019e\10\0\1\u019e\2\0"+
    "\1\u019e\10\0\3\u019e\14\0\4\u019f\12\0\2\u019f\22\0"+
    "\2\u019f\3\0\2\u019f\10\0\1\u019f\2\0\1\u019f\10\0"+
    "\3\u019f\76\0\1\u01a0\52\0\1\u01a1\127\0\1\u01a2\126\0"+
    "\1\u013d\103\0\1\u01a3\4\0\1\u01a4\134\0\1\u01a5\106\0"+
    "\1\u01a6\77\0\1\u01a7\5\0\1\u01a8\104\0\1\u01a9\116\0"+
    "\1\u01aa\116\0\1\u01ab\107\0\1\u01ac\105\0\1\u01ad\115\0"+
    "\1\u01ae\121\0\1\u01af\117\0\1\u01b0\105\0\1\u01b1\3\0"+
    "\1\u01b2\122\0\1\u01b3\114\0\1\u01b4\73\0\1\u01b5\2\0"+
    "\1\u01b6\21\0\1\u01b7\75\0\1\u01b8\104\0\1\u01b9\125\0"+
    "\1\u01ba\5\0\1\u01bb\35\0\1\u01bc\157\0\1\u01bd\105\0"+
    "\1\u01be\2\0\1\u01bf\14\0\1\u01c0\105\0\1\u01c1\106\0"+
    "\1\u01c2\4\0\1\u01c3\113\0\1\u01c4\103\0\1\u01c5\7\0"+
    "\1\u01c6\115\0\1\u01c7\75\0\1\u01c8\127\0\1\u01c9\103\0"+
    "\1\u01ca\15\0\1\u01cb\1\0\1\u01cc\72\0\1\u01cd\116\0"+
    "\1\u01ce\117\0\1\u01cf\3\0\1\u01d0\103\0\1\u01d1\2\0"+
    "\1\u0149\110\0\1\u01d2\113\0\1\u01d3\127\0\1\u01d4\52\0"+
    "\1\u01d5\127\0\1\u01d6\126\0\1\u0165\47\0\1\u01d7\161\0"+
    "\1\u01d8\123\0\1\u01d9\52\0\1\u01da\127\0\1\u01db\126\0"+
    "\1\u016b\42\0\6\u016d\3\0\1\u016d\3\0\6\u016d\13\0"+
    "\1\u016d\2\0\1\u016d\1\0\26\u016d\5\0\4\u016d\3\0"+
    "\3\u016d\25\0\1\u01dc\170\0\1\u01dd\100\0\1\u01de\52\0"+
    "\1\u01df\127\0\1\u01e0\126\0\1\u0173\63\0\1\u01e1\67\0"+
    "\1\21\2\0\1\21\4\u01e2\1\21\1\0\4\21\2\0"+
    "\2\21\2\u01e2\20\0\2\21\2\u01e2\3\21\2\u01e2\10\21"+
    "\1\u01e2\2\21\1\u01e2\3\21\5\0\3\u01e2\1\21\3\0"+
    "\3\21\1\0\1\21\2\0\6\24\1\0\1\21\1\201"+
    "\2\24\2\0\4\24\20\0\1\24\1\21\4\24\1\u01e3"+
    "\21\24\5\0\4\24\3\0\3\24\1\0\1\21\2\0"+
    "\6\24\1\0\1\21\1\201\2\24\2\0\4\24\20\0"+
    "\1\24\1\21\16\24\1\262\7\24\5\0\4\24\3\0"+
    "\3\24\1\0\1\21\2\0\6\24\1\0\1\21\1\201"+
    "\2\24\2\0\4\24\20\0\1\24\1\21\6\24\1\u01e4"+
    "\17\24\5\0\4\24\3\0\3\24\1\0\1\21\2\0"+
    "\6\24\1\0\1\21\1\201\2\24\2\0\4\24\20\0"+
    "\1\24\1\21\10\24\1\u01e5\15\24\5\0\4\24\3\0"+
    "\3\24\1\0\1\21\2\0\6\24\1\0\1\21\1\201"+
    "\2\24\2\0\4\24\20\0\1\24\1\21\3\24\1\u017c"+
    "\22\24\5\0\4\24\3\0\3\24\1\0\1\21\2\0"+
    "\6\24\1\0\1\21\1\201\2\24\2\0\4\24\20\0"+
    "\1\24\1\21\13\24\1\u01e6\12\24\5\0\4\24\3\0"+
    "\3\24\1\0\1\21\2\0\6\24\1\0\1\21\1\201"+
    "\2\24\2\0\4\24\20\0\1\24\1\21\2\24\1\u01e7"+
    "\23\24\5\0\4\24\3\0\3\24\1\0\1\21\2\0"+
    "\6\24\1\0\1\21\1\201\2\24\2\0\4\24\20\0"+
    "\1\24\1\21\15\24\1\u01e8\10\24\5\0\4\24\3\0"+
    "\3\24\1\0\1\21\2\0\6\24\1\0\1\21\1\201"+
    "\2\24\2\0\4\24\20\0\1\24\1\21\14\24\1\u01e9"+
    "\11\24\5\0\4\24\3\0\3\24\1\0\1\21\2\0"+
    "\6\24\1\0\1\21\1\201\2\24\2\0\4\24\20\0"+
    "\1\24\1\21\4\24\1\u01ea\21\24\5\0\4\24\3\0"+
    "\3\24\1\0\1\21\2\0\6\24\1\0\1\21\1\201"+
    "\2\24\2\0\4\24\20\0\1\24\1\21\3\24\1\262"+
    "\22\24\5\0\4\24\3\0\3\24\1\0\1\21\2\0"+
    "\6\24\1\0\1\21\1\201\2\24\2\0\4\24\20\0"+
    "\1\24\1\21\10\24\1\u01eb\15\24\5\0\4\24\3\0"+
    "\3\24\1\0\1\21\2\0\6\24\1\0\1\21\1\201"+
    "\2\24\2\0\4\24\20\0\1\24\1\21\20\24\1\u01ec"+
    "\5\24\5\0\4\24\3\0\3\24\1\0\1\21\2\0"+
    "\6\24\1\0\1\21\1\201\2\24\2\0\4\24\20\0"+
    "\1\24\1\21\12\24\1\u01ed\13\24\5\0\4\24\3\0"+
    "\3\24\1\0\1\21\2\0\6\24\1\0\1\21\1\201"+
    "\2\24\2\0\4\24\20\0\1\24\1\21\4\24\1\u0185"+
    "\21\24\5\0\4\24\3\0\3\24\1\0\1\21\2\0"+
    "\6\24\1\0\1\21\1\201\2\24\2\0\4\24\20\0"+
    "\1\24\1\21\6\24\1\u01ee\17\24\5\0\4\24\3\0"+
    "\3\24\1\0\1\21\2\0\6\24\1\0\1\21\1\201"+
    "\2\24\2\0\4\24\20\0\1\24\1\21\12\24\1\u01ef"+
    "\13\24\5\0\4\24\3\0\3\24\1\0\1\21\2\0"+
    "\6\24\1\0\1\21\1\201\2\24\2\0\4\24\20\0"+
    "\1\24\1\21\26\24\5\0\4\24\3\0\1\24\1\u0189"+
    "\1\24\1\0\1\21\2\0\6\24\1\0\1\21\1\201"+
    "\2\24\2\0\4\24\20\0\1\24\1\21\1\u01f0\25\24"+
    "\5\0\4\24\3\0\3\24\1\0\1\21\2\0\6\24"+
    "\1\0\1\21\1\201\2\24\2\0\4\24\20\0\1\24"+
    "\1\21\4\24\1\u01f1\21\24\5\0\4\24\3\0\3\24"+
    "\1\0\1\21\2\0\6\24\1\0\1\21\1\201\2\24"+
    "\2\0\4\24\20\0\1\24\1\21\23\24\1\u0112\2\24"+
    "\5\0\4\24\3\0\3\24\1\0\1\21\2\0\6\24"+
    "\1\0\1\21\1\201\2\24\2\0\4\24\20\0\1\24"+
    "\1\21\11\24\1\u01f2\14\24\5\0\4\24\3\0\3\24"+
    "\1\0\1\21\2\0\6\24\1\0\1\21\1\201\2\24"+
    "\2\0\4\24\20\0\1\24\1\21\3\24\1\u0112\22\24"+
    "\5\0\4\24\3\0\3\24\1\0\1\21\2\0\5\24"+
    "\1\u01f3\1\0\1\21\1\201\2\24\2\0\4\24\20\0"+
    "\1\24\1\21\26\24\5\0\4\24\3\0\3\24\1\0"+
    "\1\21\2\0\6\24\1\0\1\21\1\201\2\24\2\0"+
    "\4\24\20\0\1\24\1\21\7\24\1\u0106\16\24\5\0"+
    "\4\24\3\0\3\24\1\0\1\21\2\0\6\24\1\0"+
    "\1\21\1\201\2\24\2\0\4\24\20\0\1\24\1\21"+
    "\6\24\1\u01f4\17\24\5\0\4\24\3\0\3\24\1\0"+
    "\1\21\2\0\6\24\1\0\1\21\1\201\2\24\2\0"+
    "\4\24\20\0\1\24\1\21\1\u01f5\25\24\5\0\4\24"+
    "\3\0\3\24\1\0\1\21\2\0\6\24\1\0\1\21"+
    "\1\201\2\24\2\0\4\24\20\0\1\24\1\21\1\u0193"+
    "\25\24\5\0\4\24\3\0\3\24\1\0\1\21\2\0"+
    "\6\24\1\0\1\21\1\201\2\24\2\0\4\24\20\0"+
    "\1\24\1\21\6\24\1\u01f6\17\24\5\0\4\24\3\0"+
    "\3\24\1\0\1\21\2\0\6\24\1\0\1\21\1\201"+
    "\2\24\2\0\4\24\20\0\1\24\1\21\3\24\1\u01f7"+
    "\22\24\5\0\4\24\3\0\3\24\1\0\1\21\2\0"+
    "\6\24\1\0\1\21\1\201\2\24\2\0\4\24\20\0"+
    "\1\24\1\21\7\24\1\u01f8\16\24\5\0\4\24\3\0"+
    "\3\24\1\0\1\21\2\0\6\24\1\0\1\21\1\201"+
    "\2\24\2\0\4\24\20\0\1\24\1\21\3\24\1\270"+
    "\22\24\5\0\4\24\3\0\3\24\1\0\1\21\2\0"+
    "\6\24\1\0\1\21\1\201\2\24\2\0\4\24\20\0"+
    "\1\24\1\21\12\24\1\u01f9\13\24\5\0\4\24\3\0"+
    "\3\24\42\0\1\u01a2\6\0\1\u013d\46\0\6\u01a1\1\0"+
    "\1\u01fa\1\0\1\u01fa\2\u01a1\1\u01fa\4\u01a1\2\u01fa\1\0"+
    "\2\u01fa\1\0\1\u01fa\2\0\6\u01fa\1\0\1\u01a1\1\u01fa"+
    "\26\u01a1\2\0\1\u01fa\1\0\1\u01fa\4\u01a1\3\u01fa\3\u01a1"+
    "\17\0\1\u01fb\144\0\1\u01fc\125\0\1\u01fd\106\0\1\u01b2"+
    "\1\0\1\u01fe\45\0\1\u01ff\164\0\1\u0200\76\0\1\u0201"+
    "\120\0\1\u0202\116\0\1\u0203\105\0\1\u01b2\117\0\1\u01b1"+
    "\105\0\1\u0204\120\0\1\u0205\115\0\1\u0149\122\0\1\u0206"+
    "\101\0\1\u01af\125\0\1\u01af\105\0\1\u0207\124\0\1\u0208"+
    "\36\0\1\u0209\113\0\1\u020a\160\0\1\u020b\106\0\1\u020c"+
    "\113\0\1\u020d\132\0\1\u020e\70\0\1\u01af\127\0\1\u020f"+
    "\77\0\1\u0210\123\0\1\u0211\121\0\1\u0212\116\0\1\u01b2"+
    "\102\0\1\u0213\123\0\1\u01af\111\0\1\u0214\102\0\1\u0215"+
    "\116\0\1\u0216\106\0\1\u0217\120\0\1\u0218\124\0\1\u01af"+
    "\101\0\1\u01af\112\0\1\u0219\107\0\1\u021a\122\0\1\u0205"+
    "\104\0\1\u01bc\136\0\1\u021b\73\0\1\u021c\14\0\1\u021d"+
    "\101\0\1\u01b2\115\0\1\u021e\105\0\1\u021f\104\0\1\u01d6"+
    "\6\0\1\u0165\46\0\6\u01d5\1\0\1\u0220\1\0\1\u0220"+
    "\2\u01d5\1\u0220\4\u01d5\2\u0220\1\0\2\u0220\1\0\1\u0220"+
    "\2\0\6\u0220\1\0\1\u01d5\1\u0220\26\u01d5\2\0\1\u0220"+
    "\1\0\1\u0220\4\u01d5\3\u0220\3\u01d5\17\0\1\u0221\146\0"+
    "\1\u0222\122\0\1\u0223\74\0\1\u01db\6\0\1\u016b\46\0"+
    "\6\u01da\1\0\1\u0224\1\0\1\u0224\2\u01da\1\u0224\4\u01da"+
    "\2\u0224\1\0\2\u0224\1\0\1\u0224\2\0\6\u0224\1\0"+
    "\1\u01da\1\u0224\26\u01da\2\0\1\u0224\1\0\1\u0224\4\u01da"+
    "\3\u0224\3\u01da\17\0\1\u0225\177\0\1\u0226\52\0\1\u01e0"+
    "\6\0\1\u0173\46\0\6\u01df\1\0\1\u0227\1\0\1\u0227"+
    "\2\u01df\1\u0227\4\u01df\2\u0227\1\0\2\u0227\1\0\1\u0227"+
    "\2\0\6\u0227\1\0\1\u01df\1\u0227\26\u01df\2\0\1\u0227"+
    "\1\0\1\u0227\4\u01df\3\u0227\3\u01df\17\0\1\u0228\75\0"+
    "\1\21\2\0\1\21\4\u0229\1\21\1\0\4\21\2\0"+
    "\2\21\2\u0229\20\0\2\21\2\u0229\3\21\2\u0229\10\21"+
    "\1\u0229\2\21\1\u0229\3\21\5\0\3\u0229\1\21\3\0"+
    "\3\21\1\0\1\21\2\0\6\24\1\0\1\21\1\201"+
    "\2\24\2\0\4\24\20\0\1\24\1\21\1\u022a\25\24"+
    "\5\0\4\24\3\0\3\24\1\0\1\21\2\0\6\24"+
    "\1\0\1\21\1\201\2\24\2\0\4\24\20\0\1\24"+
    "\1\21\1\u022b\25\24\5\0\4\24\3\0\3\24\1\0"+
    "\1\21\2\0\6\24\1\0\1\21\1\201\2\24\2\0"+
    "\4\24\20\0\1\24\1\21\5\24\1\262\20\24\5\0"+
    "\4\24\3\0\3\24\1\0\1\21\2\0\6\24\1\0"+
    "\1\21\1\201\2\24\2\0\4\24\20\0\1\24\1\21"+
    "\4\24\1\u022c\21\24\5\0\4\24\3\0\3\24\1\0"+
    "\1\21\2\0\6\24\1\0\1\21\1\201\2\24\2\0"+
    "\4\24\20\0\1\24\1\21\10\24\1\u022d\15\24\5\0"+
    "\4\24\3\0\3\24\1\0\1\21\2\0\6\24\1\0"+
    "\1\21\1\201\2\24\2\0\4\24\20\0\1\24\1\21"+
    "\22\24\1\262\3\24\5\0\4\24\3\0\3\24\1\0"+
    "\1\21\2\0\6\24\1\0\1\21\1\201\2\24\2\0"+
    "\4\24\20\0\1\24\1\21\12\24\1\u022e\13\24\5\0"+
    "\4\24\3\0\3\24\1\0\1\21\2\0\6\24\1\0"+
    "\1\21\1\201\2\24\2\0\4\24\20\0\1\24\1\21"+
    "\12\24\1\u022f\13\24\5\0\4\24\3\0\3\24\1\0"+
    "\1\21\2\0\6\24\1\0\1\21\1\201\2\24\2\0"+
    "\4\24\20\0\1\24\1\21\6\24\1\u0189\17\24\5\0"+
    "\4\24\3\0\3\24\1\0\1\21\2\0\6\24\1\0"+
    "\1\21\1\201\2\24\2\0\4\24\20\0\1\24\1\21"+
    "\17\24\1\u010f\6\24\5\0\4\24\3\0\3\24\1\0"+
    "\1\21\2\0\6\24\1\0\1\21\1\201\2\24\2\0"+
    "\4\24\20\0\1\u0230\1\21\26\24\5\0\4\24\3\0"+
    "\3\24\1\0\1\21\2\0\6\24\1\0\1\21\1\201"+
    "\2\24\2\0\4\24\20\0\1\24\1\21\10\24\1\u0231"+
    "\15\24\5\0\4\24\3\0\3\24\1\0\1\21\2\0"+
    "\6\24\1\0\1\21\1\201\2\24\2\0\4\24\20\0"+
    "\1\24\1\21\12\24\1\u0232\13\24\5\0\4\24\3\0"+
    "\3\24\1\0\1\21\2\0\6\24\1\0\1\21\1\201"+
    "\2\24\2\0\4\24\20\0\1\24\1\21\22\24\1\u0233"+
    "\3\24\5\0\4\24\3\0\3\24\1\0\1\21\2\0"+
    "\6\24\1\0\1\21\1\201\2\24\2\0\4\24\20\0"+
    "\1\24\1\21\11\24\1\u0107\14\24\5\0\4\24\3\0"+
    "\3\24\1\0\1\21\2\0\6\24\1\0\1\21\1\201"+
    "\2\24\2\0\4\24\20\0\1\24\1\21\7\24\1\u0185"+
    "\16\24\5\0\4\24\3\0\3\24\1\0\1\21\2\0"+
    "\6\24\1\0\1\21\1\201\2\24\2\0\2\24\1\u0234"+
    "\1\24\20\0\1\24\1\21\26\24\5\0\4\24\3\0"+
    "\2\24\1\u0235\1\0\1\21\2\0\6\24\1\0\1\21"+
    "\1\201\2\24\2\0\4\24\20\0\1\24\1\21\11\24"+
    "\1\u0112\14\24\5\0\4\24\3\0\3\24\1\0\1\21"+
    "\2\0\6\24\1\0\1\21\1\201\2\24\2\0\4\24"+
    "\20\0\1\24\1\21\5\24\1\u0236\20\24\5\0\4\24"+
    "\3\0\3\24\1\0\1\21\2\0\6\24\1\0\1\21"+
    "\1\201\2\24\2\0\4\24\20\0\1\24\1\21\10\24"+
    "\1\u0237\15\24\5\0\4\24\3\0\3\24\1\0\1\21"+
    "\2\0\6\24\1\0\1\21\1\201\2\24\2\0\4\24"+
    "\20\0\1\24\1\21\7\24\1\u0238\16\24\5\0\4\24"+
    "\3\0\3\24\1\0\1\21\2\0\6\24\1\0\1\21"+
    "\1\201\2\24\2\0\4\24\20\0\1\24\1\21\10\24"+
    "\1\u0239\15\24\5\0\4\24\3\0\3\24\17\0\1\u01a1"+
    "\151\0\1\u023a\121\0\1\u01c9\111\0\1\u01af\110\0\1\u0149"+
    "\120\0\1\u0216\105\0\1\u023b\111\0\1\u023c\111\0\1\u01b2"+
    "\111\0\1\u023d\123\0\1\u01ca\120\0\1\u01b2\115\0\1\u023e"+
    "\110\0\1\u023f\103\0\1\u0240\117\0\1\u0241\104\0\1\u0242"+
    "\114\0\1\u0243\114\0\1\u0244\114\0\1\u0245\112\0\1\u01af"+
    "\130\0\1\u01ff\77\0\1\u0246\113\0\1\u0247\121\0\1\u0248"+
    "\105\0\1\u0149\107\0\1\u014a\117\0\1\u01af\107\0\1\u0249"+
    "\115\0\1\u024a\117\0\1\u024b\47\0\1\u024c\151\0\1\u024d"+
    "\121\0\1\u024e\113\0\1\u024f\105\0\1\u0250\123\0\1\u0251"+
    "\53\0\1\u01d5\157\0\1\u0252\115\0\1\u0253\45\0\1\u01da"+
    "\200\0\1\u0254\26\0\1\u01df\75\0\1\21\2\0\1\21"+
    "\4\24\1\21\1\0\4\21\2\0\2\21\2\24\20\0"+
    "\2\21\2\24\3\21\2\24\10\21\1\24\2\21\1\24"+
    "\3\21\5\0\3\24\1\21\3\0\3\21\1\0\1\21"+
    "\2\0\6\24\1\0\1\21\1\201\2\24\2\0\4\24"+
    "\20\0\1\24\1\21\5\24\1\u0185\20\24\5\0\4\24"+
    "\3\0\3\24\1\0\1\21\2\0\6\24\1\0\1\21"+
    "\1\201\2\24\2\0\4\24\20\0\1\24\1\21\12\24"+
    "\1\u017c\13\24\5\0\4\24\3\0\3\24\1\0\1\21"+
    "\2\0\6\24\1\0\1\21\1\201\2\24\2\0\4\24"+
    "\20\0\1\24\1\21\14\24\1\u0255\11\24\5\0\4\24"+
    "\3\0\3\24\1\0\1\21\2\0\6\24\1\0\1\21"+
    "\1\201\2\24\2\0\4\24\20\0\1\24\1\21\6\24"+
    "\1\u0256\17\24\5\0\4\24\3\0\3\24\1\0\1\21"+
    "\2\0\5\24\1\u0112\1\0\1\21\1\201\2\24\2\0"+
    "\4\24\20\0\1\24\1\21\26\24\5\0\4\24\3\0"+
    "\3\24\1\0\1\21\2\0\6\24\1\0\1\21\1\201"+
    "\2\24\2\0\4\24\20\0\1\24\1\21\6\24\1\u0257"+
    "\17\24\5\0\4\24\3\0\3\24\1\0\1\21\2\0"+
    "\6\24\1\0\1\21\1\201\2\24\2\0\4\24\20\0"+
    "\1\24\1\21\3\24\1\u01ec\22\24\5\0\4\24\3\0"+
    "\3\24\1\0\1\21\2\0\6\24\1\0\1\21\1\201"+
    "\2\24\2\0\4\24\20\0\1\24\1\21\5\24\1\u0110"+
    "\20\24\5\0\4\24\3\0\3\24\1\0\1\21\2\0"+
    "\6\24\1\0\1\21\1\201\2\24\2\0\4\24\20\0"+
    "\1\24\1\21\1\u0258\25\24\5\0\4\24\3\0\3\24"+
    "\1\0\1\21\2\0\6\24\1\0\1\21\1\201\2\24"+
    "\2\0\4\24\20\0\1\24\1\21\7\24\1\u0259\16\24"+
    "\5\0\4\24\3\0\3\24\1\0\1\21\2\0\6\24"+
    "\1\0\1\21\1\201\2\24\2\0\4\24\20\0\1\24"+
    "\1\21\12\24\1\u025a\13\24\5\0\4\24\3\0\3\24"+
    "\1\0\1\21\2\0\6\24\1\0\1\21\1\201\2\24"+
    "\2\0\4\24\20\0\1\24\1\21\3\24\1\u025b\22\24"+
    "\5\0\4\24\3\0\3\24\1\0\1\21\2\0\6\24"+
    "\1\0\1\21\1\201\2\24\2\0\4\24\20\0\1\24"+
    "\1\21\14\24\1\u025c\11\24\5\0\4\24\3\0\3\24"+
    "\1\0\1\21\2\0\6\24\1\0\1\21\1\201\2\24"+
    "\2\0\4\24\20\0\1\24\1\21\21\24\1\262\4\24"+
    "\5\0\4\24\3\0\3\24\1\0\1\21\2\0\6\24"+
    "\1\0\1\21\1\201\2\24\2\0\4\24\20\0\1\24"+
    "\1\21\3\24\1\u0238\22\24\5\0\4\24\3\0\3\24"+
    "\53\0\1\u025d\121\0\1\u0247\101\0\1\u025e\117\0\1\u025f"+
    "\115\0\1\u0260\117\0\1\u0261\113\0\1\u0262\105\0\1\u01d1"+
    "\107\0\1\u0263\132\0\1\u0264\74\0\1\u01bd\3\0\1\u0265"+
    "\117\0\1\u0266\115\0\1\u0217\104\0\1\u01b2\112\0\1\u0149"+
    "\120\0\1\u01af\124\0\1\u0267\100\0\1\u0268\115\0\1\u020f"+
    "\107\0\1\u0149\115\0\1\u0269\112\0\1\u026a\112\0\1\u021f"+
    "\124\0\1\u01fe\103\0\1\u026b\41\0\26\u0253\1\u01af\65\u0253"+
    "\104\0\1\u026c\7\0\1\21\2\0\6\24\1\0\1\21"+
    "\1\201\2\24\2\0\4\24\20\0\1\24\1\21\12\24"+
    "\1\u026d\13\24\5\0\4\24\3\0\3\24\1\0\1\21"+
    "\2\0\6\24\1\0\1\21\1\201\2\24\2\0\4\24"+
    "\20\0\1\24\1\21\12\24\1\u0185\13\24\5\0\4\24"+
    "\3\0\3\24\1\0\1\21\2\0\6\24\1\0\1\21"+
    "\1\201\2\24\2\0\4\24\20\0\1\24\1\21\12\24"+
    "\1\u026e\13\24\5\0\4\24\3\0\3\24\1\0\1\21"+
    "\2\0\6\24\1\0\1\21\1\201\2\24\2\0\4\24"+
    "\20\0\1\24\1\21\5\24\1\u0112\20\24\5\0\4\24"+
    "\3\0\3\24\1\0\1\21\2\0\6\24\1\0\1\21"+
    "\1\201\2\24\2\0\4\24\20\0\1\24\1\21\14\24"+
    "\1\u026f\11\24\5\0\4\24\3\0\3\24\1\0\1\21"+
    "\2\0\6\24\1\0\1\21\1\201\2\24\2\0\4\24"+
    "\20\0\1\24\1\21\3\24\1\u0189\22\24\5\0\4\24"+
    "\3\0\3\24\1\0\1\21\2\0\6\24\1\0\1\21"+
    "\1\201\2\24\2\0\4\24\20\0\1\24\1\21\6\24"+
    "\1\u0137\17\24\5\0\4\24\3\0\3\24\1\0\1\21"+
    "\2\0\6\24\1\0\1\21\1\201\2\24\2\0\4\24"+
    "\20\0\1\24\1\21\12\24\1\262\13\24\5\0\4\24"+
    "\3\0\3\24\63\0\1\u0260\104\0\1\u020f\127\0\1\u01af"+
    "\114\0\1\u01af\100\0\1\u025f\111\0\1\u01c3\114\0\1\u0270"+
    "\47\0\1\u0271\162\0\1\u0272\102\0\1\u01b0\113\0\1\u0269"+
    "\116\0\1\u0273\113\0\1\u025f\120\0\1\u0274\140\0\1\u0275"+
    "\10\0\1\21\2\0\6\24\1\0\1\21\1\201\2\24"+
    "\2\0\4\24\20\0\1\24\1\21\10\24\1\u0276\15\24"+
    "\5\0\4\24\3\0\3\24\1\0\1\21\2\0\6\24"+
    "\1\0\1\21\1\201\2\24\2\0\4\24\20\0\1\24"+
    "\1\21\3\24\1\u010f\22\24\5\0\4\24\3\0\3\24"+
    "\1\0\1\21\2\0\6\24\1\0\1\21\1\201\2\24"+
    "\2\0\4\24\20\0\1\24\1\21\1\u025a\25\24\5\0"+
    "\4\24\3\0\3\24\51\0\1\u01ca\116\0\1\u0277\121\0"+
    "\1\u020f\106\0\1\u01c9\105\0\1\u0278\145\0\1\u0279\13\0"+
    "\1\21\2\0\6\24\1\0\1\21\1\201\2\24\2\0"+
    "\4\24\20\0\1\24\1\21\26\24\5\0\4\24\3\0"+
    "\1\u025b\2\24\52\0\1\u027a\117\0\1\u0253\106\0\1\u01af"+
    "\11\0\1\u0216\31\0";

  private static int [] zzUnpackTrans() {
    int [] result = new int[42788];
    int offset = 0;
    offset = zzUnpackTrans(ZZ_TRANS_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackTrans(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      value--;
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /* error codes */
  private static final int ZZ_UNKNOWN_ERROR = 0;
  private static final int ZZ_NO_MATCH = 1;
  private static final int ZZ_PUSHBACK_2BIG = 2;

  /* error messages for the codes above */
  private static final String ZZ_ERROR_MSG[] = {
    "Unkown internal scanner error",
    "Error: could not match input",
    "Error: pushback value was too large"
  };

  /**
   * ZZ_ATTRIBUTE[aState] contains the attributes of state <code>aState</code>
   */
  private static final int [] ZZ_ATTRIBUTE = zzUnpackAttribute();

  private static final String ZZ_ATTRIBUTE_PACKED_0 =
    "\13\0\2\1\3\0\2\1\1\11\4\1\1\11\4\1"+
    "\2\11\4\1\1\11\23\1\2\11\2\1\1\11\1\1"+
    "\1\11\1\1\1\11\1\1\1\11\1\1\1\11\1\1"+
    "\1\11\5\1\1\11\10\1\1\11\5\1\1\11\2\1"+
    "\1\11\1\1\1\11\5\1\1\11\2\1\1\11\1\1"+
    "\3\11\3\1\3\11\1\1\1\11\4\1\1\11\2\1"+
    "\1\11\1\1\1\11\1\1\1\11\12\1\2\0\1\11"+
    "\3\1\2\0\1\11\62\1\1\11\2\1\1\11\4\0"+
    "\1\11\2\0\1\11\32\0\3\1\2\11\5\0\1\11"+
    "\2\0\2\11\2\1\1\0\73\1\64\0\1\1\2\0"+
    "\1\11\5\0\1\11\1\1\1\11\45\1\1\0\1\11"+
    "\1\0\1\1\15\0\1\11\45\0\1\1\4\0\1\1"+
    "\1\0\1\11\2\0\1\1\1\0\1\11\30\1\15\0"+
    "\1\1\20\0\1\1\20\0\21\1\33\0\11\1\4\0"+
    "\1\1\12\0\3\1\6\0\1\1\2\0\1\11\1\0";

  private static int [] zzUnpackAttribute() {
    int [] result = new int[634];
    int offset = 0;
    offset = zzUnpackAttribute(ZZ_ATTRIBUTE_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAttribute(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }

  /** the input device */
  private java.io.Reader zzReader;

  /** the current state of the DFA */
  private int zzState;

  /** the current lexical state */
  private int zzLexicalState = YYINITIAL;

  /** this buffer contains the current text to be matched and is
      the source of the yytext() string */
  private char zzBuffer[];

  /** the textposition at the last accepting state */
  private int zzMarkedPos;

  /** the current text position in the buffer */
  private int zzCurrentPos;

  /** startRead marks the beginning of the yytext() string in the buffer */
  private int zzStartRead;

  /** endRead marks the last character in the buffer, that has been read
      from input */
  private int zzEndRead;

  /** zzAtEOF == true <=> the scanner is at the EOF */
  private boolean zzAtEOF;

  /* user code: */

	/**
	 * Token type specifying we're in a JavaScript multiline comment.
	 */
	private static final int INTERNAL_IN_JS_MLC				= -8;

	/**
	 * Token type specifying we're in a JavaScript documentation comment.
	 */
	private static final int INTERNAL_IN_JS_COMMENT_DOCUMENTATION = -9;

	/**
	 * Token type specifying we're in an invalid multi-line JS string.
	 */
	private static final int INTERNAL_IN_JS_STRING_INVALID	= -10;

	/**
	 * Token type specifying we're in a valid multi-line JS string.
	 */
	private static final int INTERNAL_IN_JS_STRING_VALID		= -11;

	/**
	 * Token type specifying we're in an invalid multi-line JS single-quoted string.
	 */
	private static final int INTERNAL_IN_JS_CHAR_INVALID	= -12;

	/**
	 * Token type specifying we're in a valid multi-line JS single-quoted string.
	 */
	private static final int INTERNAL_IN_JS_CHAR_VALID		= -13;

	private static final int INTERNAL_E4X = -14;

	private static final int INTERNAL_E4X_INTAG = -15;

	private static final int INTERNAL_E4X_MARKUP_PROCESSING_INSTRUCTION = -16;

	private static final int INTERNAL_IN_E4X_COMMENT = -17;

	private static final int INTERNAL_E4X_DTD = -18;

	private static final int INTERNAL_E4X_DTD_INTERNAL = -19;

	private static final int INTERNAL_E4X_ATTR_SINGLE = -20;

	private static final int INTERNAL_E4X_ATTR_DOUBLE = -21;

	private static final int INTERNAL_E4X_MARKUP_CDATA = -22;

	/**
	 * Token type specifying we're in a valid multi-line template literal.
	 */
	private static final int INTERNAL_IN_JS_TEMPLATE_LITERAL_VALID = -23;

	/**
	 * Token type specifying we're in an invalid multi-line template literal.
	 */
	private static final int INTERNAL_IN_JS_TEMPLATE_LITERAL_INVALID = -24;

	/**
	 * When in the JS_STRING state, whether the current string is valid.
	 */
	private boolean validJSString;

	/**
	 * Whether we're in an internal DTD.  Only valid if in an e4x DTD.
	 */
	private boolean e4x_inInternalDtd;

	/**
	 * The previous e4x state.  Only valid if in an e4x state.
	 */
	private int e4x_prevState;

	/**
	 * The version of JavaScript being highlighted.
	 */
	private static String jsVersion;

	/**
	 * Whether e4x is being highlighted.
	 */
	private static boolean e4xSupported;

	/**
	 * Language state set on JS tokens.  Must be 0.
	 */
	private static final int LANG_INDEX_DEFAULT	= 0;

	/**
	 * Language state set on E4X tokens.
	 */
	private static final int LANG_INDEX_E4X = 1;

	private Stack<Boolean> varDepths;

	/**
	 * Constructor.  This must be here because JFlex does not generate a
	 * no-parameter constructor.
	 */
	public JavaScriptTokenMaker() {
		super();
	}


	static {
		jsVersion = "1.7"; // Many folks using JS tend to be bleeding edge
		e4xSupported = true;
	}


	/**
	 * Adds the token specified to the current linked list of tokens as an
	 * "end token;" that is, at <code>zzMarkedPos</code>.
	 *
	 * @param tokenType The token's type.
	 */
	private void addEndToken(int tokenType) {
		addToken(zzMarkedPos,zzMarkedPos, tokenType);
	}


	/**
	 * Adds the token specified to the current linked list of tokens.
	 *
	 * @param tokenType The token's type.
	 * @see #addToken(int, int, int)
	 */
	private void addHyperlinkToken(int start, int end, int tokenType) {
		int so = start + offsetShift;
		addToken(zzBuffer, start,end, tokenType, so, true);
	}


	/**
	 * Adds the token specified to the current linked list of tokens.
	 *
	 * @param tokenType The token's type.
	 */
	private void addToken(int tokenType) {
		addToken(zzStartRead, zzMarkedPos-1, tokenType);
	}


	/**
	 * Adds the token specified to the current linked list of tokens.
	 *
	 * @param tokenType The token's type.
	 */
	private void addToken(int start, int end, int tokenType) {
		int so = start + offsetShift;
		addToken(zzBuffer, start,end, tokenType, so);
	}


	/**
	 * Adds the token specified to the current linked list of tokens.
	 *
	 * @param array The character array.
	 * @param start The starting offset in the array.
	 * @param end The ending offset in the array.
	 * @param tokenType The token's type.
	 * @param startOffset The offset in the document at which this token
	 *                    occurs.
	 */
	@Override
	public void addToken(char[] array, int start, int end, int tokenType, int startOffset) {
		super.addToken(array, start,end, tokenType, startOffset);
		zzStartRead = zzMarkedPos;
	}


	/**
	 * Returns the closest {@link TokenTypes} "standard" token type for a given
	 * "internal" token type (e.g. one whose value is <code>&lt; 0</code>).
	 */
	 @Override
	public int getClosestStandardTokenTypeForInternalType(int type) {
		switch (type) {
			case INTERNAL_IN_JS_MLC:
				return TokenTypes.COMMENT_MULTILINE;
			case INTERNAL_IN_JS_COMMENT_DOCUMENTATION:
				return TokenTypes.COMMENT_DOCUMENTATION;
			case INTERNAL_IN_JS_STRING_INVALID:
			case INTERNAL_IN_JS_STRING_VALID:
			case INTERNAL_IN_JS_CHAR_INVALID:
			case INTERNAL_IN_JS_CHAR_VALID:
				return TokenTypes.LITERAL_STRING_DOUBLE_QUOTE;
			case INTERNAL_IN_JS_TEMPLATE_LITERAL_VALID:
				return TokenTypes.LITERAL_BACKQUOTE;
			case INTERNAL_IN_JS_TEMPLATE_LITERAL_INVALID:
				return TokenTypes.ERROR_STRING_DOUBLE;
		}
		return type;
	}


	/**
	 * Returns the JavaScript version being highlighted.
	 *
	 * @return Supported JavaScript version.
	 * @see #isJavaScriptCompatible(String)
	 */
	public static String getJavaScriptVersion() {
		return jsVersion;
	}


	/**
	 * {@inheritDoc}
	 */
	@Override
	public String[] getLineCommentStartAndEnd(int languageIndex) {
		return new String[] { "//", null };
	}


	/**
	 * Returns the first token in the linked list of tokens generated
	 * from <code>text</code>.  This method must be implemented by
	 * subclasses so they can correctly implement syntax highlighting.
	 *
	 * @param text The text from which to get tokens.
	 * @param initialTokenType The token type we should start with.
	 * @param startOffset The offset into the document at which
	 *        <code>text</code> starts.
	 * @return The first <code>Token</code> in a linked list representing
	 *         the syntax highlighted text.
	 */
	@Override
	public Token getTokenList(Segment text, int initialTokenType, int startOffset) {

		resetTokenList();
		this.offsetShift = -text.offset + startOffset;
		validJSString = true;
		e4x_prevState = YYINITIAL;
		e4x_inInternalDtd = false;
		int languageIndex = LANG_INDEX_DEFAULT;

		// Start off in the proper state.
		int state = YYINITIAL;
		switch (initialTokenType) {
			case INTERNAL_IN_JS_MLC:
				state = JS_MLC;
				break;
			case INTERNAL_IN_JS_COMMENT_DOCUMENTATION:
				state = JS_DOCCOMMENT;
				start = text.offset;
				break;
			case INTERNAL_IN_JS_STRING_INVALID:
				state = JS_STRING;
				validJSString = false;
				break;
			case INTERNAL_IN_JS_STRING_VALID:
				state = JS_STRING;
				break;
			case INTERNAL_IN_JS_CHAR_INVALID:
				state = JS_CHAR;
				validJSString = false;
				break;
			case INTERNAL_IN_JS_CHAR_VALID:
				state = JS_CHAR;
				break;
			case INTERNAL_E4X:
				state = E4X;
				languageIndex = LANG_INDEX_E4X;
				break;
			case INTERNAL_E4X_INTAG:
				state = E4X_INTAG;
				languageIndex = LANG_INDEX_E4X;
				break;
			case INTERNAL_E4X_MARKUP_PROCESSING_INSTRUCTION:
				state = E4X_PI;
				languageIndex = LANG_INDEX_E4X;
				break;
			case INTERNAL_E4X_DTD:
				state = E4X_DTD;
				languageIndex = LANG_INDEX_E4X;
				break;
			case INTERNAL_E4X_DTD_INTERNAL:
				state = E4X_DTD;
				e4x_inInternalDtd = true;
				languageIndex = LANG_INDEX_E4X;
				break;
			case INTERNAL_E4X_ATTR_SINGLE:
				state = E4X_INATTR_SINGLE;
				languageIndex = LANG_INDEX_E4X;
				break;
			case INTERNAL_E4X_ATTR_DOUBLE:
				state = E4X_INATTR_DOUBLE;
				languageIndex = LANG_INDEX_E4X;
				break;
			case INTERNAL_E4X_MARKUP_CDATA:
				state = E4X_CDATA;
				languageIndex = LANG_INDEX_E4X;
				break;
			case INTERNAL_IN_JS_TEMPLATE_LITERAL_VALID:
				state = JS_TEMPLATE_LITERAL;
				validJSString = true;
				break;
			case INTERNAL_IN_JS_TEMPLATE_LITERAL_INVALID:
				state = JS_TEMPLATE_LITERAL;
				validJSString = false;
				break;
			default:
				if (initialTokenType<-1024) { // INTERNAL_IN_E4X_COMMENT - prevState
					int main = -(-initialTokenType & 0xffffff00);
					switch (main) {
						default: // Should never happen
						case INTERNAL_IN_E4X_COMMENT:
							state = E4X_COMMENT;
							break;
					}
					e4x_prevState = -initialTokenType&0xff;
					languageIndex = LANG_INDEX_E4X;
				}
				else { // Shouldn't happen
					state = Token.NULL;
				}
		}

		setLanguageIndex(languageIndex);
		start = text.offset;
		s = text;
		try {
			yyreset(zzReader);
			yybegin(state);
			return yylex();
		} catch (IOException ioe) {
			ioe.printStackTrace();
			return new TokenImpl();
		}

	}


	/**
	 * Returns whether e4x is being highlighted.
	 *
	 * @return Whether e4x is being highlighted.
	 * @see #setE4xSupported(boolean)
	 */
	public static boolean isE4xSupported() {
		return e4xSupported;
	}


	/**
	 * Returns whether features for a specific JS version should be honored
	 * while highlighting.
	 *
	 * @param version JavaScript version required
	 * @return Whether the JavaScript version is the same or greater than
	 *         version required.
	 */
	public static boolean isJavaScriptCompatible(String version) {
		return jsVersion.compareTo(version) >= 0;
	}


	/**
	 * Sets whether e4x should be highlighted.  A repaint should be forced on
	 * all <code>RSyntaxTextArea</code>s editing JavaScript if this property
	 * is changed to see the difference.
	 *
	 * @param supported Whether e4x should be highlighted.
	 * @see #isE4xSupported()
	 */
	public static void setE4xSupported(boolean supported) {
		e4xSupported = supported;
	}


	/**
	 * Set the supported JavaScript version because some keywords were
	 * introduced on or after this version.
	 *
	 * @param javaScriptVersion The version of JavaScript to support, such as
	 *        "<code>1.5</code>" or "<code>1.6</code>".
	 * @see #isJavaScriptCompatible(String)
	 * @see #getJavaScriptVersion()
	 */
	public static void setJavaScriptVersion(String javaScriptVersion) {
		jsVersion = javaScriptVersion;
	}


	/**
	 * Refills the input buffer.
	 *
	 * @return      <code>true</code> if EOF was reached, otherwise
	 *              <code>false</code>.
	 */
	private boolean zzRefill() {
		return zzCurrentPos>=s.offset+s.count;
	}


	/**
	 * Resets the scanner to read from a new input stream.
	 * Does not close the old reader.
	 *
	 * All internal variables are reset, the old input stream
	 * <b>cannot</b> be reused (internal buffer is discarded and lost).
	 * Lexical state is set to <tt>YY_INITIAL</tt>.
	 *
	 * @param reader   the new input stream
	 */
	public final void yyreset(java.io.Reader reader) {
		// 's' has been updated.
		zzBuffer = s.array;
		/*
		 * We replaced the line below with the two below it because zzRefill
		 * no longer "refills" the buffer (since the way we do it, it's always
		 * "full" the first time through, since it points to the segment's
		 * array).  So, we assign zzEndRead here.
		 */
		//zzStartRead = zzEndRead = s.offset;
		zzStartRead = s.offset;
		zzEndRead = zzStartRead + s.count - 1;
		zzCurrentPos = zzMarkedPos = s.offset;
		zzLexicalState = YYINITIAL;
		zzReader = reader;
		zzAtEOF  = false;
	}




  /**
   * Creates a new scanner
   * There is also a java.io.InputStream version of this constructor.
   *
   * @param   in  the java.io.Reader to read input from.
   */
  public JavaScriptTokenMaker(java.io.Reader in) {
    this.zzReader = in;
  }

  /**
   * Creates a new scanner.
   * There is also java.io.Reader version of this constructor.
   *
   * @param   in  the java.io.Inputstream to read input from.
   */
  public JavaScriptTokenMaker(java.io.InputStream in) {
    this(new java.io.InputStreamReader(in));
  }

  /**
   * Unpacks the compressed character translation table.
   *
   * @param packed   the packed character translation table
   * @return         the unpacked character translation table
   */
  private static char [] zzUnpackCMap(String packed) {
    char [] map = new char[0x10000];
    int i = 0;  /* index in packed string  */
    int j = 0;  /* index in unpacked array */
    while (i < 172) {
      int  count = packed.charAt(i++);
      char value = packed.charAt(i++);
      do map[j++] = value; while (--count > 0);
    }
    return map;
  }


  /**
   * Closes the input stream.
   */
  public final void yyclose() throws java.io.IOException {
    zzAtEOF = true;            /* indicate end of file */
    zzEndRead = zzStartRead;  /* invalidate buffer    */

    if (zzReader != null)
      zzReader.close();
  }

  /**
   * Returns the current lexical state.
   */
  public final int yystate() {
    return zzLexicalState;
  }


  /**
   * Enters a new lexical state
   *
   * @param newState the new lexical state
   */
  @Override
  public final void yybegin(int newState) {
    zzLexicalState = newState;
  }


  /**
   * Returns the text matched by the current regular expression.
   */
  public final String yytext() {
    return new String( zzBuffer, zzStartRead, zzMarkedPos-zzStartRead );
  }


  /**
   * Returns the character at position <tt>pos</tt> from the
   * matched text.
   *
   * It is equivalent to yytext().charAt(pos), but faster
   *
   * @param pos the position of the character to fetch.
   *            A value from 0 to yylength()-1.
   *
   * @return the character at position pos
   */
  public final char yycharat(int pos) {
    return zzBuffer[zzStartRead+pos];
  }


  /**
   * Returns the length of the matched text region.
   */
  public final int yylength() {
    return zzMarkedPos-zzStartRead;
  }


  /**
   * Reports an error that occured while scanning.
   *
   * In a wellformed scanner (no or only correct usage of
   * yypushback(int) and a match-all fallback rule) this method
   * will only be called with things that "Can't Possibly Happen".
   * If this method is called, something is seriously wrong
   * (e.g. a JFlex bug producing a faulty scanner etc.).
   *
   * Usual syntax/scanner level error handling should be done
   * in error fallback rules.
   *
   * @param   errorCode  the code of the errormessage to display
   */
  private void zzScanError(int errorCode) {
    String message;
    try {
      message = ZZ_ERROR_MSG[errorCode];
    }
    catch (ArrayIndexOutOfBoundsException e) {
      message = ZZ_ERROR_MSG[ZZ_UNKNOWN_ERROR];
    }

    throw new Error(message);
  }


  /**
   * Pushes the specified amount of characters back into the input stream.
   *
   * They will be read again by then next call of the scanning method
   *
   * @param number  the number of characters to be read again.
   *                This number must not be greater than yylength()!
   */
  public void yypushback(int number)  {
    if ( number > yylength() )
      zzScanError(ZZ_PUSHBACK_2BIG);

    zzMarkedPos -= number;
  }


  /**
   * Resumes scanning until the next regular expression is matched,
   * the end of input is encountered or an I/O-Error occurs.
   *
   * @return      the next token
   * @exception   java.io.IOException  if any I/O-Error occurs
   */
  public org.fife.ui.rsyntaxtextarea.Token yylex() throws java.io.IOException {
    int zzInput;
    int zzAction;

    // cached fields:
    int zzCurrentPosL;
    int zzMarkedPosL;
    int zzEndReadL = zzEndRead;
    char [] zzBufferL = zzBuffer;
    char [] zzCMapL = ZZ_CMAP;

    int [] zzTransL = ZZ_TRANS;
    int [] zzRowMapL = ZZ_ROWMAP;
    int [] zzAttrL = ZZ_ATTRIBUTE;

    while (true) {
      zzMarkedPosL = zzMarkedPos;

      zzAction = -1;

      zzCurrentPosL = zzCurrentPos = zzStartRead = zzMarkedPosL;

      zzState = zzLexicalState;


      zzForAction: {
        while (true) {

          if (zzCurrentPosL < zzEndReadL)
            zzInput = zzBufferL[zzCurrentPosL++];
          else if (zzAtEOF) {
            zzInput = YYEOF;
            break zzForAction;
          }
          else {
            // store back cached positions
            zzCurrentPos  = zzCurrentPosL;
            zzMarkedPos   = zzMarkedPosL;
            boolean eof = zzRefill();
            // get translated positions and possibly new buffer
            zzCurrentPosL  = zzCurrentPos;
            zzMarkedPosL   = zzMarkedPos;
            zzBufferL      = zzBuffer;
            zzEndReadL     = zzEndRead;
            if (eof) {
              zzInput = YYEOF;
              break zzForAction;
            }
            else {
              zzInput = zzBufferL[zzCurrentPosL++];
            }
          }
          int zzNext = zzTransL[ zzRowMapL[zzState] + zzCMapL[zzInput] ];
          if (zzNext == -1) break zzForAction;
          zzState = zzNext;

          int zzAttributes = zzAttrL[zzState];
          if ( (zzAttributes & 1) == 1 ) {
            zzAction = zzState;
            zzMarkedPosL = zzCurrentPosL;
            if ( (zzAttributes & 8) == 8 ) break zzForAction;
          }

        }
      }

      // store back cached position
      zzMarkedPos = zzMarkedPosL;

      switch (zzAction < 0 ? zzAction : ZZ_ACTION[zzAction]) {
        case 35:
          { start = zzMarkedPos-1; yybegin(E4X_INATTR_SINGLE);
          }
        case 83: break;
        case 34:
          { start = zzMarkedPos-1; yybegin(E4X_INATTR_DOUBLE);
          }
        case 84: break;
        case 43:
          { addToken(Token.ERROR_NUMBER_FORMAT);
          }
        case 85: break;
        case 81:
          { addToken(Token.RESERVED_WORD_2);
          }
        case 86: break;
        case 27:
          { addToken(start,zzStartRead-1, Token.MARKUP_DTD); addEndToken(e4x_inInternalDtd ? INTERNAL_E4X_DTD_INTERNAL : INTERNAL_E4X_DTD); return firstToken;
          }
        case 87: break;
        case 40:
          { int type = validJSString ? Token.LITERAL_BACKQUOTE : Token.ERROR_STRING_DOUBLE; addToken(start,zzStartRead, type); yybegin(YYINITIAL);
          }
        case 88: break;
        case 16:
          { /* Line ending in '\' => continue to next line. */
								if (validJSString) {
									addToken(start,zzStartRead, Token.LITERAL_CHAR);
									addEndToken(INTERNAL_IN_JS_CHAR_VALID);
								}
								else {
									addToken(start,zzStartRead, Token.ERROR_CHAR);
									addEndToken(INTERNAL_IN_JS_CHAR_INVALID);
								}
								return firstToken;
          }
        case 89: break;
        case 3:
          { addToken(Token.WHITESPACE);
          }
        case 90: break;
        case 18:
          { addToken(start,zzStartRead-1, Token.COMMENT_MULTILINE); addEndToken(INTERNAL_IN_JS_MLC); return firstToken;
          }
        case 91: break;
        case 48:
          { int start = zzStartRead;
										int operatorLen = yycharat(0)=='+' ? 2 : 1;
										int yylen = yylength(); // Cache before first addToken() invalidates it
										//System.out.println("'" + yytext() + "': " + yylength() + ", " + (operatorLen+1));
										addToken(zzStartRead,zzStartRead+operatorLen-1, Token.OPERATOR);
										if (yylen>operatorLen+1) {
											//System.out.println((start+operatorLen) + ", " + (zzMarkedPos-2));
											addToken(start+operatorLen,zzMarkedPos-2, Token.WHITESPACE);
										}
										zzStartRead = zzCurrentPos = zzMarkedPos = zzMarkedPos - 1;
										if (isE4xSupported()) {
											// Scanning will continue with "<" as markup tag start
											yybegin(E4X, LANG_INDEX_E4X);
										}
										// Found e4x (or syntax error) but option not enabled;
										// Scanning will continue at "<" as operator
          }
        case 92: break;
        case 73:
          { addToken(Token.FUNCTION);
          }
        case 93: break;
        case 56:
          { int temp=zzStartRead; addToken(start,zzStartRead-1, Token.COMMENT_DOCUMENTATION); addToken(temp,zzMarkedPos-1, Token.COMMENT_MARKUP); start = zzMarkedPos;
          }
        case 94: break;
        case 61:
          { addToken(start, zzStartRead - 1, Token.LITERAL_BACKQUOTE);
								start = zzMarkedPos-2;
								if (varDepths==null) {
									varDepths = new Stack<Boolean>();
								}
								else {
									varDepths.clear();
								}
								varDepths.push(Boolean.TRUE);
								yybegin(JS_TEMPLATE_LITERAL_EXPR);
          }
        case 95: break;
        case 37:
          { if (validJSString) {
									addToken(start, zzStartRead - 1, Token.LITERAL_BACKQUOTE);
									addEndToken(INTERNAL_IN_JS_TEMPLATE_LITERAL_VALID);
								}
								else {
									addToken(start,zzStartRead - 1, Token.ERROR_STRING_DOUBLE);
									addEndToken(INTERNAL_IN_JS_TEMPLATE_LITERAL_INVALID);
								}
								return firstToken;
          }
        case 96: break;
        case 39:
          { /* Skip valid '$' that is not part of template literal expression start */
          }
        case 97: break;
        case 11:
          { start = zzMarkedPos-1; validJSString = true; yybegin(JS_TEMPLATE_LITERAL);
          }
        case 98: break;
        case 51:
          { /* Skip all escaped chars. */
          }
        case 99: break;
        case 12:
          { addToken(start,zzStartRead-1, Token.ERROR_STRING_DOUBLE); addNullToken(); return firstToken;
          }
        case 100: break;
        case 78:
          { start = zzStartRead; e4x_prevState = zzLexicalState; yybegin(E4X_COMMENT);
          }
        case 101: break;
        case 69:
          { int temp=zzStartRead; yybegin(E4X); addToken(start,zzStartRead-1, Token.MARKUP_CDATA); addToken(temp,zzMarkedPos-1, Token.MARKUP_CDATA_DELIMITER);
          }
        case 102: break;
        case 62:
          { varDepths.push(Boolean.TRUE);
          }
        case 103: break;
        case 67:
          { int count = yylength();
									addToken(zzStartRead,zzStartRead+1, Token.MARKUP_TAG_DELIMITER);
									addToken(zzMarkedPos-(count-2), zzMarkedPos-1, Token.MARKUP_TAG_NAME);
									yybegin(E4X_INTAG);
          }
        case 104: break;
        case 53:
          { /* Invalid latin-1 character \xXX */ validJSString = false;
          }
        case 105: break;
        case 70:
          { addToken(Token.COMMENT_MULTILINE);
          }
        case 106: break;
        case 59:
          { start = zzMarkedPos-2; yybegin(E4X_PI);
          }
        case 107: break;
        case 36:
          { yybegin(E4X_INTAG); addToken(start,zzStartRead, Token.MARKUP_TAG_ATTRIBUTE_VALUE);
          }
        case 108: break;
        case 14:
          { int type = validJSString ? Token.LITERAL_STRING_DOUBLE_QUOTE : Token.ERROR_STRING_DOUBLE; addToken(start,zzStartRead, type); yybegin(YYINITIAL);
          }
        case 109: break;
        case 20:
          { addToken(start,zzStartRead-1, Token.COMMENT_EOL); addNullToken(); return firstToken;
          }
        case 110: break;
        case 24:
          { yybegin(YYINITIAL, LANG_INDEX_DEFAULT); addToken(Token.IDENTIFIER);
          }
        case 111: break;
        case 52:
          { /* Invalid Unicode character \\uXXXX */ validJSString = false;
          }
        case 112: break;
        case 80:
          { int temp = zzStartRead; addToken(start,zzStartRead-1, Token.MARKUP_DTD); start = temp; e4x_prevState = zzLexicalState; yybegin(E4X_COMMENT);
          }
        case 113: break;
        case 72:
          { if(e4xSupported){ addToken(Token.RESERVED_WORD);} else {addToken(Token.IDENTIFIER);}
          }
        case 114: break;
        case 68:
          { int temp = zzMarkedPos; addToken(start,zzStartRead+2, Token.MARKUP_COMMENT); start = temp; yybegin(e4x_prevState);
          }
        case 115: break;
        case 7:
          { addToken(Token.OPERATOR);
          }
        case 116: break;
        case 60:
          { yybegin(E4X); addToken(start,zzStartRead+1, Token.MARKUP_PROCESSING_INSTRUCTION);
          }
        case 117: break;
        case 55:
          { yybegin(YYINITIAL); addToken(start,zzStartRead+1, Token.COMMENT_DOCUMENTATION);
          }
        case 118: break;
        case 19:
          { addToken(start,zzStartRead-1, Token.COMMENT_DOCUMENTATION); addEndToken(INTERNAL_IN_JS_COMMENT_DOCUMENTATION); return firstToken;
          }
        case 119: break;
        case 26:
          { addToken(start,zzStartRead-1, Token.MARKUP_PROCESSING_INSTRUCTION); addEndToken(INTERNAL_E4X_MARKUP_PROCESSING_INSTRUCTION); return firstToken;
          }
        case 120: break;
        case 5:
          { addToken(Token.IDENTIFIER);
          }
        case 121: break;
        case 74:
          { int temp=zzStartRead; addToken(start,zzStartRead-1, Token.COMMENT_MULTILINE); addHyperlinkToken(temp,zzMarkedPos-1, Token.COMMENT_MULTILINE); start = zzMarkedPos;
          }
        case 122: break;
        case 49:
          { addToken(isE4xSupported() ? Token.MARKUP_TAG_ATTRIBUTE : Token.ERROR_IDENTIFIER);
          }
        case 123: break;
        case 77:
          { int temp=zzStartRead; addToken(start,zzStartRead-1, Token.COMMENT_EOL); addHyperlinkToken(temp,zzMarkedPos-1, Token.COMMENT_EOL); start = zzMarkedPos;
          }
        case 124: break;
        case 64:
          { start = zzMarkedPos-3; yybegin(JS_DOCCOMMENT);
          }
        case 125: break;
        case 9:
          { start = zzMarkedPos-1; validJSString = true; yybegin(JS_STRING);
          }
        case 126: break;
        case 58:
          { start = zzMarkedPos-2; e4x_inInternalDtd = false; yybegin(E4X_DTD);
          }
        case 127: break;
        case 38:
          { if (validJSString) {
									addToken(start,zzStartRead, Token.LITERAL_BACKQUOTE);
									addEndToken(INTERNAL_IN_JS_TEMPLATE_LITERAL_VALID);
								}
								else {
									addToken(start,zzStartRead, Token.ERROR_STRING_DOUBLE);
									addEndToken(INTERNAL_IN_JS_TEMPLATE_LITERAL_INVALID);
								}
								return firstToken;
          }
        case 128: break;
        case 25:
          { addToken(start,zzStartRead-1, Token.MARKUP_COMMENT); addEndToken(INTERNAL_IN_E4X_COMMENT - e4x_prevState); return firstToken;
          }
        case 129: break;
        case 10:
          { start = zzMarkedPos-1; validJSString = true; yybegin(JS_CHAR);
          }
        case 130: break;
        case 29:
          { e4x_inInternalDtd = true;
          }
        case 131: break;
        case 76:
          { int temp=zzStartRead; addToken(start,zzStartRead-1, Token.COMMENT_DOCUMENTATION); addHyperlinkToken(temp,zzMarkedPos-1, Token.COMMENT_DOCUMENTATION); start = zzMarkedPos;
          }
        case 132: break;
        case 47:
          { start = zzMarkedPos-2; yybegin(JS_MLC);
          }
        case 133: break;
        case 45:
          { addToken(Token.LITERAL_NUMBER_HEXADECIMAL);
          }
        case 134: break;
        case 82:
          { addToken(Token.MARKUP_CDATA_DELIMITER); start = zzMarkedPos; yybegin(E4X_CDATA);
          }
        case 135: break;
        case 32:
          { addToken(Token.MARKUP_TAG_DELIMITER); /* Not valid but we'll still accept it */
          }
        case 136: break;
        case 2:
          { addToken(Token.ERROR_IDENTIFIER);
          }
        case 137: break;
        case 79:
          { int temp=zzStartRead; addToken(start,zzStartRead-1, Token.MARKUP_COMMENT); addHyperlinkToken(temp,zzMarkedPos-1, Token.MARKUP_COMMENT); start = zzMarkedPos;
          }
        case 138: break;
        case 33:
          { yybegin(E4X); addToken(Token.MARKUP_TAG_DELIMITER);
          }
        case 139: break;
        case 23:
          { addToken(Token.MARKUP_ENTITY_REFERENCE);
          }
        case 140: break;
        case 65:
          { if(isJavaScriptCompatible("1.7")){ addToken(Token.RESERVED_WORD);} else {addToken(Token.IDENTIFIER);}
          }
        case 141: break;
        case 71:
          { addToken(Token.LITERAL_BOOLEAN);
          }
        case 142: break;
        case 42:
          { if (!varDepths.empty()) {
								varDepths.pop();
								if (varDepths.empty()) {
									addToken(start,zzStartRead, Token.VARIABLE);
									start = zzMarkedPos;
									yybegin(JS_TEMPLATE_LITERAL);
								}
							}
          }
        case 143: break;
        case 4:
          { addNullToken(); return firstToken;
          }
        case 144: break;
        case 50:
          { addToken(Token.RESERVED_WORD);
          }
        case 145: break;
        case 54:
          { yybegin(YYINITIAL); addToken(start,zzStartRead+1, Token.COMMENT_MULTILINE);
          }
        case 146: break;
        case 66:
          { addToken(Token.DATA_TYPE);
          }
        case 147: break;
        case 22:
          { addToken(Token.MARKUP_TAG_DELIMITER); yybegin(E4X_INTAG);
          }
        case 148: break;
        case 8:
          { addToken(Token.SEPARATOR);
          }
        case 149: break;
        case 31:
          { addToken(Token.MARKUP_TAG_ATTRIBUTE);
          }
        case 150: break;
        case 75:
          { int temp=zzStartRead; addToken(start,zzStartRead-1, Token.COMMENT_DOCUMENTATION); addToken(temp,zzMarkedPos-1, Token.COMMENT_KEYWORD); start = zzMarkedPos;
          }
        case 151: break;
        case 17:
          { int type = validJSString ? Token.LITERAL_CHAR : Token.ERROR_CHAR; addToken(start,zzStartRead, type); yybegin(YYINITIAL);
          }
        case 152: break;
        case 46:
          { start = zzMarkedPos-2; yybegin(JS_EOL_COMMENT);
          }
        case 153: break;
        case 21:
          { addEndToken(INTERNAL_E4X); return firstToken;
          }
        case 154: break;
        case 13:
          { /* Line ending in '\' => continue to next line. */
								if (validJSString) {
									addToken(start,zzStartRead, Token.LITERAL_STRING_DOUBLE_QUOTE);
									addEndToken(INTERNAL_IN_JS_STRING_VALID);
								}
								else {
									addToken(start,zzStartRead, Token.ERROR_STRING_DOUBLE);
									addEndToken(INTERNAL_IN_JS_STRING_INVALID);
								}
								return firstToken;
          }
        case 155: break;
        case 44:
          { addToken(Token.LITERAL_NUMBER_FLOAT);
          }
        case 156: break;
        case 57:
          { int count = yylength();
									addToken(zzStartRead,zzStartRead, Token.MARKUP_TAG_DELIMITER);
									addToken(zzMarkedPos-(count-1), zzMarkedPos-1, Token.MARKUP_TAG_NAME);
									yybegin(E4X_INTAG);
          }
        case 157: break;
        case 63:
          { boolean highlightedAsRegex = false;
										if (firstToken==null) {
											addToken(Token.REGEX);
											highlightedAsRegex = true;
										}
										else {
											// If this is *likely* to be a regex, based on
											// the previous token, highlight it as such.
											Token t = firstToken.getLastNonCommentNonWhitespaceToken();
											if (RSyntaxUtilities.regexCanFollowInJavaScript(t)) {
												addToken(Token.REGEX);
												highlightedAsRegex = true;
											}
										}
										// If it doesn't *appear* to be a regex, highlight it as
										// individual tokens.
										if (!highlightedAsRegex) {
											int temp = zzStartRead + 1;
											addToken(zzStartRead, zzStartRead, Token.OPERATOR);
											zzStartRead = zzCurrentPos = zzMarkedPos = temp;
										}
          }
        case 158: break;
        case 28:
          { if (!e4x_inInternalDtd) { yybegin(E4X); addToken(start,zzStartRead, Token.MARKUP_DTD); }
          }
        case 159: break;
        case 6:
          { addToken(Token.LITERAL_NUMBER_DECIMAL_INT);
          }
        case 160: break;
        case 30:
          { e4x_inInternalDtd = false;
          }
        case 161: break;
        case 15:
          { addToken(start,zzStartRead-1, Token.ERROR_CHAR); addNullToken(); return firstToken;
          }
        case 162: break;
        case 41:
          { // TODO: This isn't right.  The expression and its depth should continue to the next line.
							addToken(start,zzStartRead-1, Token.VARIABLE); addEndToken(INTERNAL_IN_JS_TEMPLATE_LITERAL_INVALID); return firstToken;
          }
        case 163: break;
        case 1:
          {
          }
        case 164: break;
        default:
          if (zzInput == YYEOF && zzStartRead == zzCurrentPos) {
            zzAtEOF = true;
            switch (zzLexicalState) {
            case JS_STRING: {
              addToken(start,zzStartRead-1, Token.ERROR_STRING_DOUBLE); addNullToken(); return firstToken;
            }
            case 635: break;
            case E4X: {
              addEndToken(INTERNAL_E4X); return firstToken;
            }
            case 636: break;
            case E4X_INTAG: {
              addToken(start,zzStartRead-1, INTERNAL_E4X_INTAG); return firstToken;
            }
            case 637: break;
            case E4X_PI: {
              addToken(start,zzStartRead-1, Token.MARKUP_PROCESSING_INSTRUCTION); addEndToken(INTERNAL_E4X_MARKUP_PROCESSING_INSTRUCTION); return firstToken;
            }
            case 638: break;
            case JS_MLC: {
              addToken(start,zzStartRead-1, Token.COMMENT_MULTILINE); addEndToken(INTERNAL_IN_JS_MLC); return firstToken;
            }
            case 639: break;
            case JS_CHAR: {
              addToken(start,zzStartRead-1, Token.ERROR_CHAR); addNullToken(); return firstToken;
            }
            case 640: break;
            case JS_EOL_COMMENT: {
              addToken(start,zzStartRead-1, Token.COMMENT_EOL); addNullToken(); return firstToken;
            }
            case 641: break;
            case E4X_COMMENT: {
              addToken(start,zzStartRead-1, Token.MARKUP_COMMENT); addEndToken(INTERNAL_IN_E4X_COMMENT - e4x_prevState); return firstToken;
            }
            case 642: break;
            case JS_DOCCOMMENT: {
              yybegin(YYINITIAL); addToken(start,zzEndRead, Token.COMMENT_DOCUMENTATION); addEndToken(INTERNAL_IN_JS_COMMENT_DOCUMENTATION); return firstToken;
            }
            case 643: break;
            case E4X_DTD: {
              addToken(start,zzStartRead-1, Token.MARKUP_DTD); addEndToken(e4x_inInternalDtd ? INTERNAL_E4X_DTD_INTERNAL : INTERNAL_E4X_DTD); return firstToken;
            }
            case 644: break;
            case JS_TEMPLATE_LITERAL: {
              if (validJSString) {
									addToken(start, zzStartRead - 1, Token.LITERAL_BACKQUOTE);
									addEndToken(INTERNAL_IN_JS_TEMPLATE_LITERAL_VALID);
								}
								else {
									addToken(start,zzStartRead - 1, Token.ERROR_STRING_DOUBLE);
									addEndToken(INTERNAL_IN_JS_TEMPLATE_LITERAL_INVALID);
								}
								return firstToken;
            }
            case 645: break;
            case E4X_INATTR_SINGLE: {
              addToken(start,zzStartRead-1, Token.MARKUP_TAG_ATTRIBUTE_VALUE); addEndToken(INTERNAL_E4X_ATTR_SINGLE); return firstToken;
            }
            case 646: break;
            case E4X_INATTR_DOUBLE: {
              addToken(start,zzStartRead-1, Token.MARKUP_TAG_ATTRIBUTE_VALUE); addEndToken(INTERNAL_E4X_ATTR_DOUBLE); return firstToken;
            }
            case 647: break;
            case JS_TEMPLATE_LITERAL_EXPR: {
              // TODO: This isn't right.  The expression and its depth should continue to the next line.
							addToken(start,zzStartRead-1, Token.VARIABLE); addEndToken(INTERNAL_IN_JS_TEMPLATE_LITERAL_INVALID); return firstToken;
            }
            case 648: break;
            case YYINITIAL: {
              addNullToken(); return firstToken;
            }
            case 649: break;
            case E4X_CDATA: {
              addToken(start,zzStartRead-1, Token.MARKUP_CDATA); addEndToken(INTERNAL_E4X_MARKUP_CDATA); return firstToken;
            }
            case 650: break;
            default:
            return null;
            }
          }
          else {
            zzScanError(ZZ_NO_MATCH);
          }
      }
    }
  }


}
