/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.parquetio.splitter;

import com.exasol.errorreporting.ExaError;
import com.exasol.parquetio.data.ChunkInterval;
import com.exasol.parquetio.data.ChunkIntervalImpl;
import com.exasol.parquetio.splitter.FileSplitter;
import java.util.ArrayList;
import java.util.List;
import org.apache.parquet.hadoop.ParquetFileReader;
import org.apache.parquet.hadoop.metadata.BlockMetaData;
import org.apache.parquet.io.InputFile;

public class ParquetFileSplitter
implements FileSplitter {
    private static final long DEFAULT_CHUNK_SIZE = 0x4000000L;
    private final InputFile file;
    private final long chunkSize;

    public ParquetFileSplitter(InputFile file) {
        this(file, 0x4000000L);
    }

    public ParquetFileSplitter(InputFile file, long chunkSize) {
        this.file = file;
        this.chunkSize = chunkSize;
    }

    @Override
    public List<ChunkInterval> getSplits() {
        List<ChunkInterval> list;
        block8: {
            ParquetFileReader reader = ParquetFileReader.open((InputFile)this.file);
            try {
                list = this.getRowGroupSplits(reader.getRowGroups());
                if (reader == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception exception) {
                    throw new IllegalStateException(ExaError.messageBuilder((String)"E-PIOJ-4").message("Failed to open a Parquet file {{FILE}} for splitting.", new Object[]{this.file.toString()}).toString(), exception);
                }
            }
            reader.close();
        }
        return list;
    }

    protected List<ChunkInterval> getRowGroupSplits(List<BlockMetaData> rowGroups) {
        ArrayList<ChunkInterval> chunks = new ArrayList<ChunkInterval>();
        long end = rowGroups.size();
        long startPosition = 0L;
        long currentSize = 0L;
        int endPosition = 0;
        while ((long)endPosition < end) {
            if ((currentSize += rowGroups.get(endPosition).getTotalByteSize()) >= this.chunkSize) {
                chunks.add(new ChunkIntervalImpl(startPosition, (long)endPosition + 1L));
                startPosition = (long)endPosition + 1L;
                currentSize = 0L;
            }
            ++endPosition;
        }
        if (currentSize != 0L) {
            chunks.add(new ChunkIntervalImpl(startPosition, end));
        }
        return chunks;
    }
}

