/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.parquetio.merger;

import com.exasol.parquetio.data.ChunkInterval;
import com.exasol.parquetio.data.ChunkIntervalImpl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ChunkIntervalMerger {
    public List<ChunkInterval> sortAndMerge(List<ChunkInterval> chunks) {
        if (chunks == null || chunks.size() <= 1) {
            return chunks;
        }
        ArrayList<ChunkInterval> modifiableChunks = new ArrayList<ChunkInterval>(chunks);
        this.sortByStartPosition(modifiableChunks);
        return this.mergeOverlaps(modifiableChunks);
    }

    private void sortByStartPosition(List<ChunkInterval> chunks) {
        Collections.sort(chunks, (a, b) -> Long.compare(a.getStartPosition(), b.getStartPosition()));
    }

    private List<ChunkInterval> mergeOverlaps(List<ChunkInterval> chunks) {
        ArrayList<ChunkInterval> result = new ArrayList<ChunkInterval>();
        long startPosition = chunks.get(0).getStartPosition();
        long endPosition = chunks.get(0).getEndPosition();
        for (ChunkInterval chunk : chunks) {
            if (chunk.getStartPosition() <= endPosition) {
                endPosition = Math.max(endPosition, chunk.getEndPosition());
                continue;
            }
            result.add(new ChunkIntervalImpl(startPosition, endPosition));
            startPosition = chunk.getStartPosition();
            endPosition = chunk.getEndPosition();
        }
        result.add(new ChunkIntervalImpl(startPosition, endPosition));
        return result;
    }
}

