/*
 * Decompiled with CFR 0.152.
 */
package com.browseengine.bobo.index;

import com.browseengine.bobo.index.digest.DataDigester;
import java.io.IOException;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.store.Directory;
import org.apache.lucene.util.Version;

public class BoboIndexer {
    private Directory _index;
    private DataDigester _digester;
    private IndexWriter _writer;
    private Analyzer _analyzer;

    public void setAnalyzer(Analyzer analyzer) {
        this._analyzer = analyzer;
    }

    private Analyzer getAnalyzer() {
        return this._analyzer == null ? new StandardAnalyzer(Version.LUCENE_CURRENT) : this._analyzer;
    }

    public BoboIndexer(DataDigester digester, Directory index) {
        this._index = index;
        this._digester = digester;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void index() throws IOException {
        this._writer = null;
        try {
            this._writer = new IndexWriter(this._index, this.getAnalyzer(), IndexWriter.MaxFieldLength.UNLIMITED);
            MyDataHandler handler = new MyDataHandler(this._writer);
            this._digester.digest(handler);
            this._writer.optimize();
        }
        finally {
            if (this._writer != null) {
                this._writer.close();
            }
        }
    }

    private static class MyDataHandler
    implements DataDigester.DataHandler {
        private IndexWriter _writer;

        MyDataHandler(IndexWriter writer) {
            this._writer = writer;
        }

        @Override
        public void handleDocument(Document doc) throws IOException {
            this._writer.addDocument(doc);
        }
    }
}

