/*
 * Decompiled with CFR 0.152.
 */
package com.browseengine.bobo.facets.data;

import com.browseengine.bobo.facets.data.TermCharList;
import com.browseengine.bobo.facets.data.TermDateList;
import com.browseengine.bobo.facets.data.TermDoubleList;
import com.browseengine.bobo.facets.data.TermFloatList;
import com.browseengine.bobo.facets.data.TermIntList;
import com.browseengine.bobo.facets.data.TermListFactory;
import com.browseengine.bobo.facets.data.TermLongList;
import com.browseengine.bobo.facets.data.TermShortList;
import com.browseengine.bobo.facets.data.TermValueList;
import java.lang.reflect.Constructor;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class PredefinedTermListFactory<T>
implements TermListFactory<T> {
    private static Map<Class<?>, Class<? extends TermValueList<?>>> supportedTypes = new HashMap();
    private final Class<T> _cls;
    private final String _format;
    private final Class<? extends TermValueList<T>> _listClass;

    public PredefinedTermListFactory(Class<?> cls, String format) {
        if (supportedTypes.get(cls) == null) {
            throw new IllegalArgumentException("Class " + cls + " not defined.");
        }
        this._cls = cls;
        this._format = format;
        this._listClass = supportedTypes.get(this._cls);
    }

    public PredefinedTermListFactory(Class<?> cls) {
        this(cls, null);
    }

    @Override
    public TermValueList<T> createTermList() {
        if (TermCharList.class.equals(this._listClass)) {
            TermCharList retlist = new TermCharList();
            return retlist;
        }
        try {
            Constructor<TermValueList<T>> constructor = this._listClass.getConstructor(String.class);
            return constructor.newInstance(this._format);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    @Override
    public Class<T> getType() {
        return this._cls;
    }

    static {
        supportedTypes.put(Integer.TYPE, TermIntList.class);
        supportedTypes.put(Float.TYPE, TermFloatList.class);
        supportedTypes.put(Character.TYPE, TermCharList.class);
        supportedTypes.put(Double.TYPE, TermDoubleList.class);
        supportedTypes.put(Short.TYPE, TermShortList.class);
        supportedTypes.put(Long.TYPE, TermLongList.class);
        supportedTypes.put(Integer.class, TermIntList.class);
        supportedTypes.put(Float.class, TermFloatList.class);
        supportedTypes.put(Character.class, TermCharList.class);
        supportedTypes.put(Double.class, TermDoubleList.class);
        supportedTypes.put(Short.class, TermShortList.class);
        supportedTypes.put(Long.class, TermLongList.class);
        supportedTypes.put(Date.class, TermDateList.class);
    }
}

