/*
 * Decompiled with CFR 0.152.
 */
package com.box.sdk;

import com.box.sdk.Base64;
import com.box.sdk.internal.pool.MacPool;
import java.nio.charset.Charset;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class BoxWebHookSignatureVerifier {
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    private static final Set<String> SUPPORTED_VERSIONS = Collections.singleton("1");
    private static final Set<BoxSignatureAlgorithm> SUPPORTED_ALGORITHMS = Collections.unmodifiableSet(EnumSet.of(BoxSignatureAlgorithm.HMAC_SHA256));
    private static final MacPool MAC_POOL = new MacPool();
    private final String primarySignatureKey;
    private final String secondarySignatureKey;

    public BoxWebHookSignatureVerifier(String primarySignatureKey, String secondarySignatureKey) {
        if (primarySignatureKey == null && secondarySignatureKey == null) {
            throw new IllegalArgumentException("At least primary or secondary signature key must be provided!");
        }
        this.primarySignatureKey = primarySignatureKey;
        this.secondarySignatureKey = secondarySignatureKey;
    }

    public boolean verify(String signatureVersion, String signatureAlgorithm, String primarySignature, String secondarySignature, String webHookPayload, String deliveryTimestamp) {
        if (!SUPPORTED_VERSIONS.contains(signatureVersion)) {
            return false;
        }
        BoxSignatureAlgorithm algorithm = BoxSignatureAlgorithm.byName(signatureAlgorithm);
        if (!SUPPORTED_ALGORITHMS.contains((Object)algorithm)) {
            return false;
        }
        if (this.primarySignatureKey != null && this.verify(this.primarySignatureKey, algorithm, primarySignature, webHookPayload, deliveryTimestamp)) {
            return true;
        }
        return this.secondarySignatureKey != null && this.verify(this.secondarySignatureKey, algorithm, secondarySignature, webHookPayload, deliveryTimestamp);
    }

    private boolean verify(String key, BoxSignatureAlgorithm actualAlgorithm, String actualSignature, String webHookPayload, String deliveryTimestamp) {
        if (actualSignature == null) {
            return false;
        }
        byte[] actual = Base64.decode(actualSignature);
        byte[] expected = this.signRaw(actualAlgorithm, key, webHookPayload, deliveryTimestamp);
        return MessageDigest.isEqual(expected, actual);
    }

    public String sign(BoxSignatureAlgorithm algorithm, String key, String webHookPayload, String deliveryTimestamp) {
        return Base64.encode(this.signRaw(algorithm, key, webHookPayload, deliveryTimestamp));
    }

    private byte[] signRaw(BoxSignatureAlgorithm algorithm, String key, String webHookPayload, String deliveryTimestamp) {
        Mac mac = MAC_POOL.acquire(algorithm.javaProviderName);
        try {
            mac.init(new SecretKeySpec(key.getBytes(UTF_8), algorithm.javaProviderName));
            mac.update(UTF_8.encode(webHookPayload));
            mac.update(UTF_8.encode(deliveryTimestamp));
            byte[] byArray = mac.doFinal();
            return byArray;
        }
        catch (InvalidKeyException e) {
            throw new IllegalArgumentException("Invalid key: ", e);
        }
        finally {
            MAC_POOL.release(mac);
        }
    }

    public static enum BoxSignatureAlgorithm {
        HMAC_SHA256("HmacSHA256", "HmacSHA256");

        private static final Map<String, BoxSignatureAlgorithm> ALGORITHM_BY_NAME;
        private final String name;
        private final String javaProviderName;

        private BoxSignatureAlgorithm(String name, String javaProviderName) {
            this.name = javaProviderName;
            this.javaProviderName = javaProviderName;
        }

        private static BoxSignatureAlgorithm byName(String name) {
            return ALGORITHM_BY_NAME.get(name);
        }

        static {
            ConcurrentHashMap<String, BoxSignatureAlgorithm> algorithmByName = new ConcurrentHashMap<String, BoxSignatureAlgorithm>();
            for (BoxSignatureAlgorithm algorithm : BoxSignatureAlgorithm.values()) {
                algorithmByName.put(algorithm.name, algorithm);
            }
            ALGORITHM_BY_NAME = Collections.unmodifiableMap(algorithmByName);
        }
    }
}

