/*
 * Decompiled with CFR 0.152.
 */
package com.azure.xml.implementation.aalto.out;

import com.azure.xml.implementation.aalto.impl.ErrorConsts;
import com.azure.xml.implementation.aalto.impl.LocationImpl;
import com.azure.xml.implementation.aalto.impl.StreamExceptionBase;
import com.azure.xml.implementation.aalto.out.OutputElement;
import com.azure.xml.implementation.aalto.out.WName;
import com.azure.xml.implementation.aalto.out.WNameTable;
import com.azure.xml.implementation.aalto.out.WriterConfig;
import com.azure.xml.implementation.aalto.out.XmlWriter;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Iterator;
import javax.xml.namespace.NamespaceContext;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public final class StreamWriterBase
implements NamespaceContext,
XMLStreamWriter {
    private final WriterConfig _config;
    private NamespaceContext _rootNsContext;
    private final WNameTable _symbols;
    private final XmlWriter _xmlWriter;
    private State _state = State.PROLOG;
    private OutputElement _currElem = OutputElement.createRoot();
    private boolean _stateAnyOutput = false;
    private boolean _stateStartElementOpen = false;
    private boolean _stateEmptyElement = false;
    private final String _dtdRootElemName;
    private OutputElement _outputElemPool = null;
    static final int MAX_POOL_SIZE = 8;
    private int _poolSize = 0;

    public StreamWriterBase(WriterConfig cfg, XmlWriter writer, WNameTable symbols) {
        this._dtdRootElemName = null;
        this._config = cfg;
        this._xmlWriter = writer;
        this._symbols = symbols;
    }

    @Override
    public void close() throws XMLStreamException {
        this._finishDocument();
    }

    @Override
    public void flush() throws XMLStreamException {
        try {
            this._xmlWriter.flush();
        }
        catch (IOException ie) {
            throw new StreamExceptionBase(ie);
        }
    }

    @Override
    public NamespaceContext getNamespaceContext() {
        return this;
    }

    @Override
    public Object getProperty(String name) {
        return this._config.getProperty(name, true);
    }

    @Override
    public void setDefaultNamespace(String uri) {
        this._currElem.setDefaultNsURI(uri);
    }

    @Override
    public void setNamespaceContext(NamespaceContext ctxt) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setPrefix(String prefix, String uri) throws XMLStreamException {
        if (prefix == null) {
            throw new NullPointerException();
        }
        if (prefix.isEmpty()) {
            this.setDefaultNamespace(uri);
            return;
        }
        if (uri == null) {
            throw new NullPointerException();
        }
        if (prefix.equals("xml")) {
            if (!uri.equals("http://www.w3.org/XML/1998/namespace")) {
                StreamWriterBase.throwOutputError(ErrorConsts.ERR_NS_REDECL_XML, uri);
            }
        } else if (prefix.equals("xmlns")) {
            if (!uri.equals("http://www.w3.org/2000/xmlns/")) {
                StreamWriterBase.throwOutputError(ErrorConsts.ERR_NS_REDECL_XMLNS, uri);
            }
        } else if (uri.equals("http://www.w3.org/XML/1998/namespace")) {
            StreamWriterBase.throwOutputError(ErrorConsts.ERR_NS_REDECL_XML_URI, prefix);
        } else if (uri.equals("http://www.w3.org/2000/xmlns/")) {
            StreamWriterBase.throwOutputError(ErrorConsts.ERR_NS_REDECL_XMLNS_URI, prefix);
        }
        if (uri.isEmpty()) {
            StreamWriterBase.throwOutputError(ErrorConsts.ERR_NS_EMPTY);
        }
        this._setPrefix(prefix, uri);
    }

    public void _setPrefix(String prefix, String uri) {
        this._currElem.addPrefix(prefix, uri);
    }

    @Override
    public void writeAttribute(String localName, String value) throws XMLStreamException {
        if (!this._stateStartElementOpen) {
            StreamWriterBase.throwOutputError(ErrorConsts.WERR_ATTR_NO_ELEM);
        }
        this._writeAttribute(this._symbols.findSymbol(localName), value);
    }

    @Override
    public void writeAttribute(String nsURI, String localName, String value) throws XMLStreamException {
        WName name;
        if (!this._stateStartElementOpen) {
            StreamWriterBase.throwOutputError(ErrorConsts.WERR_ATTR_NO_ELEM);
        }
        if (nsURI == null || nsURI.isEmpty()) {
            name = this._symbols.findSymbol(localName);
        } else {
            String prefix = this._currElem.getExplicitPrefix(nsURI, this._rootNsContext);
            if (prefix == null) {
                StreamWriterBase.throwOutputError("Unbound namespace URI '" + nsURI + "'");
            }
            name = this._symbols.findSymbol(prefix, localName);
        }
        this._writeAttribute(name, value);
    }

    @Override
    public void writeAttribute(String prefix, String nsURI, String localName, String value) throws XMLStreamException {
        if (!this._stateStartElementOpen) {
            StreamWriterBase.throwOutputError(ErrorConsts.WERR_ATTR_NO_ELEM);
        }
        WName name = prefix == null || prefix.isEmpty() ? this._symbols.findSymbol(localName) : this._symbols.findSymbol(prefix, localName);
        this._writeAttribute(name, value);
    }

    @Override
    public void writeCData(String data) throws XMLStreamException {
        this._verifyWriteCData();
        try {
            int ix = this._xmlWriter.writeCData(data);
            if (ix >= 0) {
                StreamWriterBase._reportNwfContent(ErrorConsts.WERR_CDATA_CONTENT, ix);
            }
        }
        catch (IOException ioe) {
            throw new StreamExceptionBase(ioe);
        }
    }

    @Override
    public void writeCharacters(char[] text, int start, int len) throws XMLStreamException {
        this._stateAnyOutput = true;
        if (this._stateStartElementOpen) {
            this._closeStartElement(this._stateEmptyElement);
        }
        if (this.inPrologOrEpilog()) {
            this.writeSpace(text, start, len);
            return;
        }
        if (len > 0) {
            try {
                this._xmlWriter.writeCharacters(text, start, len);
            }
            catch (IOException ioe) {
                throw new StreamExceptionBase(ioe);
            }
        }
    }

    @Override
    public void writeCharacters(String text) throws XMLStreamException {
        this._stateAnyOutput = true;
        if (this._stateStartElementOpen) {
            this._closeStartElement(this._stateEmptyElement);
        }
        if (this.inPrologOrEpilog()) {
            this.writeSpace(text);
            return;
        }
        try {
            this._xmlWriter.writeCharacters(text);
        }
        catch (IOException ioe) {
            throw new StreamExceptionBase(ioe);
        }
    }

    @Override
    public void writeComment(String data) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void writeDefaultNamespace(String nsURI) throws XMLStreamException {
        if (!this._stateStartElementOpen) {
            StreamWriterBase.throwOutputError(ErrorConsts.WERR_NS_NO_ELEM);
        }
        this._writeDefaultNamespace(nsURI);
        this.setDefaultNamespace(nsURI);
    }

    @Override
    public void writeDTD(String dtd) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void writeEmptyElement(String localName) throws XMLStreamException {
        this._verifyStartElement(null, localName);
        WName name = this._symbols.findSymbol(localName);
        this._writeStartTag(name, true);
    }

    @Override
    public void writeEmptyElement(String nsURI, String localName) throws XMLStreamException {
        WName name;
        String prefix = this._currElem.getPrefix(nsURI);
        if (prefix == null) {
            StreamWriterBase.throwOutputError("Unbound namespace URI '" + nsURI + "'");
        }
        if (prefix.isEmpty()) {
            name = this._symbols.findSymbol(localName);
            prefix = null;
        } else {
            name = this._symbols.findSymbol(prefix, localName);
        }
        this._verifyStartElement(prefix, localName);
        this._writeStartTag(name, true, nsURI);
    }

    @Override
    public void writeEmptyElement(String prefix, String localName, String nsURI) throws XMLStreamException {
        this._verifyStartElement(prefix, localName);
        WName name = prefix == null || prefix.isEmpty() ? this._symbols.findSymbol(localName) : this._symbols.findSymbol(prefix, localName);
        this._writeStartTag(name, true, nsURI);
    }

    @Override
    public void writeEndDocument() throws XMLStreamException {
        this._finishDocument();
    }

    @Override
    public void writeEndElement() throws XMLStreamException {
        if (this._stateStartElementOpen && this._stateEmptyElement) {
            this._stateEmptyElement = false;
            this._closeStartElement(true);
        }
        if (this._state != State.TREE) {
            StreamWriterBase._reportNwfStructure("No open start element, when trying to write end element");
        }
        OutputElement thisElem = this._currElem;
        this._currElem = thisElem.getParent();
        if (this._poolSize < 8) {
            thisElem.addToPool(this._outputElemPool);
            this._outputElemPool = thisElem;
            ++this._poolSize;
        }
        try {
            if (this._stateStartElementOpen) {
                this._stateStartElementOpen = false;
                this._xmlWriter.writeStartTagEmptyEnd();
            } else {
                this._xmlWriter.writeEndTag(thisElem.getName());
            }
        }
        catch (IOException ioe) {
            throw new StreamExceptionBase(ioe);
        }
        if (this._currElem.isRoot()) {
            this._state = State.EPILOG;
        }
    }

    @Override
    public void writeEntityRef(String name) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void writeNamespace(String prefix, String nsURI) throws XMLStreamException {
        if (prefix == null || prefix.isEmpty()) {
            this.writeDefaultNamespace(nsURI);
            return;
        }
        if (!this._stateStartElementOpen) {
            StreamWriterBase.throwOutputError(ErrorConsts.WERR_NS_NO_ELEM);
        }
        this._writeNamespace(prefix, nsURI);
        this.setPrefix(prefix, nsURI);
    }

    @Override
    public void writeProcessingInstruction(String target) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void writeProcessingInstruction(String target, String data) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void writeStartDocument() throws XMLStreamException {
        String enc = this._config.getActualEncoding();
        if (enc == null) {
            enc = "UTF-8";
            this._config.setActualEncodingIfNotSet(enc);
        }
        this._writeStartDocument("1.0", enc);
    }

    @Override
    public void writeStartDocument(String version) throws XMLStreamException {
        this._writeStartDocument(version, this._config.getActualEncoding());
    }

    @Override
    public void writeStartDocument(String encoding, String version) throws XMLStreamException {
        this._writeStartDocument(version, encoding);
    }

    @Override
    public void writeStartElement(String localName) throws XMLStreamException {
        this._verifyStartElement(null, localName);
        WName name = this._symbols.findSymbol(localName);
        this._writeStartTag(name, false);
    }

    @Override
    public void writeStartElement(String nsURI, String localName) throws XMLStreamException {
        WName name;
        String prefix = this._currElem.getPrefix(nsURI);
        if (prefix == null) {
            StreamWriterBase.throwOutputError("Unbound namespace URI '" + nsURI + "'");
        }
        if (prefix.isEmpty()) {
            name = this._symbols.findSymbol(localName);
            prefix = null;
        } else {
            name = this._symbols.findSymbol(prefix, localName);
        }
        this._verifyStartElement(prefix, localName);
        this._writeStartTag(name, false);
    }

    @Override
    public void writeStartElement(String prefix, String localName, String nsURI) throws XMLStreamException {
        this._verifyStartElement(prefix, localName);
        WName name = prefix == null || prefix.isEmpty() ? this._symbols.findSymbol(localName) : this._symbols.findSymbol(prefix, localName);
        this._writeStartTag(name, false, nsURI);
    }

    @Override
    public String getNamespaceURI(String prefix) {
        String uri = this._currElem.getNamespaceURI(prefix);
        if (uri == null && this._rootNsContext != null) {
            uri = this._rootNsContext.getNamespaceURI(prefix);
        }
        return uri;
    }

    @Override
    public String getPrefix(String uri) {
        String prefix = this._currElem.getPrefix(uri);
        if (prefix == null && this._rootNsContext != null) {
            prefix = this._rootNsContext.getPrefix(uri);
        }
        return prefix;
    }

    @Override
    public Iterator<String> getPrefixes(String uri) {
        return this._currElem.getPrefixes(uri, this._rootNsContext);
    }

    public void writeSpace(String text) throws XMLStreamException {
        try {
            this._xmlWriter.writeSpace(text);
        }
        catch (IOException ioe) {
            throw new StreamExceptionBase(ioe);
        }
    }

    public void writeSpace(char[] cbuf, int offset, int len) throws XMLStreamException {
        try {
            this._xmlWriter.writeSpace(cbuf, offset, len);
        }
        catch (IOException ioe) {
            throw new StreamExceptionBase(ioe);
        }
    }

    public Location getLocation() {
        return new LocationImpl(this._xmlWriter.getAbsOffset(), this._xmlWriter.getRow(), this._xmlWriter.getColumn());
    }

    private void _closeStartElement(boolean emptyElem) throws XMLStreamException {
        this._stateStartElementOpen = false;
        try {
            if (emptyElem) {
                this._xmlWriter.writeStartTagEmptyEnd();
            } else {
                this._xmlWriter.writeStartTagEnd();
            }
        }
        catch (IOException ioe) {
            throw new StreamExceptionBase(ioe);
        }
        if (emptyElem) {
            OutputElement thisElem = this._currElem;
            this._currElem = thisElem.getParent();
            if (this._currElem.isRoot()) {
                this._state = State.EPILOG;
            }
            if (this._poolSize < 8) {
                thisElem.addToPool(this._outputElemPool);
                this._outputElemPool = thisElem;
                ++this._poolSize;
            }
        }
    }

    private boolean inPrologOrEpilog() {
        return this._state != State.TREE;
    }

    private void _writeAttribute(WName name, String value) throws XMLStreamException {
        try {
            this._xmlWriter.writeAttribute(name, value);
        }
        catch (IOException ioe) {
            throw new StreamExceptionBase(ioe);
        }
    }

    private void _writeDefaultNamespace(String uri) throws XMLStreamException {
        WName name = this._symbols.findSymbol("xmlns");
        try {
            this._xmlWriter.writeAttribute(name, uri);
        }
        catch (IOException ioe) {
            throw new StreamExceptionBase(ioe);
        }
    }

    private void _writeNamespace(String prefix, String uri) throws XMLStreamException {
        WName name = this._symbols.findSymbol("xmlns", prefix);
        try {
            this._xmlWriter.writeAttribute(name, uri);
        }
        catch (IOException ioe) {
            throw new StreamExceptionBase(ioe);
        }
    }

    private void _writeStartDocument(String version, String encoding) throws XMLStreamException {
        if (this._stateAnyOutput) {
            StreamWriterBase._reportNwfStructure(ErrorConsts.WERR_DUP_XML_DECL);
        }
        this._stateAnyOutput = true;
        if (!(version == null || version.isEmpty() || version.equals("1.0") || version.equals("1.1"))) {
            StreamWriterBase._reportNwfContent("Illegal version argument ('" + version + "'); should only use '" + "1.0" + "' or '" + "1.1" + "'");
        }
        if (version == null || version.isEmpty()) {
            version = "1.0";
        }
        if ("1.1".equals(version)) {
            this._xmlWriter.enableXml11();
        }
        if (encoding != null && !encoding.isEmpty()) {
            this._config.setActualEncodingIfNotSet(encoding);
        }
        try {
            this._xmlWriter.writeXmlDeclaration(version, encoding, null);
        }
        catch (IOException ioe) {
            throw new StreamExceptionBase(ioe);
        }
    }

    private void _writeStartTag(WName name, boolean isEmpty) throws XMLStreamException {
        this._stateAnyOutput = true;
        this._stateStartElementOpen = true;
        if (this._outputElemPool != null) {
            OutputElement newCurr = this._outputElemPool;
            this._outputElemPool = newCurr.reuseAsChild(this._currElem, name);
            --this._poolSize;
            this._currElem = newCurr;
        } else {
            this._currElem = this._currElem.createChild(name);
        }
        try {
            this._xmlWriter.writeStartTagStart(name);
        }
        catch (IOException ioe) {
            throw new StreamExceptionBase(ioe);
        }
        this._stateEmptyElement = isEmpty;
    }

    private void _writeStartTag(WName name, boolean isEmpty, String uri) throws XMLStreamException {
        this._stateAnyOutput = true;
        this._stateStartElementOpen = true;
        if (uri == null) {
            uri = "";
        }
        if (this._outputElemPool != null) {
            OutputElement newCurr = this._outputElemPool;
            this._outputElemPool = newCurr.reuseAsChild(this._currElem, name, uri);
            --this._poolSize;
            this._currElem = newCurr;
        } else {
            this._currElem = this._currElem.createChild(name, uri);
        }
        try {
            this._xmlWriter.writeStartTagStart(name);
        }
        catch (IOException ioe) {
            throw new StreamExceptionBase(ioe);
        }
        this._stateEmptyElement = isEmpty;
    }

    private void _verifyStartElement(String prefix, String localName) throws XMLStreamException {
        if (this._stateStartElementOpen) {
            this._closeStartElement(this._stateEmptyElement);
        } else if (this._state == State.PROLOG) {
            this._verifyRootElement();
        } else if (this._state == State.EPILOG) {
            String name = prefix == null ? localName : prefix + ":" + localName;
            StreamWriterBase._reportNwfStructure(ErrorConsts.WERR_PROLOG_SECOND_ROOT, name);
            this._state = State.TREE;
        }
    }

    private void _verifyWriteCData() throws XMLStreamException {
        this._stateAnyOutput = true;
        if (this._stateStartElementOpen) {
            this._closeStartElement(this._stateEmptyElement);
        }
        if (this.inPrologOrEpilog()) {
            StreamWriterBase._reportNwfStructure(ErrorConsts.WERR_PROLOG_CDATA);
        }
    }

    private void _verifyWriteDTD() throws XMLStreamException {
        if (this._state != State.PROLOG) {
            throw new XMLStreamException("Can not write DOCTYPE declaration (DTD) when not in prolog any more (state " + (Object)((Object)this._state) + "; start element(s) written)");
        }
        if (this._dtdRootElemName != null) {
            throw new XMLStreamException("Trying to write multiple DOCTYPE declarations");
        }
    }

    private void _verifyRootElement() {
        this._state = State.TREE;
    }

    private static void throwOutputError(String msg) throws XMLStreamException {
        throw new StreamExceptionBase(msg);
    }

    private static void throwOutputError(String format, Object arg) throws XMLStreamException {
        String msg = MessageFormat.format(format, arg);
        StreamWriterBase.throwOutputError(msg);
    }

    private static void _reportNwfStructure(String msg) throws XMLStreamException {
        StreamWriterBase.throwOutputError(msg);
    }

    private static void _reportNwfStructure(String msg, Object arg) throws XMLStreamException {
        StreamWriterBase.throwOutputError(msg, arg);
    }

    private static void _reportNwfContent(String msg) throws XMLStreamException {
        StreamWriterBase.throwOutputError(msg);
    }

    private static void _reportNwfContent(String msg, Object arg) throws XMLStreamException {
        StreamWriterBase.throwOutputError(msg, arg);
    }

    private void _finishDocument() throws XMLStreamException {
        if (this._state != State.EPILOG) {
            if (this._state == State.PROLOG) {
                StreamWriterBase._reportNwfStructure(ErrorConsts.WERR_PROLOG_NO_ROOT);
            }
            if (this._stateStartElementOpen) {
                this._closeStartElement(this._stateEmptyElement);
            }
            while (this._state != State.EPILOG) {
                this.writeEndElement();
            }
        }
        if (this._symbols.maybeDirty()) {
            this._symbols.mergeToParent();
        }
        try {
            this._xmlWriter.close(false);
        }
        catch (IOException ie) {
            throw new StreamExceptionBase(ie);
        }
    }

    public String toString() {
        return "[StreamWriter: " + this.getClass() + ", underlying outputter: " + (this._xmlWriter == null ? "NULL" : this._xmlWriter.toString());
    }

    protected static enum State {
        PROLOG,
        TREE,
        EPILOG;

    }
}

