/*
 * Decompiled with CFR 0.152.
 */
package com.azure.data.appconfiguration;

import com.azure.core.annotation.ServiceClientBuilder;
import com.azure.core.client.traits.ConfigurationTrait;
import com.azure.core.client.traits.ConnectionStringTrait;
import com.azure.core.client.traits.EndpointTrait;
import com.azure.core.client.traits.HttpTrait;
import com.azure.core.client.traits.TokenCredentialTrait;
import com.azure.core.credential.TokenCredential;
import com.azure.core.http.HttpClient;
import com.azure.core.http.HttpHeader;
import com.azure.core.http.HttpHeaders;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpPipelineBuilder;
import com.azure.core.http.HttpPipelinePosition;
import com.azure.core.http.policy.AddDatePolicy;
import com.azure.core.http.policy.AddHeadersFromContextPolicy;
import com.azure.core.http.policy.AddHeadersPolicy;
import com.azure.core.http.policy.BearerTokenAuthenticationPolicy;
import com.azure.core.http.policy.HttpLogOptions;
import com.azure.core.http.policy.HttpLoggingPolicy;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.http.policy.HttpPolicyProviders;
import com.azure.core.http.policy.RequestIdPolicy;
import com.azure.core.http.policy.RetryOptions;
import com.azure.core.http.policy.RetryPolicy;
import com.azure.core.http.policy.UserAgentPolicy;
import com.azure.core.util.ClientOptions;
import com.azure.core.util.Configuration;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.TracingOptions;
import com.azure.core.util.builder.ClientBuilderUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.serializer.JacksonAdapter;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.core.util.tracing.Tracer;
import com.azure.core.util.tracing.TracerProvider;
import com.azure.data.appconfiguration.ConfigurationAsyncClient;
import com.azure.data.appconfiguration.ConfigurationClient;
import com.azure.data.appconfiguration.ConfigurationServiceVersion;
import com.azure.data.appconfiguration.implementation.ConfigurationClientCredentials;
import com.azure.data.appconfiguration.implementation.ConfigurationClientImpl;
import com.azure.data.appconfiguration.implementation.ConfigurationCredentialsPolicy;
import com.azure.data.appconfiguration.implementation.ConfigurationSettingJsonDeserializer;
import com.azure.data.appconfiguration.implementation.ConfigurationSettingJsonSerializer;
import com.azure.data.appconfiguration.implementation.SyncTokenPolicy;
import com.fasterxml.jackson.databind.Module;
import java.net.MalformedURLException;
import java.net.URL;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@ServiceClientBuilder(serviceClients={ConfigurationAsyncClient.class, ConfigurationClient.class})
public final class ConfigurationClientBuilder
implements TokenCredentialTrait<ConfigurationClientBuilder>,
ConnectionStringTrait<ConfigurationClientBuilder>,
HttpTrait<ConfigurationClientBuilder>,
ConfigurationTrait<ConfigurationClientBuilder>,
EndpointTrait<ConfigurationClientBuilder> {
    private static final SerializerAdapter SERIALIZER_ADAPTER;
    private static final String CLIENT_NAME;
    private static final String CLIENT_VERSION;
    private static final HttpPipelinePolicy ADD_HEADERS_POLICY;
    private static final ClientLogger LOGGER;
    private final List<HttpPipelinePolicy> perCallPolicies = new ArrayList<HttpPipelinePolicy>();
    private final List<HttpPipelinePolicy> perRetryPolicies = new ArrayList<HttpPipelinePolicy>();
    private ClientOptions clientOptions;
    private String connectionString;
    private TokenCredential tokenCredential;
    private String endpoint;
    private HttpClient httpClient;
    private HttpLogOptions httpLogOptions = new HttpLogOptions();
    private HttpPipeline pipeline;
    private HttpPipelinePolicy retryPolicy;
    private RetryOptions retryOptions;
    private Configuration configuration;
    private ConfigurationServiceVersion version;

    public ConfigurationClient buildClient() {
        SyncTokenPolicy syncTokenPolicy = new SyncTokenPolicy();
        return new ConfigurationClient(this.buildInnerClient(syncTokenPolicy), syncTokenPolicy);
    }

    public ConfigurationAsyncClient buildAsyncClient() {
        SyncTokenPolicy syncTokenPolicy = new SyncTokenPolicy();
        return new ConfigurationAsyncClient(this.buildInnerClient(syncTokenPolicy), syncTokenPolicy);
    }

    private ConfigurationClientImpl buildInnerClient(SyncTokenPolicy syncTokenPolicy) {
        String endpointLocal = this.endpoint;
        ConfigurationClientCredentials credentialsLocal = null;
        TokenCredential tokenCredentialLocal = null;
        if (this.tokenCredential == null && this.connectionString == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new NullPointerException("'tokenCredential' and 'connectionString' both can not be null. Set one authentication before creating client."));
        }
        if (this.tokenCredential != null && this.connectionString != null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Multiple forms of authentication found. TokenCredential should be null if using connection string, vice versa."));
        }
        if (this.tokenCredential == null) {
            if (this.connectionString.isEmpty()) {
                throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("'connectionString' cannot be an empty string."));
            }
            credentialsLocal = new ConfigurationClientCredentials(this.connectionString);
            endpointLocal = credentialsLocal.getBaseUri();
        } else {
            tokenCredentialLocal = this.tokenCredential;
        }
        ConfigurationServiceVersion serviceVersion = this.version != null ? this.version : ConfigurationServiceVersion.getLatest();
        return new ConfigurationClientImpl(this.pipeline == null ? this.createDefaultHttpPipeline(syncTokenPolicy, credentialsLocal, tokenCredentialLocal) : this.pipeline, SERIALIZER_ADAPTER, endpointLocal, serviceVersion.getVersion());
    }

    private HttpPipeline createDefaultHttpPipeline(SyncTokenPolicy syncTokenPolicy, ConfigurationClientCredentials credentials, TokenCredential tokenCredential) {
        Configuration buildConfiguration = this.configuration == null ? Configuration.getGlobalConfiguration() : this.configuration;
        String buildEndpoint = this.endpoint;
        if (credentials != null) {
            buildEndpoint = credentials.getBaseUri();
        }
        Objects.requireNonNull(buildEndpoint, "'Endpoint' is required and can not be null.");
        ArrayList<Object> policies = new ArrayList<Object>();
        policies.add(new UserAgentPolicy(CoreUtils.getApplicationId((ClientOptions)this.clientOptions, (HttpLogOptions)this.httpLogOptions), CLIENT_NAME, CLIENT_VERSION, buildConfiguration));
        policies.add(new RequestIdPolicy());
        policies.add(new AddHeadersFromContextPolicy());
        policies.add(ADD_HEADERS_POLICY);
        policies.addAll(this.perCallPolicies);
        HttpPolicyProviders.addBeforeRetryPolicies(policies);
        policies.add(ClientBuilderUtil.validateAndGetRetryPolicy((HttpPipelinePolicy)this.retryPolicy, (RetryOptions)this.retryOptions, (HttpPipelinePolicy)new RetryPolicy("retry-after-ms", ChronoUnit.MILLIS)));
        policies.add(new AddDatePolicy());
        if (tokenCredential != null) {
            policies.add(new BearerTokenAuthenticationPolicy(tokenCredential, new String[]{String.format("%s/.default", buildEndpoint)}));
        } else if (credentials != null) {
            policies.add(new ConfigurationCredentialsPolicy(credentials));
        } else {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing credential information while building a client."));
        }
        policies.add((Object)syncTokenPolicy);
        policies.addAll(this.perRetryPolicies);
        if (this.clientOptions != null) {
            ArrayList httpHeaderList = new ArrayList();
            this.clientOptions.getHeaders().forEach(header -> httpHeaderList.add(new HttpHeader(header.getName(), header.getValue())));
            policies.add(new AddHeadersPolicy(new HttpHeaders(httpHeaderList)));
        }
        HttpPolicyProviders.addAfterRetryPolicies(policies);
        policies.add(new HttpLoggingPolicy(this.httpLogOptions));
        return new HttpPipelineBuilder().policies(policies.toArray(new HttpPipelinePolicy[0])).httpClient(this.httpClient).tracer(ConfigurationClientBuilder.createTracer(this.clientOptions)).build();
    }

    private static Tracer createTracer(ClientOptions clientOptions) {
        TracingOptions tracingOptions = clientOptions == null ? null : clientOptions.getTracingOptions();
        return TracerProvider.getDefaultProvider().createTracer(CLIENT_NAME, CLIENT_VERSION, "Microsoft.AppConfiguration", tracingOptions);
    }

    public ConfigurationClientBuilder endpoint(String endpoint) {
        try {
            new URL(endpoint);
        }
        catch (MalformedURLException ex) {
            throw LOGGER.logExceptionAsWarning((RuntimeException)new IllegalArgumentException("'endpoint' must be a valid URL", ex));
        }
        this.endpoint = endpoint;
        return this;
    }

    public ConfigurationClientBuilder clientOptions(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        return this;
    }

    public ConfigurationClientBuilder connectionString(String connectionString) {
        this.connectionString = connectionString;
        return this;
    }

    public ConfigurationClientBuilder credential(TokenCredential tokenCredential) {
        this.tokenCredential = tokenCredential;
        return this;
    }

    public ConfigurationClientBuilder httpLogOptions(HttpLogOptions logOptions) {
        this.httpLogOptions = logOptions;
        return this;
    }

    public ConfigurationClientBuilder addPolicy(HttpPipelinePolicy policy) {
        Objects.requireNonNull(policy, "'policy' cannot be null.");
        if (policy.getPipelinePosition() == HttpPipelinePosition.PER_CALL) {
            this.perCallPolicies.add(policy);
        } else {
            this.perRetryPolicies.add(policy);
        }
        return this;
    }

    public ConfigurationClientBuilder httpClient(HttpClient client) {
        if (this.httpClient != null && client == null) {
            LOGGER.info("HttpClient is being set to 'null' when it was previously configured.");
        }
        this.httpClient = client;
        return this;
    }

    public ConfigurationClientBuilder pipeline(HttpPipeline pipeline) {
        if (this.pipeline != null && pipeline == null) {
            LOGGER.info("HttpPipeline is being set to 'null' when it was previously configured.");
        }
        this.pipeline = pipeline;
        return this;
    }

    public ConfigurationClientBuilder configuration(Configuration configuration) {
        this.configuration = configuration;
        return this;
    }

    public ConfigurationClientBuilder retryPolicy(HttpPipelinePolicy retryPolicy) {
        this.retryPolicy = retryPolicy;
        return this;
    }

    public ConfigurationClientBuilder retryOptions(RetryOptions retryOptions) {
        this.retryOptions = retryOptions;
        return this;
    }

    public ConfigurationClientBuilder serviceVersion(ConfigurationServiceVersion version) {
        this.version = version;
        return this;
    }

    static {
        Map properties = CoreUtils.getProperties((String)"azure-data-appconfiguration.properties");
        CLIENT_NAME = properties.getOrDefault("name", "UnknownName");
        CLIENT_VERSION = properties.getOrDefault("version", "UnknownVersion");
        ADD_HEADERS_POLICY = new AddHeadersPolicy(new HttpHeaders().set("x-ms-return-client-request-id", "true").set("Content-Type", "application/json").set("Accept", "application/vnd.microsoft.azconfig.kv+json"));
        JacksonAdapter jacksonAdapter = new JacksonAdapter();
        jacksonAdapter.serializer().registerModule((Module)ConfigurationSettingJsonSerializer.getModule());
        jacksonAdapter.serializer().registerModule((Module)ConfigurationSettingJsonDeserializer.getModule());
        SERIALIZER_ADAPTER = jacksonAdapter;
        LOGGER = new ClientLogger(ConfigurationClientBuilder.class);
    }
}

