/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.http;

import com.azure.core.http.HttpClient;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.implementation.http.UrlSanitizer;
import com.azure.core.implementation.http.policy.InstrumentationPolicy;
import com.azure.core.util.ClientOptions;
import com.azure.core.util.HttpClientOptions;
import com.azure.core.util.TracingOptions;
import com.azure.core.util.tracing.Tracer;
import com.azure.core.util.tracing.TracerProvider;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;

public class HttpPipelineBuilder {
    private HttpClient httpClient;
    private List<HttpPipelinePolicy> pipelinePolicies;
    private ClientOptions clientOptions;
    private Tracer tracer;

    public HttpPipeline build() {
        ArrayList<HttpPipelinePolicy> policies;
        List<Object> list = policies = this.pipelinePolicies == null ? new ArrayList() : this.pipelinePolicies;
        HttpClient client = this.httpClient != null ? this.httpClient : (this.clientOptions instanceof HttpClientOptions ? HttpClient.createDefault((HttpClientOptions)this.clientOptions) : HttpClient.createDefault());
        this.configureTracing(policies, this.clientOptions);
        return new HttpPipeline(client, policies, this.tracer);
    }

    private void configureTracing(List<HttpPipelinePolicy> policies, ClientOptions clientOptions) {
        if (this.tracer == null) {
            TracingOptions tracingOptions = clientOptions == null ? null : clientOptions.getTracingOptions();
            this.tracer = TracerProvider.getDefaultProvider().createTracer("azure-core", null, null, tracingOptions);
        }
        for (HttpPipelinePolicy policy : policies) {
            if (!(policy instanceof InstrumentationPolicy)) continue;
            UrlSanitizer sanitizer = new UrlSanitizer(HttpPipelineBuilder.getAllowedQueryParams(clientOptions));
            ((InstrumentationPolicy)policy).initialize(this.tracer, sanitizer);
        }
    }

    private static Set<String> getAllowedQueryParams(ClientOptions options) {
        if (options == null || options.getTracingOptions() == null) {
            return null;
        }
        return options.getTracingOptions().getAllowedTracingQueryParamNames();
    }

    public HttpPipelineBuilder httpClient(HttpClient httpClient) {
        this.httpClient = httpClient;
        return this;
    }

    public HttpPipelineBuilder policies(HttpPipelinePolicy ... policies) {
        if (this.pipelinePolicies == null) {
            this.pipelinePolicies = new ArrayList<HttpPipelinePolicy>();
        }
        this.pipelinePolicies.addAll(Arrays.asList(policies));
        return this;
    }

    public HttpPipelineBuilder clientOptions(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        return this;
    }

    public HttpPipelineBuilder tracer(Tracer tracer) {
        this.tracer = tracer;
        return this;
    }
}

