/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.SdkVersionInfo;

public abstract class AndroidTargetHash {
    public static final String PLATFORM_HASH_PREFIX = "android-";
    public static final String ADD_ON_FORMAT = "%s:%s:%s";
    static final String PLATFORM_HASH = "android-%s";

    @NonNull
    public static String getPlatformHashString(@NonNull AndroidVersion version) {
        return String.format(PLATFORM_HASH, version.getApiString());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public static AndroidVersion getPlatformVersion(@NonNull String hashString) {
        if (hashString.startsWith(PLATFORM_HASH_PREFIX)) {
            String suffix = hashString.substring(PLATFORM_HASH_PREFIX.length());
            if (suffix.isEmpty()) return null;
            if (!Character.isDigit(suffix.charAt(0))) {
                int api = SdkVersionInfo.getApiByBuildCode(suffix, false);
                if (api >= 1) return new AndroidVersion(api, suffix);
                api = 1;
                return new AndroidVersion(api, suffix);
            }
            try {
                int api = Integer.parseInt(suffix);
                return new AndroidVersion(api, null);
            }
            catch (NumberFormatException ignore) {
                return null;
            }
        }
        if (hashString.length() <= 0) return null;
        if (!Character.isDigit(hashString.charAt(0))) return null;
        try {
            int api = Integer.parseInt(hashString);
            return new AndroidVersion(api, null);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return null;
    }

    public static String getAddonHashString(@NonNull String addonVendorDisplay, @NonNull String addonNameDisplay, @NonNull AndroidVersion version) {
        return String.format(ADD_ON_FORMAT, addonVendorDisplay, addonNameDisplay, version.getApiString());
    }

    public static String getTargetHashString(@NonNull IAndroidTarget target) {
        if (target.isPlatform()) {
            return AndroidTargetHash.getPlatformHashString(target.getVersion());
        }
        return AndroidTargetHash.getAddonHashString(target.getVendor(), target.getName(), target.getVersion());
    }

    public static boolean isPlatform(@NonNull String hashString) {
        return hashString.startsWith(PLATFORM_HASH_PREFIX);
    }
}

