/*
 * Decompiled with CFR 0.152.
 */
package lombok.ast.grammar;

import java.util.List;
import lombok.ast.AbstractNode;
import lombok.ast.ArrayAccess;
import lombok.ast.ArrayCreation;
import lombok.ast.ArrayDimension;
import lombok.ast.ArrayInitializer;
import lombok.ast.BinaryExpression;
import lombok.ast.Cast;
import lombok.ast.ClassLiteral;
import lombok.ast.ConstructorInvocation;
import lombok.ast.DanglingNodes;
import lombok.ast.Expression;
import lombok.ast.Identifier;
import lombok.ast.InlineIfExpression;
import lombok.ast.InstanceOf;
import lombok.ast.MethodInvocation;
import lombok.ast.Node;
import lombok.ast.Position;
import lombok.ast.Select;
import lombok.ast.Super;
import lombok.ast.This;
import lombok.ast.TypeReference;
import lombok.ast.TypeReferencePart;
import lombok.ast.UnaryExpression;
import lombok.ast.UnaryOperator;
import lombok.ast.VariableReference;
import lombok.ast.grammar.Source;
import lombok.ast.grammar.SourceActions;
import lombok.ast.grammar.TemporaryNode;

public class ExpressionsActions
extends SourceActions {
    public ExpressionsActions(Source source) {
        super(source);
    }

    public Node createLeftAssociativeBinaryExpression(org.parboiled.Node<Node> head, List<org.parboiled.Node<Node>> operatorsNodes, List<String> operators, List<org.parboiled.Node<Node>> tail) {
        Node currentLeft = (Node)head.getValue();
        for (int i = 0; i < operators.size(); ++i) {
            currentLeft = new BinaryExpression().rawLeft(currentLeft).rawRight((Node)tail.get(i).getValue()).rawOperator(operators.get(i));
            this.source.registerStructure(currentLeft, operatorsNodes.get(i));
            this.positionSpan(currentLeft, head, tail.get(i));
        }
        return currentLeft;
    }

    public Node createAssignmentExpression(Node lhs, String operator, Node rhs) {
        if (rhs == null && operator == null) {
            return lhs;
        }
        return this.posify(new BinaryExpression().rawLeft(lhs).rawRight(rhs).rawOperator(operator));
    }

    public Node createInlineIfExpression(Node head, org.parboiled.Node<Node> operator1Node, org.parboiled.Node<Node> operator2Node, Node tail1, Node tail2) {
        if (tail1 == null || tail2 == null) {
            return head;
        }
        InlineIfExpression result = new InlineIfExpression().rawCondition(head).rawIfTrue(tail1).rawIfFalse(tail2);
        this.source.registerStructure(result, operator1Node);
        this.source.registerStructure(result, operator2Node);
        return this.posify(result);
    }

    public Node createUnaryPrefixExpression(Node operand, org.parboiled.Node<Node> opNode, String symbol) {
        if (opNode == null) {
            return operand;
        }
        if (!opNode.getChildren().isEmpty() && "cast".equals(((org.parboiled.Node)opNode.getChildren().get(0)).getLabel())) {
            return this.posify(new Cast().rawOperand(operand).rawTypeReference((Node)opNode.getValue()));
        }
        if (symbol != null) {
            symbol = symbol.trim();
        }
        if (!symbol.isEmpty()) {
            UnaryOperator op = UnaryOperator.fromSymbol(symbol, false);
            UnaryExpression expr = new UnaryExpression().rawOperand(operand);
            if (op != null) {
                expr.astOperator(op);
            }
            return this.posify(expr);
        }
        return operand;
    }

    public Node createUnaryPrefixExpressions(org.parboiled.Node<Node> operand, List<org.parboiled.Node<Node>> operators, List<String> operatorTexts) {
        if (operators == null || operators.isEmpty()) {
            return (Node)operand.getValue();
        }
        Node current = (Node)operand.getValue();
        for (int i = operators.size() - 1; i >= 0; --i) {
            org.parboiled.Node<Node> operator = operators.get(i);
            Node prev = current;
            if (operator == null) continue;
            if (!operator.getChildren().isEmpty() && "cast".equals(((org.parboiled.Node)operator.getChildren().get(0)).getLabel())) {
                current = new Cast().rawOperand(current).rawTypeReference((Node)operator.getValue());
            } else {
                String symbol = operatorTexts.get(i);
                if (symbol == null || (symbol = symbol.trim()).isEmpty()) continue;
                UnaryOperator op = UnaryOperator.fromSymbol(symbol, false);
                UnaryExpression expr = new UnaryExpression().rawOperand(current);
                if (op != null) {
                    expr.astOperator(op);
                }
                current = expr;
            }
            if (prev == null || prev.getPosition().isUnplaced() || prev == current || current == null) continue;
            this.positionSpan(current, operator, operand);
        }
        return current;
    }

    public Node createUnaryPostfixExpression(Node operand, List<org.parboiled.Node<Node>> nodes, List<String> operators) {
        if (operators == null) {
            return operand;
        }
        Node current = operand;
        for (int i = 0; i < operators.size(); ++i) {
            String op = operators.get(i);
            if (op == null) continue;
            op = op.trim();
            Node prev = current;
            if (op.equals("++")) {
                current = new UnaryExpression().rawOperand(current).astOperator(UnaryOperator.POSTFIX_INCREMENT);
            } else if (op.equals("--")) {
                current = new UnaryExpression().rawOperand(current).astOperator(UnaryOperator.POSTFIX_DECREMENT);
            }
            org.parboiled.Node<Node> p = nodes.get(i);
            if (prev == null || prev.getPosition().isUnplaced() || p == null) continue;
            current.setPosition(new Position(prev.getPosition().getStart(), p.getEndIndex()));
        }
        return current;
    }

    public Node createInstanceOfExpression(Node operand, Node type) {
        if (type == null) {
            return operand;
        }
        return this.posify(new InstanceOf().rawObjectReference(operand).rawTypeReference(type));
    }

    public Node createQualifiedConstructorInvocation(Node constructorTypeArgs, org.parboiled.Node<Node> identifier, org.parboiled.Node<Node> classTypeArgs, Node methodArguments, Node classBody) {
        TypeReferencePart classTypeArgs0;
        Node identifierNode;
        boolean classTypeArgsCorrect = false;
        Node node = identifierNode = identifier == null ? null : (Node)identifier.getValue();
        if (classTypeArgs != null && classTypeArgs.getValue() instanceof TypeReferencePart) {
            classTypeArgs0 = (TypeReferencePart)classTypeArgs.getValue();
            classTypeArgsCorrect = true;
        } else {
            classTypeArgs0 = new TypeReferencePart();
            if (identifierNode != null) {
                classTypeArgs0.setPosition(identifierNode.getPosition());
            }
        }
        TypeReference typeReference = (TypeReference)new TypeReference().astParts().addToEnd(new TypeReferencePart[]{classTypeArgs0.astIdentifier(this.createIdentifierIfNeeded(identifierNode, this.currentPos()))});
        if (!classTypeArgsCorrect) {
            if (identifier != null && identifier.getValue() != null) {
                typeReference.setPosition(((Node)identifier.getValue()).getPosition());
            }
        } else {
            this.positionSpan(typeReference, identifier, classTypeArgs);
        }
        ConstructorInvocation constructorInvocation = new ConstructorInvocation().rawTypeReference(typeReference).rawAnonymousClassBody(classBody);
        if (constructorTypeArgs instanceof TemporaryNode.TypeArguments) {
            for (Node arg : ((TemporaryNode.TypeArguments)constructorTypeArgs).arguments) {
                constructorInvocation.rawConstructorTypeArguments().addToEnd(arg);
            }
        }
        if (methodArguments instanceof TemporaryNode.MethodArguments) {
            for (Node arg : ((TemporaryNode.MethodArguments)methodArguments).arguments) {
                constructorInvocation.rawArguments().addToEnd(arg);
            }
        }
        return this.posify(constructorInvocation);
    }

    public Node createChainOfQualifiedConstructorInvocations(org.parboiled.Node<Node> qualifier, List<org.parboiled.Node<Node>> constructorInvocations) {
        Node current = (Node)qualifier.getValue();
        if (constructorInvocations == null) {
            return current;
        }
        for (org.parboiled.Node<Node> pNode : constructorInvocations) {
            Node n = (Node)pNode.getValue();
            if (n instanceof ConstructorInvocation) {
                current = ((ConstructorInvocation)n).rawQualifier(current);
                this.positionSpan(current, qualifier, pNode);
                continue;
            }
            DanglingNodes.addDanglingNode(current, n);
        }
        return current;
    }

    public Node createMethodInvocationOperation(org.parboiled.Node<Node> dot, Node typeArguments, Node name, Node arguments) {
        MethodInvocation mi = new MethodInvocation().astName(this.createIdentifierIfNeeded(name, this.currentPos()));
        if (typeArguments instanceof TemporaryNode.TypeArguments) {
            for (Node arg : ((TemporaryNode.TypeArguments)typeArguments).arguments) {
                mi.rawMethodTypeArguments().addToEnd(arg);
            }
        } else {
            DanglingNodes.addDanglingNode(mi, typeArguments);
        }
        if (arguments instanceof TemporaryNode.MethodArguments) {
            for (Node arg : ((TemporaryNode.MethodArguments)arguments).arguments) {
                mi.rawArguments().addToEnd(arg);
            }
        } else {
            DanglingNodes.addDanglingNode(mi, arguments);
        }
        this.source.registerStructure(mi, dot);
        return this.posify(mi);
    }

    public Node createSelectOperation(Node identifier) {
        return this.posify(new Select().astIdentifier(this.createIdentifierIfNeeded(identifier, this.currentPos())));
    }

    public Node createArrayAccessOperation(Node indexExpression) {
        return this.posify(new ArrayAccess().rawIndexExpression(indexExpression));
    }

    public Node createLevel1Expression(org.parboiled.Node<Node> operand, List<org.parboiled.Node<Node>> operations) {
        Node current = (Node)operand.getValue();
        if (operations == null) {
            return current;
        }
        for (org.parboiled.Node<Node> pNode : operations) {
            Node o = (Node)pNode.getValue();
            if (o instanceof ArrayAccess) {
                current = ((ArrayAccess)o).rawOperand(current);
            } else if (o instanceof MethodInvocation) {
                current = ((MethodInvocation)o).rawOperand(current);
            } else if (o instanceof Select) {
                current = ((Select)o).rawOperand(current);
            } else {
                DanglingNodes.addDanglingNode(current, o);
            }
            this.positionSpan(o, operand, pNode);
        }
        return current;
    }

    public Node createPrimary(Node identifier, Node methodArguments) {
        Identifier id = this.createIdentifierIfNeeded(identifier, this.currentPos());
        if (methodArguments instanceof TemporaryNode.MethodArguments) {
            MethodInvocation invoke = new MethodInvocation().astName(id);
            for (Node arg : ((TemporaryNode.MethodArguments)methodArguments).arguments) {
                invoke.rawArguments().addToEnd(arg);
            }
            return this.posify(invoke);
        }
        VariableReference ref = new VariableReference().astIdentifier(id);
        DanglingNodes.addDanglingNode(ref, methodArguments);
        return this.posify(ref);
    }

    public Node createUnqualifiedConstructorInvocation(Node constructorTypeArgs, Node type, Node args, Node anonymousClassBody) {
        ConstructorInvocation result = new ConstructorInvocation().rawTypeReference(type).rawAnonymousClassBody(anonymousClassBody);
        if (constructorTypeArgs instanceof TemporaryNode.TypeArguments) {
            for (Node arg : ((TemporaryNode.TypeArguments)constructorTypeArgs).arguments) {
                result.rawConstructorTypeArguments().addToEnd(arg);
            }
        }
        if (args instanceof TemporaryNode.MethodArguments) {
            for (Node arg : ((TemporaryNode.MethodArguments)args).arguments) {
                result.rawArguments().addToEnd(arg);
            }
        } else {
            DanglingNodes.addDanglingNode(result, args);
        }
        return this.posify(result);
    }

    public Node createArrayInitializerExpression(Node head, List<Node> tail) {
        ArrayInitializer ai = new ArrayInitializer();
        if (head != null) {
            ai.rawExpressions().addToEnd(head);
        }
        if (tail != null) {
            for (Node n : tail) {
                if (n == null) continue;
                ai.rawExpressions().addToEnd(n);
            }
        }
        return this.posify(ai);
    }

    public Node createDimension(Node dimExpr, org.parboiled.Node<Node> arrayOpen) {
        ArrayDimension d = new ArrayDimension().rawDimension(dimExpr);
        if (arrayOpen != null) {
            d.setPosition(new Position(arrayOpen.getStartIndex(), this.currentPos()));
        }
        return d;
    }

    public Node createArrayCreationExpression(Node type, List<Node> dimensions, Node initializer) {
        ArrayCreation ac = new ArrayCreation().rawComponentTypeReference(type).rawInitializer(initializer);
        if (dimensions != null) {
            for (Node d : dimensions) {
                if (d == null) continue;
                ac.rawDimensions().addToEnd(d);
            }
        }
        return this.posify(ac);
    }

    public Node addParens(Node v) {
        if (v instanceof Expression) {
            ((Expression)v).astParensPositions().add(new Position(this.startPos(), this.currentPos()));
        }
        return v;
    }

    public Node createThisOrSuperOrClass(org.parboiled.Node<Node> dot, String text, Node qualifier) {
        AbstractNode result = "super".equals(text) ? new Super().rawQualifier(qualifier) : ("class".equals(text) ? new ClassLiteral().rawTypeReference(qualifier) : new This().rawQualifier(qualifier));
        if (dot != null) {
            this.source.registerStructure(result, dot);
        }
        return this.posify(result);
    }

    public boolean checkIfLevel1ExprIsValidForAssignment(Node node) {
        return node instanceof VariableReference || node instanceof Select || node instanceof ArrayAccess;
    }

    public boolean checkIfMethodOrConstructorInvocation(Node node) {
        return node instanceof MethodInvocation || node instanceof ConstructorInvocation;
    }

    public boolean typeIsAlsoLegalAsExpression(Node type) {
        if (!(type instanceof TypeReference)) {
            return true;
        }
        TypeReference tr = (TypeReference)type;
        if (tr.astArrayDimensions() > 0) {
            return false;
        }
        if (tr.isPrimitive() || tr.isVoid()) {
            return false;
        }
        for (Node part : tr.rawParts()) {
            if (!(part instanceof TypeReferencePart) || ((TypeReferencePart)part).rawTypeArguments().isEmpty()) continue;
            return false;
        }
        return true;
    }
}

